/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport.actions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.transport.ExportMemoryDialog;
import org.eclipse.cdt.debug.ui.memory.transport.MemoryTransportPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportMemoryAction
implements IViewActionDelegate {
    private IMemoryRenderingSite fView;

    public void init(IViewPart view) {
        if (view instanceof IMemoryRenderingSite) {
            this.fView = (IMemoryRenderingSite)view;
        }
    }

    static BlockAndAddress getMemoryBlockAndInitialStartAddress(ISelection selection) {
        IMemoryBlock memBlock = null;
        BigInteger initialStartAddr = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            if (strucSel.isEmpty()) {
                return BlockAndAddress.EMPTY;
            }
            Object obj = strucSel.getFirstElement();
            if (obj == null) {
                return BlockAndAddress.EMPTY;
            }
            if (obj instanceof IMemoryRendering) {
                memBlock = ((IMemoryRendering)obj).getMemoryBlock();
                if (obj instanceof IRepositionableMemoryRendering) {
                    initialStartAddr = ((IRepositionableMemoryRendering)obj).getSelectedAddress();
                }
            } else if (obj instanceof IMemoryBlock) {
                memBlock = (IMemoryBlock)obj;
            }
            if (initialStartAddr == null) {
                if (memBlock instanceof IMemoryBlockExtension) {
                    try {
                        initialStartAddr = ((IMemoryBlockExtension)memBlock).getBigBaseAddress();
                    }
                    catch (DebugException debugException) {
                        initialStartAddr = BigInteger.valueOf(memBlock.getStartAddress());
                    }
                } else {
                    initialStartAddr = BigInteger.valueOf(memBlock.getStartAddress());
                }
            }
        }
        return new BlockAndAddress(memBlock, initialStartAddr);
    }

    public void run(IAction action) {
        ISelection selection = this.fView.getSite().getSelectionProvider().getSelection();
        BlockAndAddress blockAndAddr = ExportMemoryAction.getMemoryBlockAndInitialStartAddress(selection);
        if (blockAndAddr.block == null) {
            return;
        }
        ExportMemoryDialog dialog = new ExportMemoryDialog(MemoryTransportPlugin.getShell(), blockAndAddr.block, blockAndAddr.addr);
        dialog.open();
        dialog.getResult();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(ExportMemoryAction.getMemoryBlockAndInitialStartAddress((ISelection)selection).block != null);
    }

    static class BlockAndAddress {
        public static final BlockAndAddress EMPTY = new BlockAndAddress(null, BigInteger.valueOf(0L));
        public IMemoryBlock block;
        public BigInteger addr;

        public BlockAndAddress(IMemoryBlock block, BigInteger addr) {
            this.block = block;
            this.addr = addr;
        }
    }
}

