/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTPointer;
import org.eclipse.cdt.internal.ui.refactoring.NodeContainer;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractExpression;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractStatement;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtractedFunctionConstructionHelper {
    public static ExtractedFunctionConstructionHelper createFor(List<IASTNode> list) {
        if (list.get(0) instanceof IASTExpression) {
            return new ExtractExpression();
        }
        return new ExtractStatement();
    }

    public abstract void constructMethodBody(IASTCompoundStatement var1, List<IASTNode> var2, ASTRewrite var3, TextEditGroup var4);

    public abstract IASTDeclSpecifier determineReturnType(IASTNode var1, NodeContainer.NameInformation var2);

    public abstract IASTNode createReturnAssignment(IASTNode var1, IASTExpressionStatement var2, IASTExpression var3);

    protected boolean isReturnTypeAPointer(IASTNode node) {
        return false;
    }

    IASTStandardFunctionDeclarator createFunctionDeclarator(IASTName name, ICPPASTFunctionDeclarator functionDeclarator, NodeContainer.NameInformation returnVariable, List<IASTNode> nodesToWrite, Collection<NodeContainer.NameInformation> allUsedNames) {
        CPPASTFunctionDeclarator declarator = new CPPASTFunctionDeclarator();
        declarator.setName(name);
        if (functionDeclarator != null && functionDeclarator.isConst()) {
            declarator.setConst(true);
        }
        if (returnVariable != null) {
            IASTPointerOperator[] pointers;
            IASTDeclarator decl = (IASTDeclarator)returnVariable.getDeclaration().getParent();
            IASTPointerOperator[] iASTPointerOperatorArray = pointers = decl.getPointerOperators();
            int n = pointers.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator operator = iASTPointerOperatorArray[n2];
                declarator.addPointerOperator(operator.copy());
                ++n2;
            }
        }
        for (ICPPASTParameterDeclaration param : this.getParameterDeclarations(allUsedNames)) {
            declarator.addParameterDeclaration((IASTParameterDeclaration)param);
        }
        if (this.isReturnTypeAPointer(nodesToWrite.get(0))) {
            declarator.addPointerOperator((IASTPointerOperator)new CPPASTPointer());
        }
        return declarator;
    }

    public Collection<ICPPASTParameterDeclaration> getParameterDeclarations(Collection<NodeContainer.NameInformation> allUsedNames) {
        ArrayList<ICPPASTParameterDeclaration> result = new ArrayList<ICPPASTParameterDeclaration>();
        for (NodeContainer.NameInformation name : allUsedNames) {
            if (name.isDeclarationInScope()) continue;
            result.add(name.getICPPASTParameterDeclaration(name.isUserSetIsReference()));
        }
        return result;
    }
}

