/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTNameCollector;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDeclarationsAction
extends SelectionParseAction
implements ASTCache.ASTRunnable {
    public static boolean sIsJUnitTest = false;
    ITextSelection fTextSelection;
    private String fSelectedText;
    private ITranslationUnit fWorkingCopy;
    private IIndex fIndex;
    private IProgressMonitor fMonitor;

    public OpenDeclarationsAction(CEditor editor) {
        super(editor);
        this.setText(CEditorMessages.OpenDeclarations_label);
        this.setToolTipText(CEditorMessages.OpenDeclarations_tooltip);
        this.setDescription(CEditorMessages.OpenDeclarations_description);
    }

    protected IStatus performNavigation(IProgressMonitor monitor) throws CoreException {
        this.clearStatusLine();
        this.fMonitor = monitor;
        ICElement celem = this.fEditor.getInputCElement();
        if (!(celem instanceof ITranslationUnit)) {
            return Status.CANCEL_STATUS;
        }
        this.fWorkingCopy = (ITranslationUnit)celem;
        this.fIndex = CCorePlugin.getIndexManager().getIndex(this.fWorkingCopy.getCProject(), 3);
        try {
            this.fIndex.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            IStatus iStatus = ASTProvider.getASTProvider().runOnAST((ICElement)this.fWorkingCopy, ASTProvider.WAIT_ACTIVE_ONLY, monitor, this);
            return iStatus;
        }
        finally {
            this.fIndex.releaseReadLock();
        }
    }

    public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
        if (ast == null) {
            return Status.OK_STATUS;
        }
        int selectionStart = this.fTextSelection.getOffset();
        int selectionLength = this.fTextSelection.getLength();
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTName sourceName = nodeSelector.findEnclosingName(selectionStart, selectionLength);
        if (sourceName == null) {
            IASTImplicitNameOwner owner;
            IASTImplicitName[] implicits;
            IASTImplicitName implicit = nodeSelector.findEnclosingImplicitName(selectionStart, selectionLength);
            if (implicit != null && (implicits = (owner = (IASTImplicitNameOwner)implicit.getParent()).getImplicitNames()).length > 0) {
                ArrayList<IName> allNames = new ArrayList<IName>();
                IASTImplicitName[] iASTImplicitNameArray = implicits;
                int n = implicits.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTImplicitName name = iASTImplicitNameArray[n2];
                    if (((ASTNode)name).getOffset() == ((ASTNode)implicit).getOffset()) {
                        IBinding binding = name.resolveBinding();
                        IName[] declNames = this.findDeclNames(ast, NameKind.REFERENCE, binding);
                        allNames.addAll(Arrays.asList(declNames));
                    }
                    ++n2;
                }
                if (this.navigateViaCElements(this.fWorkingCopy.getCProject(), this.fIndex, allNames.toArray(new IName[0]))) {
                    return Status.OK_STATUS;
                }
            }
        } else {
            boolean found = false;
            IASTNode parent = sourceName.getParent();
            if (parent instanceof IASTPreprocessorIncludeStatement) {
                this.openInclude((IASTPreprocessorIncludeStatement)parent);
                return Status.OK_STATUS;
            }
            NameKind kind = OpenDeclarationsAction.getNameKind((IName)sourceName);
            IBinding b = sourceName.resolveBinding();
            IBinding[] bindings = new IBinding[]{b};
            if (b instanceof IProblemBinding) {
                IBinding[] candidateBindings = ((IProblemBinding)b).getCandidateBindings();
                if (candidateBindings.length != 0) {
                    bindings = candidateBindings;
                }
            } else if (kind == NameKind.DEFINITION && b instanceof IType) {
                this.navigateToName((IName)sourceName);
                return Status.OK_STATUS;
            }
            Object[] declNames = null;
            String filename = ast.getFilePath();
            IBinding[] iBindingArray = bindings;
            int n = bindings.length;
            int n3 = 0;
            while (n3 < n) {
                IBinding binding = iBindingArray[n3];
                if (binding != null && !(binding instanceof IProblemBinding)) {
                    Object[] names = this.findDeclNames(ast, kind, binding);
                    int i = 0;
                    while (i < names.length) {
                        if (names[i] instanceof IIndexName && filename.equals(((IIndexName)names[i]).getFileLocation().getFileName())) {
                            names[i] = null;
                        } else if (this.isSameName((IName)names[i], (IName)sourceName)) {
                            names[i] = null;
                        } else if (binding instanceof IParameter) {
                            if (!OpenDeclarationsAction.isInSameFunction(sourceName, (IName)names[i])) {
                                names[i] = null;
                            }
                        } else if (binding instanceof ICPPTemplateParameter && !OpenDeclarationsAction.isInSameTemplate(sourceName, (IName)names[i])) {
                            names[i] = null;
                        }
                        ++i;
                    }
                    this.compact(names);
                    declNames = declNames == null ? names : (IName[])ArrayUtil.addAll(IName.class, (Object[])declNames, (Object[])names);
                }
                ++n3;
            }
            declNames = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])declNames);
            found = this.navigateViaCElements(this.fWorkingCopy.getCProject(), this.fIndex, (IName[])declNames) ? true : this.navigateOneLocation((IName[])declNames);
            if (!found && !this.navigationFallBack(ast, sourceName, kind)) {
                this.reportSymbolLookupFailure(new String(sourceName.toCharArray()));
            }
            return Status.OK_STATUS;
        }
        IASTNode node = nodeSelector.findEnclosingNode(selectionStart, selectionLength);
        if (node instanceof IASTPreprocessorIncludeStatement) {
            this.openInclude((IASTPreprocessorIncludeStatement)node);
            return Status.OK_STATUS;
        }
        if (!this.navigationFallBack(ast, null, NameKind.REFERENCE)) {
            this.reportSelectionMatchFailure();
        }
        return Status.OK_STATUS;
    }

    private void compact(Object[] array) {
        int i = 0;
        int j = 0;
        while (i < array.length) {
            if (array[i] != null) {
                if (i != j) {
                    array[j] = array[i];
                    array[i] = null;
                }
                ++j;
            }
            ++i;
        }
    }

    private static NameKind getNameKind(IName name) {
        if (name.isDefinition()) {
            if (OpenDeclarationsAction.getBinding(name) instanceof ICPPUsingDeclaration) {
                return NameKind.USING_DECL;
            }
            return NameKind.DEFINITION;
        }
        if (name.isDeclaration()) {
            return NameKind.DECLARATION;
        }
        return NameKind.REFERENCE;
    }

    private static IBinding getBinding(IName name) {
        if (name instanceof IASTName) {
            return ((IASTName)name).resolveBinding();
        }
        if (name instanceof IIndexFragmentName) {
            try {
                return ((IIndexFragmentName)name).getBinding();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    private static boolean isInSameFunction(IASTName name1, IName name2) {
        IASTDeclaration decl2;
        IASTDeclaration decl1 = OpenDeclarationsAction.getEnclosingDeclaration((IASTNode)name1);
        IASTDeclaration iASTDeclaration = decl2 = name2 instanceof IASTName ? OpenDeclarationsAction.getEnclosingDeclaration((IASTNode)((IASTName)name2)) : null;
        return decl1 != null && decl1.equals(decl2) || decl1 == null && decl2 == null;
    }

    private static IASTDeclaration getEnclosingDeclaration(IASTNode node) {
        while (node != null && !(node instanceof IASTDeclaration)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static boolean isInSameTemplate(IASTName name1, IName name2) {
        IASTDeclaration decl2;
        IASTDeclaration decl1 = OpenDeclarationsAction.getEnclosingTemplateDeclaration((IASTNode)name1);
        IASTDeclaration iASTDeclaration = decl2 = name2 instanceof IASTName ? OpenDeclarationsAction.getEnclosingTemplateDeclaration((IASTNode)((IASTName)name2)) : null;
        return decl1 != null && decl1.equals(decl2) || decl1 == null && decl2 == null;
    }

    private static IASTDeclaration getEnclosingTemplateDeclaration(IASTNode node) {
        while (node != null && !(node instanceof ICPPASTTemplateDeclaration)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private IName[] findDeclNames(IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        IName[] declNames = this.findNames(this.fIndex, ast, kind, binding);
        if (declNames.length == 0) {
            ICPPMethod method;
            if (binding instanceof ICPPSpecialization) {
                IBinding specialized = ((ICPPSpecialization)binding).getSpecializedBinding();
                if (specialized != null && !(specialized instanceof IProblemBinding)) {
                    declNames = this.findNames(this.fIndex, ast, NameKind.DEFINITION, specialized);
                }
            } else if (binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit()) {
                try {
                    ICPPClassType clsBinding = method.getClassOwner();
                    if (clsBinding != null && !(clsBinding instanceof IProblemBinding)) {
                        declNames = this.findNames(this.fIndex, ast, NameKind.REFERENCE, (IBinding)clsBinding);
                    }
                }
                catch (DOMException dOMException) {}
            }
        }
        return declNames;
    }

    /*
     * WARNING - void declaration
     */
    private boolean navigationFallBack(IASTTranslationUnit ast, IASTName sourceName, NameKind kind) {
        if (this.fSelectedText != null && this.fSelectedText.length() > 0) {
            block18: {
                Object[] objectArray;
                void var15_27;
                IIndexMacro[] macros;
                IIndexBinding[] idxBindings;
                IASTName[] candidates;
                ICProject project = this.fWorkingCopy.getCProject();
                char[] name = this.fSelectedText.toCharArray();
                ArrayList<ICElement> elems = new ArrayList<ICElement>();
                HashSet<Object> bindings = new HashSet<Object>();
                HashSet<IIndexBinding> ignoreIndexBindings = new HashSet<IIndexBinding>();
                ASTNameCollector nc = new ASTNameCollector(this.fSelectedText);
                ast.accept((ASTVisitor)nc);
                IASTName[] iASTNameArray = candidates = nc.getNames();
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName astName = iASTNameArray[n2];
                    try {
                        IBinding iBinding = astName.resolveBinding();
                        if (iBinding != null && !(iBinding instanceof IProblemBinding) && bindings.add(iBinding)) {
                            ignoreIndexBindings.add(this.fIndex.adaptBinding(iBinding));
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        CUIPlugin.log(runtimeException);
                    }
                    ++n2;
                }
                IndexFilter filter = IndexFilter.getDeclaredBindingFilter((int)ast.getLinkage().getLinkageID(), (boolean)false);
                IIndexBinding[] iIndexBindingArray = idxBindings = this.fIndex.findBindings(name, false, filter, this.fMonitor);
                int n3 = idxBindings.length;
                int n32 = 0;
                while (n32 < n3) {
                    IIndexBinding idxBinding = iIndexBindingArray[n32];
                    if (!ignoreIndexBindings.contains(idxBinding)) {
                        bindings.add(idxBinding);
                    }
                    ++n32;
                }
                IIndexMacro[] iIndexMacroArray = macros = this.fIndex.findMacros(name, filter, this.fMonitor);
                int n4 = macros.length;
                boolean bl = false;
                while (var15_27 < n4) {
                    IIndexMacro macro = iIndexMacroArray[var15_27];
                    ICElementHandle elem = IndexUI.getCElementForMacro(project, this.fIndex, macro);
                    if (elem != null) {
                        elems.add((ICElement)elem);
                    }
                    ++var15_27;
                }
                if (sourceName != null) {
                    objectArray = CPPVisitor.getQualifiedName((IBinding)sourceName.resolveBinding());
                } else {
                    String[] stringArray = new String[1];
                    objectArray = stringArray;
                    stringArray[0] = this.fSelectedText;
                }
                Object[] sourceQualifiedName = objectArray;
                for (IBinding iBinding : bindings) {
                    Object[] qualifiedName = CPPVisitor.getQualifiedName((IBinding)iBinding);
                    if (!Arrays.equals(qualifiedName, sourceQualifiedName)) continue;
                    Object[] names = this.findNames(this.fIndex, ast, kind, iBinding);
                    int i = 0;
                    while (i < names.length) {
                        if (OpenDeclarationsAction.getNameKind((IName)names[i]) == kind) {
                            names[i] = null;
                        }
                        ++i;
                    }
                    names = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])names);
                    this.convertToCElements(project, this.fIndex, (IName[])names, elems);
                }
                if (!this.navigateCElements(elems)) break block18;
                return true;
            }
            try {
                if (sourceName != null && sourceName.isDeclaration()) {
                    return this.navigateToName((IName)sourceName);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        }
        return false;
    }

    private boolean isSameName(IName n1, IName n2) {
        IASTFileLocation loc1 = n1.getFileLocation();
        IASTFileLocation loc2 = n2.getFileLocation();
        return loc1.getFileName().equals(loc2.getFileName()) && loc1.getNodeOffset() == loc2.getNodeOffset() && loc1.getNodeLength() == loc2.getNodeLength();
    }

    private void openInclude(IASTPreprocessorIncludeStatement incStmt) {
        String name = null;
        if (incStmt.isResolved()) {
            name = incStmt.getPath();
        }
        if (name != null) {
            Path path = new Path(name);
            this.runInUIThread(new Runnable((IPath)path){
                private final /* synthetic */ IPath val$path;
                {
                    this.val$path = iPath;
                }

                public void run() {
                    try {
                        OpenDeclarationsAction.this.open(this.val$path, 0, 0);
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            });
        } else {
            this.reportIncludeLookupFailure(new String(incStmt.getName().toCharArray()));
        }
    }

    private boolean navigateOneLocation(IName[] names) {
        IName[] iNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IName name = iNameArray[n2];
            if (this.navigateToName(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean navigateToName(IName name) {
        IASTFileLocation fileloc = name.getFileLocation();
        if (fileloc == null) {
            return false;
        }
        Path path = new Path(fileloc.getFileName());
        int offset = fileloc.getNodeOffset();
        int length = fileloc.getNodeLength();
        this.runInUIThread(new Runnable((IPath)path, offset, length){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ int val$offset;
            private final /* synthetic */ int val$length;
            {
                this.val$path = iPath;
                this.val$offset = n;
                this.val$length = n2;
            }

            public void run() {
                try {
                    OpenDeclarationsAction.this.open(this.val$path, this.val$offset, this.val$length);
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
            }
        });
        return true;
    }

    private boolean navigateViaCElements(ICProject project, IIndex index, IName[] declNames) {
        ArrayList<ICElement> elements = new ArrayList<ICElement>();
        this.convertToCElements(project, index, declNames, elements);
        return this.navigateCElements(elements);
    }

    private void convertToCElements(ICProject project, IIndex index, IName[] declNames, List<ICElement> elements) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName declName = iNameArray[n2];
            try {
                ICElementHandle elem = this.getCElementForName(project, index, declName);
                if (elem instanceof ISourceReference) {
                    elements.add((ICElement)elem);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
            ++n2;
        }
    }

    private boolean navigateCElements(final List<ICElement> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        this.runInUIThread(new Runnable(){

            public void run() {
                ISourceReference target = null;
                if (elements.size() == 1) {
                    target = (ISourceReference)elements.get(0);
                } else {
                    if (sIsJUnitTest) {
                        throw new RuntimeException("ambiguous input: " + elements.size());
                    }
                    ICElement[] elemArray = elements.toArray(new ICElement[elements.size()]);
                    target = (ISourceReference)OpenActionUtil.selectCElement(elemArray, OpenDeclarationsAction.this.getSite().getShell(), CEditorMessages.OpenDeclarationsAction_dialog_title, CEditorMessages.OpenDeclarationsAction_selectMessage, -2112870367, 0);
                }
                if (target != null) {
                    ITranslationUnit tu = target.getTranslationUnit();
                    try {
                        ISourceRange sourceRange = target.getSourceRange();
                        if (tu != null && sourceRange != null) {
                            OpenDeclarationsAction.this.open(tu.getLocation(), sourceRange.getIdStartPos(), sourceRange.getIdLength());
                        }
                    }
                    catch (CoreException e) {
                        CUIPlugin.log(e);
                    }
                }
            }
        });
        return true;
    }

    private ICElementHandle getCElementForName(ICProject project, IIndex index, IName declName) throws CoreException {
        if (declName instanceof IIndexName) {
            return IndexUI.getCElementForName(project, index, (IIndexName)declName);
        }
        if (declName instanceof IASTName) {
            ITranslationUnit tu;
            IASTName astName = (IASTName)declName;
            IBinding binding = astName.resolveBinding();
            if (binding != null && (tu = IndexUI.getTranslationUnit(project, (IName)astName)) != null) {
                IASTFileLocation loc = astName.getFileLocation();
                Region region = new Region(loc.getNodeOffset(), loc.getNodeLength());
                return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)binding, (boolean)astName.isDefinition(), (IRegion)region, (long)0L);
            }
            return null;
        }
        return null;
    }

    private IName[] findNames(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        IName[] declNames = kind == NameKind.DEFINITION ? this.findDeclarations(index, ast, binding) : this.findDefinitions(index, ast, kind, binding);
        if (declNames.length == 0) {
            declNames = kind == NameKind.DEFINITION ? this.findDefinitions(index, ast, kind, binding) : this.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ArrayList<IASTName> declNames = new ArrayList<IASTName>();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            if (!(name.resolveBinding() instanceof ICPPUsingDeclaration)) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] declNames = ast.getDeclarationsInAST(binding);
        int i = 0;
        while (i < declNames.length) {
            Object name = declNames[i];
            if (name.isDefinition()) {
                declNames[i] = null;
            }
            ++i;
        }
        if ((declNames = (IName[])ArrayUtil.removeNulls(IName.class, (Object[])declNames)).length == 0) {
            declNames = index.findNames(binding, 9);
        }
        return declNames;
    }

    public void run() {
        this.computeSelectedWord();
        if (this.fTextSelection != null) {
            new WrapperJob().schedule();
        }
    }

    private void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public void runSync() throws CoreException {
        this.computeSelectedWord();
        if (this.fTextSelection != null) {
            this.performNavigation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void computeSelectedWord() {
        this.fTextSelection = this.getSelectedStringFromEditor();
        this.fSelectedText = null;
        if (this.fTextSelection != null) {
            if (this.fTextSelection.getLength() > 0) {
                this.fSelectedText = this.fTextSelection.getText();
            } else {
                IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                IRegion reg = CWordFinder.findWord(document, this.fTextSelection.getOffset());
                if (reg != null && reg.getLength() > 0) {
                    try {
                        this.fSelectedText = document.get(reg.getOffset(), reg.getLength());
                    }
                    catch (BadLocationException e) {
                        CUIPlugin.log(e);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NameKind {
        REFERENCE,
        DECLARATION,
        USING_DECL,
        DEFINITION;

    }

    private class WrapperJob
    extends Job {
        WrapperJob() {
            super(CEditorMessages.OpenDeclarations_dialog_title);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                return OpenDeclarationsAction.this.performNavigation(monitor);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }
}

