/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    protected StringMatcher fStringMatcher;
    private Composite fViewMenuButtonComposite;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private int fTreeStyle;

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        this.fTreeStyle = treeStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected Control createDialogArea(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent, this.fTreeStyle);
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.getId(), (StructuredViewer)this.fTreeViewer);
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.installFilter();
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this(parent, shellStyle, treeStyle, null, false);
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fFilterText;
    }

    protected String getStatusFieldText() {
        return "";
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                AbstractInformationControl.this.setMatcherString(text, true);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String pattern, boolean update) {
        if (pattern.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                IEditorPart part = EditorUtility.openInEditor(selectedElement, true);
                if (part != null && selectedElement instanceof ICElement) {
                    EditorUtility.revealInEditor(part, (ICElement)selectedElement);
                }
            }
            catch (CoreException ex) {
                CUIPlugin.log(ex);
            }
        }
    }

    protected void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        ICElement element = this.findElement(tree.getItems());
        if (element != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private ICElement findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item2 = treeItemArray[n2];
            Object item = item2.getData();
            ICElement element = null;
            if (item instanceof ICElement) {
                element = (ICElement)item;
                if (this.fStringMatcher == null) {
                    return element;
                }
                String label = labelProvider.getText((Object)element);
                if (this.fStringMatcher.match(label)) {
                    return element;
                }
            }
            if ((element = this.findElement(item2.getItems())) != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager viewMenu) {
        this.fCustomFiltersActionGroup.fillViewMenu(viewMenu);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(newInput);
        if (newSelection != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.fFilterText = this.createFilterText(parent);
        }
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.fFilterText = this.createFilterText(parent);
        return this.fFilterText;
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.fFilterText, this.fTreeViewer.getTree()});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.fFilterText});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTreeViewer.getTree()});
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        private final String COLON_COLON = String.valueOf(Keywords.cpCOLONCOLON);

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = AbstractInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if (matchName != null) {
                if (matcher.match(matchName)) {
                    return true;
                }
                int idx = matchName.lastIndexOf(this.COLON_COLON);
                if (idx >= 0 && matcher.match(matchName.substring(idx + this.COLON_COLON.length()))) {
                    return true;
                }
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            if (element instanceof IParent) {
                Object[] children;
                Object[] objectArray = children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element2 = objectArray[n2];
                    if (this.select((Viewer)viewer, element, element2)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

