/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.ExpansionOverlapsBoundaryException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNodeSearch;
import org.eclipse.cdt.internal.core.dom.parser.ChildCollector;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.Token;

public abstract class ASTNode
implements IASTNode {
    private static final IASTNodeLocation[] EMPTY_LOCATION_ARRAY = new IASTNodeLocation[0];
    private IASTNode parent;
    private ASTNodeProperty property;
    private int length;
    private int offset;
    private boolean frozen = false;
    private boolean active = true;
    private IASTNodeLocation[] locations = null;
    private IASTFileLocation fileLocation = null;

    public IASTNode getParent() {
        return this.parent;
    }

    public IASTNode[] getChildren() {
        ChildCollector collector = new ChildCollector(this);
        return collector.getChildren();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isActive() {
        return this.active;
    }

    public void freeze() {
        this.frozen = true;
        IASTNode[] iASTNodeArray = this.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child != null) {
                ((ASTNode)child).freeze();
            }
            ++n2;
        }
    }

    public void setInactive() {
        if (this.frozen) {
            throw new IllegalStateException("attempt to modify frozen AST node");
        }
        this.active = false;
    }

    protected void assertNotFrozen() throws IllegalStateException {
        if (this.frozen) {
            throw new IllegalStateException("attempt to modify frozen AST node");
        }
    }

    public void setParent(IASTNode node) {
        this.assertNotFrozen();
        this.parent = node;
    }

    public ASTNodeProperty getPropertyInParent() {
        return this.property;
    }

    public void setPropertyInParent(ASTNodeProperty property) {
        this.assertNotFrozen();
        this.property = property;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.locations = null;
    }

    public void setLength(int length) {
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.locations = null;
    }

    public void setOffsetAndLength(ASTNode node) {
        this.setOffsetAndLength(node.getOffset(), node.getLength());
    }

    public IASTNodeLocation[] getNodeLocations() {
        if (this.locations != null) {
            return this.locations;
        }
        if (this.length == 0) {
            this.locations = EMPTY_LOCATION_ARRAY;
        } else {
            ILocationResolver l;
            IASTTranslationUnit tu = this.getTranslationUnit();
            if (tu != null && (l = (ILocationResolver)tu.getAdapter(ILocationResolver.class)) != null) {
                this.locations = l.getLocations(this.offset, this.length);
            }
        }
        return this.locations;
    }

    public IASTImageLocation getImageLocation() {
        ILocationResolver l;
        IASTTranslationUnit tu = this.getTranslationUnit();
        if (tu != null && (l = (ILocationResolver)tu.getAdapter(ILocationResolver.class)) != null) {
            return l.getImageLocation(this.offset, this.length);
        }
        return null;
    }

    protected char[] getRawSignatureChars() {
        ILocationResolver lr;
        IASTFileLocation floc = this.getFileLocation();
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (floc != null && ast != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null) {
            return lr.getUnpreprocessedSignature(this.getFileLocation());
        }
        return CharArrayUtils.EMPTY;
    }

    public String getRawSignature() {
        return new String(this.getRawSignatureChars());
    }

    public String getContainingFilename() {
        if (this.offset <= 0 && (this.length == 0 || this.offset < 0)) {
            IASTNode parent = this.getParent();
            if (parent == null) {
                if (this instanceof IASTTranslationUnit) {
                    return ((IASTTranslationUnit)((Object)this)).getFilePath();
                }
                return "";
            }
            return parent.getContainingFilename();
        }
        return this.getTranslationUnit().getContainingFilename(this.offset);
    }

    public IASTFileLocation getFileLocation() {
        if (this.fileLocation != null) {
            return this.fileLocation;
        }
        if (this.offset <= 0 && (this.length == 0 || this.offset < 0)) {
            return null;
        }
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null) {
            ILocationResolver lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class);
            this.fileLocation = lr != null ? lr.getMappedFileLocation(this.offset, this.length) : ast.flattenLocationsToFile(this.getNodeLocations());
        }
        return this.fileLocation;
    }

    public boolean isPartOfTranslationUnitFile() {
        ILocationResolver lr;
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null) {
            return lr.isPartOfTranslationUnitFile(this.offset);
        }
        return false;
    }

    public boolean isPartOfSourceFile() {
        ILocationResolver lr;
        IASTTranslationUnit ast = this.getTranslationUnit();
        if (ast != null && (lr = (ILocationResolver)ast.getAdapter(ILocationResolver.class)) != null) {
            return lr.isPartOfSourceFile(this.offset);
        }
        return false;
    }

    public IASTTranslationUnit getTranslationUnit() {
        return this.parent != null ? this.parent.getTranslationUnit() : null;
    }

    public boolean accept(ASTVisitor visitor) {
        return true;
    }

    public boolean contains(IASTNode node) {
        if (node instanceof ASTNode) {
            ASTNode astNode = (ASTNode)node;
            return this.offset <= astNode.offset && astNode.offset + astNode.length <= this.offset + this.length;
        }
        return false;
    }

    public IToken getSyntax() throws ExpansionOverlapsBoundaryException {
        return this.getSyntax(this.offset, this.offset + this.length, 0);
    }

    public IToken getLeadingSyntax() throws ExpansionOverlapsBoundaryException {
        int left = this.getBoundary(-1);
        return this.getSyntax(left, this.offset, -1);
    }

    public IToken getTrailingSyntax() throws ExpansionOverlapsBoundaryException {
        int right = this.getBoundary(1);
        return this.getSyntax(this.offset + this.length, right, 1);
    }

    private int getBoundary(int direction) {
        IASTNode sib;
        ASTNodeSearch visitor = new ASTNodeSearch(this);
        IASTNode iASTNode = sib = direction < 0 ? visitor.findLeftSibling() : visitor.findRightSibling();
        if (sib == null) {
            direction = -direction;
            sib = this.getParent();
        }
        if (sib instanceof ASTNode) {
            ASTNode astNode = (ASTNode)sib;
            int offset = astNode.getOffset();
            if (direction < 0) {
                offset += astNode.getLength();
            }
            return offset;
        }
        throw new UnsupportedOperationException();
    }

    private IToken getSyntax(int fromSequenceNumber, int nextSequenceNumber, int direction) throws ExpansionOverlapsBoundaryException {
        Token result;
        Lexer lex;
        int adjustment;
        block11: {
            IASTFileLocation fl;
            IASTTranslationUnit tu = this.getTranslationUnit();
            if (!(tu instanceof ASTNode)) {
                throw new UnsupportedOperationException();
            }
            ILocationResolver lr = (ILocationResolver)tu.getAdapter(ILocationResolver.class);
            if (lr == null) {
                throw new UnsupportedOperationException();
            }
            int endSequenceNumber = lr.convertToSequenceEndNumber(nextSequenceNumber);
            IASTFileLocation total = lr.getMappedFileLocation(fromSequenceNumber, endSequenceNumber - fromSequenceNumber);
            IASTFileLocation myfloc = this.getFileLocation();
            if (total == null || myfloc == null) {
                throw new UnsupportedOperationException();
            }
            if (!total.getFileName().equals(myfloc.getFileName())) {
                throw new ExpansionOverlapsBoundaryException();
            }
            if (fromSequenceNumber > 0 && (fl = lr.getMappedFileLocation(fromSequenceNumber - 1, endSequenceNumber - fromSequenceNumber + 1)).getFileName().equals(total.getFileName()) && fl.getNodeOffset() == total.getNodeOffset()) {
                throw new ExpansionOverlapsBoundaryException();
            }
            if (endSequenceNumber < ((ASTNode)((Object)tu)).getOffset() + ((ASTNode)((Object)tu)).getLength() && (fl = lr.getMappedFileLocation(fromSequenceNumber, nextSequenceNumber - fromSequenceNumber + 1)).getFileName().equals(total.getFileName()) && fl.getNodeLength() == total.getNodeLength()) {
                throw new ExpansionOverlapsBoundaryException();
            }
            adjustment = total.getNodeOffset() - myfloc.getNodeOffset();
            if (direction > 0) {
                adjustment -= myfloc.getNodeLength();
            }
            char[] txt = lr.getUnpreprocessedSignature(total);
            lex = new Lexer(txt, (Lexer.LexerOptions)tu.getAdapter(Lexer.LexerOptions.class), ILexerLog.NULL, null);
            result = lex.nextToken();
            if (result.getType() != 144) break block11;
            return null;
        }
        try {
            Token last = result;
            while (true) {
                int offset = last.getOffset() + adjustment;
                int endOffset = last.getEndOffset() + adjustment;
                last.setOffset(offset, endOffset);
                Token t = lex.nextToken();
                if (t.getType() == 144) break;
                last.setNext(t);
                last = t;
            }
            return result;
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
            return null;
        }
    }
}

