/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;

class FunctionCost {
    private final IFunction fFunction;
    private final Cost[] fCosts;

    public FunctionCost(IFunction fn, int paramCount) {
        this.fFunction = fn;
        this.fCosts = new Cost[paramCount];
    }

    public int getLength() {
        return this.fCosts.length;
    }

    public Cost getCost(int idx) {
        return this.fCosts[idx];
    }

    public void setCost(int idx, Cost cost) {
        this.fCosts[idx] = cost;
    }

    public IFunction getFunction() {
        return this.fFunction;
    }

    public boolean hasAmbiguousUserDefinedConversion() {
        Cost[] costArray = this.fCosts;
        int n = this.fCosts.length;
        int n2 = 0;
        while (n2 < n) {
            Cost cost = costArray[n2];
            if (cost.isAmbiguousUDC()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasDeferredUDC() {
        Cost[] costArray = this.fCosts;
        int n = this.fCosts.length;
        int n2 = 0;
        while (n2 < n) {
            Cost cost = costArray[n2];
            if (cost.isDeferredUDC()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean performUDC() throws DOMException {
        int i = 0;
        while (i < this.fCosts.length) {
            Cost cost = this.fCosts[i];
            if (cost.isDeferredUDC()) {
                Cost udcCost = Conversions.checkUserDefinedConversionSequence(cost.source, cost.target, false);
                if (udcCost == null) {
                    return false;
                }
                this.fCosts[i] = udcCost;
            }
            ++i;
        }
        return true;
    }

    public int compareTo(LookupData data, FunctionCost other) throws DOMException {
        if (other == null) {
            return -1;
        }
        boolean haveWorse = false;
        boolean haveBetter = false;
        int idx = this.getLength() - 1;
        int idxOther = other.getLength() - 1;
        while (idx >= 0 && idxOther >= 0) {
            Cost cost = this.getCost(idx);
            if (cost.getRank() == Cost.Rank.NO_MATCH) {
                haveWorse = true;
                haveBetter = false;
                break;
            }
            int cmp = cost.compareTo(other.getCost(idxOther));
            haveWorse |= cmp > 0;
            haveBetter |= cmp < 0;
            --idx;
            --idxOther;
        }
        if (!haveWorse && !haveBetter) {
            boolean otherIsTemplate;
            ICPPFunctionTemplate asTemplate = FunctionCost.asTemplate(this.getFunction());
            ICPPFunctionTemplate otherAsTemplate = FunctionCost.asTemplate(other.getFunction());
            boolean isTemplate = asTemplate != null;
            boolean bl = otherIsTemplate = otherAsTemplate != null;
            if (isTemplate && !otherIsTemplate) {
                haveWorse = true;
            } else if (!isTemplate && otherIsTemplate) {
                haveBetter = true;
            } else if (isTemplate && otherIsTemplate) {
                int order = CPPTemplates.orderTemplateFunctions(otherAsTemplate, asTemplate);
                if (order < 0) {
                    haveBetter = true;
                } else if (order > 0) {
                    haveWorse = true;
                }
            }
        }
        if (haveBetter == haveWorse) {
            return -CPPSemantics.compareByRelevance(data, this.getFunction(), other.getFunction());
        }
        if (haveBetter) {
            return -1;
        }
        return 1;
    }

    public boolean mustBeWorse(FunctionCost other) {
        if (other == null) {
            return false;
        }
        boolean haveWorse = false;
        int idx = this.getLength() - 1;
        int idxOther = other.getLength() - 1;
        while (idx >= 0 && idxOther >= 0) {
            Cost cost = this.getCost(idx);
            if (cost.getRank() == Cost.Rank.NO_MATCH) {
                return true;
            }
            Cost otherCost = other.getCost(idxOther);
            int cmp = cost.isDeferredUDC() ? cost.getRank().compareTo(otherCost.getRank()) : cost.compareTo(otherCost);
            if (cmp < 0) {
                return false;
            }
            if (cmp > 0) {
                haveWorse = true;
            }
            --idx;
            --idxOther;
        }
        return haveWorse;
    }

    private static ICPPFunctionTemplate asTemplate(IFunction function) {
        IBinding original;
        if (function instanceof ICPPSpecialization && (original = ((ICPPSpecialization)((Object)function)).getSpecializedBinding()) instanceof ICPPFunctionTemplate) {
            return (ICPPFunctionTemplate)original;
        }
        return null;
    }
}

