/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.LocalProjectScope;
import org.eclipse.cdt.internal.core.model.Archive;
import org.eclipse.cdt.internal.core.model.ArchiveContainer;
import org.eclipse.cdt.internal.core.model.Binary;
import org.eclipse.cdt.internal.core.model.BinaryContainer;
import org.eclipse.cdt.internal.core.model.BinaryParserConfig;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelCache;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.CShiftData;
import org.eclipse.cdt.internal.core.model.ContentTypeProcessor;
import org.eclipse.cdt.internal.core.model.DeltaProcessor;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.SourceMapper;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CModelManager
implements IResourceChangeListener,
ICDescriptorListener,
IContentTypeManager.IContentTypeChangeListener {
    public static boolean VERBOSE = false;
    final CModel cModel = new CModel();
    public static HashSet<String> OptionNames = new HashSet(20);
    public static final int DEFAULT_CHANGE_EVENT = 0;
    protected final DeltaProcessor fDeltaProcessor = new DeltaProcessor();
    List<ICElementDelta> fCModelDeltas = Collections.synchronizedList(new ArrayList());
    HashMap<IWorkingCopy, ICElementDelta> reconcileDeltas = new HashMap();
    protected boolean fFire = true;
    protected List<IElementChangedListener> fElementChangedListeners = Collections.synchronizedList(new ArrayList());
    public Map<IBufferFactory, Map<ITranslationUnit, WorkingCopy>> sharedWorkingCopies = new HashMap<IBufferFactory, Map<ITranslationUnit, WorkingCopy>>();
    protected Map<ICElement, ICElement> elementsOutOfSynchWithBuffers = new HashMap<ICElement, ICElement>(11);
    private ThreadLocal<Map<ICElement, CElementInfo>> temporaryCache = new ThreadLocal();
    protected CModelCache cache = new CModelCache();
    public ICProject[] cProjectsCache;
    private HashMap<IProject, BinaryRunner> binaryRunners = new HashMap();
    private HashMap<IProject, BinaryParserConfig[]> binaryParsersMap = new HashMap();
    private HashMap<ICProject, SourceMapper> sourceMappers = new HashMap();
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    static volatile CModelManager factory = null;

    private CModelManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CModelManager getDefault() {
        if (factory != null) return factory;
        Class<CModelManager> clazz = CModelManager.class;
        synchronized (CModelManager.class) {
            if (factory != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return factory;
            }
            factory = new CModelManager();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)factory, 7);
            CCorePlugin.getDefault().getCDescriptorManager().addDescriptorListener(factory);
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)factory);
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    public ICModel getCModel(IWorkspaceRoot root) {
        return this.getCModel();
    }

    public CModel getCModel() {
        return this.cModel;
    }

    public ICElement create(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = root.findMember(path);
        if (res == null) {
            IPath rootPath = root.getLocation();
            if (path.equals((Object)rootPath)) {
                return this.getCModel(root);
            }
            res = root.getContainerForLocation(path);
            if (res == null || !res.exists()) {
                res = root.getFileForLocation(path);
            }
            if (res != null && !res.exists()) {
                res = null;
            }
        }
        if (res == null) {
            res = ResourceLookup.selectFileForLocation(path, null);
        }
        return this.create(res, null);
    }

    public ICElement create(IResource resource, ICProject cproject) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return this.create((IProject)resource);
            }
            case 1: {
                return this.create((IFile)resource, cproject);
            }
            case 2: {
                return this.create((IFolder)resource, cproject);
            }
            case 8: {
                return this.getCModel((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public ICProject create(IProject project) {
        if (project == null) {
            return null;
        }
        return this.cModel.getCProject((IResource)project);
    }

    public ICContainer create(IFolder folder, ICProject cproject) {
        if (folder == null) {
            return null;
        }
        if (cproject == null) {
            cproject = this.create(folder.getProject());
        }
        try {
            ICElement[] children = cproject.getChildren();
            int i = 0;
            while (i < children.length) {
                IPath path;
                IPath rootPath;
                ICContainer root;
                if (children[i] instanceof ISourceRoot) {
                    root = (ISourceRoot)children[i];
                    if (root.isOnSourceEntry((IResource)folder)) {
                        IPath path2 = folder.getFullPath();
                        path2 = path2.removeFirstSegments(root.getPath().segmentCount());
                        String[] segments = path2.segments();
                        ICContainer cfolder = root;
                        int j = 0;
                        while (j < segments.length) {
                            cfolder = cfolder.getCContainer(segments[j]);
                            ++j;
                        }
                        return cfolder;
                    }
                } else if (children[i] instanceof ICContainer && (rootPath = (root = (ICContainer)children[i]).getPath()).isPrefixOf(path = folder.getFullPath()) && cproject.isOnOutputEntry((IResource)folder)) {
                    path = path.removeFirstSegments(root.getPath().segmentCount());
                    String[] segments = path.segments();
                    ICContainer cfolder = root;
                    int j = 0;
                    while (j < segments.length) {
                        cfolder = cfolder.getCContainer(segments[j]);
                        ++j;
                    }
                    return cfolder;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public ICElement create(IFile file, ICProject cproject) {
        if (file == null) {
            return null;
        }
        if (cproject == null) {
            cproject = this.create(file.getProject());
        }
        ICElement celement = null;
        try {
            IBinaryParser.IBinaryFile bin;
            IPath resourcePath = file.getFullPath();
            ISourceRoot[] roots = cproject.getSourceRoots();
            int i = 0;
            while (i < roots.length) {
                ISourceRoot root = roots[i];
                if (root.isOnSourceEntry((IResource)file)) {
                    IPath rootPath = root.getPath();
                    IPath path = resourcePath.removeFirstSegments(rootPath.segmentCount());
                    String fileName = path.lastSegment();
                    path = path.removeLastSegments(1);
                    String[] segments = path.segments();
                    ICContainer cfolder = root;
                    String[] stringArray = segments;
                    int n = segments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String segment = stringArray[n2];
                        cfolder = cfolder.getCContainer(segment);
                        ++n2;
                    }
                    if (!CoreModel.isValidTranslationUnitName(cproject.getProject(), fileName)) break;
                    celement = cfolder.getTranslationUnit(fileName);
                    break;
                }
                ++i;
            }
            if (celement == null && cproject.isOnOutputEntry((IResource)file) && (bin = this.createBinaryFile(file)) != null) {
                celement = this.create(file, bin, cproject);
            }
        }
        catch (CModelException cModelException) {}
        return celement;
    }

    public ICElement create(IFile file, IBinaryParser.IBinaryFile bin, ICProject cproject) {
        if (file == null) {
            return null;
        }
        if (bin == null) {
            return this.create(file, cproject);
        }
        if (cproject == null) {
            cproject = this.create(file.getProject());
        }
        Openable celement = null;
        try {
            if (cproject.isOnOutputEntry((IResource)file)) {
                IPath resourcePath = file.getParent().getFullPath();
                ICElement cfolder = cproject.findElement(resourcePath);
                ISourceRoot sourceRoot = cproject.findSourceRoot(resourcePath);
                if (sourceRoot != null) {
                    cfolder = sourceRoot;
                }
                if (bin.getType() == 8) {
                    ArchiveContainer vlib = (ArchiveContainer)cproject.getArchiveContainer();
                    celement = new Archive(cfolder, file, (IBinaryParser.IBinaryArchive)bin);
                    vlib.addChild(celement);
                } else {
                    BinaryContainer vbin = (BinaryContainer)cproject.getBinaryContainer();
                    celement = new Binary(cfolder, file, (IBinaryParser.IBinaryObject)bin);
                    vbin.addChild(celement);
                }
            }
        }
        catch (CModelException cModelException) {}
        return celement;
    }

    public ITranslationUnit createTranslationUnitFrom(ICProject cproject, IPath path) {
        if (path == null || cproject == null) {
            return null;
        }
        IProject project = cproject.getProject();
        String contentTypeId = CoreModel.getRegistedContentTypeId(project, path.lastSegment());
        if (path.isAbsolute()) {
            if (!Util.isNonZeroLengthFile(path)) {
                return null;
            }
            try {
                IIncludeReference[] includeReferences;
                IIncludeReference[] iIncludeReferenceArray = includeReferences = cproject.getIncludeReferences();
                int n = includeReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IIncludeReference includeReference = iIncludeReferenceArray[n2];
                    if (includeReference.isOnIncludeEntry(path)) {
                        String headerContentTypeId = contentTypeId;
                        if (headerContentTypeId == null) {
                            headerContentTypeId = CoreModel.hasCCNature(project) ? "org.eclipse.cdt.core.cxxHeader" : "org.eclipse.cdt.core.cHeader";
                        }
                        return new ExternalTranslationUnit((ICElement)includeReference, URIUtil.toURI((IPath)path), headerContentTypeId);
                    }
                    ++n2;
                }
            }
            catch (CModelException cModelException) {}
            if (contentTypeId != null && path.toFile().exists()) {
                return new ExternalTranslationUnit((ICElement)cproject, URIUtil.toURI((IPath)path), contentTypeId);
            }
        } else {
            try {
                IIncludeReference[] includeReferences;
                IIncludeReference[] iIncludeReferenceArray = includeReferences = cproject.getIncludeReferences();
                int n = includeReferences.length;
                int n3 = 0;
                while (n3 < n) {
                    IIncludeReference includeReference = iIncludeReferenceArray[n3];
                    IPath includePath = includeReference.getPath().append(path);
                    if (Util.isNonZeroLengthFile(includePath)) {
                        String headerContentTypeId = contentTypeId;
                        if (headerContentTypeId == null) {
                            headerContentTypeId = CoreModel.hasCCNature(project) ? "org.eclipse.cdt.core.cxxHeader" : "org.eclipse.cdt.core.cHeader";
                        }
                        return new ExternalTranslationUnit((ICElement)includeReference, URIUtil.toURI((IPath)includePath), headerContentTypeId);
                    }
                    ++n3;
                }
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public ITranslationUnit createTranslationUnitFrom(ICProject cproject, URI locationURI) {
        if (locationURI == null || cproject == null) {
            return null;
        }
        if (!locationURI.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        IProject project = cproject.getProject();
        IFileStore fileStore = null;
        try {
            fileStore = EFS.getStore((URI)locationURI);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            return null;
        }
        String contentTypeId = CoreModel.getRegistedContentTypeId(project, fileStore.getName());
        if (!Util.isNonZeroLengthFile(locationURI)) {
            return null;
        }
        try {
            IIncludeReference[] includeReferences;
            IIncludeReference[] iIncludeReferenceArray = includeReferences = cproject.getIncludeReferences();
            int n = includeReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IIncludeReference includeReference = iIncludeReferenceArray[n2];
                IPath path = URIUtil.toPath((URI)locationURI);
                if (path != null && includeReference.isOnIncludeEntry(path)) {
                    String headerContentTypeId = contentTypeId;
                    if (headerContentTypeId == null) {
                        headerContentTypeId = CoreModel.hasCCNature(project) ? "org.eclipse.cdt.core.cxxHeader" : "org.eclipse.cdt.core.cHeader";
                    }
                    return new ExternalTranslationUnit((ICElement)includeReference, locationURI, headerContentTypeId);
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {}
        IFileInfo info = fileStore.fetchInfo();
        if (contentTypeId != null && info != null && info.exists()) {
            return new ExternalTranslationUnit((ICElement)cproject, locationURI, contentTypeId);
        }
        return null;
    }

    public void releaseCElement(ICElement celement) {
        if (celement == null) {
            return;
        }
        if (celement instanceof IParent) {
            CElementInfo info = (CElementInfo)this.peekAtInfo(celement);
            if (info != null) {
                ICElement[] children;
                ICElement[] iCElementArray = children = info.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement element = iCElementArray[n2];
                    this.releaseCElement(element);
                    ++n2;
                }
            }
            if (celement instanceof CElement) {
                try {
                    ((CElement)celement).closing(info);
                }
                catch (CModelException cModelException) {}
            }
            if (celement.getElementType() == 12) {
                int n;
                int n3;
                ICElement[] iCElementArray;
                ICProject cproject = celement.getCProject();
                CProjectInfo pinfo = (CProjectInfo)this.peekAtInfo(cproject);
                ArrayList<ICElement> list = new ArrayList<ICElement>(5);
                if (pinfo != null && pinfo.vBin != null && this.peekAtInfo(pinfo.vBin) != null) {
                    try {
                        ICElement[] bins;
                        iCElementArray = bins = pinfo.vBin.getChildren();
                        n3 = bins.length;
                        n = 0;
                        while (n < n3) {
                            ICElement bin = iCElementArray[n];
                            if (celement.getPath().isPrefixOf(bin.getPath())) {
                                list.add(bin);
                            }
                            ++n;
                        }
                    }
                    catch (CModelException cModelException) {}
                }
                if (pinfo != null && pinfo.vLib != null && this.peekAtInfo(pinfo.vLib) != null) {
                    try {
                        ICElement[] ars;
                        iCElementArray = ars = pinfo.vLib.getChildren();
                        n3 = ars.length;
                        n = 0;
                        while (n < n3) {
                            ICElement ar = iCElementArray[n];
                            if (celement.getPath().isPrefixOf(ar.getPath())) {
                                list.add(ar);
                            }
                            ++n;
                        }
                    }
                    catch (CModelException cModelException) {}
                }
                int i = 0;
                while (i < list.size()) {
                    ICElement b = (ICElement)list.get(i);
                    this.releaseCElement(b);
                    ++i;
                }
            }
        }
        this.removeInfo(celement);
    }

    public BinaryParserConfig[] getBinaryParser(IProject project) {
        BinaryParserConfig[] parsers = this.binaryParsersMap.get(project);
        if (parsers == null) {
            try {
                ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(project, false);
                if (cdesc != null) {
                    ICExtensionReference[] cextensions = cdesc.get("org.eclipse.cdt.core.BinaryParser", true);
                    if (cextensions.length > 0) {
                        ArrayList<BinaryParserConfig> list = new ArrayList<BinaryParserConfig>(cextensions.length);
                        ICExtensionReference[] iCExtensionReferenceArray = cextensions;
                        int n = cextensions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ICExtensionReference cextension = iCExtensionReferenceArray[n2];
                            BinaryParserConfig config = new BinaryParserConfig(cextension);
                            list.add(config);
                            ++n2;
                        }
                        parsers = new BinaryParserConfig[list.size()];
                        list.toArray(parsers);
                    } else {
                        parsers = new BinaryParserConfig[]{};
                    }
                }
            }
            catch (CoreException coreException) {}
            if (parsers == null) {
                try {
                    BinaryParserConfig config = new BinaryParserConfig(CCorePlugin.getDefault().getDefaultBinaryParser(), "org.eclipse.cdt.core.ELF");
                    parsers = new BinaryParserConfig[]{config};
                }
                catch (CoreException coreException) {}
            }
        }
        if (parsers != null) {
            this.binaryParsersMap.put(project, parsers);
            return parsers;
        }
        return new BinaryParserConfig[0];
    }

    public IBinaryParser.IBinaryFile createBinaryFile(IFile file) {
        byte[] bytes;
        BinaryParserConfig[] parsers;
        block37: {
            File f;
            BinaryParserConfig[] cts;
            parsers = this.getBinaryParser(file.getProject());
            if (parsers.length == 0) {
                return null;
            }
            String ext = file.getFileExtension();
            if (ext != null) {
                boolean isNumber = true;
                int i = 0;
                while (i < ext.length()) {
                    if (!Character.isDigit(ext.charAt(i))) {
                        isNumber = false;
                        break;
                    }
                    ++i;
                }
                if (!isNumber) {
                    boolean isBinary = false;
                    IContentTypeManager ctm = Platform.getContentTypeManager();
                    IContentType ctbin = ctm.getContentType("org.eclipse.cdt.core.binaryFile");
                    cts = ctm.findContentTypesFor(file.getName());
                    int i2 = 0;
                    while (!isBinary && i2 < cts.length) {
                        isBinary = cts[i2].isKindOf(ctbin);
                        ++i2;
                    }
                    if (!isBinary) {
                        return null;
                    }
                }
            }
            if (!Util.isNonZeroLengthFile(file.getLocationURI()) && (f = new File(file.getLocationURI())).length() == 0L) {
                return null;
            }
            int hints = 0;
            cts = parsers;
            int ctbin = parsers.length;
            int ctm = 0;
            while (ctm < ctbin) {
                BinaryParserConfig parser2 = cts[ctm];
                IBinaryParser parser = null;
                try {
                    parser = parser2.getBinaryParser();
                    if (parser.getHintBufferSize() > hints) {
                        hints = Math.max(hints, parser.getHintBufferSize());
                    }
                }
                catch (CoreException coreException) {}
                ++ctm;
            }
            bytes = new byte[hints];
            if (hints > 0) {
                InputStream is = null;
                try {
                    is = file.getContents();
                    int count = 0;
                    while (count < hints) {
                        int bytesRead = is.read(bytes, count, hints - count);
                        if (bytesRead < 0) break;
                        count += bytesRead;
                    }
                    if (count > 0 && count < bytes.length) {
                        byte[] array = new byte[count];
                        System.arraycopy(bytes, 0, array, 0, count);
                        bytes = array;
                    }
                }
                catch (CoreException coreException) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return null;
                }
                catch (IOException iOException) {
                    block36: {
                        try {
                            if (is == null) break block36;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    return null;
                }
                if (is == null) break block37;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        IPath location = file.getLocation();
        BinaryParserConfig[] binaryParserConfigArray = parsers;
        int n = parsers.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryParserConfig parser2 = binaryParserConfigArray[n2];
            try {
                IBinaryParser.IBinaryFile binFile;
                IBinaryParser parser = parser2.getBinaryParser();
                if (parser.isBinary(bytes, location) && (binFile = parser.getBinary(bytes, location)) != null) {
                    return binFile;
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    public void resetBinaryParser(IProject project) {
        ICProject cproject;
        if (project != null && (cproject = this.create(project)) != null) {
            try {
                cproject.close();
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
            this.binaryParsersMap.remove(project);
            CElementDelta delta = new CElementDelta(this.getCModel());
            delta.binaryParserChanged(cproject);
            this.registerCModelDelta(delta);
            this.fire(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryRunner getBinaryRunner(ICProject cproject) {
        BinaryRunner runner = null;
        HashMap<IProject, BinaryRunner> hashMap = this.binaryRunners;
        synchronized (hashMap) {
            IProject project = cproject.getProject();
            runner = this.binaryRunners.get(project);
            if (runner == null) {
                runner = new BinaryRunner(project);
                this.binaryRunners.put(project, runner);
                runner.start();
            }
        }
        return runner;
    }

    public void removeBinaryRunner(ICProject cproject) {
        this.removeBinaryRunner(cproject.getProject());
    }

    public void removeBinaryRunner(IProject project) {
        BinaryRunner runner = this.binaryRunners.remove(project);
        if (runner != null) {
            runner.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceMapper getSourceMapper(ICProject cProject) {
        SourceMapper mapper = null;
        HashMap<ICProject, SourceMapper> hashMap = this.sourceMappers;
        synchronized (hashMap) {
            mapper = this.sourceMappers.get(cProject);
            if (mapper == null) {
                mapper = new SourceMapper(cProject);
                this.sourceMappers.put(cProject, mapper);
            }
        }
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElementChangedListener(IElementChangedListener listener) {
        List<IElementChangedListener> list = this.fElementChangedListeners;
        synchronized (list) {
            if (!this.fElementChangedListeners.contains(listener)) {
                this.fElementChangedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElementChangedListener(IElementChangedListener listener) {
        List<IElementChangedListener> list = this.fElementChangedListeners;
        synchronized (list) {
            int i = this.fElementChangedListeners.indexOf(listener);
            if (i != -1) {
                this.fElementChangedListeners.remove(i);
            }
        }
    }

    public void registerCModelDelta(ICElementDelta delta) {
        this.fCModelDeltas.add(delta);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResourceDelta delta = event.getDelta();
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 4: {
                    try {
                        if (resource.getType() != 4 || !((IProject)resource).hasNature("org.eclipse.cdt.core.cnature") && !((IProject)resource).hasNature("org.eclipse.cdt.core.ccnature")) break;
                        this.preDeleteProject((IProject)resource);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 2: {
                    try {
                        if (resource.getType() != 4 || !((IProject)resource).hasNature("org.eclipse.cdt.core.cnature") && !((IProject)resource).hasNature("org.eclipse.cdt.core.ccnature")) break;
                        this.preCloseProject((IProject)resource);
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                case 1: {
                    try {
                        if (delta == null) break;
                        this.checkForProjectRename(delta);
                        ICElementDelta[] translatedDeltas = this.fDeltaProcessor.processResourceDelta(delta);
                        if (translatedDeltas.length > 0) {
                            ICElementDelta[] iCElementDeltaArray = translatedDeltas;
                            int n = translatedDeltas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ICElementDelta translatedDelta = iCElementDeltaArray[n2];
                                this.registerCModelDelta(translatedDelta);
                                ++n2;
                            }
                        }
                        this.fire(1);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void descriptorChanged(CDescriptorEvent event) {
        block6: {
            ICDescriptor cdesc;
            int flags = event.getFlags();
            if ((flags & 0x20) != 0 && (cdesc = event.getDescriptor()) != null) {
                IProject project = cdesc.getProject();
                try {
                    ICExtensionReference[] newExts = CCorePlugin.getDefault().getBinaryParserExtensions(project);
                    BinaryParserConfig[] currentConfigs = this.getBinaryParser(project);
                    if (newExts.length != currentConfigs.length) {
                        this.resetBinaryParser(project);
                        break block6;
                    }
                    int i = 0;
                    while (i < newExts.length) {
                        if (!newExts[i].getID().equals(currentConfigs[i].getId())) {
                            this.resetBinaryParser(project);
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {
                    this.resetBinaryParser(project);
                }
            }
        }
    }

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
        ContentTypeProcessor.processContentTypeChanges(new IContentTypeManager.ContentTypeChangeEvent[]{event});
    }

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent[] events) {
        ContentTypeProcessor.processContentTypeChanges(events);
    }

    public void fire(int eventType) {
        this.fire(null, eventType);
    }

    public void fireShift(ICElement element, int offset, int size, int lines) {
        CShiftData delta = new CShiftData(element, offset, size, lines);
        this.fire(delta, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fire(ICElementDelta customDeltas, int eventType) {
        if (this.fFire) {
            int[] listenerMask;
            int listenerCount;
            IElementChangedListener[] listeners;
            ICElementDelta deltaToNotify = customDeltas == null ? this.mergeDeltas(this.fCModelDeltas) : customDeltas;
            List<IElementChangedListener> list = this.fElementChangedListeners;
            synchronized (list) {
                listeners = new IElementChangedListener[this.fElementChangedListeners.size()];
                this.fElementChangedListeners.toArray(listeners);
                listenerCount = listeners.length;
                listenerMask = null;
            }
            switch (eventType) {
                case 0: {
                    this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                    this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                    this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                    break;
                }
                case 2: {
                    this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                    break;
                }
                case 1: {
                    this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                    this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                    break;
                }
                case 4: {
                    this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                    break;
                }
                case 5: {
                    this.fireShiftEvent(deltaToNotify, listeners, listenerMask, listenerCount);
                    return;
                }
            }
        }
    }

    private void firePreAutoBuildDelta(ICElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (Util.VERBOSE_DELTA) {
            System.out.println("FIRING PRE_AUTO_BUILD Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.notifyListeners(deltaToNotify, 2, listeners, listenerMask, listenerCount);
        }
    }

    private void firePostChangeDelta(ICElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (Util.VERBOSE_DELTA) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        ICElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (Util.VERBOSE_DELTA) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    private void fireShiftEvent(ICElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (Util.VERBOSE_DELTA) {
            System.out.println("FIRING POST_SHIFT event [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 5, listeners, listenerMask, listenerCount);
        }
    }

    public void notifyListeners(ICElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if (listenerMask == null || (listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (Util.VERBOSE_DELTA) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        CCorePlugin.log(exception);
                    }

                    public void run() throws Exception {
                        listener.elementChanged(extraEvent);
                    }
                });
                if (Util.VERBOSE_DELTA) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    protected void flush() {
        this.fCModelDeltas.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICElementDelta mergeDeltas(Collection<ICElementDelta> deltas) {
        Collection<ICElementDelta> collection = deltas;
        synchronized (collection) {
            block12: {
                block11: {
                    if (deltas.size() != 0) break block11;
                    return null;
                }
                if (deltas.size() == 1) {
                    return deltas.iterator().next();
                }
                if (deltas.size() > 1) break block12;
                return null;
            }
            CModel cRoot = this.getCModel();
            CElementDelta rootDelta = new CElementDelta(cRoot);
            boolean insertedTree = false;
            for (ICElementDelta delta : deltas) {
                ICElement element = delta.getElement();
                if (((Object)cRoot).equals(element)) {
                    ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
                    int n = iCElementDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICElementDelta child = iCElementDeltaArray[n2];
                        CElementDelta projectDelta = (CElementDelta)child;
                        rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                        insertedTree = true;
                        ++n2;
                    }
                    IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                    if (resourceDeltas == null) continue;
                    IResourceDelta[] iResourceDeltaArray = resourceDeltas;
                    int n3 = resourceDeltas.length;
                    n = 0;
                    while (n < n3) {
                        IResourceDelta resourceDelta = iResourceDeltaArray[n];
                        rootDelta.addResourceDelta(resourceDelta);
                        insertedTree = true;
                        ++n;
                    }
                    continue;
                }
                rootDelta.insertDeltaTree(element, (CElementDelta)delta);
                insertedTree = true;
            }
            if (insertedTree) {
                return rootDelta;
            }
            return null;
        }
    }

    protected Map<ICElement, ICElement> getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public synchronized Object getInfo(ICElement element) {
        CElementInfo result;
        Map<ICElement, CElementInfo> tempCache = this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.getInfo(element);
    }

    protected synchronized Object peekAtInfo(ICElement element) {
        CElementInfo result;
        Map<ICElement, CElementInfo> tempCache = this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.peekAtInfo(element);
    }

    protected synchronized void putInfos(ICElement openedElement, Map<ICElement, CElementInfo> newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof CElementInfo) {
            ICElement[] children = ((CElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                CElement child = (CElement)children[i];
                try {
                    child.close();
                }
                catch (CModelException cModelException) {}
                ++i;
            }
        }
        for (Map.Entry<ICElement, CElementInfo> element : newElements.entrySet()) {
            this.cache.putInfo(element.getKey(), element.getValue());
        }
    }

    protected synchronized void removeChildrenInfo(ICElement openedElement) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof CElementInfo) {
            ICElement[] children = ((CElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                CElement child = (CElement)children[i];
                try {
                    child.close();
                }
                catch (CModelException cModelException) {}
                ++i;
            }
        }
    }

    protected synchronized void removeInfo(ICElement element) {
        this.cache.removeInfo(element);
    }

    public Map<ICElement, CElementInfo> getTemporaryCache() {
        Map<ICElement, CElementInfo> result = this.temporaryCache.get();
        if (result == null) {
            result = new HashMap<ICElement, CElementInfo>();
            this.temporaryCache.set(result);
        }
        return result;
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public void startup() {
    }

    public void shutdown() {
        BinaryRunner[] runners;
        CCorePlugin.getDefault().getCDescriptorManager().removeDescriptorListener(factory);
        Platform.getContentTypeManager().removeContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)factory);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)factory);
        BinaryRunner[] binaryRunnerArray = runners = this.binaryRunners.values().toArray(new BinaryRunner[0]);
        int n = runners.length;
        int n2 = 0;
        while (n2 < n) {
            BinaryRunner runner = binaryRunnerArray[n2];
            runner.stop();
            ++n2;
        }
        factory = null;
    }

    private void checkForProjectRename(IResourceDelta delta) {
        IResourceDelta[] rem;
        IResourceDelta[] iResourceDeltaArray = rem = delta.getAffectedChildren(2);
        int n = rem.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta element = iResourceDeltaArray[n2];
            delta = element;
            IResource res = delta.getResource();
            if (res.getType() == 4) {
                IPath movedTo = null;
                if ((delta.getFlags() & 0x2000) != 0) {
                    movedTo = delta.getMovedToPath();
                }
                LocalProjectScope.deletePreferences(res.getFullPath(), movedTo);
            }
            ++n2;
        }
    }

    private void preDeleteProject(IProject project) {
        this.removeBinaryRunner(project);
        CCoreInternals.getPDOMManager().preDeleteProject(this.create(project));
    }

    private void preCloseProject(IProject project) {
        this.removeBinaryRunner(project);
        CCoreInternals.getPDOMManager().preCloseProject(this.create(project));
    }
}

