/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.internal.core.model.APathEntry;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IncludeFileEntry
extends APathEntry
implements IIncludeFileEntry {
    IPath includeFilePath;

    public IncludeFileEntry(IPath resourcePath, IPath basePath, IPath baseRef, IPath includeFilePath, IPath[] exclusionPatterns, boolean isExported) {
        super(256, basePath, baseRef, resourcePath, exclusionPatterns, isExported);
        this.includeFilePath = includeFilePath == null ? Path.EMPTY : PathUtil.getCanonicalPath(includeFilePath);
    }

    public IPath getIncludeFilePath() {
        return this.includeFilePath;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IIncludeFileEntry) {
            IIncludeFileEntry otherEntry = (IIncludeFileEntry)obj;
            if (!super.equals(otherEntry)) {
                return false;
            }
            if (this.path == null ? otherEntry.getPath() != null : !this.path.toString().equals(otherEntry.getPath().toString())) {
                return false;
            }
            return !(this.includeFilePath == null ? otherEntry.getIncludeFilePath() != null : !this.includeFilePath.toString().equals(otherEntry.getIncludeFilePath().toString()));
        }
        return super.equals(obj);
    }

    public IPath getFullIncludeFilePath() {
        IPath inc = this.getIncludeFilePath();
        if (!this.basePath.isEmpty()) {
            IPath location;
            IResource res;
            IPath loc = this.basePath;
            if (!loc.isAbsolute() && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(loc.append(inc))) != null && (location = res.getLocation()) != null) {
                return location;
            }
            return loc.append(inc);
        }
        if (!inc.isAbsolute()) {
            IPath location;
            IPath resPath = this.getPath();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(resPath.append(inc));
            if (res != null && (location = res.getLocation()) != null) {
                return location;
            }
        }
        return inc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.includeFilePath != null && !this.includeFilePath.isEmpty()) {
            sb.append(" includeFilePath:").append(this.includeFilePath);
        }
        return sb.toString();
    }
}

