/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMValue {
    public static int store(Database db, PDOMLinkage linkage, IValue val) throws CoreException {
        if (val == null) {
            return 0;
        }
        IBinding[] unknown = val.getUnknownBindings();
        int[] unknownRecs = new int[]{};
        if (unknown.length != 0) {
            unknownRecs = new int[unknown.length];
            int i = 0;
            while (i < unknown.length) {
                PDOMBinding node = linkage.addUnknownValue(unknown[i]);
                if (node == null) {
                    return PDOMValue.store(db, linkage, Value.UNKNOWN);
                }
                unknownRecs[i] = node.getRecord();
                ++i;
            }
        }
        int len = Math.min(unknown.length, 1022);
        int block = db.malloc(6 + 4 * len);
        int repRec = db.newString(val.getInternalExpression()).getRecord();
        db.putShort(block, (short)len);
        db.putInt(block + 2, repRec);
        int p = block + 6;
        int i = 0;
        while (i < len) {
            db.putInt(p, unknownRecs[i]);
            p += 4;
            ++i;
        }
        return block;
    }

    public static IValue restore(Database db, PDOMLinkage linkage, int valRec) throws CoreException {
        if (valRec == 0) {
            return null;
        }
        short len = db.getShort(valRec);
        int repRec = db.getInt(valRec + 2);
        char[] rep = db.getString(repRec).getChars();
        if (len == 0) {
            return Value.fromInternalRepresentation(rep, ICPPUnknownBinding.EMPTY_UNKNOWN_BINDING_ARRAY);
        }
        ICPPUnknownBinding[] unknown = new ICPPUnknownBinding[len];
        int p = valRec + 6;
        int i = 0;
        while (i < unknown.length) {
            int rec = db.getInt(p);
            PDOMNode node = linkage.getNode(rec);
            if (!(node instanceof ICPPUnknownBinding)) {
                return Value.UNKNOWN;
            }
            unknown[i] = (ICPPUnknownBinding)((Object)node);
            p += 4;
            ++i;
        }
        return Value.fromInternalRepresentation(rep, unknown);
    }

    public static void delete(Database db, int valueRec) throws CoreException {
        if (valueRec == 0) {
            return;
        }
        int repRec = db.getInt(valueRec + 2);
        db.getString(repRec).delete();
        db.free(valueRec);
    }
}

