/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBase;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFriend;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMClassUtil;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPClassType
extends PDOMCPPBinding
implements IPDOMCPPClassType,
IPDOMMemberOwner {
    private static final int FIRSTBASE = 28;
    private static final int MEMBERLIST = 32;
    private static final int FIRSTFRIEND = 36;
    private static final int KEY = 40;
    private static final int ANONYMOUS = 41;
    protected static final int RECORD_SIZE = 42;
    private ICPPClassScope fScope;

    public PDOMCPPClassType(PDOMLinkage linkage, PDOMNode parent, ICPPClassType classType) throws CoreException {
        super(linkage, parent, classType.getNameCharArray());
        this.setKind(classType);
        this.setAnonymous(classType);
    }

    public PDOMCPPClassType(PDOMLinkage linkage, int bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 42;
    }

    public int getNodeType() {
        return 8;
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPClassType) {
            ICPPClassType ct = (ICPPClassType)newBinding;
            this.setKind(ct);
            this.setAnonymous(ct);
            super.update(linkage, newBinding);
        }
    }

    private void setKind(ICPPClassType ct) throws CoreException {
        try {
            this.getDB().putByte(this.record + 40, (byte)ct.getKey());
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    private void setAnonymous(ICPPClassType ct) throws CoreException {
        try {
            this.getDB().putByte(this.record + 41, (byte)(ct.isAnonymous() ? 1 : 0));
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public void addChild(PDOMNode member) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 0);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32);
        list.addMember(member);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPClassScope.acceptViaCache(this, visitor, false);
    }

    public void acceptUncached(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32);
        list.accept(visitor);
    }

    private PDOMCPPBase getFirstBase() throws CoreException {
        int rec = this.getDB().getInt(this.record + 28);
        return rec != 0 ? new PDOMCPPBase((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstBase(PDOMCPPBase base) throws CoreException {
        int rec = base != null ? base.getRecord() : 0;
        this.getDB().putInt(this.record + 28, rec);
    }

    public void addBase(PDOMCPPBase base) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1);
        PDOMCPPBase firstBase = this.getFirstBase();
        base.setNextBase(firstBase);
        this.setFirstBase(base);
    }

    public void removeBase(PDOMName pdomName) throws CoreException {
        this.getPDOM().removeCachedResult(this.record + 1);
        PDOMCPPBase base = this.getFirstBase();
        PDOMCPPBase predecessor = null;
        int nameRec = pdomName.getRecord();
        while (base != null) {
            PDOMName name = base.getBaseClassSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = base;
            base = base.getNextBase();
        }
        if (base != null) {
            if (predecessor != null) {
                predecessor.setNextBase(base.getNextBase());
            } else {
                this.setFirstBase(base.getNextBase());
            }
            base.delete();
        }
    }

    public void addFriend(PDOMCPPFriend friend) throws CoreException {
        PDOMCPPFriend firstFriend = this.getFirstFriend();
        friend.setNextFriend(firstFriend);
        this.setFirstFriend(friend);
    }

    private PDOMCPPFriend getFirstFriend() throws CoreException {
        int rec = this.getDB().getInt(this.record + 36);
        return rec != 0 ? new PDOMCPPFriend((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    private void setFirstFriend(PDOMCPPFriend friend) throws CoreException {
        int rec = friend != null ? friend.getRecord() : 0;
        this.getDB().putInt(this.record + 36, rec);
    }

    public void removeFriend(PDOMName pdomName) throws CoreException {
        PDOMCPPFriend friend = this.getFirstFriend();
        PDOMCPPFriend predecessor = null;
        int nameRec = pdomName.getRecord();
        while (friend != null) {
            PDOMName name = friend.getSpecifierName();
            if (name != null && name.getRecord() == nameRec) break;
            predecessor = friend;
            friend = friend.getNextFriend();
        }
        if (friend != null) {
            if (predecessor != null) {
                predecessor.setNextFriend(friend.getNextFriend());
            } else {
                this.setFirstFriend(friend.getNextFriend());
            }
            friend.delete();
        }
    }

    public ICPPClassScope getCompositeScope() throws DOMException {
        if (this.fScope == null) {
            this.fScope = new PDOMCPPClassScope(this);
        }
        return this.fScope;
    }

    public int getKey() throws DOMException {
        try {
            return this.getDB().getByte(this.record + 40);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 3;
        }
    }

    public boolean isAnonymous() throws DOMException {
        try {
            return this.getDB().getByte(this.record + 41) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPClassType && !(type instanceof ProblemBinding)) {
            ICPPClassType ctype;
            block9: {
                block8: {
                    ctype = (ICPPClassType)type;
                    if (ctype.getKey() == this.getKey()) break block8;
                    return false;
                }
                char[] nchars = ctype.getNameCharArray();
                if (nchars.length == 0) {
                    nchars = ASTTypeUtil.createNameForAnonymous(ctype);
                }
                if (nchars != null && CharArrayUtils.equals(nchars, this.getNameCharArray())) break block9;
                return false;
            }
            try {
                return this.isSameOwner(this.getOwner(), ctype.getOwner());
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    public ICPPBase[] getBases() throws DOMException {
        Integer key = this.record + 1;
        ICPPBase[] bases = (ICPPBase[])this.getPDOM().getCachedResult(key);
        if (bases != null) {
            return bases;
        }
        try {
            ArrayList<PDOMCPPBase> list = new ArrayList<PDOMCPPBase>();
            PDOMCPPBase base = this.getFirstBase();
            while (base != null) {
                list.add(base);
                base = base.getNextBase();
            }
            Collections.reverse(list);
            bases = list.toArray(new ICPPBase[list.size()]);
            this.getPDOM().putCachedResult(key, bases);
            return bases;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new ICPPBase[0];
        }
    }

    public ICPPConstructor[] getConstructors() throws DOMException {
        PDOMClassUtil.ConstructorCollector visitor = new PDOMClassUtil.ConstructorCollector();
        try {
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getConstructors();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
    }

    public ICPPMethod[] getDeclaredMethods() throws DOMException {
        try {
            PDOMClassUtil.MethodCollector methods = new PDOMClassUtil.MethodCollector(false);
            PDOMCPPClassScope.acceptViaCache(this, methods, false);
            return methods.getMethods();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
    }

    public ICPPField[] getDeclaredFields() throws DOMException {
        try {
            PDOMClassUtil.FieldCollector visitor = new PDOMClassUtil.FieldCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPField.EMPTY_CPPFIELD_ARRAY;
        }
    }

    public ICPPClassType[] getNestedClasses() throws DOMException {
        try {
            PDOMClassUtil.NestedClassCollector visitor = new PDOMClassUtil.NestedClassCollector();
            PDOMCPPClassScope.acceptViaCache(this, visitor, false);
            return visitor.getNestedClasses();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPClassType.EMPTY_CLASS_ARRAY;
        }
    }

    public IBinding[] getFriends() throws DOMException {
        try {
            ArrayList<IBinding> list = new ArrayList<IBinding>();
            PDOMCPPFriend friend = this.getFirstFriend();
            while (friend != null) {
                list.add(0, friend.getFriendSpecifier());
                friend = friend.getNextFriend();
            }
            return list.toArray(new IBinding[list.size()]);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new IBinding[0];
        }
    }

    public ICPPMethod[] getMethods() throws DOMException {
        return ClassTypeHelper.getMethods(this);
    }

    public ICPPMethod[] getAllDeclaredMethods() throws DOMException {
        return ClassTypeHelper.getAllDeclaredMethods(this);
    }

    public IField[] getFields() throws DOMException {
        return ClassTypeHelper.getFields(this);
    }

    public IField findField(String name) throws DOMException {
        return ClassTypeHelper.findField(this, name);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

