/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFriend
extends PDOMNode {
    private static final int FRIEND_SPECIFIER = 8;
    private static final int NEXT_FRIEND = 12;
    protected static final int RECORD_SIZE = 16;

    public PDOMCPPFriend(PDOMLinkage linkage, int record) {
        super(linkage, record);
    }

    public PDOMCPPFriend(PDOMLinkage linkage, PDOMName friendSpec) throws CoreException {
        super(linkage, null);
        int friendrec = friendSpec != null ? friendSpec.getRecord() : 0;
        linkage.getDB().putInt(this.record + 8, friendrec);
    }

    protected int getRecordSize() {
        return 16;
    }

    public int getNodeType() {
        return 50;
    }

    public PDOMName getSpecifierName() throws CoreException {
        int rec = this.getDB().getInt(this.record + 8);
        if (rec != 0) {
            return new PDOMName(this.getLinkage(), rec);
        }
        return null;
    }

    public IBinding getFriendSpecifier() {
        try {
            PDOMName friendSpecName = this.getSpecifierName();
            if (friendSpecName != null) {
                return friendSpecName.getBinding();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public void setNextFriend(PDOMCPPFriend nextFriend) throws CoreException {
        int rec = nextFriend != null ? nextFriend.getRecord() : 0;
        this.getDB().putInt(this.record + 12, rec);
    }

    public PDOMCPPFriend getNextFriend() throws CoreException {
        int rec = this.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMCPPFriend(this.getLinkage(), rec) : null;
    }

    public void delete() throws CoreException {
        this.getDB().free(this.record);
    }
}

