/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.IPDOMCPPTemplateParameterOwner;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownScope;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMTemplateParameterArray;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPTemplateTemplateParameter
extends PDOMCPPBinding
implements ICPPTemplateTemplateParameter,
ICPPUnknownBinding,
ICPPUnknownType,
IIndexType,
IPDOMCPPTemplateParameter,
IPDOMCPPTemplateParameterOwner {
    private static final int DEFAULT_TYPE = 28;
    private static final int MEMBERLIST = 32;
    private static final int PARAMETERID = 36;
    private static final int PARAMETERS = 40;
    protected static final int RECORD_SIZE = 42;
    private ICPPScope fUnknownScope;
    private int fCachedParamID = -1;
    private IPDOMCPPTemplateParameter[] params;

    public PDOMCPPTemplateTemplateParameter(PDOMLinkage linkage, PDOMNode parent, ICPPTemplateTemplateParameter param) throws CoreException, DOMException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        db.putInt(this.record + 36, param.getParameterID());
        ICPPTemplateParameter[] origParams = param.getTemplateParameters();
        IPDOMCPPTemplateParameter[] params = PDOMTemplateParameterArray.createPDOMTemplateParameters(linkage, this, origParams);
        int rec = PDOMTemplateParameterArray.putArray(db, params);
        this.getDB().putInt(this.record + 40, rec);
    }

    public PDOMCPPTemplateTemplateParameter(PDOMLinkage linkage, int bindingRecord) {
        super(linkage, bindingRecord);
    }

    protected int getRecordSize() {
        return 42;
    }

    public int getNodeType() {
        return 51;
    }

    public short getParameterPosition() {
        this.readParamID();
        return (short)this.fCachedParamID;
    }

    public short getTemplateNestingLevel() {
        this.readParamID();
        return (short)(this.fCachedParamID >> 16);
    }

    public int getParameterID() {
        this.readParamID();
        return this.fCachedParamID;
    }

    private void readParamID() {
        if (this.fCachedParamID == -1) {
            try {
                Database db = this.getDB();
                this.fCachedParamID = db.getInt(this.record + 36);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fCachedParamID = -2;
            }
        }
    }

    public void addChild(PDOMNode member) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32);
        list.addMember(member);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMNodeLinkedList list = new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32);
        list.accept(visitor);
    }

    public boolean isSameType(IType type) {
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (!(type instanceof ICPPTemplateTemplateParameter)) {
            return false;
        }
        return this.getParameterID() == ((ICPPTemplateParameter)((Object)type)).getParameterID();
    }

    public IType getDefault() {
        try {
            PDOMNode node = ((PDOMLinkage)this.getLinkage()).getNode(this.getDB().getInt(this.record + 28));
            if (node instanceof IType) {
                return (IType)((Object)node);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public ICPPTemplateArgument getDefaultValue() {
        IType d = this.getDefault();
        if (d == null) {
            return null;
        }
        return new CPPTemplateArgument(d);
    }

    public Object clone() {
        this.fail();
        return null;
    }

    public ICPPScope asScope() {
        if (this.fUnknownScope == null) {
            this.fUnknownScope = new PDOMCPPUnknownScope(this, (IASTName)new CPPASTName(this.getNameCharArray()));
        }
        return this.fUnknownScope;
    }

    public IASTName getUnknownName() {
        return new CPPASTName(this.getNameCharArray());
    }

    public void configure(ICPPTemplateParameter param) {
        try {
            IType dflt;
            ICPPTemplateArgument val = param.getDefaultValue();
            if (val != null && (dflt = val.getTypeValue()) != null) {
                Database db = this.getPDOM().getDB();
                PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, dflt);
                if (typeNode != null) {
                    db.putInt(this.record + 28, typeNode.getRecord());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof ICPPTemplateTemplateParameter) {
            Database db = this.getDB();
            ICPPTemplateTemplateParameter ttp = (ICPPTemplateTemplateParameter)newBinding;
            this.updateName(newBinding.getNameCharArray());
            IType newDefault = null;
            try {
                newDefault = ttp.getDefault();
            }
            catch (DOMException dOMException) {}
            if (newDefault != null) {
                IType mytype = this.getDefault();
                PDOMNode typeNode = ((PDOMLinkage)this.getLinkage()).addType(this, newDefault);
                if (typeNode != null) {
                    db.putInt(this.record + 28, typeNode.getRecord());
                    if (mytype != null) {
                        linkage.deleteType(mytype, this.record);
                    }
                }
            }
            int oldRec = db.getInt(this.record + 40);
            IPDOMCPPTemplateParameter[] oldParams = this.getTemplateParameters();
            try {
                this.params = PDOMTemplateParameterArray.createPDOMTemplateParameters((PDOMLinkage)this.getLinkage(), this, ttp.getTemplateParameters());
                int newRec = PDOMTemplateParameterArray.putArray(db, this.params);
                db.putInt(this.record + 40, newRec);
                if (oldRec != 0) {
                    db.free(oldRec);
                }
                IPDOMCPPTemplateParameter[] iPDOMCPPTemplateParameterArray = oldParams;
                int n = oldParams.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDOMCPPTemplateParameter opar = iPDOMCPPTemplateParameterArray[n2];
                    opar.forceDelete(linkage);
                    ++n2;
                }
            }
            catch (DOMException dOMException) {}
        }
    }

    public void forceDelete(PDOMLinkage linkage) throws CoreException {
        Database db;
        int valueRec;
        this.getDBName().delete();
        IType type = this.getDefault();
        if (type instanceof PDOMNode) {
            ((PDOMNode)((Object)type)).delete(linkage);
        }
        if ((valueRec = (db = this.getDB()).getInt(this.record + 28)) != 0) {
            db.getString(valueRec).delete();
        }
        int oldRec = db.getInt(this.record + 40);
        IPDOMCPPTemplateParameter[] oldParams = this.getTemplateParameters();
        if (oldRec != 0) {
            db.free(oldRec);
        }
        IPDOMCPPTemplateParameter[] iPDOMCPPTemplateParameterArray = oldParams;
        int n = oldParams.length;
        int n2 = 0;
        while (n2 < n) {
            IPDOMCPPTemplateParameter opar = iPDOMCPPTemplateParameterArray[n2];
            opar.forceDelete(linkage);
            ++n2;
        }
    }

    public IPDOMCPPTemplateParameter[] getTemplateParameters() {
        if (this.params == null) {
            try {
                int rec = this.getDB().getInt(this.record + 40);
                this.params = rec == 0 ? IPDOMCPPTemplateParameter.EMPTY_ARRAY : PDOMTemplateParameterArray.getArray(this, rec);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.params = IPDOMCPPTemplateParameter.EMPTY_ARRAY;
            }
        }
        return this.params;
    }

    public ICPPClassTemplatePartialSpecialization[] getPartialSpecializations() {
        return ICPPClassTemplatePartialSpecialization.EMPTY_PARTIAL_SPECIALIZATION_ARRAY;
    }

    public IField findField(String name) {
        return null;
    }

    public ICPPMethod[] getAllDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPBase[] getBases() {
        return ICPPBase.EMPTY_BASE_ARRAY;
    }

    public ICPPConstructor[] getConstructors() {
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    public ICPPField[] getDeclaredFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    public ICPPMethod[] getDeclaredMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public IField[] getFields() {
        return ICPPField.EMPTY_CPPFIELD_ARRAY;
    }

    public IBinding[] getFriends() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public ICPPMethod[] getMethods() {
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public ICPPClassType[] getNestedClasses() {
        return ICPPClassType.EMPTY_CLASS_ARRAY;
    }

    public IScope getCompositeScope() {
        return this.asScope();
    }

    public int getKey() {
        return 0;
    }

    public boolean isAnonymous() {
        return false;
    }

    public ICPPTemplateParameter adaptTemplateParameter(ICPPTemplateParameter param) {
        short pos = param.getParameterPosition();
        IPDOMCPPTemplateParameter[] pars = this.getTemplateParameters();
        if (pars == null || pos >= pars.length) {
            return null;
        }
        IPDOMCPPTemplateParameter result = pars[pos];
        if (param instanceof ICPPTemplateTypeParameter ? result instanceof ICPPTemplateTypeParameter : (param instanceof ICPPTemplateNonTypeParameter ? result instanceof ICPPTemplateNonTypeParameter : param instanceof ICPPTemplateTemplateParameter && result instanceof ICPPTemplateTemplateParameter)) {
            return result;
        }
        return null;
    }

    public ICPPDeferredClassInstance asDeferredInstance() throws DOMException {
        return null;
    }
}

