/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.CConfigBasedDescriptorManager;
import org.eclipse.cdt.internal.core.settings.model.AbstractCProjectDescriptionStorage;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICProjectDescriptionStorageType;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlProjectDescriptionStorage;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class CProjectDescriptionStorageManager {
    private static final String CPROJ_DESC_STORAGE_EXT_ID = "CProjectDescriptionStorage";
    private static final String CPROJ_STORAGE_TYPE = "CProjectStorageType";
    private static final String DEFAULT_STORAGE_TYPE = "org.eclipse.cdt.core.XmlProjectDescriptionStorage";
    private static final Version DEFAULT_STORAGE_VERSION = XmlProjectDescriptionStorage.STORAGE_DESCRIPTION_VERSION;
    private volatile Map<String, List<ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy>> storageTypeMap;
    private Map<IProject, AbstractCProjectDescriptionStorage> fDescriptionStorageMap = Collections.synchronizedMap(new HashMap());
    private static volatile CProjectDescriptionStorageManager instance;

    private CProjectDescriptionStorageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CProjectDescriptionStorageManager getInstance() {
        if (instance != null) return instance;
        Class<CProjectDescriptionStorageManager> clazz = CProjectDescriptionStorageManager.class;
        synchronized (CProjectDescriptionStorageManager.class) {
            if (instance != null) return instance;
            instance = new CProjectDescriptionStorageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AbstractCProjectDescriptionStorage getProjectDescriptionStorage(IProject project) {
        AbstractCProjectDescriptionStorage projStorage = this.fDescriptionStorageMap.get(project);
        if (projStorage == null) {
            projStorage = this.loadProjectStorage(project);
            this.fDescriptionStorageMap.put(project, projStorage);
        }
        return projStorage;
    }

    public void setProjectDescription(IProject project, ICProjectDescription description, int flags, IProgressMonitor monitor) throws CoreException {
        AbstractCProjectDescriptionStorage storage = this.fDescriptionStorageMap.get(project);
        if (storage == null) {
            throw ExceptionFactory.createCoreException("Can't set ProjectDescription before getProjectDescriptionStorage!");
        }
        if (!storage.type.createsCProjectXMLFile()) {
            this.writeProjectStorageType(project, storage.type);
        }
        storage.setProjectDescription(description, flags, monitor);
    }

    private void writeProjectStorageType(IProject project, ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type) throws CoreException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            ProcessingInstruction instruction = doc.createProcessingInstruction("fileVersion", type.version.toString());
            doc.appendChild(instruction);
            Element el = doc.createElement("cproject");
            el.setAttribute("storage_type_id", type.id);
            doc.appendChild(el);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            ByteArrayInputStream input = new ByteArrayInputStream(stream.toByteArray());
            IFile f = project.getFile(".cproject");
            if (!f.exists()) {
                f.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            CProjectDescriptionStorageManager.ensureWritable((IResource)f);
            if (!f.exists()) {
                f.create((InputStream)input, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                f.setContents((InputStream)input, 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    private AbstractCProjectDescriptionStorage loadProjectStorage(IProject project) {
        List<ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy> types;
        String storageTypeID;
        Version version;
        block22: {
            if (this.storageTypeMap == null) {
                this.initExtensionPoints();
            }
            version = DEFAULT_STORAGE_VERSION;
            storageTypeID = DEFAULT_STORAGE_TYPE;
            InputStream stream = null;
            try {
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    stream = this.getInputStreamForIFile(project, ".cproject");
                    if (stream != null) {
                        Document doc = builder.parse(stream);
                        Node rootElement = doc.getFirstChild();
                        if (rootElement.getNodeType() != 7) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.7"));
                        }
                        version = new Version(rootElement.getNodeValue());
                        NodeList nodes = doc.getElementsByTagName("cproject");
                        if (nodes.getLength() == 0) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.9"));
                        }
                        Node node = nodes.item(0);
                        if (node.getNodeType() != 1) {
                            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.10"));
                        }
                        storageTypeID = "org.eclipse.cdt.core.XmlProjectDescriptionStorage2";
                        if (((Element)node).hasAttribute("storage_type_id")) {
                            storageTypeID = ((Element)node).getAttribute("storage_type_id");
                        }
                    }
                }
                catch (Exception exception) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((types = this.storageTypeMap.get(storageTypeID)) != null) {
            for (ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type : types) {
                if (!type.isCompatible(version)) continue;
                return type.getProjectDescriptionStorage(type, project, version);
            }
        }
        CCorePlugin.log("CProjectDescriptionStorageType: " + storageTypeID + "  for version: " + version + " not found!");
        return null;
    }

    private InputStream getInputStreamForIFile(IProject project, String name) throws CoreException {
        IFile f = project.getFile(name);
        if (f.exists()) {
            return f.getContents(true);
        }
        URI location = f.getLocationURI();
        if (location != null) {
            IFileStore file = EFS.getStore((URI)location);
            IFileInfo info = null;
            if (file != null && (info = file.fetchInfo()) != null && info.exists()) {
                return file.openInputStream(0, null);
            }
        }
        throw ExceptionFactory.createCoreException("No project des file found...");
    }

    void projectMove(IProject fromProject, IProject toProject) {
        AbstractCProjectDescriptionStorage projStorage = this.fDescriptionStorageMap.get(fromProject);
        if (projStorage != null) {
            this.fDescriptionStorageMap.put(toProject, projStorage);
            projStorage.projectMove(toProject);
            this.fDescriptionStorageMap.remove(fromProject);
        }
        CConfigBasedDescriptorManager.getInstance().projectMove(fromProject, toProject);
    }

    void projectClosedRemove(IProject project) {
        AbstractCProjectDescriptionStorage projStorage = this.fDescriptionStorageMap.get(project);
        if (projStorage != null) {
            projStorage.projectCloseRemove();
        }
        this.fDescriptionStorageMap.remove(project);
        CConfigBasedDescriptorManager.getInstance().projectClosedRemove(project);
    }

    public void shutdown() {
        instance = null;
    }

    private synchronized void initExtensionPoints() {
        if (this.storageTypeMap != null) {
            return;
        }
        HashMap<String, List<ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy>> m = new HashMap<String, List<ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy>>();
        IExtensionPoint extpoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CPROJ_DESC_STORAGE_EXT_ID);
        IExtension[] iExtensionArray = extpoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type;
                IConfigurationElement configEl = iConfigurationElementArray[n4];
                if (configEl.getName().equalsIgnoreCase(CPROJ_STORAGE_TYPE) && (type = CProjectDescriptionStorageManager.initStorageType(configEl)) != null) {
                    if (!m.containsKey(type.id)) {
                        m.put(type.id, new LinkedList());
                    }
                    ((List)m.get(type.id)).add(type);
                }
                ++n4;
            }
            ++n2;
        }
        this.storageTypeMap = m;
    }

    private static ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy initStorageType(IConfigurationElement el) {
        ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type = null;
        try {
            type = new ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy(el);
        }
        catch (CoreException e) {
            CCorePlugin.log("Couldn't instantiate CProjectDescriptionStorageType " + el.getDeclaringExtension().getNamespaceIdentifier() + " " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            CCorePlugin.log("Failed to load CProjectDescriptionStorageType " + el.getDeclaringExtension().getNamespaceIdentifier() + " " + e.getMessage());
        }
        return type;
    }

    public static void ensureWritable(IResource resource) throws CoreException {
        if (!resource.exists()) {
            resource.refreshLocal(2, null);
        }
        if (!resource.exists()) {
            ResourceAttributes parentAttr = resource.getParent().getResourceAttributes();
            if (parentAttr.isReadOnly()) {
                parentAttr.setReadOnly(false);
                resource.getParent().setResourceAttributes(parentAttr);
            }
        } else {
            resource.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    ResourceAttributes resAttr = resource.getResourceAttributes();
                    if (resAttr.isReadOnly()) {
                        resAttr.setReadOnly(false);
                        resource.setResourceAttributes(resAttr);
                    }
                    return true;
                }
            });
        }
    }
}

