/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.dataviewer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.examples.dsf.dataviewer.IDataGenerator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGeneratorWithThread
extends Thread
implements IDataGenerator {
    private final BlockingQueue<Request> fQueue = new LinkedBlockingQueue<Request>();
    private ListenerList fListeners = new ListenerList();
    private int fCount = 100;
    private int fCountResetTrigger = 0;
    private Set<Integer> fChangedIndexes = Collections.synchronizedSet(new HashSet());
    private long fLastChangeTime = System.currentTimeMillis();
    private AtomicBoolean fShutdown = new AtomicBoolean(false);

    public DataGeneratorWithThread() {
        this.start();
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        if (!this.fShutdown.getAndSet(true)) {
            this.fQueue.add(new ShutdownRequest(rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
            rm.done();
        }
    }

    @Override
    public void getCount(DataRequestMonitor<Integer> rm) {
        if (!this.fShutdown.get()) {
            this.fQueue.add(new CountRequest(rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
            rm.done();
        }
    }

    @Override
    public void getValue(int index, DataRequestMonitor<String> rm) {
        if (!this.fShutdown.get()) {
            this.fQueue.add(new ItemRequest(index, rm));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
            rm.done();
        }
    }

    @Override
    public void addListener(IDataGenerator.Listener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeListener(IDataGenerator.Listener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request request;
                if ((request = this.fQueue.poll(100L, TimeUnit.MILLISECONDS)) != null) {
                    Thread.sleep(10L);
                    if (request instanceof CountRequest) {
                        this.processCountRequest((CountRequest)request);
                    } else if (request instanceof ItemRequest) {
                        this.processItemRequest((ItemRequest)request);
                    } else if (request instanceof ShutdownRequest) {
                        request.fRequestMonitor.done();
                        break;
                    }
                }
                this.randomChanges();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void processCountRequest(CountRequest request) {
        DataRequestMonitor rm = (DataRequestMonitor)request.fRequestMonitor;
        rm.setData((Object)this.fCount);
        rm.done();
    }

    private void processItemRequest(ItemRequest request) {
        DataRequestMonitor rm = (DataRequestMonitor)request.fRequestMonitor;
        if (this.fChangedIndexes.contains(request.fIndex)) {
            rm.setData((Object)("Changed: " + request.fIndex));
        } else {
            rm.setData((Object)Integer.toString(request.fIndex));
        }
        rm.done();
    }

    private void randomChanges() {
        if (System.currentTimeMillis() > this.fLastChangeTime + 10000L) {
            this.fLastChangeTime = System.currentTimeMillis();
            if (++this.fCountResetTrigger % 3 == 0) {
                this.randomCountReset();
            } else {
                this.randomDataChange();
            }
        }
    }

    private void randomCountReset() {
        Random random = new Random();
        this.fCount = 100 + Math.abs(random.nextInt()) % 100;
        this.fChangedIndexes.clear();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDataGenerator.Listener)listener).countChanged();
            ++n2;
        }
    }

    private void randomDataChange() {
        Random random = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        while (i < this.fCount * 10 / 100) {
            set.add(new Integer(Math.abs(random.nextInt()) % this.fCount));
            ++i;
        }
        this.fChangedIndexes.addAll(set);
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IDataGenerator.Listener)listener).valuesChanged(set);
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CountRequest
    extends Request {
        CountRequest(DataRequestMonitor<Integer> rm) {
            super((RequestMonitor)rm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemRequest
    extends Request {
        final int fIndex;

        ItemRequest(int index, DataRequestMonitor<String> rm) {
            super((RequestMonitor)rm);
            this.fIndex = index;
        }
    }

    abstract class Request {
        final RequestMonitor fRequestMonitor;

        Request(RequestMonitor rm) {
            this.fRequestMonitor = rm;
        }
    }

    class ShutdownRequest
    extends Request {
        ShutdownRequest(RequestMonitor rm) {
            super(rm);
        }
    }
}

