/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.dataviewer.answers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.examples.dsf.dataviewer.answers.IDataGenerator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DataGeneratorWithExecutor
implements IDataGenerator {
    private DsfExecutor fExecutor;
    @ConfinedToDsfExecutor(value="fExecutor")
    private List<Request> fQueue = new LinkedList<Request>();
    @ConfinedToDsfExecutor(value="fExecutor")
    private List<IDataGenerator.Listener> fListeners = new LinkedList<IDataGenerator.Listener>();
    @ConfinedToDsfExecutor(value="fExecutor")
    private int fCount = 100;
    @ConfinedToDsfExecutor(value="fExecutor")
    private int fCountResetTrigger = 0;
    @ConfinedToDsfExecutor(value="fExecutor")
    private Set<Integer> fChangedIndexes = new HashSet<Integer>();
    @ConfinedToDsfExecutor(value="fExecutor")
    private boolean fServiceQueueInProgress = false;

    public DataGeneratorWithExecutor() {
        this.fExecutor = new DefaultDsfExecutor("Supplier Executor");
        this.fExecutor.scheduleAtFixedRate((Runnable)new DsfRunnable(){

            public void run() {
                DataGeneratorWithExecutor.this.randomChanges();
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown(final RequestMonitor rm) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    for (Request request : DataGeneratorWithExecutor.this.fQueue) {
                        request.fRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
                        request.fRequestMonitor.done();
                    }
                    DataGeneratorWithExecutor.this.fQueue.clear();
                    DataGeneratorWithExecutor.this.fExecutor.shutdown();
                    rm.done();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
            rm.done();
        }
    }

    @Override
    public void getCount(final DataRequestMonitor<Integer> rm) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    DataGeneratorWithExecutor.this.fQueue.add(new CountRequest((DataRequestMonitor<Integer>)rm));
                    DataGeneratorWithExecutor.this.serviceQueue();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
            rm.done();
        }
    }

    @Override
    public void getValue(final int index, final DataRequestMonitor<String> rm) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    DataGeneratorWithExecutor.this.fQueue.add(new ItemRequest(index, (DataRequestMonitor<String>)rm));
                    DataGeneratorWithExecutor.this.serviceQueue();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", "Supplier shut down"));
            rm.done();
        }
    }

    @Override
    public void addListener(final IDataGenerator.Listener listener) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    DataGeneratorWithExecutor.this.fListeners.add(listener);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    @Override
    public void removeListener(final IDataGenerator.Listener listener) {
        try {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    DataGeneratorWithExecutor.this.fListeners.remove(listener);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void serviceQueue() {
        Iterator<Request> requestItr = this.fQueue.iterator();
        while (requestItr.hasNext()) {
            Request request = requestItr.next();
            if (!request.fRequestMonitor.isCanceled()) continue;
            request.fRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.cdt.examples.dsf", "Request canceled"));
            request.fRequestMonitor.done();
            requestItr.remove();
        }
        if (this.fServiceQueueInProgress) {
            return;
        }
        if (this.fQueue.size() != 0) {
            this.fServiceQueueInProgress = true;
            final Request request = this.fQueue.remove(0);
            this.fExecutor.schedule((Runnable)new DsfRunnable(){

                public void run() {
                    if (request instanceof CountRequest) {
                        DataGeneratorWithExecutor.this.processCountRequest((CountRequest)request);
                    } else if (request instanceof ItemRequest) {
                        DataGeneratorWithExecutor.this.processItemRequest((ItemRequest)request);
                    }
                    DataGeneratorWithExecutor.this.fServiceQueueInProgress = false;
                    DataGeneratorWithExecutor.this.serviceQueue();
                }
            }, 10L, TimeUnit.MILLISECONDS);
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void processCountRequest(CountRequest request) {
        DataRequestMonitor rm = (DataRequestMonitor)request.fRequestMonitor;
        rm.setData((Object)this.fCount);
        rm.done();
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void processItemRequest(ItemRequest request) {
        DataRequestMonitor rm = (DataRequestMonitor)request.fRequestMonitor;
        if (this.fChangedIndexes.contains(request.fIndex)) {
            rm.setData((Object)("Changed: " + request.fIndex));
        } else {
            rm.setData((Object)Integer.toString(request.fIndex));
        }
        rm.done();
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void randomChanges() {
        if (++this.fCountResetTrigger % 3 == 0) {
            this.randomCountReset();
        } else {
            this.randomDataChange();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void randomCountReset() {
        Random random = new Random();
        this.fCount = 100 + Math.abs(random.nextInt()) % 100;
        this.fChangedIndexes.clear();
        for (IDataGenerator.Listener listener : this.fListeners) {
            listener.countChanged();
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    private void randomDataChange() {
        Random random = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        while (i < this.fCount * 10 / 100) {
            set.add(new Integer(Math.abs(random.nextInt()) % this.fCount));
            ++i;
        }
        this.fChangedIndexes.addAll(set);
        for (IDataGenerator.Listener listener : this.fListeners) {
            listener.valuesChanged(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class CountRequest
    extends Request {
        CountRequest(DataRequestMonitor<Integer> rm) {
            super((RequestMonitor)rm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    class ItemRequest
    extends Request {
        final int fIndex;

        ItemRequest(int index, DataRequestMonitor<String> rm) {
            super((RequestMonitor)rm);
            this.fIndex = index;
        }
    }

    @Immutable
    abstract class Request {
        final RequestMonitor fRequestMonitor;

        Request(RequestMonitor rm) {
            this.fRequestMonitor = rm;
        }
    }
}

