/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.concurrent;

import java.util.HashSet;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.StackTraceWrapper;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.core.runtime.Platform;

@Immutable
public class DsfExecutable {
    static boolean DEBUG_EXECUTOR = false;
    static boolean ASSERTIONS_ENABLED = false;
    final StackTraceWrapper fCreatedAt;
    final DefaultDsfExecutor.TracingWrapper fCreatedBy;
    private volatile boolean fSubmitted = false;

    static {
        if (!$assertionsDisabled) {
            ASSERTIONS_ENABLED = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        DEBUG_EXECUTOR = DsfPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.cdt.dsf/debug/executor"));
    }

    public DsfExecutable() {
        if (ASSERTIONS_ENABLED || DEBUG_EXECUTOR) {
            DefaultDsfExecutor executor = DefaultDsfExecutor.fThreadToExecutorMap.get(Thread.currentThread());
            this.fCreatedBy = executor != null ? executor.fCurrentlyExecuting : null;
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            Class<?> thisClass = this.getClass();
            HashSet<String> classNamesSet = new HashSet<String>();
            while (thisClass != null) {
                classNamesSet.add(thisClass.getName());
                thisClass = thisClass.getSuperclass();
            }
            int i = 3;
            while (i < stackTrace.length) {
                if (!classNamesSet.contains(stackTrace[i].getClassName())) break;
                ++i;
            }
            this.fCreatedAt = new StackTraceWrapper(new StackTraceElement[stackTrace.length - i]);
            System.arraycopy(stackTrace, i, this.fCreatedAt.fStackTraceElements, 0, this.fCreatedAt.fStackTraceElements.length);
        } else {
            this.fCreatedAt = null;
            this.fCreatedBy = null;
        }
    }

    public boolean getSubmitted() {
        return this.fSubmitted;
    }

    public void setSubmitted() {
        this.fSubmitted = true;
    }

    protected boolean isExecutionRequired() {
        return true;
    }

    protected void finalize() {
        if (DEBUG_EXECUTOR && !this.fSubmitted && this.isExecutionRequired()) {
            StringBuilder traceBuilder = new StringBuilder();
            traceBuilder.append(DsfPlugin.getDebugTime());
            traceBuilder.append(' ');
            traceBuilder.append("DsfExecutable was never executed:\n        ");
            traceBuilder.append(this);
            traceBuilder.append("\nCreated at:");
            traceBuilder.append(this.fCreatedAt);
            DsfPlugin.debug(traceBuilder.toString());
        }
    }
}

