/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.tests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIFunctionLocation;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.testplugin.CDebugHelper;
import org.eclipse.cdt.debug.testplugin.CProjectHelper;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class DebugTests
extends TestCase {
    IWorkspace workspace = ResourcesPlugin.getWorkspace();
    IWorkspaceRoot root = this.workspace.getRoot();
    ICProject testProject;
    NullProgressMonitor monitor = new NullProgressMonitor();
    ICDISession session;

    public DebugTests(String name) {
        super(name);
        if (this.workspace == null) {
            DebugTests.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            DebugTests.fail((String)"Workspace root was not setup");
        }
    }

    protected void setUp() throws CoreException, InvocationTargetException, IOException {
        ResourcesPlugin.getWorkspace().getDescription().setAutoBuilding(false);
        Path importFile = new Path("resources/debugTest.zip");
        this.testProject = CProjectHelper.createCProjectWithImport("filetest", (IPath)importFile);
        if (this.testProject == null) {
            DebugTests.fail((String)"Unable to create project");
        }
        this.testProject.getProject().build(6, null);
    }

    protected void tearDown() throws CoreException, CDIException {
        if (this.session != null) {
            this.session.terminate();
            this.session = null;
        }
        CProjectHelper.delete(this.testProject);
    }

    public static TestSuite suite() {
        return new TestSuite(DebugTests.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DebugTests.suite());
    }

    public void testDebug() throws CoreException, MIException, IOException, CDIException {
        this.session = CDebugHelper.createSession("main", this.testProject);
        DebugTests.assertNotNull((Object)this.session);
        ICDITarget[] targets = this.session.getTargets();
        DebugTests.assertNotNull((Object)targets);
        DebugTests.assertTrue((targets.length > 0 ? 1 : 0) != 0);
        ICDITarget cdiTarget = targets[0];
        DebugTests.assertNotNull((Object)cdiTarget);
        ICDIFunctionLocation location = cdiTarget.createFunctionLocation(null, "func1");
        DebugTests.assertNotNull((Object)location);
        cdiTarget.setFunctionBreakpoint(0, location, null, false);
        cdiTarget.resume();
        this.session.terminate();
        this.session = null;
    }
}

