/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTArraySubscriptExpression
extends ASTNode
implements IASTArraySubscriptExpression,
IASTAmbiguityParent {
    private IASTExpression array;
    private IASTExpression subscript;

    public CASTArraySubscriptExpression() {
    }

    public CASTArraySubscriptExpression(IASTExpression array, IASTExpression subscript) {
        this.setArrayExpression(array);
        this.setSubscriptExpression(subscript);
    }

    public CASTArraySubscriptExpression copy() {
        CASTArraySubscriptExpression copy = new CASTArraySubscriptExpression();
        copy.setArrayExpression(this.array == null ? null : this.array.copy());
        copy.setSubscriptExpression(this.subscript == null ? null : this.subscript.copy());
        copy.setOffsetAndLength(this);
        return copy;
    }

    public IASTExpression getArrayExpression() {
        return this.array;
    }

    public void setArrayExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.array = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(ARRAY);
        }
    }

    public IASTExpression getSubscriptExpression() {
        return this.subscript;
    }

    public void setSubscriptExpression(IASTExpression expression) {
        this.assertNotFrozen();
        this.subscript = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(SUBSCRIPT);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.array != null && !this.array.accept(action)) {
            return false;
        }
        if (this.subscript != null && !this.subscript.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (child == this.array) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.array = (IASTExpression)other;
        }
        if (child == this.subscript) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.subscript = (IASTExpression)other;
        }
    }

    public IType getExpressionType() {
        IType t = this.getArrayExpression().getExpressionType();
        try {
            if (t instanceof IPointerType) {
                return ((IPointerType)t).getType();
            }
            if (t instanceof IArrayType) {
                return ((IArrayType)t).getType();
            }
        }
        catch (DOMException e) {
            return e.getProblem();
        }
        return t;
    }
}

