/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplatePartialSpecializationSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPConstructorTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFieldSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethodTemplateSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerToMemberType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTemplateParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTypedefSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPASTInternalTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

public class CPPTemplates {
    public static IBinding instantiate(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) {
        try {
            arguments = SemanticUtil.getSimplifiedArguments(arguments);
            if (template instanceof ICPPTemplateTemplateParameter || CPPTemplates.hasDependentArgument(arguments)) {
                return CPPTemplates.deferredInstance(template, arguments);
            }
            if (template instanceof ICPPClassTemplatePartialSpecialization) {
                return CPPTemplates.instantiatePartialSpecialization((ICPPClassTemplatePartialSpecialization)template, arguments);
            }
            ICPPTemplateParameter[] parameters = template.getTemplateParameters();
            int numArgs = arguments.length;
            int numParams = parameters.length;
            if (numParams == 0 || numParams < numArgs) {
                return CPPTemplates.createProblem(template, 15);
            }
            ICPPTemplateArgument[] completeArgs = new ICPPTemplateArgument[numParams];
            CPPTemplateParameterMap map = new CPPTemplateParameterMap(numParams);
            boolean hasDependentDefaultArg = false;
            int i = 0;
            while (i < numParams) {
                ICPPTemplateArgument arg;
                ICPPTemplateParameter param = parameters[i];
                if (i < numArgs) {
                    arg = arguments[i];
                } else {
                    ICPPTemplateArgument defaultArg = param.getDefaultValue();
                    if (defaultArg == null) {
                        if (template instanceof ICPPInternalClassTemplate) {
                            defaultArg = ((ICPPInternalClassTemplate)((Object)template)).getDefaultArgFromIndex(i);
                        }
                        if (defaultArg == null) {
                            return CPPTemplates.createProblem(template, 15);
                        }
                    }
                    arg = CPPTemplates.instantiateArgument(defaultArg, map, null);
                    arg = SemanticUtil.getSimplifiedArgument(arg);
                    hasDependentDefaultArg |= CPPTemplates.isDependentArgument(arg);
                }
                if (!hasDependentDefaultArg && (arg = CPPTemplates.matchTemplateParameterAndArgument(param, arg, map)) == null) {
                    return CPPTemplates.createProblem(template, 15);
                }
                map.put(param, arg);
                completeArgs[i] = arg;
                ++i;
            }
            if (hasDependentDefaultArg) {
                return CPPTemplates.deferredInstance(template, completeArgs);
            }
            ICPPTemplateDefinition tdef = CPPTemplates.selectSpecialization(template, completeArgs);
            if (tdef == null || tdef instanceof IProblemBinding) {
                return tdef;
            }
            if (tdef instanceof ICPPClassTemplatePartialSpecialization) {
                return CPPTemplates.instantiatePartialSpecialization((ICPPClassTemplatePartialSpecialization)tdef, completeArgs);
            }
            return CPPTemplates.instantiatePrimaryTemplate(template, completeArgs, map);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    private static IBinding createProblem(ICPPClassTemplate template, int id) {
        CPPASTName node = new CPPASTName(template.getNameCharArray());
        return new ProblemBinding((IASTNode)node, id, template.getNameCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IBinding isUsedInClassTemplateScope(ICPPClassTemplate ct, IASTName name) {
        try {
            IASTInternalScope internalScope;
            IASTName start = name;
            ICPPASTFunctionDefinition func = CPPVisitor.findEnclosingFunctionDefinition(name);
            if (func != null) {
                start = ASTQueries.findInnermostDeclarator(func.getDeclarator()).getName();
                start = start.getLastName();
            }
            IScope scope = CPPVisitor.getContainingScope(start);
            do {
                ICPPClassSpecialization specialization;
                IName scopeName;
                if (!(scope instanceof IASTInternalScope)) {
                    return null;
                }
                if (scope instanceof IProblemBinding) {
                    return null;
                }
                internalScope = (IASTInternalScope)scope;
                if (!(scope instanceof ICPPClassScope) || !((scopeName = internalScope.getScopeName()) instanceof IASTName)) continue;
                IBinding b = ((IASTName)scopeName).resolveBinding();
                if (b instanceof IType && ct.isSameType((IType)((Object)b))) {
                    return CPPTemplates.instantiateWithinClassTemplate(ct);
                }
                if (b instanceof ICPPClassTemplatePartialSpecialization) {
                    ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)b;
                    if (!ct.isSameType(pspec.getPrimaryClassTemplate())) continue;
                    return CPPTemplates.instantiateWithinClassTemplate(pspec);
                }
                if (!(b instanceof ICPPClassSpecialization) || !ct.isSameType((specialization = (ICPPClassSpecialization)b).getSpecializedBinding())) continue;
                return specialization;
            } while ((scope = CPPVisitor.getContainingScope(internalScope.getPhysicalNode())) != internalScope);
            return null;
        }
        catch (DOMException dOMException) {}
        return null;
    }

    private static IBinding instantiatePartialSpecialization(ICPPClassTemplatePartialSpecialization partialSpec, ICPPTemplateArgument[] args) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(partialSpec, args);
        if (instance != null) {
            return instance;
        }
        CPPTemplateParameterMap tpMap = new CPPTemplateParameterMap(args.length);
        if (!CPPTemplates.deduceTemplateParameterMap(partialSpec.getTemplateArguments(), args, tpMap)) {
            return null;
        }
        ICPPTemplateParameter[] params = partialSpec.getTemplateParameters();
        int numParams = params.length;
        int i = 0;
        while (i < numParams) {
            ICPPTemplateParameter param = params[i];
            if (tpMap.getArgument(param) == null) {
                return null;
            }
            ++i;
        }
        instance = CPPTemplates.createInstance(partialSpec.getOwner(), partialSpec, tpMap, args);
        CPPTemplates.addInstance(partialSpec, args, instance);
        return instance;
    }

    private static IBinding instantiatePrimaryTemplate(ICPPClassTemplate template, ICPPTemplateArgument[] arguments, CPPTemplateParameterMap map) throws DOMException {
        assert (!(template instanceof ICPPClassTemplatePartialSpecialization));
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments);
        if (instance != null) {
            return instance;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, map, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static IBinding instantiateFunctionTemplate(ICPPFunctionTemplate template, ICPPTemplateArgument[] arguments) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments);
        if (instance != null) {
            return instance;
        }
        int length = arguments.length;
        ICPPTemplateParameter[] parameters = template.getTemplateParameters();
        if (parameters.length != length) {
            return null;
        }
        CPPTemplateParameterMap map = new CPPTemplateParameterMap(length);
        int i = 0;
        while (i < length) {
            map.put(parameters[i], arguments[i]);
            ++i;
        }
        IBinding owner = template.getOwner();
        instance = CPPTemplates.createInstance(owner, template, map, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    private static ICPPTemplateInstance getInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args) {
        if (template instanceof ICPPInstanceCache) {
            return ((ICPPInstanceCache)((Object)template)).getInstance(args);
        }
        return null;
    }

    private static void addInstance(ICPPTemplateDefinition template, ICPPTemplateArgument[] args, ICPPTemplateInstance instance) {
        if (template instanceof ICPPInstanceCache) {
            ((ICPPInstanceCache)((Object)template)).addInstance(args, instance);
        }
    }

    private static IBinding deferredInstance(ICPPClassTemplate template, ICPPTemplateArgument[] arguments) throws DOMException {
        ICPPTemplateInstance instance = CPPTemplates.getInstance(template, arguments);
        if (instance != null) {
            return instance;
        }
        instance = new CPPDeferredClassInstance(template, arguments);
        CPPTemplates.addInstance(template, arguments, instance);
        return instance;
    }

    public static ICPPClassType instantiateWithinClassTemplate(ICPPClassTemplate template) throws DOMException {
        ICPPTemplateArgument[] args;
        ICPPTemplateInstance di = template.asDeferredInstance();
        if (di instanceof ICPPClassType) {
            return (ICPPClassType)((Object)di);
        }
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            args = ((ICPPClassTemplatePartialSpecialization)template).getTemplateArguments();
        } else {
            ICPPTemplateParameter[] templateParameters = template.getTemplateParameters();
            args = CPPTemplates.templateParametersAsArguments(templateParameters);
        }
        IBinding result = CPPTemplates.deferredInstance(template, args);
        if (result instanceof ICPPClassType) {
            return (ICPPClassType)result;
        }
        return template;
    }

    public static ICPPTemplateArgument[] templateParametersAsArguments(ICPPTemplateParameter[] templateParameters) throws DOMException {
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[templateParameters.length];
        int i = 0;
        while (i < templateParameters.length) {
            ICPPTemplateParameter tp = templateParameters[i];
            if (tp instanceof IType) {
                args[i] = new CPPTemplateArgument((IType)((Object)tp));
            } else if (tp instanceof ICPPTemplateNonTypeParameter) {
                ICPPTemplateNonTypeParameter nttp = (ICPPTemplateNonTypeParameter)tp;
                args[i] = new CPPTemplateArgument(Value.create(nttp), nttp.getType());
            } else assert (false);
            ++i;
        }
        return args;
    }

    public static IASTName getTemplateParameterName(ICPPASTTemplateParameter param) {
        if (param instanceof ICPPASTSimpleTypeTemplateParameter) {
            return ((ICPPASTSimpleTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return ((ICPPASTTemplatedTypeTemplateParameter)param).getName();
        }
        if (param instanceof ICPPASTParameterDeclaration) {
            return ASTQueries.findInnermostDeclarator(((ICPPASTParameterDeclaration)param).getDeclarator()).getName();
        }
        return null;
    }

    public static ICPPTemplateDefinition getContainingTemplate(ICPPASTTemplateParameter param) {
        IASTNode parent = param.getParent();
        IBinding binding = null;
        if (parent instanceof ICPPASTTemplateDeclaration) {
            Object[] templates = new ICPPASTTemplateDeclaration[]{(ICPPASTTemplateDeclaration)parent};
            while (parent.getParent() instanceof ICPPASTTemplateDeclaration) {
                parent = parent.getParent();
                templates = (ICPPASTTemplateDeclaration[])ArrayUtil.append(ICPPASTTemplateDeclaration.class, templates, parent);
            }
            templates = (ICPPASTTemplateDeclaration[])ArrayUtil.trim(ICPPASTTemplateDeclaration.class, templates);
            Object templateDeclaration = templates[0];
            IASTDeclaration decl = templateDeclaration.getDeclaration();
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            IASTName name = null;
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simpleDecl = (IASTSimpleDeclaration)decl;
                IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                if (dtors.length == 0) {
                    IASTDeclSpecifier spec = simpleDecl.getDeclSpecifier();
                    if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                        name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                    } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                        name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                    }
                } else {
                    IASTDeclarator dtor = dtors[0];
                    dtor = ASTQueries.findInnermostDeclarator(dtor);
                    name = dtor.getName();
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = ASTQueries.findInnermostDeclarator(dtor);
                name = dtor.getName();
            }
            if (name == null) {
                return null;
            }
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns;
                int idx = templates.length;
                int i = 0;
                IASTName[] iASTNameArray = ns = ((ICPPASTQualifiedName)name).getNames();
                int n = ns.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName element = iASTNameArray[n2];
                    if (element instanceof ICPPASTTemplateId && ++i == idx) {
                        binding = ((ICPPASTTemplateId)element).resolveBinding();
                        break;
                    }
                    ++n2;
                }
                if (binding == null) {
                    binding = ns[ns.length - 1].resolveBinding();
                }
            } else {
                binding = name.resolveBinding();
            }
        } else if (parent instanceof ICPPASTTemplatedTypeTemplateParameter) {
            ICPPASTTemplatedTypeTemplateParameter templatedParam = (ICPPASTTemplatedTypeTemplateParameter)parent;
            binding = templatedParam.getName().resolveBinding();
        }
        return binding instanceof ICPPTemplateDefinition ? (ICPPTemplateDefinition)binding : null;
    }

    public static IBinding createBinding(ICPPASTTemplateParameter templateParameter) {
        if (templateParameter instanceof ICPPASTSimpleTypeTemplateParameter) {
            return new CPPTemplateTypeParameter(((ICPPASTSimpleTypeTemplateParameter)templateParameter).getName());
        }
        if (templateParameter instanceof ICPPASTTemplatedTypeTemplateParameter) {
            return new CPPTemplateTemplateParameter(((ICPPASTTemplatedTypeTemplateParameter)templateParameter).getName());
        }
        assert (templateParameter instanceof ICPPASTParameterDeclaration);
        IASTDeclarator dtor = ((ICPPASTParameterDeclaration)templateParameter).getDeclarator();
        return new CPPTemplateNonTypeParameter(ASTQueries.findInnermostDeclarator(dtor).getName());
    }

    public static ICPPScope getContainingScope(IASTNode node) {
        while (node != null) {
            IASTNode parent;
            if (node instanceof ICPPASTTemplateParameter && (parent = node.getParent()) instanceof ICPPASTTemplateDeclaration) {
                return ((ICPPASTTemplateDeclaration)parent).getScope();
            }
            node = node.getParent();
        }
        return null;
    }

    public static IBinding createBinding(ICPPASTTemplateId id) {
        if (!CPPTemplates.isClassTemplate(id)) {
            IBinding result = CPPVisitor.createBinding(id);
            IASTName templateName = id.getTemplateName();
            if (result instanceof ICPPTemplateInstance) {
                templateName.setBinding(((ICPPTemplateInstance)result).getTemplateDefinition());
            } else {
                templateName.setBinding(result);
            }
            return result;
        }
        IASTNode parentOfName = id.getParent();
        boolean isLastName = true;
        if (parentOfName instanceof ICPPASTQualifiedName) {
            isLastName = ((ICPPASTQualifiedName)parentOfName).getLastName() == id;
            parentOfName = parentOfName.getParent();
        }
        boolean isDecl = false;
        boolean isDef = false;
        if (isLastName) {
            if (parentOfName instanceof ICPPASTElaboratedTypeSpecifier) {
                IASTNode parentOfDeclaration = parentOfName;
                while (parentOfDeclaration != null) {
                    if (parentOfDeclaration instanceof IASTDeclaration) {
                        parentOfDeclaration = parentOfDeclaration.getParent();
                        break;
                    }
                    parentOfDeclaration = parentOfDeclaration.getParent();
                }
                isDecl = !(parentOfDeclaration instanceof ICPPASTExplicitTemplateInstantiation);
            } else if (parentOfName instanceof ICPPASTCompositeTypeSpecifier) {
                isDef = true;
            }
        }
        try {
            ICPPASTTemplateDeclaration tdecl;
            IBinding owner;
            IBinding result = null;
            IASTName templateName = id.getTemplateName();
            IBinding template = templateName.resolveBinding();
            if (template instanceof ICPPConstructor) {
                template = template.getOwner();
            }
            if (template instanceof ICPPUnknownClassType && (owner = template.getOwner()) instanceof ICPPUnknownBinding) {
                ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
                return new CPPUnknownClassInstance((ICPPUnknownBinding)template.getOwner(), id.getSimpleID(), args);
            }
            if (!(template instanceof ICPPClassTemplate) || template instanceof ICPPClassTemplatePartialSpecialization) {
                return new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
            }
            ICPPClassTemplate classTemplate = (ICPPClassTemplate)template;
            ICPPTemplateArgument[] args = CPPTemplates.createTemplateArgumentArray(id);
            if (CPPTemplates.hasDependentArgument(args) && (tdecl = CPPTemplates.getTemplateDeclaration(id)) != null) {
                if (CPPTemplates.argsAreTrivial(classTemplate.getTemplateParameters(), args)) {
                    result = classTemplate;
                } else {
                    ICPPClassTemplatePartialSpecialization partialSpec = CPPTemplates.findPartialSpecialization(classTemplate, args);
                    if ((isDecl || isDef) && partialSpec == null) {
                        partialSpec = new CPPClassTemplatePartialSpecialization(id);
                        if (template instanceof ICPPInternalClassTemplate) {
                            ((ICPPInternalClassTemplate)template).addPartialSpecialization(partialSpec);
                        }
                        return partialSpec;
                    }
                    if (partialSpec == null) {
                        return new ProblemBinding((IASTNode)id, 5, templateName.toCharArray());
                    }
                    result = partialSpec;
                }
            }
            if (result == null && (result = CPPTemplates.instantiate(classTemplate, args)) instanceof ICPPInternalBinding) {
                if (isDecl) {
                    ASTInternal.addDeclaration(result, id);
                } else if (isDef) {
                    ASTInternal.addDefinition(result, id);
                }
            }
            return CPPSemantics.postResolution(result, id);
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    static boolean isClassTemplate(ICPPASTTemplateId id) {
        IASTNode parentOfName = id.getParent();
        if (parentOfName instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)parentOfName).getLastName() != id) {
                return true;
            }
            parentOfName = parentOfName.getParent();
        }
        return parentOfName instanceof ICPPASTElaboratedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier || parentOfName instanceof ICPPASTNamedTypeSpecifier || parentOfName instanceof ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier;
    }

    private static ICPPTemplateArgument[] deduceTemplateFunctionArguments(ICPPFunctionTemplate template, ICPPTemplateArgument[] tmplArgs, IType[] fnArgs, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int length = tmplParams.length;
        if (tmplArgs.length > length) {
            return null;
        }
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[length];
        tmplArgs = SemanticUtil.getSimplifiedArguments(tmplArgs);
        int i = 0;
        while (i < tmplArgs.length) {
            ICPPTemplateArgument tmplArg = tmplArgs[i];
            ICPPTemplateParameter tmplParam = tmplParams[i];
            if ((tmplArg = CPPTemplates.matchTemplateParameterAndArgument(tmplParam, tmplArg, map)) == null) {
                return null;
            }
            tmplArg = SemanticUtil.getSimplifiedArgument(tmplArg);
            map.put(tmplParam, tmplArg);
            result[i] = tmplArg;
            ++i;
        }
        if (!CPPTemplates.deduceTemplateParameterMapFromFunctionParameters(template, fnArgs, map)) {
            return null;
        }
        i = 0;
        while (i < length) {
            if (result[i] == null) {
                ICPPTemplateArgument deducedArg = map.getArgument(tmplParams[i]);
                if (deducedArg == null) {
                    return null;
                }
                result[i] = deducedArg;
            }
            ++i;
        }
        return result;
    }

    private static ICPPTemplateArgument[] deduceTemplateConversionArguments(ICPPFunctionTemplate template, IType conversionType, CPPTemplateParameterMap map) throws DOMException {
        ICPPTemplateParameter[] tmplParams = template.getTemplateParameters();
        int length = tmplParams.length;
        ICPPTemplateArgument[] result = new ICPPTemplateArgument[length];
        if (!CPPTemplates.deduceTemplateParameterMap(template.getType().getReturnType(), conversionType, map)) {
            return null;
        }
        int i = 0;
        while (i < length) {
            if (result[i] == null) {
                ICPPTemplateArgument deducedArg = map.getArgument(tmplParams[i]);
                if (deducedArg == null) {
                    return null;
                }
                result[i] = deducedArg;
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateInstance createInstance(IBinding owner, ICPPTemplateDefinition template, CPPTemplateParameterMap tpMap, ICPPTemplateArgument[] args) {
        ICPPTemplateParameterMap map;
        if (owner instanceof ICPPSpecialization && (map = ((ICPPSpecialization)owner).getTemplateParameterMap()) != null) {
            tpMap.putAll(map);
        }
        CPPSpecialization instance = null;
        if (template instanceof ICPPClassType) {
            instance = new CPPClassInstance(owner, (ICPPClassType)((Object)template), tpMap, args);
        } else if (owner instanceof ICPPClassType && template instanceof ICPPMethod) {
            instance = template instanceof ICPPConstructor ? new CPPConstructorInstance((ICPPClassType)owner, (ICPPConstructor)((Object)template), tpMap, args) : new CPPMethodInstance((ICPPClassType)owner, (ICPPMethod)((Object)template), tpMap, args);
        } else if (template instanceof ICPPFunction) {
            instance = new CPPFunctionInstance(owner, (ICPPFunction)((Object)template), tpMap, args);
        }
        return instance;
    }

    public static IBinding createSpecialization(ICPPClassSpecialization owner, IBinding decl) {
        IBinding spec = null;
        ICPPTemplateParameterMap tpMap = owner.getTemplateParameterMap();
        if (decl instanceof ICPPClassTemplatePartialSpecialization) {
            try {
                ICPPClassTemplatePartialSpecialization pspec = (ICPPClassTemplatePartialSpecialization)decl;
                ICPPClassTemplate template = (ICPPClassTemplate)owner.specializeMember(pspec.getPrimaryClassTemplate());
                spec = new CPPClassTemplatePartialSpecializationSpecialization(pspec, template, tpMap);
            }
            catch (DOMException dOMException) {}
        } else if (decl instanceof ICPPClassTemplate) {
            spec = new CPPClassTemplateSpecialization((ICPPClassTemplate)decl, owner, tpMap);
        } else if (decl instanceof ICPPClassType) {
            spec = new CPPClassSpecialization((ICPPClassType)decl, (IBinding)owner, tpMap);
        } else if (decl instanceof ICPPField) {
            spec = new CPPFieldSpecialization(decl, owner, tpMap);
        } else if (decl instanceof ICPPFunctionTemplate) {
            spec = decl instanceof ICPPConstructor ? new CPPConstructorTemplateSpecialization(decl, owner, tpMap) : (decl instanceof ICPPMethod ? new CPPMethodTemplateSpecialization(decl, owner, tpMap) : new CPPFunctionTemplateSpecialization(decl, owner, tpMap));
        } else if (decl instanceof ICPPConstructor) {
            spec = new CPPConstructorSpecialization(decl, owner, tpMap);
        } else if (decl instanceof ICPPMethod) {
            spec = new CPPMethodSpecialization(decl, owner, tpMap);
        } else if (decl instanceof ICPPFunction) {
            spec = new CPPFunctionSpecialization(decl, owner, tpMap);
        } else if (decl instanceof ITypedef) {
            spec = new CPPTypedefSpecialization(decl, owner, tpMap);
        } else if (decl instanceof IEnumeration || decl instanceof IEnumerator) {
            spec = decl;
        }
        return spec;
    }

    public static IValue instantiateValue(IValue value, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within, int maxdepth) {
        if (value == null) {
            return null;
        }
        IBinding[] unknowns = value.getUnknownBindings();
        IBinding[] resolvedUnknowns = null;
        if (unknowns.length != 0) {
            int i = 0;
            while (i < unknowns.length) {
                IBinding unknown;
                IBinding resolved = unknown = unknowns[i];
                if (unknown instanceof ICPPUnknownBinding) {
                    try {
                        resolved = CPPTemplates.resolveUnknown((ICPPUnknownBinding)unknown, tpMap, within);
                    }
                    catch (DOMException dOMException) {
                        return Value.UNKNOWN;
                    }
                }
                if (resolvedUnknowns != null) {
                    resolvedUnknowns[i] = resolved;
                } else if (resolved != unknown) {
                    resolvedUnknowns = new IBinding[unknowns.length];
                    System.arraycopy(unknowns, 0, resolvedUnknowns, 0, i);
                    resolvedUnknowns[i] = resolved;
                }
                ++i;
            }
        }
        if (resolvedUnknowns != null) {
            return Value.reevaluate(value, resolvedUnknowns, tpMap, maxdepth);
        }
        if (Value.referencesTemplateParameter(value)) {
            return Value.reevaluate(value, unknowns, tpMap, maxdepth);
        }
        return value;
    }

    public static IType instantiateType(IType type, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within) {
        try {
            if (tpMap == null) {
                return type;
            }
            if (type instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)type;
                IType ret = null;
                IType[] params = null;
                IType r = ft.getReturnType();
                ret = CPPTemplates.instantiateType(r, tpMap, within);
                IType[] ps = ft.getParameterTypes();
                params = CPPTemplates.instantiateTypes(ps, tpMap, within);
                if (ret == r && params == ps) {
                    return type;
                }
                return new CPPFunctionType(ret, params, ft.isConst(), ft.isVolatile());
            }
            if (type instanceof ICPPTemplateParameter) {
                IType t;
                ICPPTemplateArgument arg = tpMap.getArgument((ICPPTemplateParameter)((Object)type));
                if (arg != null && (t = arg.getTypeValue()) != null) {
                    return t;
                }
                return type;
            }
            if (type instanceof ICPPUnknownBinding) {
                IBinding binding = CPPTemplates.resolveUnknown((ICPPUnknownBinding)((Object)type), tpMap, within);
                if (binding instanceof IType) {
                    return (IType)((Object)binding);
                }
                return type;
            }
            if (within != null && type instanceof IBinding && (type instanceof ITypedef || type instanceof ICPPClassType)) {
                ICPPClassType originalClass = within.getSpecializedBinding();
                if (originalClass.isSameType(type)) {
                    return within;
                }
                IBinding typeAsBinding = (IBinding)((Object)type);
                IBinding typeOwner = typeAsBinding.getOwner();
                if (typeOwner instanceof IType) {
                    IType newOwner = CPPTemplates.instantiateType((IType)((Object)typeOwner), tpMap, within);
                    if (newOwner != typeOwner && newOwner instanceof ICPPClassSpecialization) {
                        return (IType)((Object)((ICPPClassSpecialization)newOwner).specializeMember(typeAsBinding));
                    }
                    return type;
                }
            }
            if (type instanceof ITypeContainer) {
                ITypeContainer tc = (ITypeContainer)type;
                IType nestedType = tc.getType();
                IType newNestedType = CPPTemplates.instantiateType(nestedType, tpMap, within);
                if (type instanceof ICPPPointerToMemberType) {
                    ICPPPointerToMemberType ptm = (ICPPPointerToMemberType)type;
                    IType memberOfClass = ptm.getMemberOfClass();
                    IType newMemberOfClass = CPPTemplates.instantiateType(memberOfClass, tpMap, within);
                    if (newNestedType != nestedType || newMemberOfClass != memberOfClass) {
                        if (newMemberOfClass instanceof ICPPClassType) {
                            return new CPPPointerToMemberType(newNestedType, newMemberOfClass, ptm.isConst(), ptm.isVolatile());
                        }
                        return type;
                    }
                }
                if (newNestedType != nestedType) {
                    return SemanticUtil.replaceNestedType(tc, newNestedType);
                }
                return type;
            }
            return type;
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    public static IType[] instantiateTypes(IType[] types, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = CPPTemplates.instantiateType(types[i], tpMap, within);
            if (result != types) {
                result[i] = type;
            } else if (type != types[i]) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = type;
            }
            ++i;
        }
        return result;
    }

    public static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] types, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within) {
        ICPPTemplateArgument[] result = types;
        int i = 0;
        while (i < types.length) {
            ICPPTemplateArgument type = CPPTemplates.instantiateArgument(types[i], tpMap, within);
            if (result != types) {
                result[i] = type;
            } else if (type != types[i]) {
                result = new ICPPTemplateArgument[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = type;
            }
            ++i;
        }
        return result;
    }

    private static ICPPTemplateArgument instantiateArgument(ICPPTemplateArgument arg, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within) {
        IType inst;
        if (arg.isNonTypeValue()) {
            IValue inst2;
            IValue orig = arg.getNonTypeValue();
            if (orig == (inst2 = CPPTemplates.instantiateValue(orig, tpMap, within, 25))) {
                return arg;
            }
            return new CPPTemplateArgument(inst2, arg.getTypeOfNonTypeValue());
        }
        IType orig = arg.getTypeValue();
        if (orig == (inst = CPPTemplates.instantiateType(orig, tpMap, within))) {
            return arg;
        }
        return new CPPTemplateArgument(inst);
    }

    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTName name) {
        if (name == null) {
            return null;
        }
        ICPPASTInternalTemplateDeclaration tdecl = CPPTemplates.getInnerTemplateDeclaration(name);
        if (tdecl == null) {
            return null;
        }
        IASTNode parent = (name = name.getLastName()).getParent();
        if (!(parent instanceof ICPPASTQualifiedName)) {
            if (parent instanceof ICPPASTTemplateId) {
                return null;
            }
            return tdecl;
        }
        ICPPASTQualifiedName qname = (ICPPASTQualifiedName)parent;
        IASTName lastName = qname.getLastName();
        boolean lastIsTemplate = tdecl.isAssociatedWithLastName();
        if (name == lastName) {
            if (lastIsTemplate) {
                return tdecl;
            }
            return null;
        }
        if (!(name instanceof ICPPASTTemplateId)) {
            return null;
        }
        if (lastIsTemplate) {
            tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
        }
        IASTName[] ns = qname.getNames();
        int i = ns.length - 2;
        while (tdecl != null && i >= 0) {
            IASTName n = ns[i];
            if (n == name) {
                return tdecl;
            }
            if (n instanceof ICPPASTTemplateId) {
                tdecl = CPPTemplates.getDirectlyEnclosingTemplateDeclaration(tdecl);
            }
            --i;
        }
        return null;
    }

    public static void associateTemplateDeclarations(ICPPASTInternalTemplateDeclaration tdecl) {
        IASTDeclaration decl = tdecl.getDeclaration();
        while (decl instanceof ICPPASTInternalTemplateDeclaration) {
            tdecl = (ICPPASTInternalTemplateDeclaration)decl;
            decl = tdecl.getDeclaration();
        }
        ICPPASTInternalTemplateDeclaration innerMostTDecl = tdecl;
        IASTName name = CPPTemplates.getNameForDeclarationInTemplateDeclaration(decl);
        int tdeclcount = 1;
        IASTNode node = tdecl.getParent();
        while (node instanceof ICPPASTInternalTemplateDeclaration) {
            ++tdeclcount;
            tdecl = (ICPPASTInternalTemplateDeclaration)node;
            node = node.getParent();
        }
        ICPPASTInternalTemplateDeclaration outerMostTDecl = tdecl;
        boolean lastIsTemplate = true;
        int additionalLevels = 0;
        if (name instanceof ICPPASTQualifiedName) {
            char[] lastNamesLookupKey;
            IASTName secondLastName;
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
            IASTName lastName = qname.getLastName();
            boolean lastIsID = lastName instanceof ICPPASTTemplateId;
            int idcount = 0;
            IASTName[] ns = qname.getNames();
            int j = 0;
            while (j < ns.length) {
                IASTName n = ns[j];
                if (n instanceof ICPPASTTemplateId) {
                    ++idcount;
                }
                ++j;
            }
            boolean isCtorWithTemplateID = false;
            if (lastIsID && ns.length > 1 && (secondLastName = ns[ns.length - 2]) instanceof ICPPASTTemplateId && (CharArrayUtils.equals(lastNamesLookupKey = lastName.getLookupKey(), ((ICPPASTTemplateId)secondLastName).getLookupKey()) || lastNamesLookupKey.length > 0 && lastNamesLookupKey[0] == '~')) {
                isCtorWithTemplateID = true;
                --idcount;
            }
            if (lastIsID && !isCtorWithTemplateID) {
                additionalLevels = idcount - tdeclcount;
            } else {
                additionalLevels = idcount + 1 - tdeclcount;
                if (additionalLevels > 0) {
                    --additionalLevels;
                    lastIsTemplate = false;
                    CharArraySet tparnames = CPPTemplates.collectTemplateParameterNames(outerMostTDecl);
                    int j2 = 0;
                    int i = 0;
                    while (i < ns.length) {
                        IASTName n = ns[j2];
                        if (n instanceof ICPPASTTemplateId) {
                            ICPPASTTemplateId id = (ICPPASTTemplateId)n;
                            if (CPPTemplates.usesTemplateParameter(id, tparnames)) break;
                            if (j2++ == additionalLevels) {
                                IBinding b = n.resolveBinding();
                                if (!(b instanceof ICPPTemplateInstance) || !(b instanceof ICPPClassType)) break;
                                try {
                                    IScope s = ((ICPPClassType)b).getCompositeScope();
                                    if (s instanceof ICPPClassSpecializationScope) break;
                                    ++additionalLevels;
                                    lastIsTemplate = true;
                                }
                                catch (DOMException dOMException) {}
                                break;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        if (additionalLevels < 0) {
            additionalLevels = 0;
        }
        int level = additionalLevels;
        if (!CPPVisitor.isFriendFunctionDeclaration(innerMostTDecl.getDeclaration())) {
            node = outerMostTDecl.getParent();
            while (node != null) {
                if (node instanceof ICPPASTInternalTemplateDeclaration) {
                    level += ((ICPPASTInternalTemplateDeclaration)node).getNestingLevel() + 1;
                    break;
                }
                node = node.getParent();
            }
        }
        tdecl = outerMostTDecl;
        while (true) {
            tdecl.setNestingLevel((short)level++);
            tdecl.setAssociatedWithLastName(false);
            node = tdecl.getDeclaration();
            if (!(node instanceof ICPPASTInternalTemplateDeclaration)) break;
            tdecl = (ICPPASTInternalTemplateDeclaration)node;
        }
        innerMostTDecl.setAssociatedWithLastName(lastIsTemplate);
    }

    private static CharArraySet collectTemplateParameterNames(ICPPASTTemplateDeclaration tdecl) {
        CharArraySet set = new CharArraySet(4);
        while (true) {
            ICPPASTTemplateParameter[] pars;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = pars = tdecl.getTemplateParameters();
            int n = pars.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter par = iCPPASTTemplateParameterArray[n2];
                IASTName name = CPPTemplates.getTemplateParameterName(par);
                if (name != null) {
                    set.put(name.getLookupKey());
                }
                ++n2;
            }
            IASTDeclaration next = tdecl.getDeclaration();
            if (!(next instanceof ICPPASTTemplateDeclaration)) break;
            tdecl = (ICPPASTTemplateDeclaration)next;
        }
        return set;
    }

    private static boolean usesTemplateParameter(ICPPASTTemplateId id, final CharArraySet names) {
        final boolean[] result = new boolean[1];
        ASTVisitor v = new ASTVisitor(false){
            {
                super($anonymous0);
                this.shouldVisitNames = true;
                this.shouldVisitAmbiguousNodes = true;
            }

            public int visit(IASTName name) {
                if (name instanceof ICPPASTTemplateId) {
                    return 3;
                }
                if (name instanceof ICPPASTQualifiedName) {
                    ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
                    if (qname.isFullyQualified()) {
                        return 1;
                    }
                    return 3;
                }
                if (names.containsKey(name.getLookupKey())) {
                    IASTNode parent = name.getParent();
                    if (parent instanceof ICPPASTQualifiedName) {
                        if (((ICPPASTQualifiedName)parent).getNames()[0] != name) {
                            return 3;
                        }
                        result[0] = true;
                        return 2;
                    }
                    if (parent instanceof IASTIdExpression || parent instanceof ICPPASTNamedTypeSpecifier) {
                        result[0] = true;
                        return 2;
                    }
                }
                return 3;
            }

            public int visit(ASTAmbiguousNode node) {
                IASTNode[] alternatives;
                IASTNode[] iASTNodeArray = alternatives = node.getNodes();
                int n = alternatives.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTNode alt = iASTNodeArray[n2];
                    if (!alt.accept(this)) {
                        return 2;
                    }
                    ++n2;
                }
                return 3;
            }
        };
        id.accept(v);
        return result[0];
    }

    private static IASTName getNameForDeclarationInTemplateDeclaration(IASTDeclaration decl) {
        IASTName name = null;
        if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
            IASTDeclarator[] dtors = sdecl.getDeclarators();
            if (dtors != null && dtors.length > 0) {
                name = ASTQueries.findInnermostDeclarator(dtors[0]).getName();
            } else {
                IASTDeclSpecifier declspec = sdecl.getDeclSpecifier();
                if (declspec instanceof IASTCompositeTypeSpecifier) {
                    name = ((IASTCompositeTypeSpecifier)declspec).getName();
                } else if (declspec instanceof IASTElaboratedTypeSpecifier) {
                    name = ((IASTElaboratedTypeSpecifier)declspec).getName();
                }
            }
        } else if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
            name = ASTQueries.findInnermostDeclarator(fdef.getDeclarator()).getName();
        }
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private static ICPPASTInternalTemplateDeclaration getInnerTemplateDeclaration(IASTName name) {
        block5: {
            parent = name.getParent();
            while (parent instanceof IASTName) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTDeclSpecifier)) ** GOTO lbl11
            if (!(parent instanceof IASTCompositeTypeSpecifier) && !(parent instanceof IASTElaboratedTypeSpecifier)) {
                return null;
            }
            parent = parent.getParent();
            break block5;
lbl-1000:
            // 1 sources

            {
                parent = parent.getParent();
lbl11:
                // 2 sources

                ** while (parent instanceof IASTDeclarator)
            }
        }
        if (!(parent instanceof IASTDeclaration)) {
            return null;
        }
        if ((parent = parent.getParent()) instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    private static ICPPASTInternalTemplateDeclaration getDirectlyEnclosingTemplateDeclaration(ICPPASTInternalTemplateDeclaration tdecl) {
        IASTNode parent = tdecl.getParent();
        if (parent instanceof ICPPASTInternalTemplateDeclaration) {
            return (ICPPASTInternalTemplateDeclaration)parent;
        }
        return null;
    }

    public static IASTName getTemplateName(ICPPASTTemplateDeclaration templateDecl) {
        if (templateDecl == null) {
            return null;
        }
        ICPPASTTemplateDeclaration decl = templateDecl;
        while (decl.getParent() instanceof ICPPASTTemplateDeclaration) {
            decl = (ICPPASTTemplateDeclaration)decl.getParent();
        }
        IASTDeclaration nestedDecl = templateDecl.getDeclaration();
        while (nestedDecl instanceof ICPPASTTemplateDeclaration) {
            nestedDecl = ((ICPPASTTemplateDeclaration)nestedDecl).getDeclaration();
        }
        IASTName name = null;
        if (nestedDecl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration simple = (IASTSimpleDeclaration)nestedDecl;
            if (simple.getDeclarators().length == 1) {
                IASTDeclarator dtor = simple.getDeclarators()[0];
                while (dtor.getNestedDeclarator() != null) {
                    dtor = dtor.getNestedDeclarator();
                }
                name = dtor.getName();
            } else if (simple.getDeclarators().length == 0) {
                IASTDeclSpecifier spec = simple.getDeclSpecifier();
                if (spec instanceof ICPPASTCompositeTypeSpecifier) {
                    name = ((ICPPASTCompositeTypeSpecifier)spec).getName();
                } else if (spec instanceof ICPPASTElaboratedTypeSpecifier) {
                    name = ((ICPPASTElaboratedTypeSpecifier)spec).getName();
                }
            }
        } else if (nestedDecl instanceof IASTFunctionDefinition) {
            IASTDeclarator declarator = ((IASTFunctionDefinition)nestedDecl).getDeclarator();
            declarator = ASTQueries.findInnermostDeclarator(declarator);
            name = declarator.getName();
        }
        if (name != null) {
            if (name instanceof ICPPASTQualifiedName) {
                IASTName[] ns = ((ICPPASTQualifiedName)name).getNames();
                IASTDeclaration currDecl = decl;
                int j = 0;
                while (j < ns.length) {
                    if (ns[j] instanceof ICPPASTTemplateId || j + 1 == ns.length) {
                        if (currDecl == templateDecl) {
                            return ns[j];
                        }
                        if (currDecl instanceof ICPPASTTemplateDeclaration) {
                            currDecl = currDecl.getDeclaration();
                        } else {
                            return null;
                        }
                    }
                    ++j;
                }
            } else {
                return name;
            }
        }
        return null;
    }

    public static boolean areSameArguments(ICPPTemplateArgument[] args, ICPPTemplateArgument[] specArgs) {
        if (args.length == specArgs.length) {
            int i = 0;
            while (i < args.length) {
                if (!specArgs[i].isSameValue(args[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static ICPPTemplateArgument[] createTemplateArgumentArray(ICPPASTTemplateId id) throws DOMException {
        ICPPTemplateArgument[] result = ICPPTemplateArgument.EMPTY_ARGUMENTS;
        if (id != null) {
            IASTNode[] params = id.getTemplateArguments();
            result = new ICPPTemplateArgument[params.length];
            int i = 0;
            while (i < params.length) {
                IASTNode param = params[i];
                IType type = CPPVisitor.createType(param);
                if (type == null) {
                    throw new DOMException(new ProblemBinding(id, 5));
                }
                if (param instanceof IASTExpression) {
                    IValue value = Value.create((IASTExpression)param, 25);
                    result[i] = new CPPTemplateArgument(value, type);
                } else {
                    result[i] = new CPPTemplateArgument(type);
                }
                ++i;
            }
        }
        return result;
    }

    protected static void instantiateFunctionTemplates(IFunction[] functions, IType[] fnArgs, IASTName name) {
        boolean requireTemplate = false;
        if (name != null) {
            if (name.getPropertyInParent() == ICPPASTTemplateId.TEMPLATE_NAME) {
                name = (IASTName)name.getParent();
                requireTemplate = true;
            } else if (name instanceof ICPPASTTemplateId) {
                requireTemplate = true;
            }
        }
        ICPPTemplateArgument[] templateArguments = null;
        int i = 0;
        while (i < functions.length) {
            IFunction func = functions[i];
            if (func instanceof ICPPFunctionTemplate) {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)func;
                functions[i] = null;
                if (templateArguments == null || fnArgs == null) {
                    templateArguments = ICPPTemplateArgument.EMPTY_ARGUMENTS;
                    try {
                        if (CPPTemplates.containsDependentType(fnArgs)) {
                            functions[i] = CPPUnknownFunction.createForSample(template);
                            return;
                        }
                        if (name instanceof ICPPASTTemplateId && !(template instanceof ICPPConstructor) && CPPTemplates.hasDependentArgument(templateArguments = CPPTemplates.createTemplateArgumentArray((ICPPASTTemplateId)name))) {
                            functions[i] = CPPUnknownFunction.createForSample(template);
                            return;
                        }
                    }
                    catch (DOMException dOMException) {
                        return;
                    }
                }
                CPPTemplateParameterMap map = new CPPTemplateParameterMap(fnArgs.length);
                try {
                    IBinding instance;
                    ICPPTemplateArgument[] args = CPPTemplates.deduceTemplateFunctionArguments(template, templateArguments, fnArgs, map);
                    if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args)) instanceof IFunction) {
                        functions[i] = (IFunction)instance;
                    }
                }
                catch (DOMException dOMException) {}
            } else if (!(!requireTemplate || func instanceof ICPPConstructor || func instanceof ICPPUnknownBinding || func instanceof ICPPMethod && ((ICPPMethod)func).isDestructor())) {
                functions[i] = null;
            }
            ++i;
        }
    }

    protected static void instantiateConversionTemplates(IFunction[] functions, IType conversionType, IASTName name) {
        CPPTemplates.instantiateConversionTemplates(functions, conversionType);
    }

    protected static void instantiateConversionTemplates(IFunction[] functions, IType conversionType) {
        boolean checkedForDependentType = false;
        int i = 0;
        while (i < functions.length) {
            IFunction func = functions[i];
            if (func instanceof ICPPFunctionTemplate) {
                ICPPFunctionTemplate template = (ICPPFunctionTemplate)func;
                functions[i] = null;
                if (!checkedForDependentType) {
                    try {
                        if (CPPTemplates.isDependentType(conversionType)) {
                            functions[i] = CPPUnknownFunction.createForSample(template);
                            return;
                        }
                        checkedForDependentType = true;
                    }
                    catch (DOMException dOMException) {
                        return;
                    }
                }
                CPPTemplateParameterMap map = new CPPTemplateParameterMap(1);
                try {
                    IBinding instance;
                    ICPPTemplateArgument[] args = CPPTemplates.deduceTemplateConversionArguments(template, conversionType, map);
                    if (args != null && (instance = CPPTemplates.instantiateFunctionTemplate(template, args)) instanceof IFunction) {
                        functions[i] = (IFunction)instance;
                    }
                }
                catch (DOMException dOMException) {}
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean deduceTemplateParameterMapFromFunctionParameters(ICPPFunctionTemplate template, IType[] fnArgs, CPPTemplateParameterMap map) throws DOMException {
        try {
            IType par;
            IType[] fnPars = template.getType().getParameterTypes();
            if (fnPars.length == 0) {
                return true;
            }
            int len = Math.min(fnPars.length, fnArgs.length);
            IType[] instPars = new IType[len];
            int j = 0;
            while (j < len) {
                par = fnPars[j];
                IType instPar = CPPTemplates.instantiateType(par, map, null);
                if (!CPPTemplates.isValidType(instPar)) {
                    return false;
                }
                instPars[j] = instPar;
                ++j;
            }
            j = 0;
            while (j < len) {
                par = instPars[j];
                if (CPPTemplates.isDependentType(par)) {
                    ICPPClassType aInst;
                    ICPPTemplateInstance pInst;
                    ICPPClassTemplate pTemplate;
                    par = SemanticUtil.getNestedType(par, 1);
                    par = SemanticUtil.adjustParameterType(par, false);
                    boolean isReferenceType = par instanceof ICPPReferenceType;
                    IType arg = CPPTemplates.getArgumentTypeForDeduction(fnArgs[j], isReferenceType);
                    if ((par = CPPTemplates.getParameterTypeForDeduction(par, isReferenceType)) instanceof ICPPTemplateInstance && !(par instanceof ICPPTemplateParameter) && arg instanceof ICPPClassType && (pTemplate = CPPTemplates.getPrimaryTemplate(pInst = (ICPPTemplateInstance)((Object)par))) != null && (aInst = CPPTemplates.findBaseInstance((ICPPClassType)arg, pTemplate, 10)) != null) {
                        arg = aInst;
                    }
                    if (!CPPTemplates.deduceTemplateParameterMap(par, arg, map)) {
                        return false;
                    }
                }
                ++j;
            }
            return true;
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public static boolean deduceTemplateParameterMap(ICPPTemplateArgument[] p, ICPPTemplateArgument[] a, CPPTemplateParameterMap map) throws DOMException {
        int len = a.length;
        if (p == null || p.length != len) {
            return false;
        }
        int j = 0;
        while (j < len) {
            if (!CPPTemplates.deduceTemplateParameterMap(p[j], a[j], map)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private static boolean deduceTemplateParameterMap(ICPPTemplateArgument p, ICPPTemplateArgument a, CPPTemplateParameterMap map) throws DOMException {
        if (p.isNonTypeValue() != a.isNonTypeValue()) {
            return false;
        }
        if (p.isNonTypeValue()) {
            IValue tval = p.getNonTypeValue();
            int parPos = Value.isTemplateParameter(tval);
            if (parPos >= 0) {
                ICPPTemplateArgument old = map.getArgument(parPos);
                if (old == null) {
                    map.put(parPos, a);
                    return true;
                }
                return old.isSameValue(a);
            }
            IValue sval = a.getNonTypeValue();
            return tval.equals(sval);
        }
        return CPPTemplates.deduceTemplateParameterMap(p.getTypeValue(), a.getTypeValue(), map);
    }

    private static IType getParameterTypeForDeduction(IType pType, boolean isReferenceType) {
        if (isReferenceType) {
            return SemanticUtil.getNestedType(pType, 3);
        }
        return SemanticUtil.getNestedType(pType, 13);
    }

    private static IType getArgumentTypeForDeduction(IType type, boolean parameterIsAReferenceType) {
        if ((type = SemanticUtil.getSimplifiedType(type)) instanceof ICPPReferenceType) {
            try {
                type = ((ICPPReferenceType)type).getType();
            }
            catch (DOMException dOMException) {}
        }
        IType result = type;
        if (!parameterIsAReferenceType) {
            try {
                result = type instanceof IArrayType ? new CPPPointerType(((IArrayType)type).getType()) : (type instanceof IFunctionType ? new CPPPointerType(type) : SemanticUtil.getNestedType(type, 13));
            }
            catch (DOMException e) {
                result = e.getProblem();
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean deduceTemplateParameterMap(IType p, IType a, CPPTemplateParameterMap map) throws DOMException {
        ** GOTO lbl83
        {
            a = ((ITypedef)a).getType();
            do {
                if (a instanceof ITypedef) continue block0;
                if (p instanceof IBasicType) {
                    return p.isSameType(a);
                }
                if (p instanceof ICPPPointerToMemberType) {
                    if (!(a instanceof ICPPPointerToMemberType)) {
                        return false;
                    }
                    if (!CPPTemplates.deduceTemplateParameterMap(((ICPPPointerToMemberType)p).getMemberOfClass(), ((ICPPPointerToMemberType)a).getMemberOfClass(), map)) {
                        return false;
                    }
                    p = ((ICPPPointerToMemberType)p).getType();
                    a = ((ICPPPointerToMemberType)a).getType();
                    continue;
                }
                if (p instanceof IPointerType) {
                    if (!(a instanceof IPointerType)) {
                        return false;
                    }
                    p = ((IPointerType)p).getType();
                    a = ((IPointerType)a).getType();
                    continue;
                }
                if (p instanceof IQualifierType) {
                    if (a instanceof IQualifierType) {
                        a = ((IQualifierType)a).getType();
                    }
                    p = ((IQualifierType)p).getType();
                    continue;
                }
                if (p instanceof IFunctionType) {
                    if (!(a instanceof IFunctionType)) {
                        return false;
                    }
                    if (!CPPTemplates.deduceTemplateParameterMap(((IFunctionType)p).getReturnType(), ((IFunctionType)a).getReturnType(), map)) {
                        return false;
                    }
                    pParams = ((IFunctionType)p).getParameterTypes();
                    if (pParams.length != (aParams = ((IFunctionType)a).getParameterTypes()).length) {
                        return false;
                    }
                    i = 0;
                    while (i < pParams.length) {
                        if (!CPPTemplates.deduceTemplateParameterMap(pParams[i], aParams[i], map)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                if (p instanceof ICPPTemplateParameter) {
                    current = map.getArgument((ICPPTemplateParameter)p);
                    if (current != null) {
                        if (current.isNonTypeValue()) {
                            return false;
                        }
                        return current.getTypeValue().isSameType(a);
                    }
                    if (a == null) {
                        return false;
                    }
                    map.put((ICPPTemplateParameter)p, (ICPPTemplateArgument)new CPPTemplateArgument(a));
                    return true;
                }
                if (p instanceof ICPPTemplateInstance) {
                    if (!(a instanceof ICPPTemplateInstance)) {
                        return false;
                    }
                    pInst = (ICPPTemplateInstance)p;
                    aInst = (ICPPTemplateInstance)a;
                    pTemplate = CPPTemplates.getPrimaryTemplate(pInst);
                    aTemplate = CPPTemplates.getPrimaryTemplate(aInst);
                    if (pTemplate == null || aTemplate == null || !aTemplate.isSameType(pTemplate)) {
                        return false;
                    }
                    pArgs = pInst.getTemplateArguments();
                    if (pArgs.length > (aArgs = aInst.getTemplateArguments()).length) {
                        return false;
                    }
                    tpars = null;
                    i = 0;
                    while (i < aArgs.length) {
                        if (i < pArgs.length) {
                            pArg = pArgs[i];
                        } else {
                            if (tpars == null && (tpars = pTemplate.getTemplateParameters()).length < aArgs.length) {
                                return false;
                            }
                            pArg = tpars[i].getDefaultValue();
                            if (pArg == null) {
                                return false;
                            }
                            pArg = CPPTemplates.instantiateArgument(pArg, pInst.getTemplateParameterMap(), null);
                        }
                        if (!CPPTemplates.deduceTemplateParameterMap(pArg, aArgs[i], map)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                if (p instanceof ICPPUnknownBinding) {
                    return true;
                }
                return p.isSameType(a);
lbl83:
                // 4 sources

            } while (p != null);
        }
        return false;
    }

    private static ICPPClassType findBaseInstance(ICPPClassType a, ICPPClassTemplate pTemplate, int maxdepth) throws DOMException {
        ICPPTemplateInstance inst;
        ICPPClassTemplate tmpl;
        if (a instanceof ICPPTemplateInstance && pTemplate.isSameType(tmpl = CPPTemplates.getPrimaryTemplate(inst = (ICPPTemplateInstance)((Object)a)))) {
            return a;
        }
        if (maxdepth-- > 0) {
            ICPPBase[] iCPPBaseArray = a.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType inst2;
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof ICPPClassType && (inst2 = CPPTemplates.findBaseInstance((ICPPClassType)base, pTemplate, maxdepth)) != null) {
                    return inst2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static ICPPClassTemplate getPrimaryTemplate(ICPPTemplateInstance inst) throws DOMException {
        ICPPTemplateDefinition template = inst.getTemplateDefinition();
        if (template instanceof ICPPClassTemplatePartialSpecialization) {
            return ((ICPPClassTemplatePartialSpecialization)template).getPrimaryClassTemplate();
        }
        if (template instanceof ICPPClassTemplate) {
            return (ICPPClassTemplate)template;
        }
        return null;
    }

    private static ICPPTemplateArgument[] createArgsForFunctionTemplateOrdering(ICPPFunctionTemplate template) throws DOMException {
        ICPPTemplateParameter[] paramList = template.getTemplateParameters();
        int size = paramList.length;
        ICPPTemplateArgument[] args = new ICPPTemplateArgument[size];
        int i = 0;
        while (i < size) {
            ICPPTemplateParameter param = paramList[i];
            args[i] = param instanceof ICPPTemplateNonTypeParameter ? new CPPTemplateArgument(Value.unique(), ((ICPPTemplateNonTypeParameter)param).getType()) : new CPPTemplateArgument(new CPPBasicType(-1, 0));
            ++i;
        }
        return args;
    }

    protected static int orderTemplateFunctions(ICPPFunctionTemplate f1, ICPPFunctionTemplate f2) throws DOMException {
        CPPTemplateParameterMap m1 = new CPPTemplateParameterMap(2);
        CPPTemplateParameterMap m2 = new CPPTemplateParameterMap(2);
        ICPPTemplateArgument[] args = CPPTemplates.createArgsForFunctionTemplateOrdering(f1);
        IBinding function = CPPTemplates.instantiateFunctionTemplate(f1, args);
        if (function instanceof ICPPFunction && !CPPTemplates.deduceTemplateParameterMapFromFunctionParameters(f2, ((ICPPFunction)function).getType().getParameterTypes(), m1)) {
            m1 = null;
        }
        if ((function = CPPTemplates.instantiateFunctionTemplate(f2, args = CPPTemplates.createArgsForFunctionTemplateOrdering(f2))) instanceof ICPPFunction && !CPPTemplates.deduceTemplateParameterMapFromFunctionParameters(f1, ((ICPPFunction)function).getType().getParameterTypes(), m2)) {
            m2 = null;
        }
        if (m1 == null) {
            if (m2 == null) {
                return 0;
            }
            return -1;
        }
        if (m2 == null) {
            return 1;
        }
        int d1 = 0;
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = m1.values();
        int n = iCPPTemplateArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (arg.getTypeValue() instanceof IQualifierType) {
                ++d1;
            }
            ++n2;
        }
        int d2 = 0;
        ICPPTemplateArgument[] iCPPTemplateArgumentArray2 = m2.values();
        int n3 = iCPPTemplateArgumentArray2.length;
        n = 0;
        while (n < n3) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray2[n];
            if (arg.getTypeValue() instanceof IQualifierType) {
                ++d2;
            }
            ++n;
        }
        return d1 - d2;
    }

    private static ICPPClassTemplatePartialSpecialization findPartialSpecialization(ICPPClassTemplate ct, ICPPTemplateArgument[] args) throws DOMException {
        ICPPClassTemplatePartialSpecialization[] pspecs = ct.getPartialSpecializations();
        if (pspecs != null && pspecs.length > 0) {
            String argStr = ASTTypeUtil.getArgumentListString(args, true);
            ICPPClassTemplatePartialSpecialization[] iCPPClassTemplatePartialSpecializationArray = pspecs;
            int n = pspecs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassTemplatePartialSpecialization pspec = iCPPClassTemplatePartialSpecializationArray[n2];
                try {
                    if (argStr.equals(ASTTypeUtil.getArgumentListString(pspec.getTemplateArguments(), true))) {
                        return pspec;
                    }
                }
                catch (DOMException dOMException) {}
                ++n2;
            }
        }
        return null;
    }

    public static ICPPTemplateDefinition selectSpecialization(ICPPClassTemplate template, ICPPTemplateArgument[] args) throws DOMException {
        if (template == null) {
            return null;
        }
        ICPPClassTemplatePartialSpecialization[] specializations = template.getPartialSpecializations();
        if (specializations == null) {
            return template;
        }
        int size = specializations.length;
        if (size == 0) {
            return template;
        }
        ICPPClassTemplatePartialSpecialization bestMatch = null;
        ICPPClassTemplatePartialSpecialization spec = null;
        boolean bestMatchIsBest = true;
        int i = 0;
        while (i < size) {
            spec = specializations[i];
            if (CPPTemplates.deduceTemplateParameterMap(spec.getTemplateArguments(), args, new CPPTemplateParameterMap(args.length))) {
                int compare = CPPTemplates.orderSpecializations(bestMatch, spec);
                if (compare == 0) {
                    bestMatchIsBest = false;
                } else if (compare < 0) {
                    bestMatch = spec;
                    bestMatchIsBest = true;
                }
            }
            ++i;
        }
        if (!bestMatchIsBest) {
            return new CPPTemplateDefinition.CPPTemplateProblem(null, 4, null);
        }
        if (bestMatch == null) {
            return template;
        }
        return bestMatch;
    }

    private static int orderSpecializations(ICPPClassTemplatePartialSpecialization spec1, ICPPClassTemplatePartialSpecialization spec2) throws DOMException {
        if (spec1 == null) {
            return -1;
        }
        ICPPFunctionTemplate template1 = CPPTemplates.classTemplateSpecializationToFunctionTemplate(spec1);
        ICPPFunctionTemplate template2 = CPPTemplates.classTemplateSpecializationToFunctionTemplate(spec2);
        if (template1 == null) {
            if (template2 == null) {
                return 0;
            }
            return 1;
        }
        if (template2 == null) {
            return -1;
        }
        return CPPTemplates.orderTemplateFunctions(template1, template2);
    }

    private static ICPPFunctionTemplate classTemplateSpecializationToFunctionTemplate(ICPPClassTemplatePartialSpecialization specialization) {
        IBinding paramType;
        block3: {
            try {
                ICPPTemplateArgument[] args = specialization.getTemplateArguments();
                paramType = CPPTemplates.deferredInstance(specialization, args);
                if (paramType instanceof IType) break block3;
                return null;
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        IParameter[] functionParameters = new IParameter[]{new CPPParameter((IType)((Object)paramType))};
        return new CPPImplicitFunctionTemplate(specialization.getTemplateParameters(), functionParameters);
    }

    private static boolean isValidType(IType t) {
        try {
            while (t instanceof ITypeContainer) {
                t = ((ITypeContainer)t).getType();
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
        return !(t instanceof IProblemBinding);
    }

    protected static ICPPTemplateArgument matchTemplateParameterAndArgument(ICPPTemplateParameter param, ICPPTemplateArgument arg, CPPTemplateParameterMap map) {
        if (arg == null || !CPPTemplates.isValidType(arg.getTypeValue())) {
            return null;
        }
        if (param instanceof ICPPTemplateTypeParameter) {
            IType t = arg.getTypeValue();
            if (t != null && !(t instanceof ICPPTemplateDefinition)) {
                return arg;
            }
            return null;
        }
        if (param instanceof ICPPTemplateTemplateParameter) {
            IType t = arg.getTypeValue();
            if (!(t instanceof ICPPTemplateDefinition)) {
                return null;
            }
            ICPPTemplateParameter[] pParams = null;
            ICPPTemplateParameter[] aParams = null;
            try {
                pParams = ((ICPPTemplateTemplateParameter)param).getTemplateParameters();
                aParams = ((ICPPTemplateDefinition)((Object)t)).getTemplateParameters();
            }
            catch (DOMException dOMException) {
                return null;
            }
            int size = pParams.length;
            if (aParams.length != size) {
                return null;
            }
            int i = 0;
            while (i < size) {
                ICPPTemplateParameter pParam = pParams[i];
                boolean pb = pParam instanceof ICPPTemplateTypeParameter;
                ICPPTemplateParameter aParam = aParams[i];
                boolean ab = aParam instanceof ICPPTemplateTypeParameter;
                if (pb != ab) {
                    return null;
                }
                if (!pb) {
                    pb = pParam instanceof ICPPTemplateNonTypeParameter;
                    ab = aParam instanceof ICPPTemplateNonTypeParameter;
                    if (pb != ab) {
                        return null;
                    }
                    assert (pParam instanceof ICPPTemplateTemplateParameter);
                    assert (aParam instanceof ICPPTemplateTemplateParameter);
                }
                ++i;
            }
            return arg;
        }
        if (param instanceof ICPPTemplateNonTypeParameter) {
            if (!arg.isNonTypeValue()) {
                return null;
            }
            IType argType = arg.getTypeOfNonTypeValue();
            try {
                IType pType = ((ICPPTemplateNonTypeParameter)param).getType();
                if (map != null && pType != null) {
                    pType = CPPTemplates.instantiateType(pType, map, null);
                }
                if (argType instanceof ICPPUnknownType || CPPTemplates.isNonTypeArgumentConvertible(pType, argType)) {
                    return new CPPTemplateArgument(arg.getNonTypeValue(), pType);
                }
                return null;
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        assert (false);
        return null;
    }

    private static boolean isNonTypeArgumentConvertible(IType paramType, IType arg) throws DOMException {
        if (paramType instanceof IFunctionType) {
            paramType = new CPPPointerType(paramType);
        } else if (paramType instanceof IArrayType) {
            try {
                paramType = new CPPPointerType(((IArrayType)paramType).getType());
            }
            catch (DOMException e) {
                paramType = e.getProblem();
            }
        }
        Cost cost = Conversions.checkStandardConversionSequence(arg, paramType, false);
        return cost != null && cost.getRank() != Cost.Rank.NO_MATCH;
    }

    static boolean argsAreTrivial(ICPPTemplateParameter[] pars, ICPPTemplateArgument[] args) {
        if (pars.length != args.length) {
            return false;
        }
        int i = 0;
        while (i < args.length) {
            ICPPTemplateParameter par = pars[i];
            ICPPTemplateArgument arg = args[i];
            if (par instanceof IType) {
                if (arg.isNonTypeValue()) {
                    return false;
                }
                IType argType = arg.getTypeValue();
                if (argType == null || !argType.isSameType((IType)((Object)par))) {
                    return false;
                }
            } else {
                if (arg.isTypeValue()) {
                    return false;
                }
                int parpos = Value.isTemplateParameter(arg.getNonTypeValue());
                if (parpos != par.getParameterID()) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean hasDependentArgument(ICPPTemplateArgument[] args) {
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (CPPTemplates.isDependentArgument(arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isDependentArgument(ICPPTemplateArgument arg) {
        if (arg.isTypeValue()) {
            return CPPTemplates.isDependentType(arg.getTypeValue());
        }
        return Value.isDependentValue(arg.getNonTypeValue());
    }

    public static boolean containsDependentType(IType[] ts) {
        IType[] iTypeArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (CPPTemplates.isDependentType(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDependentType(IType t) {
        try {
            while (true) {
                if (t instanceof ICPPUnknownType) {
                    return true;
                }
                if (t instanceof ICPPFunctionType) {
                    ICPPFunctionType ft = (ICPPFunctionType)t;
                    if (CPPTemplates.containsDependentType(ft.getParameterTypes())) {
                        return true;
                    }
                    t = ft.getReturnType();
                    continue;
                }
                if (t instanceof ICPPPointerToMemberType) {
                    ICPPPointerToMemberType ptmt = (ICPPPointerToMemberType)t;
                    if (CPPTemplates.isDependentType(ptmt.getMemberOfClass())) {
                        return true;
                    }
                    t = ptmt.getType();
                    continue;
                }
                if (!(t instanceof ITypeContainer)) {
                    return false;
                }
                t = ((ITypeContainer)t).getType();
            }
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public static boolean containsDependentArg(ObjectMap tpMap) {
        Object[] objectArray = tpMap.valueArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            if (CPPTemplates.isDependentType((IType)arg)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IBinding resolveUnknown(ICPPUnknownBinding unknown, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within) throws DOMException {
        if (unknown instanceof ICPPDeferredClassInstance) {
            return CPPTemplates.resolveDeferredClassInstance((ICPPDeferredClassInstance)unknown, tpMap, within);
        }
        IBinding owner = unknown.getOwner();
        if (!(owner instanceof ICPPTemplateTypeParameter) && !(owner instanceof ICPPUnknownClassType)) {
            return unknown;
        }
        IBinding result = unknown;
        IType t = CPPTemplates.instantiateType((IType)((Object)owner), tpMap, within);
        if (t != null) {
            IScope s;
            if ((t = SemanticUtil.getUltimateType(t, false)) instanceof ICPPUnknownBinding) {
                if (unknown instanceof ICPPUnknownClassInstance) {
                    ICPPUnknownClassInstance ucli = (ICPPUnknownClassInstance)unknown;
                    ICPPTemplateArgument[] arguments = ucli.getArguments();
                    ICPPTemplateArgument[] newArgs = CPPTemplates.instantiateArguments(arguments, tpMap, within);
                    if (!t.equals(owner) && newArgs != arguments) {
                        result = new CPPUnknownClassInstance((ICPPUnknownBinding)((Object)t), ucli.getNameCharArray(), newArgs);
                    }
                } else if (!t.equals(owner)) {
                    result = unknown instanceof ICPPUnknownClassType ? new CPPUnknownClass((ICPPUnknownBinding)((Object)t), unknown.getNameCharArray()) : (unknown instanceof IFunction ? new CPPUnknownClass((ICPPUnknownBinding)((Object)t), unknown.getNameCharArray()) : new CPPUnknownBinding((ICPPUnknownBinding)((Object)t), unknown.getNameCharArray()));
                }
            } else if (t instanceof ICPPClassType && (s = ((ICPPClassType)t).getCompositeScope()) != null) {
                result = CPPSemantics.resolveUnknownName(s, unknown);
                if (unknown instanceof ICPPUnknownClassInstance && result instanceof ICPPTemplateDefinition) {
                    ICPPTemplateArgument[] newArgs = CPPTemplates.instantiateArguments(((ICPPUnknownClassInstance)unknown).getArguments(), tpMap, within);
                    if (result instanceof ICPPClassTemplate) {
                        result = CPPTemplates.instantiate((ICPPClassTemplate)result, newArgs);
                    }
                }
            }
        }
        return result;
    }

    private static IBinding resolveDeferredClassInstance(ICPPDeferredClassInstance dci, ICPPTemplateParameterMap tpMap, ICPPClassSpecialization within) {
        IBinding inst;
        ICPPTemplateArgument[] newArgs;
        ICPPTemplateArgument[] arguments = dci.getTemplateArguments();
        boolean changed = arguments != (newArgs = CPPTemplates.instantiateArguments(arguments, tpMap, within));
        ICPPClassTemplate classTemplate = dci.getClassTemplate();
        IType specializedClassTemplate = CPPTemplates.instantiateType(classTemplate, tpMap, within);
        if (specializedClassTemplate != classTemplate && specializedClassTemplate instanceof ICPPClassTemplate) {
            classTemplate = (ICPPClassTemplate)specializedClassTemplate;
            changed = true;
        }
        if (changed && (inst = CPPTemplates.instantiate(classTemplate, newArgs)) != null) {
            return inst;
        }
        return dci;
    }

    public static boolean haveSameArguments(ICPPTemplateInstance i1, ICPPTemplateInstance i2) {
        ICPPTemplateArgument[] m1 = i1.getTemplateArguments();
        ICPPTemplateArgument[] m2 = i2.getTemplateArguments();
        if (m1 == null || m2 == null || m1.length != m2.length) {
            return false;
        }
        String s1 = ASTTypeUtil.getArgumentListString(m1, true);
        String s2 = ASTTypeUtil.getArgumentListString(m2, true);
        return s1.equals(s2);
    }

    public static ICPPTemplateParameterMap createParameterMap(ICPPTemplateDefinition tdef, ICPPTemplateArgument[] args) {
        try {
            ICPPTemplateParameter[] tpars = tdef.getTemplateParameters();
            int len = Math.min(tpars.length, args.length);
            CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
            int i = 0;
            while (i < len) {
                result.put(tpars[i], args[i]);
                ++i;
            }
            return result;
        }
        catch (DOMException dOMException) {
            return CPPTemplateParameterMap.EMPTY;
        }
    }

    @Deprecated
    public static IType[] getArguments(ICPPTemplateArgument[] arguments) {
        IType[] types = new IType[arguments.length];
        int i = 0;
        while (i < types.length) {
            ICPPTemplateArgument arg = arguments[i];
            types[i] = arg == null ? null : (arg.isNonTypeValue() ? arg.getTypeOfNonTypeValue() : arg.getTypeValue());
            ++i;
        }
        return types;
    }

    @Deprecated
    public static ObjectMap getArgumentMap(IBinding b, ICPPTemplateParameterMap tpmap) {
        Integer[] keys = tpmap.getAllParameterPositions();
        if (keys.length == 0) {
            return ObjectMap.EMPTY_MAP;
        }
        try {
            ArrayList<ICPPTemplateDefinition> defs = new ArrayList<ICPPTemplateDefinition>();
            IBinding owner = b;
            while (owner != null) {
                if (owner instanceof ICPPTemplateDefinition) {
                    defs.add((ICPPTemplateDefinition)owner);
                } else if (owner instanceof ICPPTemplateInstance) {
                    defs.add(((ICPPTemplateInstance)owner).getTemplateDefinition());
                }
                owner = owner.getOwner();
            }
            Collections.reverse(defs);
            ObjectMap result = new ObjectMap(keys.length);
            Integer[] integerArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPTemplateDefinition tdef;
                ICPPTemplateParameter[] tps;
                int key = integerArray[n2];
                int nestingLevel = key >> 16;
                int numParam = key & 0xFFFF;
                if (numParam >= 0 && nestingLevel >= 0 && nestingLevel < defs.size() && numParam < (tps = (tdef = (ICPPTemplateDefinition)defs.get(nestingLevel)).getTemplateParameters()).length) {
                    ICPPTemplateArgument arg = tpmap.getArgument(key);
                    IType type = arg.isNonTypeValue() ? arg.getTypeOfNonTypeValue() : arg.getTypeValue();
                    result.put(tps[numParam], type);
                }
                ++n2;
            }
            return result;
        }
        catch (DOMException dOMException) {
            return ObjectMap.EMPTY_MAP;
        }
    }

    public static final class CPPImplicitFunctionTemplate
    extends CPPFunctionTemplate {
        IParameter[] functionParameters = null;
        ICPPTemplateParameter[] templateParameters = null;

        public CPPImplicitFunctionTemplate(ICPPTemplateParameter[] templateParameters, IParameter[] functionParameters) {
            super(null);
            this.functionParameters = functionParameters;
            this.templateParameters = templateParameters;
        }

        public IParameter[] getParameters() {
            return this.functionParameters;
        }

        public ICPPTemplateParameter[] getTemplateParameters() {
            return this.templateParameters;
        }

        public IScope getScope() {
            return null;
        }

        public ICPPFunctionType getType() {
            if (this.type == null) {
                this.type = CPPVisitor.createImplicitFunctionType(new CPPBasicType(1, 0), this.functionParameters, false, false);
            }
            return this.type;
        }
    }
}

