/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IWritableIndexFragment;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.Messages;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroReferenceName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDOMFile
implements IIndexFragmentFile {
    private final PDOMLinkage fLinkage;
    private final int record;
    private IIndexFileLocation location;
    private static final int FIRST_NAME = 0;
    private static final int FIRST_INCLUDE = 4;
    private static final int FIRST_INCLUDED_BY = 8;
    private static final int FIRST_MACRO = 12;
    private static final int LOCATION_REPRESENTATION = 16;
    private static final int LINKAGE_ID = 20;
    private static final int TIME_STAMP = 24;
    private static final int SCANNER_CONFIG_HASH = 32;
    private static final int LAST_USING_DIRECTIVE = 36;
    private static final int FIRST_MACRO_REFERENCE = 40;
    private static final int RECORD_SIZE = 44;

    public PDOMFile(PDOMLinkage linkage, int record) {
        this.fLinkage = linkage;
        this.record = record;
    }

    public PDOMFile(PDOMLinkage linkage, IIndexFileLocation location, int linkageID) throws CoreException {
        this.fLinkage = linkage;
        this.location = location;
        Database db = this.fLinkage.getDB();
        this.record = db.malloc(44);
        String locationString = this.fLinkage.getPDOM().getLocationConverter().toInternalFormat(location);
        if (locationString == null) {
            throw new CoreException(CCorePlugin.createStatus(String.valueOf(Messages.getString("PDOMFile.toInternalProblem")) + location.getURI()));
        }
        IString locationDBString = db.newString(locationString);
        db.putInt(this.record + 16, locationDBString.getRecord());
        db.putInt(this.record + 20, linkageID);
        db.putLong(this.record + 24, 0L);
        this.setFirstName(null);
        this.setFirstInclude(null);
        this.setFirstIncludedBy(null);
        this.setTimestamp(-1L);
    }

    public int getRecord() {
        return this.record;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PDOMFile) {
            PDOMFile other = (PDOMFile)obj;
            return this.fLinkage.getPDOM().equals(other.getLinkage().getPDOM()) && this.record == other.record;
        }
        return false;
    }

    public final int hashCode() {
        return System.identityHashCode(this.fLinkage.getPDOM()) + 41 * this.record;
    }

    public void setInternalLocation(String internalLocation) throws CoreException {
        Database db = this.fLinkage.getDB();
        int oldRecord = db.getInt(this.record + 16);
        db.free(oldRecord);
        db.putInt(this.record + 16, db.newString(internalLocation).getRecord());
        this.location = null;
    }

    @Override
    public int getLinkageID() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getInt(this.record + 20);
    }

    @Override
    public long getTimestamp() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getLong(this.record + 24);
    }

    @Override
    public void setTimestamp(long timestamp) throws CoreException {
        Database db = this.fLinkage.getDB();
        db.putLong(this.record + 24, timestamp);
    }

    @Override
    public int getScannerConfigurationHashcode() throws CoreException {
        Database db = this.fLinkage.getDB();
        return db.getInt(this.record + 32);
    }

    @Override
    public void setScannerConfigurationHashcode(int hashcode) throws CoreException {
        Database db = this.fLinkage.getDB();
        db.putInt(this.record + 32, hashcode);
    }

    private PDOMName getFirstName() throws CoreException {
        int namerec = this.fLinkage.getDB().getInt(this.record + 0);
        return namerec != 0 ? new PDOMName(this.fLinkage, namerec) : null;
    }

    private void setFirstName(PDOMName firstName) throws CoreException {
        int namerec = firstName != null ? firstName.getRecord() : 0;
        this.fLinkage.getDB().putInt(this.record + 0, namerec);
    }

    private PDOMMacroReferenceName getFirstMacroReference() throws CoreException {
        int namerec = this.fLinkage.getDB().getInt(this.record + 40);
        return namerec != 0 ? new PDOMMacroReferenceName(this.fLinkage, namerec) : null;
    }

    private void setFirstMacroReference(PDOMMacroReferenceName firstName) throws CoreException {
        int namerec = firstName != null ? firstName.getRecord() : 0;
        this.fLinkage.getDB().putInt(this.record + 40, namerec);
    }

    public PDOMInclude getFirstInclude() throws CoreException {
        int increc = this.fLinkage.getDB().getInt(this.record + 4);
        return increc != 0 ? new PDOMInclude(this.fLinkage, increc) : null;
    }

    public void setFirstInclude(PDOMInclude include) throws CoreException {
        int rec = include != null ? include.getRecord() : 0;
        this.fLinkage.getDB().putInt(this.record + 4, rec);
    }

    public PDOMInclude getFirstIncludedBy() throws CoreException {
        int rec = this.fLinkage.getDB().getInt(this.record + 8);
        return rec != 0 ? new PDOMInclude(this.fLinkage, rec) : null;
    }

    @Override
    public IIndexInclude getParsedInContext() throws CoreException {
        return this.getFirstIncludedBy();
    }

    public void setFirstIncludedBy(PDOMInclude includedBy) throws CoreException {
        int rec = includedBy != null ? includedBy.getRecord() : 0;
        this.fLinkage.getDB().putInt(this.record + 8, rec);
    }

    public PDOMMacro getFirstMacro() throws CoreException {
        int rec = this.fLinkage.getDB().getInt(this.record + 12);
        return rec != 0 ? new PDOMMacro(this.fLinkage, rec) : null;
    }

    public void setFirstMacro(PDOMMacro macro) throws CoreException {
        int rec = macro != null ? macro.getRecord() : 0;
        this.fLinkage.getDB().putInt(this.record + 12, rec);
    }

    public void addMacros(IASTPreprocessorStatement[] macros) throws CoreException {
        assert (this.getFirstMacro() == null);
        PDOMMacro lastMacro = null;
        PDOMLinkage linkage = this.getLinkage();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = macros;
        int n = macros.length;
        int n2 = 0;
        while (n2 < n) {
            PDOMMacroContainer container;
            IASTPreprocessorStatement stmt = iASTPreprocessorStatementArray[n2];
            PDOMMacro pdomMacro = null;
            if (stmt instanceof IASTPreprocessorMacroDefinition) {
                IASTPreprocessorMacroDefinition macro = (IASTPreprocessorMacroDefinition)stmt;
                container = linkage.getMacroContainer(macro.getName().getSimpleID());
                pdomMacro = new PDOMMacro(this.fLinkage, container, macro, this);
            } else if (stmt instanceof IASTPreprocessorUndefStatement) {
                IASTPreprocessorUndefStatement undef = (IASTPreprocessorUndefStatement)stmt;
                container = linkage.getMacroContainer(undef.getMacroName().getSimpleID());
                pdomMacro = new PDOMMacro(this.fLinkage, container, undef, this);
            }
            if (pdomMacro != null) {
                if (lastMacro == null) {
                    this.setFirstMacro(pdomMacro);
                } else {
                    lastMacro.setNextMacro(pdomMacro);
                }
                lastMacro = pdomMacro;
            }
            ++n2;
        }
    }

    final PDOMLinkage getLinkage() {
        return this.fLinkage;
    }

    public void addNames(IASTName[][] names) throws CoreException {
        assert (this.getFirstName() == null);
        assert (this.getFirstMacroReference() == null);
        PDOMLinkage linkage = this.getLinkage();
        HashMap<IASTName, PDOMName> nameCache = new HashMap<IASTName, PDOMName>();
        PDOMName lastName = null;
        PDOMMacroReferenceName lastMacroName = null;
        IASTName[][] iASTNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IASTName[] name = iASTNameArray[n2];
            if (name[0] != null) {
                PDOMName caller = (PDOMName)nameCache.get(name[1]);
                IIndexFragmentName fname = this.createPDOMName(linkage, name[0], caller);
                if (fname instanceof PDOMName) {
                    PDOMName pdomName = (PDOMName)fname;
                    nameCache.put(name[0], pdomName);
                    if (lastName == null) {
                        this.setFirstName(pdomName);
                    } else {
                        lastName.setNextInFile(pdomName);
                    }
                    lastName = pdomName;
                } else if (fname instanceof PDOMMacroReferenceName) {
                    PDOMMacroReferenceName macroName = (PDOMMacroReferenceName)fname;
                    if (lastMacroName == null) {
                        this.setFirstMacroReference(macroName);
                    } else {
                        lastMacroName.setNextInFile(macroName);
                    }
                    lastMacroName = macroName;
                }
            }
            ++n2;
        }
    }

    private IIndexFragmentName createPDOMName(PDOMLinkage linkage, IASTName name, PDOMName caller) {
        IBinding binding = name.getBinding();
        if (binding instanceof IParameter) {
            return null;
        }
        try {
            if (binding instanceof IMacroBinding || binding == null && name.getPropertyInParent() == IASTPreprocessorStatement.MACRO_NAME) {
                return this.createPDOMMacroReferenceName(linkage, name);
            }
            PDOMBinding pdomBinding = linkage.addBinding(name);
            if (pdomBinding != null) {
                PDOMName result = new PDOMName(this.fLinkage, name, this, pdomBinding, caller);
                linkage.onCreateName(this, name, result);
                return result;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    private IIndexFragmentName createPDOMMacroReferenceName(PDOMLinkage linkage, IASTName name) throws CoreException {
        PDOMMacroContainer cont = linkage.getMacroContainer(name.getSimpleID());
        return new PDOMMacroReferenceName(this.fLinkage, name, this, cont);
    }

    public void clear(Collection<IIndexFileLocation> contextsRemoved) throws CoreException {
        ICPPUsingDirective[] directives;
        ICPPUsingDirective[] iCPPUsingDirectiveArray = directives = this.getUsingDirectives();
        int n = directives.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPUsingDirective ud = iCPPUsingDirectiveArray[n2];
            if (ud instanceof IPDOMNode) {
                ((IPDOMNode)((Object)ud)).delete(null);
            }
            ++n2;
        }
        this.setFirstUsingDirectiveRec(0);
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludes();
            if (contextsRemoved != null && include.getPrevInIncludedByRecord() == 0) {
                contextsRemoved.add(include.getIncludesLocation());
            }
            include.delete();
            include = nextInclude;
        }
        this.setFirstInclude(include);
        PDOMLinkage linkage = this.getLinkage();
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            PDOMMacro nextMacro = macro.getNextMacro();
            macro.delete(linkage);
            macro = nextMacro;
        }
        this.setFirstMacro(null);
        ArrayList<PDOMName> names = new ArrayList<PDOMName>();
        PDOMName name2 = this.getFirstName();
        while (name2 != null) {
            names.add(name2);
            linkage.onDeleteName(name2);
            name2 = name2.getNextInFile();
        }
        for (PDOMName name2 : names) {
            name2.delete();
        }
        this.setFirstName(null);
        ArrayList<PDOMMacroReferenceName> mrefs = new ArrayList<PDOMMacroReferenceName>();
        PDOMMacroReferenceName mref = this.getFirstMacroReference();
        while (mref != null) {
            mrefs.add(mref);
            mref = mref.getNextInFile();
        }
        for (PDOMMacroReferenceName m : mrefs) {
            m.delete();
        }
        this.setFirstMacroReference(null);
        this.setTimestamp(-1L);
    }

    public void addIncludesTo(IWritableIndex.IncludeInformation[] includeInfos) throws CoreException {
        assert (this.getFirstInclude() == null);
        PDOMInclude lastInclude = null;
        IWritableIndex.IncludeInformation[] includeInformationArray = includeInfos;
        int n = includeInfos.length;
        int n2 = 0;
        while (n2 < n) {
            IWritableIndex.IncludeInformation info = includeInformationArray[n2];
            PDOMFile targetFile = (PDOMFile)info.fTargetFile;
            PDOMInclude pdomInclude = new PDOMInclude(this.fLinkage, info.fStatement, this, targetFile);
            if (targetFile != null) {
                assert (targetFile.getIndexFragment() instanceof IWritableIndexFragment);
                targetFile.addIncludedBy(pdomInclude, info.fIsContext);
            }
            if (lastInclude == null) {
                this.setFirstInclude(pdomInclude);
            } else {
                lastInclude.setNextInIncludes(pdomInclude);
            }
            lastInclude = pdomInclude;
            ++n2;
        }
    }

    public void addIncludedBy(PDOMInclude include, boolean isContext) throws CoreException {
        PDOMInclude firstIncludedBy = this.getFirstIncludedBy();
        if (firstIncludedBy != null) {
            if (isContext) {
                this.setFirstIncludedBy(include);
                include.setNextInIncludedBy(firstIncludedBy);
                firstIncludedBy.setPrevInIncludedBy(include);
            } else {
                PDOMInclude secondIncludedBy = firstIncludedBy.getNextInIncludedBy();
                if (secondIncludedBy != null) {
                    include.setNextInIncludedBy(secondIncludedBy);
                    secondIncludedBy.setPrevInIncludedBy(include);
                }
                include.setPrevInIncludedBy(firstIncludedBy);
                firstIncludedBy.setNextInIncludedBy(include);
            }
        } else {
            this.setFirstIncludedBy(include);
        }
    }

    @Override
    public IIndexInclude[] getIncludes() throws CoreException {
        ArrayList<PDOMInclude> result = new ArrayList<PDOMInclude>();
        PDOMInclude include = this.getFirstInclude();
        while (include != null) {
            result.add(include);
            include = include.getNextInIncludes();
        }
        return result.toArray(new IIndexInclude[result.size()]);
    }

    @Override
    public IIndexMacro[] getMacros() throws CoreException {
        ArrayList<PDOMMacro> result = new ArrayList<PDOMMacro>();
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            result.add(macro);
            macro = macro.getNextMacro();
        }
        return result.toArray(new IIndexMacro[result.size()]);
    }

    @Override
    public IIndexFragment getIndexFragment() {
        return this.fLinkage.getPDOM();
    }

    @Override
    public IIndexName[] findNames(int offset, int length) throws CoreException {
        int nameOffset;
        ArrayList<IIndexFragmentName> result = new ArrayList<IIndexFragmentName>();
        IIndexFragmentName name = this.getFirstName();
        while (name != null) {
            nameOffset = ((PDOMName)name).getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset + ((PDOMName)name).getNodeLength() <= offset + length) {
                    result.add(name);
                } else if (((PDOMName)name).isReference()) break;
            }
            name = ((PDOMName)name).getNextInFile();
        }
        PDOMMacro macro = this.getFirstMacro();
        while (macro != null) {
            nameOffset = macro.getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset + macro.getNodeLength() > offset + length) break;
                IIndexFragmentName name2 = macro.getDefinition();
                if (name2 != null) {
                    result.add(name2);
                }
            }
            macro = macro.getNextMacro();
        }
        name = this.getFirstMacroReference();
        while (name != null) {
            nameOffset = ((PDOMMacroReferenceName)name).getNodeOffset();
            if (nameOffset >= offset) {
                if (nameOffset + ((PDOMMacroReferenceName)name).getNodeLength() > offset + length) break;
                result.add(name);
            }
            name = ((PDOMMacroReferenceName)name).getNextInFile();
        }
        return result.toArray(new IIndexName[result.size()]);
    }

    public static PDOMFile findFile(PDOMLinkage linkage, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy) throws CoreException {
        String internalRepresentation = strategy.toInternalFormat(location);
        int record = 0;
        if (internalRepresentation != null) {
            Finder finder = new Finder(linkage.getDB(), internalRepresentation, linkage.getLinkageID());
            btree.accept(finder);
            record = finder.getRecord();
        }
        if (record != 0) {
            return new PDOMFile(linkage, record);
        }
        return null;
    }

    public static IIndexFragmentFile[] findFiles(PDOM pdom, BTree btree, IIndexFileLocation location, IIndexLocationConverter strategy) throws CoreException {
        String internalRepresentation = strategy.toInternalFormat(location);
        if (internalRepresentation != null) {
            Finder finder = new Finder(pdom.getDB(), internalRepresentation, -1);
            btree.accept(finder);
            int[] records = finder.getRecords();
            IIndexFragmentFile[] result = new PDOMFile[records.length];
            int i = 0;
            while (i < result.length) {
                result[i] = PDOMFile.recreateFile(pdom, records[i]);
                ++i;
            }
            return result;
        }
        return new IIndexFragmentFile[0];
    }

    public static PDOMFile recreateFile(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int linkageID = db.getInt(record + 20);
        PDOMLinkage linkage = pdom.getLinkage(linkageID);
        if (linkage == null) {
            throw new CoreException(PDOMFile.createStatus("Invalid linkage ID in database"));
        }
        PDOMFile file = new PDOMFile(linkage, record);
        return file;
    }

    @Override
    public IIndexFileLocation getLocation() throws CoreException {
        if (this.location == null) {
            Database db = this.fLinkage.getDB();
            String raw = db.getString(db.getInt(this.record + 16)).getString();
            this.location = this.fLinkage.getPDOM().getLocationConverter().fromInternalFormat(raw);
            if (this.location == null) {
                URI uri;
                try {
                    int idx = raw.lastIndexOf(62);
                    uri = new URI("file", null, raw.substring(idx + 1), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    uri = URI.create("file:/unknown-location");
                }
                this.location = new IndexFileLocation(uri, null);
            }
        }
        return this.location;
    }

    @Override
    public boolean hasContent() throws CoreException {
        return this.getTimestamp() != -1L;
    }

    public void convertIncludersToUnresolved() throws CoreException {
        PDOMInclude include = this.getFirstIncludedBy();
        while (include != null) {
            PDOMInclude nextInclude = include.getNextInIncludedBy();
            include.convertToUnresolved();
            include.setNextInIncludedBy(null);
            include.setPrevInIncludedBy(null);
            include = nextInclude;
        }
        this.setFirstIncludedBy(null);
    }

    public int getLastUsingDirectiveRec() throws CoreException {
        return this.fLinkage.getDB().getInt(this.record + 36);
    }

    public void setFirstUsingDirectiveRec(int rec) throws CoreException {
        this.fLinkage.getDB().putInt(this.record + 36, rec);
    }

    @Override
    public ICPPUsingDirective[] getUsingDirectives() throws CoreException {
        return this.fLinkage.getUsingDirectives(this);
    }

    private static IStatus createStatus(String msg) {
        return new Status(4, "org.eclipse.cdt.core", 4, msg, null);
    }

    public static class Comparator
    implements IBTreeComparator {
        private Database db;

        public Comparator(Database db) {
            this.db = db;
        }

        public int compare(int record1, int record2) throws CoreException {
            IString name2;
            IString name1 = this.db.getString(this.db.getInt(record1 + 16));
            int cmp = name1.compare(name2 = this.db.getString(this.db.getInt(record2 + 16)), true);
            if (cmp == 0) {
                cmp = this.db.getInt(record1 + 20) - this.db.getInt(record2 + 20);
            }
            return cmp;
        }
    }

    private static class Finder
    implements IBTreeVisitor {
        private static final int[] EMPTY = new int[0];
        private final Database db;
        private final String rawKey;
        private int record;
        private int[] records;
        private final int linkageID;

        public Finder(Database db, String internalRepresentation, int linkageID) {
            this.db = db;
            this.rawKey = internalRepresentation;
            this.linkageID = linkageID;
        }

        public int[] getRecords() {
            if (this.records == null) {
                if (this.record == 0) {
                    return EMPTY;
                }
                return new int[]{this.record};
            }
            return this.records;
        }

        public int compare(int record) throws CoreException {
            IString name = this.db.getString(this.db.getInt(record + 16));
            int cmp = name.compare(this.rawKey, true);
            if (cmp == 0 && this.linkageID >= 0) {
                cmp = this.db.getInt(record + 20) - this.linkageID;
            }
            return cmp;
        }

        public boolean visit(int record) throws CoreException {
            if (this.linkageID >= 0) {
                this.record = record;
                return false;
            }
            if (this.record == 0) {
                this.record = record;
            } else if (this.records == null) {
                this.records = new int[]{this.record, record};
            } else {
                int[] cpy = new int[this.records.length + 1];
                System.arraycopy(this.records, 0, cpy, 0, this.records.length);
                cpy[cpy.length - 1] = record;
                this.records = cpy;
            }
            return this.linkageID < 0;
        }

        public int getRecord() {
            return this.record;
        }
    }
}

