/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class CPPFindBinding
extends FindBinding {
    public static PDOMBinding findBinding(BTree btree, PDOMLinkage linkage, char[] name, int c2, int ty2, int localToFileRec) throws CoreException {
        CPPFindBindingVisitor visitor = new CPPFindBindingVisitor(linkage, name, c2, ty2, localToFileRec);
        btree.accept(visitor);
        return visitor.getResult();
    }

    public static PDOMBinding findBinding(PDOMNode node, PDOMLinkage linkage, char[] name, int constant, int sigHash, int localToFileRec) throws CoreException {
        CPPFindBindingVisitor visitor = new CPPFindBindingVisitor(linkage, name, constant, sigHash, localToFileRec);
        try {
            node.accept(visitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        return visitor.getResult();
    }

    public static PDOMBinding findBinding(BTree btree, PDOMLinkage linkage, IBinding binding, int localToFileRec) throws CoreException {
        Integer hash = 0;
        try {
            hash = IndexCPPSignatureUtil.getSignatureHash(binding);
        }
        catch (DOMException dOMException) {}
        if (hash != null) {
            return CPPFindBinding.findBinding(btree, linkage, binding.getNameCharArray(), linkage.getBindingType(binding), (int)hash, localToFileRec);
        }
        return CPPFindBinding.findBinding(btree, linkage, binding.getNameCharArray(), new int[]{linkage.getBindingType(binding)}, localToFileRec);
    }

    public static PDOMBinding findBinding(PDOMNode node, PDOMLinkage linkage, IBinding binding, int localToFileRec) throws CoreException {
        Integer hash = null;
        try {
            hash = IndexCPPSignatureUtil.getSignatureHash(binding);
        }
        catch (DOMException dOMException) {}
        if (hash != null) {
            return CPPFindBinding.findBinding(node, linkage, binding.getNameCharArray(), linkage.getBindingType(binding), (int)hash, localToFileRec);
        }
        return CPPFindBinding.findBinding(node, linkage, binding.getNameCharArray(), new int[]{linkage.getBindingType(binding)}, localToFileRec);
    }

    public static class CPPBindingBTreeComparator
    extends FindBinding.DefaultBindingBTreeComparator {
        public CPPBindingBTreeComparator(PDOMLinkage linkage) {
            super(linkage);
        }

        public int compare(int record1, int record2) throws CoreException {
            int cmp = super.compare(record1, record2);
            if (cmp == 0) {
                PDOMBinding binding1 = this.linkage.getBinding(record1);
                PDOMBinding binding2 = this.linkage.getBinding(record2);
                if (binding1 instanceof IPDOMOverloader && binding2 instanceof IPDOMOverloader) {
                    int ty2;
                    int ty1 = ((IPDOMOverloader)((Object)binding1)).getSignatureHash();
                    cmp = ty1 < (ty2 = ((IPDOMOverloader)((Object)binding2)).getSignatureHash()) ? -1 : (ty1 > ty2 ? 1 : 0);
                }
            }
            return cmp;
        }
    }

    public static class CPPFindBindingVisitor
    extends FindBinding.DefaultFindBindingVisitor {
        private final int fConstant;
        private final int fSigHash;

        public CPPFindBindingVisitor(PDOMLinkage linkage, char[] name, int constant, int hash, int localToFile) {
            super(linkage, name, new int[]{constant}, localToFile);
            this.fConstant = constant;
            this.fSigHash = hash;
        }

        public int compare(int record) throws CoreException {
            int cmp = super.compare(record);
            if (cmp == 0) {
                PDOMBinding binding;
                int c2;
                int c1 = PDOMNode.getNodeType(this.fLinkage.getDB(), record);
                if (c1 == (c2 = this.fConstant) && (binding = this.fLinkage.getBinding(record)) instanceof IPDOMOverloader) {
                    c1 = ((IPDOMOverloader)((Object)binding)).getSignatureHash();
                    c2 = this.fSigHash;
                }
                cmp = c1 < c2 ? -1 : (c1 > c2 ? 1 : 0);
            }
            return cmp;
        }

        public boolean visit(int record) throws CoreException {
            this.fResult = this.fLinkage.getBinding(record);
            return false;
        }

        protected boolean matches(PDOMBinding binding) throws CoreException {
            if (super.matches(binding) && binding instanceof IPDOMOverloader) {
                int ty1 = ((IPDOMOverloader)((Object)binding)).getSignatureHash();
                return this.fSigHash == ty1;
            }
            return false;
        }
    }
}

