/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICSettingObject;

public class CProjectDescriptionDelta
implements ICDescriptionDelta {
    private List<CProjectDescriptionDelta> fChildList = new ArrayList<CProjectDescriptionDelta>();
    private CProjectDescriptionDelta fParent;
    private ICSettingObject fSetting;
    private ICSettingObject fOldSetting;
    private ICSettingObject fNewSetting;
    private int fStatus;
    private int fAddedLanguageEntriesKinds;
    private int fRemovedLanguageEntriesKinds;
    private int fReorderedLanguageEntriesKinds;
    private static final int KIND_MASK = 3;
    private static final int FLAGS_OFFSET = 2;

    public CProjectDescriptionDelta(ICSettingObject newSetting, ICSettingObject oldSetting) {
        this.fNewSetting = newSetting;
        this.fOldSetting = oldSetting;
        if (newSetting != null) {
            this.fSetting = newSetting;
            if (oldSetting != null) {
                this.setDeltaKind(3);
            } else {
                this.setDeltaKind(2);
            }
        } else {
            this.fSetting = oldSetting;
            this.setDeltaKind(1);
        }
    }

    void addChild(CProjectDescriptionDelta child) {
        this.fChildList.add(child);
        child.setParent(this);
    }

    private void setParent(CProjectDescriptionDelta parent) {
        this.fParent = parent;
    }

    public ICDescriptionDelta[] getChildren() {
        return this.fChildList.toArray(new CProjectDescriptionDelta[this.fChildList.size()]);
    }

    public ICSettingObject getOldSetting() {
        return this.fOldSetting;
    }

    public ICSettingObject getSetting() {
        return this.fSetting;
    }

    public int getSettingType() {
        return this.fSetting.getType();
    }

    public ICDescriptionDelta getParent() {
        return this.fParent;
    }

    public boolean isEmpty() {
        return this.fChildList.size() == 0 && this.getDeltaKind() == 3 && this.getChangeFlags() == 0;
    }

    public int getChangeFlags() {
        return (this.fStatus & 0xFFFFFFFC) >> 2;
    }

    void addChangeFlags(int flags) {
        this.setChangeFlags(flags |= this.getChangeFlags());
    }

    void removeChangeFlags(int flags) {
        flags = this.getChangeFlags() & ~flags;
        this.setChangeFlags(flags);
    }

    void setChangeFlags(int flags) {
        this.fStatus = this.fStatus & 3 | flags << 2;
    }

    void setDeltaKind(int kind) {
        this.fStatus = this.fStatus & 0xFFFFFFFC | kind & 3;
    }

    public int getDeltaKind() {
        return this.fStatus & 3;
    }

    public ICSettingObject getNewSetting() {
        return this.fNewSetting;
    }

    void setAddedLanguageEntriesKinds(int kinds) {
        this.fAddedLanguageEntriesKinds = kinds;
        this.checkSettingEntriesChangeFlag();
    }

    public int getAddedEntriesKinds() {
        return this.fAddedLanguageEntriesKinds;
    }

    public int getRemovedEntriesKinds() {
        return this.fRemovedLanguageEntriesKinds;
    }

    public int getReorderedEntriesKinds() {
        return this.fReorderedLanguageEntriesKinds;
    }

    void setRemovedLanguageEntriesKinds(int kinds) {
        this.fRemovedLanguageEntriesKinds = kinds;
        this.checkSettingEntriesChangeFlag();
    }

    void setReorderedLanguageEntriesKinds(int kinds) {
        this.fReorderedLanguageEntriesKinds = kinds;
        this.checkSettingEntriesChangeFlag();
    }

    private void checkSettingEntriesChangeFlag() {
        if (this.fAddedLanguageEntriesKinds != 0 || this.fRemovedLanguageEntriesKinds != 0 || this.fReorderedLanguageEntriesKinds != 0) {
            this.addChangeFlags(512);
        } else {
            this.removeChangeFlags(512);
        }
    }
}

