/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.IPath;

public class CDefaultFolderData
extends CFolderData {
    protected IPath fPath;
    protected List fLanguageDatas = new ArrayList();
    protected String fName;
    protected String fId;
    protected CConfigurationData fCfg;
    private CDataFactory fFactory;
    protected boolean fIsModified;

    public CDefaultFolderData(CConfigurationData cfg, CDataFactory factory) {
        this.fCfg = cfg;
        if (factory == null) {
            factory = new CDataFactory();
        }
        this.fFactory = factory;
    }

    public CDefaultFolderData(String id, IPath path, CConfigurationData cfg, CDataFactory factory) {
        this(cfg, factory);
        this.fId = id;
        this.fName = path.toString();
        this.fPath = path;
    }

    public CDefaultFolderData(String id, IPath path, CFolderData base, CConfigurationData cfg, CDataFactory factory, boolean clone) {
        this(id, path, cfg, factory);
        this.copyDataFrom(base, clone);
    }

    protected void copyDataFrom(CFolderData base, boolean clone) {
        if (base != null) {
            CLanguageData[] lDatas = base.getLanguageDatas();
            int i = 0;
            while (i < lDatas.length) {
                this.fLanguageDatas.add(this.copyLanguageData(lDatas[i], clone));
                ++i;
            }
        }
    }

    protected CLanguageData copyLanguageData(CLanguageData base, boolean clone) {
        return this.fFactory.createLanguageData(this.fCfg, this, base, null, clone);
    }

    public CLanguageData[] getLanguageDatas() {
        return this.fLanguageDatas.toArray(new CLanguageData[this.fLanguageDatas.size()]);
    }

    public IPath getPath() {
        return this.fPath;
    }

    public void setPath(IPath path) {
        if (CDataUtil.objectsEqual(path, this.fPath)) {
            return;
        }
        this.fPath = path;
        this.setModified(true);
    }

    public String getName() {
        return this.fName;
    }

    public String getId() {
        return this.fId;
    }

    public boolean isValid() {
        return this.getId() != null;
    }

    public CLanguageData createLanguageDataForContentTypes(String languageId, String[] typesIds) {
        throw new UnsupportedOperationException();
    }

    public CLanguageData createLanguageDataForExtensions(String languageId, String[] extensions) {
        throw new UnsupportedOperationException();
    }

    public boolean isModified() {
        if (this.fIsModified) {
            return true;
        }
        CLanguageData[] lDatas = this.getLanguageDatas();
        int i = 0;
        while (i < lDatas.length) {
            if (this.fFactory.isModified(lDatas[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setModified(boolean modified) {
        this.fIsModified = modified;
        if (!modified) {
            CLanguageData[] lDatas = this.getLanguageDatas();
            int i = 0;
            while (i < lDatas.length) {
                this.fFactory.setModified(lDatas[i], false);
                ++i;
            }
        }
    }

    public boolean hasCustomSettings() {
        return false;
    }
}

