/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.AbstractEntryStorage;
import org.eclipse.cdt.core.settings.model.util.SettingsSet;

public abstract class UserAndDiscoveredEntryStorage
extends AbstractEntryStorage {
    public UserAndDiscoveredEntryStorage(int kind) {
        super(kind);
    }

    protected SettingsSet createEmptySettings() {
        SettingsSet settings = new SettingsSet(2);
        SettingsSet.SettingLevel[] levels = settings.getLevels();
        boolean override = this.canDisableDiscoveredEntries();
        int readOnlyFlag = override ? 0 : 2;
        levels[0].setFlagsToClear(3);
        levels[0].setFlagsToSet(0);
        levels[0].setReadOnly(false);
        levels[0].setOverrideSupported(false);
        levels[1].setFlagsToClear(0);
        levels[1].setFlagsToSet(readOnlyFlag | 1 | 0x10);
        levels[1].setReadOnly(true);
        levels[1].setOverrideSupported(override);
        return settings;
    }

    protected void obtainEntriesFromLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                this.setUserEntries(level != null ? level.getEntries() : null);
                break;
            }
            case 1: {
                if (level != null) {
                    Set<String> set = level.getOverrideSet();
                    this.setDisabledDiscoveredNames(set);
                    break;
                }
                this.setDisabledDiscoveredNames(null);
            }
        }
    }

    protected void putEntriesToLevel(int levelNum, SettingsSet.SettingLevel level) {
        switch (levelNum) {
            case 0: {
                level.addEntries(this.getUserEntries());
                break;
            }
            case 1: {
                HashSet set = new HashSet();
                ICLanguageSettingEntry[] entries = this.getDiscoveredEntries(set);
                level.addEntries(entries);
                if (set.size() == 0) break;
                level.fOverrideSet = set;
            }
        }
    }

    protected boolean canDisableDiscoveredEntries() {
        return false;
    }

    protected abstract void setUserEntries(ICLanguageSettingEntry[] var1);

    protected abstract ICLanguageSettingEntry[] getUserEntries();

    protected abstract void setDisabledDiscoveredNames(Set var1);

    protected abstract ICLanguageSettingEntry[] getDiscoveredEntries(Set var1);
}

