/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameter
extends PDOMNamedNode
implements ICPPParameter,
IPDOMBinding {
    private static final int NEXT_PARAM = 12;
    private static final int TYPE = 16;
    private static final int ANNOTATIONS = 20;
    private static final int FLAGS = 21;
    protected static final int RECORD_SIZE = 22;
    private static final byte FLAG_DEFAULT_VALUE = 1;

    public PDOMCPPParameter(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCPPParameter(PDOMLinkage linkage, PDOMNode parent, IParameter param, long typeRecord) throws CoreException {
        super(linkage, parent, param.getNameCharArray());
        Database db = this.getDB();
        db.putRecPtr(this.record + 12L, 0L);
        byte flags = this.encodeFlags(param);
        db.putByte(this.record + 21L, flags);
        db.putRecPtr(this.record + 16L, typeRecord);
        try {
            byte annotations = PDOMCPPAnnotation.encodeAnnotation(param);
            db.putByte(this.record + 20L, annotations);
        }
        catch (DOMException dOMException) {}
    }

    private byte encodeFlags(IParameter param) {
        byte flags = 0;
        if (param instanceof ICPPParameter && ((ICPPParameter)param).hasDefaultValue()) {
            flags = (byte)(flags | 1);
        }
        return flags;
    }

    protected int getRecordSize() {
        return 22;
    }

    public int getNodeType() {
        return 14;
    }

    public void setNextParameter(PDOMCPPParameter nextParam) throws CoreException {
        long rec = nextParam != null ? nextParam.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 12L, rec);
    }

    public PDOMCPPParameter getNextParameter() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 12L);
        return rec != 0L ? new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), rec) : null;
    }

    public String[] getQualifiedName() {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IType getType() {
        try {
            PDOMNode node = ((PDOMLinkage)this.getLinkage()).getNode(this.getDB().getRecPtr(this.record + 16L));
            return node instanceof IType ? (IType)((Object)node) : null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        byte flag = 1;
        return this.hasFlag(flag, true, 20);
    }

    public boolean isExtern() throws DOMException {
        return false;
    }

    public boolean isExternC() {
        return false;
    }

    public boolean isRegister() throws DOMException {
        byte flag = 8;
        return this.hasFlag(flag, true, 20);
    }

    public boolean isStatic() throws DOMException {
        return false;
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public IIndexScope getScope() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    public boolean hasDefaultValue() {
        return this.hasFlag((byte)1, false, 21);
    }

    private boolean hasFlag(byte flag, boolean defValue, int offset) {
        try {
            byte myflags = this.getDB().getByte(this.record + (long)offset);
            return (myflags & flag) == flag;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return defValue;
        }
    }

    public IIndexFragment getFragment() {
        return this.getPDOM();
    }

    public boolean hasDefinition() throws CoreException {
        return true;
    }

    public boolean hasDeclaration() throws CoreException {
        return true;
    }

    public int compareTo(Object arg0) {
        throw new PDOMNotImplementedError();
    }

    public int getBindingConstant() {
        return this.getNodeType();
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        PDOMCPPParameter next = this.getNextParameter();
        if (next != null) {
            next.delete(linkage);
        }
        super.delete(linkage);
    }

    public boolean isFileLocal() throws CoreException {
        return false;
    }

    public IIndexFile getLocalToFile() throws CoreException {
        return null;
    }

    public IValue getInitialValue() {
        return null;
    }
}

