/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingChangeEvent;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainerChangeInfo;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsDeltaProcessor;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettinsDeltaCalculator;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CRefSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CSettingsRefInfo;
import org.eclipse.cdt.internal.core.settings.model.CfgExportSettingContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ExtensionContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ICExternalSettingsListener;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class CExternalSettingsManager
implements ICExternalSettingsListener,
ICProjectDescriptionListener {
    private static final int OP_CHANGED = 1;
    private static final int OP_ADDED = 2;
    private static final int OP_REMOVED = 3;
    private static final QualifiedName EXTERNAL_SETTING_PROPERTY = new QualifiedName("org.eclipse.cdt.core", "externalSettings");
    private static final String EXTERNAL_SETTING_STORAGE_ID = "org.eclipse.cdt.core.externalSettings";
    private Map fFactoryMap = new HashMap();
    private static CExternalSettingsManager fInstance;

    private CExternalSettingsManager() {
    }

    public void startup() {
        CProjectDescriptionManager.getInstance().addCProjectDescriptionListener(this, 17);
    }

    public void shutdown() {
        for (FactoryDescriptor dr : this.fFactoryMap.values()) {
            dr.shutdown();
        }
        this.fFactoryMap.clear();
        CProjectDescriptionManager.getInstance().removeCProjectDescriptionListener(this);
    }

    public static CExternalSettingsManager getInstance() {
        if (fInstance == null) {
            fInstance = new CExternalSettingsManager();
        }
        return fInstance;
    }

    private FactoryDescriptor getFactoryDescriptor(String id) {
        FactoryDescriptor dr = (FactoryDescriptor)this.fFactoryMap.get(id);
        if (dr == null) {
            dr = new FactoryDescriptor(id);
            this.fFactoryMap.put(id, dr);
        }
        return dr;
    }

    CExternalSettingContainerFactory getFactory(String id) {
        FactoryDescriptor dr = this.getFactoryDescriptor(id);
        return dr.getFactory();
    }

    private ContainerDescriptor createDescriptor(String factoryId, String containerId, IProject project, ICConfigurationDescription cfgDes) {
        FactoryDescriptor dr = this.getFactoryDescriptor(factoryId);
        return new ContainerDescriptor(dr, containerId, project, cfgDes);
    }

    public void settingsChanged(IProject project, String cfgId, CExternalSettingChangeEvent event) {
        ProjDesCfgList[] lists = null;
        CExternalSettingsContainerChangeInfo[] infos = event.getChangeInfos();
        int i = 0;
        while (i < infos.length) {
            CExternalSettingsContainerChangeInfo info = infos[i];
            switch (info.getEventType()) {
                case 1: {
                    int flags = info.getChangeFlags();
                    if ((flags & 2) == 0) break;
                    if (lists == null) {
                        lists = this.createCfgListsForEvent(project, cfgId);
                    }
                    this.containerContentsChanged(lists, info.getContainerInfo(), null);
                }
            }
            ++i;
        }
        if (lists != null) {
            this.applyLists(lists);
        }
    }

    private void applyLists(ProjDesCfgList[] lists) {
        final List list = this.getModifiedProjDesList(lists);
        if (list.size() != 0) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    int i = 0;
                    while (i < list.size()) {
                        ICProjectDescription des = (ICProjectDescription)list.get(i);
                        CProjectDescriptionManager.getInstance().setProjectDescription(des.getProject(), des, false, monitor);
                        ++i;
                    }
                }
            };
            CProjectDescriptionManager.getInstance();
            CProjectDescriptionManager.runWspModification(r, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private List getModifiedProjDesList(ProjDesCfgList[] lists) {
        ArrayList<ICProjectDescription> list = new ArrayList<ICProjectDescription>();
        int i = 0;
        while (i < lists.length) {
            if (lists[i].isWritable()) {
                list.add(lists[i].fProjDes);
            }
            ++i;
        }
        return list;
    }

    private void containerContentsChanged(ProjDesCfgList[] lists, CContainerRef ref, DeltaInfo deltaInfo) {
        int i = 0;
        while (i < lists.length) {
            this.containerContentsChanged(lists[i], null, ref, deltaInfo);
            ++i;
        }
    }

    private ProjDesCfgList[] createCfgListsForEvent(IProject project, String cfgId) {
        ProjDesCfgList l;
        ProjDesCfgList[] lists = project != null ? ((l = this.createCfgList(project, cfgId)) != null ? new ProjDesCfgList[]{l} : new ProjDesCfgList[]{}) : this.createCfgLists();
        return lists;
    }

    private ProjDesCfgList[] createCfgLists() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<ProjDesCfgList> list = new ArrayList<ProjDesCfgList>();
        int i = 0;
        while (i < projects.length) {
            ProjDesCfgList l = this.createCfgList(projects[i], (Set)null);
            if (l != null) {
                list.add(l);
            }
            ++i;
        }
        return list.toArray(new ProjDesCfgList[list.size()]);
    }

    private ProjDesCfgList createCfgList(IProject project, String cfgId) {
        HashSet<String> set = null;
        if (cfgId != null) {
            set = new HashSet<String>();
            set.add(cfgId);
        }
        return this.createCfgList(project, set);
    }

    private ProjDesCfgList createCfgList(IProject project, Set cfgIdSet) {
        ICProjectDescription des = CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
        if (des == null) {
            return null;
        }
        return new ProjDesCfgList(des, cfgIdSet);
    }

    private void containerContentsChanged(ProjDesCfgList list, String[] cfgIds, CContainerRef ref, DeltaInfo deltaInfo) {
        if (cfgIds != null && cfgIds.length != 0) {
            int i = 0;
            while (i < cfgIds.length) {
                int num = list.getNumForId(cfgIds[i]);
                if (num >= 0) {
                    CfgListCfgContainer cr = new CfgListCfgContainer(list, num);
                    this.containerContentsChanged(cr, ref, deltaInfo);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < list.size()) {
                CfgListCfgContainer cr = new CfgListCfgContainer(list, i);
                this.containerContentsChanged(cr, ref, deltaInfo);
                ++i;
            }
        }
    }

    private boolean containerContentsChanged(ICfgContainer cr, CContainerRef ref, DeltaInfo deltaInfo) {
        return this.processContainerChange(1, cr, ref, deltaInfo);
    }

    private boolean processContainerChange(int op, ICfgContainer cr, CContainerRef crInfo, DeltaInfo deltaInfo) {
        return this.processContainerChange(op, cr, new CfgContainerRefInfoContainer(cr), crInfo, deltaInfo);
    }

    private boolean processContainerChange(int op, ICfgContainer cr, ICRefInfoContainer riContainer, CContainerRef crInfo, DeltaInfo deltaInfo) {
        ICConfigurationDescription cfg = cr.getConfguration(false);
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.checkExternalSettingsChange(op, cfg.getProjectDescription().getProject(), cfg, riContainer, crInfo);
        if (deltas != null) {
            return this.applyDeltas(cr, deltas);
        }
        return false;
    }

    private boolean applyDeltas(ICfgContainer cr, CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas) {
        return CExternalSettingsDeltaProcessor.applyDelta(cr.getConfguration(true), deltas);
    }

    private CSettingsRefInfo getRefInfo(ICConfigurationDescription cfg, boolean write) {
        CSettingsRefInfo ri;
        if (write && cfg.isReadOnly()) {
            throw new IllegalArgumentException(SettingsModelMessages.getString("CExternalSettingsManager.3"));
        }
        RefInfoContainer cr = (RefInfoContainer)cfg.getSessionProperty(EXTERNAL_SETTING_PROPERTY);
        boolean setCr = false;
        if (cr == null) {
            ri = this.load(cfg);
            if (ri == null) {
                ri = new CSettingsRefInfo();
            }
            setCr = true;
        } else if (write && cr.fInstanceId != cfg.hashCode()) {
            ri = new CSettingsRefInfo(cr.fRefInfo);
            setCr = true;
        } else {
            ri = cr.fRefInfo;
            setCr = false;
        }
        if (setCr) {
            cr = new RefInfoContainer(ri, cfg.hashCode());
            cfg.setSessionProperty(EXTERNAL_SETTING_PROPERTY, cr);
        }
        return ri;
    }

    private CSettingsRefInfo load(ICConfigurationDescription cfg) {
        try {
            ICStorageElement el = cfg.getStorage(EXTERNAL_SETTING_STORAGE_ID, false);
            if (el != null) {
                CSettingsRefInfo ri = new CSettingsRefInfo(el);
                return ri;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        switch (event.getEventType()) {
            case 16: {
                this.checkStore(event.getNewCProjectDescription());
                break;
            }
            case 1: {
                final SettingsUpdateStatus status = this.update(event.getNewCProjectDescription());
                if (!status.isChanged()) break;
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        ICProjectDescription des = status.getCProjectDescription();
                        CProjectDescriptionManager.getInstance().setProjectDescription(des.getProject(), des);
                    }
                };
                CProjectDescriptionManager.getInstance();
                CProjectDescriptionManager.runWspModification(r, null);
            }
        }
    }

    private void checkStore(ICProjectDescription des) {
        if (des == null) {
            return;
        }
        ICConfigurationDescription[] cfgs = des.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            this.checkStore(cfgs[i]);
            ++i;
        }
    }

    private void checkStore(ICConfigurationDescription cfg) {
        RefInfoContainer cr = (RefInfoContainer)cfg.getSessionProperty(EXTERNAL_SETTING_PROPERTY);
        if (cr != null) {
            this.store(cfg, cr.fRefInfo);
        }
    }

    private void store(ICConfigurationDescription cfg, CSettingsRefInfo ri) {
        try {
            ICStorageElement el = cfg.getStorage(EXTERNAL_SETTING_STORAGE_ID, true);
            el.clear();
            ri.serialize(el);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    public void containerContentsChanged(ICConfigurationDescription cfg, CContainerRef cr) {
        CfgContainer ccr = new CfgContainer(cfg);
        this.containerContentsChanged(ccr, cr, null);
    }

    public void addContainer(ICConfigurationDescription cfg, CContainerRef cr) {
        CfgContainer ccr = new CfgContainer(cfg);
        this.processContainerChange(2, ccr, cr, null);
    }

    public void removeContainer(ICConfigurationDescription cfg, CContainerRef cr) {
        CfgContainer ccr = new CfgContainer(cfg);
        this.processContainerChange(3, ccr, cr, null);
    }

    public CContainerRef[] getReferences(ICConfigurationDescription cfg, String factoryId) {
        CSettingsRefInfo info = this.getRefInfo(cfg, false);
        return info.getReferences(factoryId);
    }

    public SettingsUpdateStatus update(ICProjectDescription des) {
        ProjDesCfgList list = new ProjDesCfgList(des, null);
        boolean changed = false;
        int i = 0;
        while (i < list.size()) {
            CfgListCfgContainer cfgCr = new CfgListCfgContainer(list, i);
            CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cfgCr);
            CContainerRef[] refs = ric.getRefInfo(false).getReferences();
            int k = 0;
            while (k < refs.length) {
                if (this.containerContentsChanged(cfgCr, refs[k], null)) {
                    changed = true;
                }
                ++k;
            }
            ++i;
        }
        return new SettingsUpdateStatus(list.fProjDes, changed);
    }

    private CExternalSettinsDeltaCalculator.ExtSettingsDelta[] checkExternalSettingsChange(int op, IProject proj, ICConfigurationDescription cfgDes, ICRefInfoContainer riContainer, CContainerRef cr) {
        HolderContainer hCr = new HolderContainer(riContainer, cr);
        CRefSettingsHolder holder = hCr.getHolder(false);
        if (holder == null && op == 2) {
            holder = new CRefSettingsHolder(cr);
            hCr.setHolder(holder);
        }
        if (holder == null) {
            return null;
        }
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.reconsile(proj, cfgDes, op != 3, hCr, cr);
        if (op == 3) {
            hCr.removeHolder();
        }
        return deltas;
    }

    private CExternalSettinsDeltaCalculator.ExtSettingsDelta[] reconsile(IProject proj, ICConfigurationDescription cfgDes, boolean add, HolderContainer hCr, CContainerRef cr) {
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas;
        CExternalSetting[] newSettings = null;
        CExternalSetting[] oldSettings = hCr.getHolder(false).getExternalSettings();
        if (add) {
            ContainerDescriptor cdr = this.createDescriptor(cr.getFactoryId(), cr.getContainerId(), proj, cfgDes);
            newSettings = cdr.getExternalSettings();
        }
        if ((deltas = this.getDeltaCalculator().getSettingChange(newSettings, oldSettings)) != null) {
            CRefSettingsHolder holder = hCr.getHolder(true);
            holder.setExternallSettings(newSettings);
            holder.setReconsiled(true);
        }
        return deltas;
    }

    private CExternalSettinsDeltaCalculator getDeltaCalculator() {
        return CExternalSettinsDeltaCalculator.getInstance();
    }

    public void restoreSourceEntryDefaults(ICConfigurationDescription cfg) {
        CfgContainer cr = new CfgContainer(cfg);
        CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cr);
        CExternalSetting[] settings = ric.getRefInfo(false).createExternalSettings();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.getDeltaCalculator().getSettingChange(settings, null);
        if (deltas != null) {
            CExternalSettingsDeltaProcessor.applySourceEntriesChange(cfg, deltas);
        }
    }

    public void restoreOutputEntryDefaults(ICConfigurationDescription cfg) {
        CfgContainer cr = new CfgContainer(cfg);
        CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cr);
        CExternalSetting[] settings = ric.getRefInfo(false).createExternalSettings();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.getDeltaCalculator().getSettingChange(settings, null);
        if (deltas != null) {
            CExternalSettingsDeltaProcessor.applyOutputEntriesChange(cfg, deltas);
        }
    }

    public void restoreDefaults(ICLanguageSetting ls, int entryKinds) {
        ICConfigurationDescription cfg = ls.getConfiguration();
        CfgContainer cr = new CfgContainer(cfg);
        CfgContainerRefInfoContainer ric = new CfgContainerRefInfoContainer(cr);
        CExternalSetting[] settings = ric.getRefInfo(false).createExternalSettings();
        CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas = this.getDeltaCalculator().getSettingChange(settings, null);
        if (deltas != null) {
            CExternalSettingsDeltaProcessor.applyDelta(ls, deltas, entryKinds);
        }
    }

    public static final class CContainerRef {
        private String fFactoryId;
        private String fContainerId;

        public CContainerRef(String factoryId, String containerId) {
            this.fFactoryId = factoryId;
            this.fContainerId = containerId;
        }

        public String getFactoryId() {
            return this.fFactoryId;
        }

        public String getContainerId() {
            return this.fContainerId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CContainerRef)) {
                return false;
            }
            CContainerRef other = (CContainerRef)obj;
            if (!this.fContainerId.equals(other.fContainerId)) {
                return false;
            }
            return this.fFactoryId.equals(other.fFactoryId);
        }

        public int hashCode() {
            return this.fFactoryId.hashCode() + this.fContainerId.hashCode();
        }

        public String toString() {
            return String.valueOf(this.fFactoryId.toString()) + " : " + this.fContainerId.toString();
        }
    }

    private class CfgContainer
    implements ICfgContainer {
        private ICConfigurationDescription fCfgDes;

        CfgContainer(ICConfigurationDescription cfgDes) {
            this.fCfgDes = cfgDes;
        }

        public ICConfigurationDescription getConfguration(boolean write) {
            return this.fCfgDes;
        }
    }

    private class CfgContainerRefInfoContainer
    implements ICRefInfoContainer {
        private ICfgContainer fCfgContainer;
        private CSettingsRefInfo fRefInfo;
        private boolean fWriteWasRequested;

        CfgContainerRefInfoContainer(ICfgContainer container) {
            this.fCfgContainer = container;
        }

        public CSettingsRefInfo getRefInfo(boolean write) {
            if (this.fRefInfo == null || write && !this.fWriteWasRequested) {
                ICConfigurationDescription cfg = this.fCfgContainer.getConfguration(write);
                this.fRefInfo = CExternalSettingsManager.this.getRefInfo(cfg, write);
                this.fWriteWasRequested |= write;
            }
            return this.fRefInfo;
        }
    }

    private static class CfgListCfgContainer
    implements ICfgContainer {
        private ICfgList fList;
        private int fNum;

        CfgListCfgContainer(ICfgList list, int num) {
            this.fList = list;
            this.fNum = num;
        }

        public ICConfigurationDescription getConfguration(boolean write) {
            return this.fList.get(this.fNum, write);
        }
    }

    private static class ContainerDescriptor {
        private FactoryDescriptor fFactoryDr;
        private CExternalSettingsHolder fHolder;
        private CExternalSettingsContainer fContainer;

        private ContainerDescriptor(FactoryDescriptor factoryDr, String containerId, IProject project, ICConfigurationDescription cfgDes) {
            this.fFactoryDr = factoryDr;
            try {
                this.fContainer = this.fFactoryDr.getFactory().createContainer(containerId, project, cfgDes);
            }
            catch (CoreException coreException) {}
            if (this.fContainer == null) {
                this.fContainer = NullContainer.INSTANCE;
            }
        }

        public CExternalSetting[] getExternalSettings() {
            if (this.fHolder == null) {
                this.fHolder = new CExternalSettingsHolder();
                this.fHolder.setExternallSettings(this.fContainer.getExternalSettings());
            }
            return this.fHolder.getExternalSettings();
        }
    }

    private static class DeltaInfo {
        private boolean fCalculated;
        private CExternalSettinsDeltaCalculator.ExtSettingsDelta[] fDeltas;

        private DeltaInfo() {
        }

        void setDelta(CExternalSettinsDeltaCalculator.ExtSettingsDelta[] deltas) {
            this.fDeltas = deltas;
            this.fCalculated = true;
        }
    }

    private class FactoryDescriptor {
        private CExternalSettingContainerFactory fFactory;
        private String fId;

        private FactoryDescriptor(String id) {
            this.fId = id;
        }

        private CExternalSettingContainerFactory getFactory() {
            if (this.fFactory == null) {
                this.fFactory = this.createFactory(this.fId);
                this.fFactory.startup();
                this.fFactory.addListener(CExternalSettingsManager.this);
            }
            return this.fFactory;
        }

        private CExternalSettingContainerFactory createFactory(String id) {
            if (id.equals("org.eclipse.cdt.core.cfg.export.settings.sipplier")) {
                return CfgExportSettingContainerFactory.getInstance();
            }
            if (id.equals("org.eclipse.cdt.core.extension.container.factory")) {
                return ExtensionContainerFactory.getInstance();
            }
            return NullFactory.INSTANCE;
        }

        public String getId() {
            return this.fId;
        }

        public void shutdown() {
            if (this.fFactory != null) {
                this.fFactory.removeListener(CExternalSettingsManager.this);
                this.fFactory.shutdown();
                this.fFactory = null;
            }
        }
    }

    private class HolderContainer {
        private ICRefInfoContainer fRIContainer;
        private CRefSettingsHolder fHolder;
        private boolean fWriteWasRequested;
        private CContainerRef fCRef;

        HolderContainer(ICRefInfoContainer cr, CContainerRef cref) {
            this.fRIContainer = cr;
            this.fCRef = cref;
        }

        CRefSettingsHolder getHolder(boolean write) {
            if (this.fHolder == null || write && !this.fWriteWasRequested) {
                CSettingsRefInfo ri = this.fRIContainer.getRefInfo(write);
                this.fHolder = ri.get(this.fCRef);
                this.fWriteWasRequested |= write;
            }
            return this.fHolder;
        }

        void setHolder(CRefSettingsHolder holder) {
            this.fRIContainer.getRefInfo(true).put(holder);
            this.fWriteWasRequested = true;
            this.fHolder = holder;
        }

        void removeHolder() {
            this.fWriteWasRequested = true;
            this.fHolder = null;
            this.fRIContainer.getRefInfo(true).remove(this.fCRef);
        }
    }

    private static interface ICRefInfoContainer {
        public CSettingsRefInfo getRefInfo(boolean var1);
    }

    private static interface ICfgContainer {
        public ICConfigurationDescription getConfguration(boolean var1);
    }

    private static interface ICfgList {
        public ICConfigurationDescription get(int var1, boolean var2);

        public int size();
    }

    static class NullContainer
    extends CExternalSettingsContainer {
        static final NullContainer INSTANCE = new NullContainer();

        NullContainer() {
        }

        public CExternalSetting[] getExternalSettings() {
            return new CExternalSetting[0];
        }
    }

    private static class NullFactory
    extends CExternalSettingContainerFactory {
        static NullFactory INSTANCE = new NullFactory();

        private NullFactory() {
        }

        public void addListener(ICExternalSettingsListener listener) {
        }

        public CExternalSettingsContainer createContainer(String id, IProject project, ICConfigurationDescription cfgDes) throws CoreException {
            return NullContainer.INSTANCE;
        }

        public String[] getSupplierIds() {
            return null;
        }

        public void removeListener(ICExternalSettingsListener listener) {
        }

        public void shutdown() {
        }

        public void startup() {
        }
    }

    private static class ProjDesCfgList
    implements ICfgList {
        private ICProjectDescription fProjDes;
        private List fCfgList = new ArrayList();

        public ProjDesCfgList(ICProjectDescription des, Set idSet) {
            this.fProjDes = des;
            ICConfigurationDescription[] cfgs = des.getConfigurations();
            int i = 0;
            while (i < cfgs.length) {
                if (idSet == null || idSet.contains(cfgs[i].getId())) {
                    this.fCfgList.add(cfgs[i]);
                }
                ++i;
            }
        }

        public boolean isWritable() {
            return !this.fProjDes.isReadOnly();
        }

        public ICConfigurationDescription get(int num, boolean write) {
            if (write && this.fProjDes.isReadOnly()) {
                this.makeWritable();
            }
            return (ICConfigurationDescription)this.fCfgList.get(num);
        }

        private void makeWritable() {
            ICProjectDescription writeDes;
            this.fProjDes = writeDes = CProjectDescriptionManager.getInstance().getProjectDescription(this.fProjDes.getProject());
            int i = 0;
            while (i < this.fCfgList.size()) {
                ICConfigurationDescription cfg = (ICConfigurationDescription)this.fCfgList.get(i);
                if ((cfg = writeDes.getConfigurationById(cfg.getId())) != null) {
                    this.fCfgList.set(i, cfg);
                } else {
                    this.fCfgList.remove(i);
                }
                ++i;
            }
        }

        public int getNumForId(String id) {
            int i = 0;
            while (i < this.fCfgList.size()) {
                ICConfigurationDescription cfg = (ICConfigurationDescription)this.fCfgList.get(i);
                if (id.equals(cfg.getId())) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public ICConfigurationDescription getConfigurationById(String id, boolean write) {
            ICConfigurationDescription cfg = this.fProjDes.getConfigurationById(id);
            if (cfg == null) {
                return null;
            }
            if (write && this.fProjDes.isReadOnly()) {
                this.makeWritable();
                cfg = this.fProjDes.getConfigurationById(id);
            }
            return cfg;
        }

        public int size() {
            return this.fCfgList.size();
        }
    }

    private static class RefInfoContainer {
        CSettingsRefInfo fRefInfo;
        int fInstanceId;

        RefInfoContainer(CSettingsRefInfo ri, int id) {
            this.fRefInfo = ri;
            this.fInstanceId = id;
        }
    }

    public static class SettingsUpdateStatus {
        ICProjectDescription fDes;
        boolean fIsChanged;

        SettingsUpdateStatus(ICProjectDescription des, boolean isChanged) {
            this.fDes = des;
            this.fIsChanged = isChanged;
        }

        public ICProjectDescription getCProjectDescription() {
            return this.fDes;
        }

        public boolean isChanged() {
            return this.fIsChanged;
        }
    }
}

