/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.transport;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;

public class BufferedMemoryWriter {
    private IMemoryBlockExtension fBlock;
    private byte[] fBuffer;
    private int fBufferPosition = 0;
    private BigInteger fBufferStart = null;

    public BufferedMemoryWriter(IMemoryBlockExtension block, int bufferLength) {
        this.fBlock = block;
        this.fBuffer = new byte[bufferLength];
    }

    public void write(BigInteger address, byte[] data) throws DebugException {
        while (data.length > 0) {
            if (this.fBufferStart == null) {
                this.fBufferStart = address;
                int length = data.length <= this.fBuffer.length ? data.length : this.fBuffer.length;
                System.arraycopy(data, 0, this.fBuffer, 0, length);
                this.fBufferPosition = length;
                byte[] dataRemainder = new byte[data.length - length];
                System.arraycopy(data, length, dataRemainder, 0, data.length - length);
                data = dataRemainder;
                address = this.fBufferStart.add(BigInteger.valueOf(length));
            } else if (this.fBufferStart.add(BigInteger.valueOf(this.fBufferPosition)).compareTo(address) != 0) {
                this.flush();
            } else {
                int availableBufferLength = this.fBuffer.length - this.fBufferPosition;
                int length = data.length <= this.fBuffer.length - availableBufferLength ? data.length : this.fBuffer.length - availableBufferLength;
                System.arraycopy(data, 0, this.fBuffer, this.fBufferPosition, length);
                this.fBufferPosition += length;
                byte[] dataRemainder = new byte[data.length - length];
                System.arraycopy(data, length, dataRemainder, 0, data.length - length);
                data = dataRemainder;
                address = this.fBufferStart.add(BigInteger.valueOf(length));
            }
            if (this.fBufferPosition != this.fBuffer.length) continue;
            this.flush();
        }
    }

    public void flush() throws DebugException {
        if (this.fBufferStart != null) {
            byte[] data = new byte[this.fBufferPosition];
            System.arraycopy(this.fBuffer, 0, data, 0, this.fBufferPosition);
            this.fBlock.setValue(this.fBufferStart, data);
            this.fBufferStart = null;
        }
    }
}

