/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.testplugin;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.ZipFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.testplugin.CTestPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

public class CProjectHelper {
    public static ICProject createCProjectWithImport(String projectName, IPath zipFile) throws CoreException, InvocationTargetException, IOException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        File zip = CTestPlugin.getDefault().getFileInPlugin(zipFile);
        CProjectHelper.importFilesFromZip(new ZipFile(zip), project.getFullPath(), null);
        if (!project.hasNature("org.eclipse.cdt.core.cnature")) {
            CProjectHelper.addNatureToProject(project, "org.eclipse.cdt.core.cnature", null);
        }
        ICProject cproject = CCorePlugin.getDefault().getCoreModel().create(project);
        ICDescriptorOperation op = new ICDescriptorOperation(){

            public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                descriptor.remove("org.eclipse.cdt.core.BinaryParser");
                String os = System.getProperty("os.name");
                boolean pe = os.toLowerCase().indexOf("windows") != -1;
                descriptor.create("org.eclipse.cdt.core.BinaryParser", pe ? "org.eclipse.cdt.core.PE" : "org.eclipse.cdt.core.ELF");
            }
        };
        CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(project, op, null);
        return cproject;
    }

    public static ICProject createCProject(String projectName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            project.create(null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        if (!project.hasNature("org.eclipse.cdt.core.cnature")) {
            CProjectHelper.addNatureToProject(project, "org.eclipse.cdt.core.cnature", null);
        }
        ICProject cproject = CCorePlugin.getDefault().getCoreModel().create(project);
        return cproject;
    }

    public static void delete(ICProject cproject) throws CoreException {
        cproject.getProject().delete(true, true, null);
    }

    public static IArchive findArchive(ICProject testProject, String name) throws CModelException {
        IArchiveContainer archCont = testProject.getArchiveContainer();
        IArchive[] myArchives = archCont.getArchives();
        if (myArchives.length < 1) {
            return null;
        }
        int x = 0;
        while (x < myArchives.length) {
            if (myArchives[x].getElementName().equals(name)) {
                return myArchives[x];
            }
            ++x;
        }
        return null;
    }

    public static IBinary findBinary(ICProject testProject, String name) throws CModelException {
        IBinaryContainer binCont = testProject.getBinaryContainer();
        IBinary[] myBinaries = binCont.getBinaries();
        if (myBinaries.length < 1) {
            return null;
        }
        int x = 0;
        while (x < myBinaries.length) {
            if (myBinaries[x].getElementName().equals(name)) {
                return myBinaries[x];
            }
            ++x;
        }
        return null;
    }

    public static IBinary findObject(ICProject testProject, String name) throws CModelException {
        ICElement[] myElements = testProject.getChildren();
        if (myElements.length < 1) {
            return null;
        }
        int x = 0;
        while (x < myElements.length) {
            if (myElements[x].getElementName().equals(name) && myElements[x] instanceof IBinary) {
                return (IBinary)myElements[x];
            }
            ++x;
        }
        return null;
    }

    public static ITranslationUnit findTranslationUnit(ICProject testProject, String name) throws CModelException {
        ICElement[] myElements = testProject.getChildren();
        if (myElements.length < 1) {
            return null;
        }
        int x = 0;
        while (x < myElements.length) {
            if (myElements[x].getElementName().equals(name) && myElements[x] instanceof ITranslationUnit) {
                return (ITranslationUnit)myElements[x];
            }
            ++x;
        }
        return null;
    }

    public static ICElement findElement(ICProject testProject, String name) throws CModelException {
        ICElement[] myElements = testProject.getChildren();
        if (myElements.length < 1) {
            return null;
        }
        int x = 0;
        while (x < myElements.length) {
            if (myElements[x].getElementName().equals(name)) {
                return myElements[x];
            }
            ++x;
        }
        return null;
    }

    private static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    private static void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        try {
            ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, (IOverwriteQuery)new ImportOverwriteQuery());
            op.run(monitor);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class ImportOverwriteQuery
    implements IOverwriteQuery {
        private ImportOverwriteQuery() {
        }

        public String queryOverwrite(String file) {
            return "ALL";
        }
    }
}

