/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICEventBreakpoint;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.cdt.debug.internal.ui.propertypages.CBreakpointPreferenceStore;
import org.eclipse.cdt.debug.internal.ui.propertypages.PropertyPageMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.CBreakpointUIContributionFactory;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointsUIContribution;
import org.eclipse.cdt.debug.ui.preferences.ReadOnlyFieldEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class CBreakpointPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private BooleanFieldEditor fEnabled;
    private BreakpointStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private BreakpointIntegerFieldEditor fIgnoreCount;
    private IAdaptable fElement;
    private CBreakpointPreferenceStore fCBreakpointPreferenceStore;

    public CBreakpointPropertyPage() {
        super(1);
        this.noDefaultAndApplyButton();
        this.fCBreakpointPreferenceStore = new CBreakpointPreferenceStore();
    }

    protected void createFieldEditors() {
        ICBreakpoint breakpoint = this.getBreakpoint();
        this.createMainLabel(breakpoint);
        this.createContributetedFieldEditors(breakpoint);
        this.createTypeSpecificLabelFieldEditors(breakpoint);
        this.createEnabledField(this.getFieldEditorParent());
        IPreferenceStore store = this.getPreferenceStore();
        try {
            String condition = breakpoint.getCondition();
            if (condition == null) {
                condition = "";
            }
            store.setValue("CONDITION", condition);
            this.createConditionEditor(this.getFieldEditorParent());
            store.setValue("ENABLED", breakpoint.isEnabled());
            int ignoreCount = breakpoint.getIgnoreCount();
            store.setValue("IGNORE_COUNT", ignoreCount >= 0 ? ignoreCount : 0);
            this.createIgnoreCountEditor(this.getFieldEditorParent());
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    private void createMainLabel(ICBreakpoint breakpoint) {
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.18"), this.getBreakpointMainLabel(breakpoint)));
    }

    private void createTypeSpecificLabelFieldEditors(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICFunctionBreakpoint) {
            ICFunctionBreakpoint fbrkpt = (ICFunctionBreakpoint)breakpoint;
            String function = PropertyPageMessages.getString("CBreakpointPropertyPage.1");
            try {
                function = fbrkpt.getFunction();
            }
            catch (CoreException coreException) {
            }
            catch (NumberFormatException numberFormatException) {}
            if (function != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.2"), function));
            }
        } else if (breakpoint instanceof ICAddressBreakpoint) {
            ICAddressBreakpoint abrkpt = (ICAddressBreakpoint)breakpoint;
            String address = PropertyPageMessages.getString("CBreakpointPropertyPage.4");
            try {
                address = abrkpt.getAddress();
            }
            catch (CoreException coreException) {}
            if (address != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.5"), address));
            }
        } else if (breakpoint instanceof ICWatchpoint) {
            String filename;
            IResource resource;
            ICWatchpoint watchpoint = (ICWatchpoint)breakpoint;
            String expression = "";
            try {
                expression = watchpoint.getExpression();
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
            IProject project = breakpoint.getMarker().getResource().getProject();
            if (project != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.10"), project.getName()));
            }
            if ((resource = breakpoint.getMarker().getResource()) instanceof IFile && (filename = resource.getLocation().toOSString()) != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.20"), filename));
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.14"), expression));
        } else if (breakpoint instanceof ILineBreakpoint) {
            String fileName = null;
            try {
                fileName = breakpoint.getSourceHandle();
            }
            catch (CoreException coreException) {}
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), PropertyPageMessages.getString("CBreakpointPropertyPage.7"), fileName));
            }
            ILineBreakpoint lBreakpoint = (ILineBreakpoint)breakpoint;
            int lNumber = 0;
            try {
                lNumber = lBreakpoint.getLineNumber();
            }
            catch (CoreException e) {
                CDebugUIPlugin.log(e);
            }
            if (lNumber > 0) {
                this.getPreferenceStore().setValue("LINE", lNumber);
                this.createLineNumberEditor(this.getFieldEditorParent());
            }
        }
    }

    private String getBreakpointMainLabel(ICBreakpoint breakpoint) {
        if (breakpoint instanceof ICFunctionBreakpoint) {
            return PropertyPageMessages.getString("CBreakpointPropertyPage.3");
        }
        if (breakpoint instanceof ICAddressBreakpoint) {
            return PropertyPageMessages.getString("CBreakpointPropertyPage.4");
        }
        if (breakpoint instanceof ICLineBreakpoint) {
            return PropertyPageMessages.getString("CBreakpointPropertyPage.8");
        }
        if (breakpoint instanceof ICEventBreakpoint) {
            return PropertyPageMessages.getString("CBreakpointPropertyPage.21");
        }
        if (breakpoint instanceof ICWatchpoint) {
            ICWatchpoint watchpoint = (ICWatchpoint)breakpoint;
            String type = "";
            try {
                type = watchpoint.isReadType() && !watchpoint.isWriteType() ? PropertyPageMessages.getString("CBreakpointPropertyPage.11") : (!watchpoint.isReadType() && watchpoint.isWriteType() ? PropertyPageMessages.getString("CBreakpointPropertyPage.12") : PropertyPageMessages.getString("CBreakpointPropertyPage.13"));
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
            return type;
        }
        String type = "";
        try {
            type = breakpoint.getMarker().getType();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
        return type;
    }

    protected void createLineNumberEditor(Composite parent) {
        String title = PropertyPageMessages.getString("CBreakpointPropertyPage.9");
        BreakpointIntegerFieldEditor labelFieldEditor = new BreakpointIntegerFieldEditor("LINE", title, parent);
        labelFieldEditor.setValidRange(1, Integer.MAX_VALUE);
        this.addField((FieldEditor)labelFieldEditor);
    }

    protected void createEnabledField(Composite parent) {
        this.fEnabled = new BooleanFieldEditor("ENABLED", PropertyPageMessages.getString("CBreakpointPropertyPage.19"), parent);
        this.addField((FieldEditor)this.fEnabled);
    }

    protected void createConditionEditor(Composite parent) {
        this.fCondition = new BreakpointStringFieldEditor("CONDITION", PropertyPageMessages.getString("CBreakpointPropertyPage.15"), parent);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage(PropertyPageMessages.getString("CBreakpointPropertyPage.16"));
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.fIgnoreCount = new BreakpointIntegerFieldEditor("IGNORE_COUNT", PropertyPageMessages.getString("CBreakpointPropertyPage.17"), parent);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(parent);
        try {
            this.fIgnoreCountTextControl.setEnabled(this.getBreakpoint().getIgnoreCount() >= 0);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected ICBreakpoint getBreakpoint() {
        IAdaptable element = this.getElement();
        return element instanceof ICBreakpoint ? (ICBreakpoint)element : (ICBreakpoint)element.getAdapter(ICBreakpoint.class);
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element;
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fCBreakpointPreferenceStore;
    }

    public boolean performOk() {
        final ArrayList changedProperties = new ArrayList(5);
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                changedProperties.add(event.getProperty());
            }
        });
        boolean result = super.performOk();
        this.setBreakpointProperties(changedProperties);
        return result;
    }

    protected void setBreakpointProperties(final List changedProperties) {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ICBreakpoint breakpoint = CBreakpointPropertyPage.this.getBreakpoint();
                for (String property : changedProperties) {
                    if (property.equals("ENABLED")) {
                        breakpoint.setEnabled(CBreakpointPropertyPage.this.getPreferenceStore().getBoolean("ENABLED"));
                        continue;
                    }
                    if (property.equals("IGNORE_COUNT")) {
                        breakpoint.setIgnoreCount(CBreakpointPropertyPage.this.getPreferenceStore().getInt("IGNORE_COUNT"));
                        continue;
                    }
                    if (property.equals("CONDITION")) {
                        breakpoint.setCondition(CBreakpointPropertyPage.this.getPreferenceStore().getString("CONDITION"));
                        continue;
                    }
                    if (property.equals("LINE")) {
                        breakpoint.getMarker().setAttribute("lineNumber", CBreakpointPropertyPage.this.getPreferenceStore().getInt("LINE"));
                        continue;
                    }
                    String value = CBreakpointPropertyPage.this.getPropertyAsString(property);
                    breakpoint.getMarker().setAttribute(property, (Object)value);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    private void createContributetedFieldEditors(ICBreakpoint breakpoint) {
        Composite parent = this.getFieldEditorParent();
        try {
            ICBreakpointsUIContribution[] cons;
            ICBreakpointsUIContribution[] iCBreakpointsUIContributionArray = cons = CBreakpointUIContributionFactory.getInstance().getBreakpointUIContributions((IBreakpoint)breakpoint);
            int n = cons.length;
            int n2 = 0;
            while (n2 < n) {
                Object o;
                ICBreakpointsUIContribution con = iCBreakpointsUIContributionArray[n2];
                FieldEditor fieldEditor = con.getFieldEditor(con.getId(), String.valueOf(con.getLabel()) + ":", parent);
                if (fieldEditor != null) {
                    this.addField(fieldEditor);
                }
                String value = (o = breakpoint.getMarker().getAttribute(con.getId())) == null ? "" : o.toString();
                this.getPreferenceStore().setValue(con.getId(), value);
                ++n2;
            }
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log(ce);
        }
    }

    protected String getPropertyAsString(String property) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.contains(property)) {
            String value = store.getString(property);
            return value;
        }
        return null;
    }

    class BreakpointIntegerFieldEditor
    extends IntegerFieldEditor {
        public BreakpointIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(PropertyPageMessages.getString("CBreakpointPropertyPage.0"));
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class BreakpointStringFieldEditor
    extends StringFieldEditor {
        public BreakpointStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class LabelFieldEditor
    extends ReadOnlyFieldEditor {
        private String fValue;

        public LabelFieldEditor(Composite parent, String title, String value) {
            super(title, title, parent);
            this.fValue = value;
        }

        protected void doLoad() {
            if (this.textField != null) {
                this.textField.setText(this.fValue);
            }
        }

        protected void doLoadDefault() {
        }
    }
}

