/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class LaunchUtils {
    public static ICProject verifyCProject(ILaunchConfiguration configuration) throws CoreException {
        String name = LaunchUtils.getProjectName(configuration);
        if (name == null) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.C_Project_not_specified"), null, 102);
            return null;
        }
        ICProject cproject = LaunchUtils.getCProject(configuration);
        if (cproject == null && name.length() > 0) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (!proj.exists()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_does_not_exist", name), null, 103);
            } else if (!proj.isOpen()) {
                LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_is_closed", name), null, 103);
            }
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Not_a_C_CPP_project"), null, 103);
        }
        return cproject;
    }

    public static IPath verifyProgramPath(ILaunchConfiguration configuration, ICProject cproject) throws CoreException {
        Path programPath;
        String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        if (programName == null) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_not_specified"), null, 103);
        }
        if ((programPath = new Path(programName)).isEmpty()) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), null, 103);
        }
        if (!programPath.isAbsolute() && cproject != null) {
            IFile wsProgramPath = cproject.getProject().getFile((IPath)programPath);
            programPath = wsProgramPath.getLocation();
        }
        if (!programPath.toFile().exists()) {
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", programPath.toOSString())), 104);
        }
        return programPath;
    }

    public static IBinaryParser.IBinaryObject verifyBinary(ILaunchConfiguration configuration, IPath exePath) throws CoreException {
        ICExtensionReference[] parserRefs;
        ICExtensionReference[] iCExtensionReferenceArray = parserRefs = CCorePlugin.getDefault().getBinaryParserExtensions(LaunchUtils.getCProject(configuration).getProject());
        int n = parserRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ICExtensionReference parserRef = iCExtensionReferenceArray[n2];
            try {
                IBinaryParser parser = (IBinaryParser)parserRef.createExtension();
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                if (exe != null) {
                    return exe;
                }
            }
            catch (ClassCastException classCastException) {
            }
            catch (IOException iOException) {}
            ++n2;
        }
        IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
        try {
            return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
        }
        catch (ClassCastException classCastException) {
        }
        catch (IOException iOException) {}
        LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable", exePath.toOSString())), 107);
        return null;
    }

    private static void abort(String message, Throwable exception, int code) throws CoreException {
        MultiStatus status = new MultiStatus("org.eclipse.cdt.dsf.gdb", code, message, exception);
        status.add((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", code, exception == null ? "" : exception.getLocalizedMessage(), exception));
        throw new CoreException((IStatus)status);
    }

    public static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = LaunchUtils.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    private static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static IPath getGDBPath(ILaunchConfiguration configuration) {
        Path retVal = new Path("gdb");
        try {
            retVal = new Path(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "gdb"));
        }
        catch (CoreException coreException) {}
        return retVal;
    }

    public static String getGDBVersionFromText(String versionOutput) {
        String version = "";
        Pattern pattern = Pattern.compile(" gdb( \\(.*?\\))? (\\d*(\\.\\d*)*)", 8);
        Matcher matcher = pattern.matcher(versionOutput);
        if (matcher.find()) {
            version = matcher.group(2);
            if (versionOutput.toLowerCase().indexOf("cygwin") != -1 && version.startsWith("6.8")) {
                version = "6.8";
            }
        }
        return version;
    }

    public static String getGDBVersion(ILaunchConfiguration configuration) throws CoreException {
        Process process = null;
        String cmd = String.valueOf(LaunchUtils.getGDBPath(configuration).toOSString()) + " --version";
        try {
            process = ProcessFactory.getFactory().exec(cmd);
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Error while launching command: " + cmd, e.getCause()));
        }
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            String line;
            InputStream stream = process.getInputStream();
            InputStreamReader r = new InputStreamReader(stream);
            BufferedReader reader = new BufferedReader(r);
            while ((line = reader.readLine()) != null) {
                cmdOutput.append(line);
            }
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 5012, "Error reading GDB STDOUT after sending: " + cmd, e.getCause()));
        }
        return LaunchUtils.getGDBVersionFromText(cmdOutput.toString());
    }

    public static boolean getIsAttach(ILaunchConfiguration config) {
        String debugMode;
        block10: {
            block9: {
                block8: {
                    block7: {
                        try {
                            debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                            if (!debugMode.equals("run")) break block7;
                            return false;
                        }
                        catch (CoreException coreException) {}
                    }
                    if (!debugMode.equals("attach")) break block8;
                    return true;
                }
                if (!debugMode.equals("core")) break block9;
                return false;
            }
            if (!debugMode.equals("remote")) break block10;
            return false;
        }
        if (debugMode.equals("remote_attach")) {
            return true;
        }
        return false;
    }

    public static SessionType getSessionType(ILaunchConfiguration config) {
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                return SessionType.LOCAL;
            }
            if (debugMode.equals("attach")) {
                return SessionType.LOCAL;
            }
            if (debugMode.equals("core")) {
                return SessionType.CORE;
            }
            if (debugMode.equals("remote")) {
                return SessionType.REMOTE;
            }
            if (debugMode.equals("remote_attach")) {
                return SessionType.REMOTE;
            }
        }
        catch (CoreException coreException) {}
        return SessionType.LOCAL;
    }
}

