/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.dataviewer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.ui.concurrent.DisplayDsfExecutor;
import org.eclipse.cdt.examples.dsf.dataviewer.DataGeneratorWithExecutor;
import org.eclipse.cdt.examples.dsf.dataviewer.IDataGenerator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="fDisplayExecutor")
public class AsyncDataViewer
implements ILazyContentProvider,
IDataGenerator.Listener {
    @ThreadSafe
    private final DsfExecutor fDisplayExecutor;
    private final TableViewer fViewer;
    private final IDataGenerator fDataGenerator;
    private List<ValueDataRequestMonitor> fItemDataRequestMonitors = new LinkedList<ValueDataRequestMonitor>();
    private Set<Integer> fIndexesToCancel = new HashSet<Integer>();
    private int fCancelCallsPending = 0;

    public AsyncDataViewer(TableViewer viewer, IDataGenerator generator) {
        this.fViewer = viewer;
        this.fDisplayExecutor = DisplayDsfExecutor.getDisplayDsfExecutor((Display)this.fViewer.getTable().getDisplay());
        this.fDataGenerator = generator;
        this.fDataGenerator.addListener(this);
    }

    public void dispose() {
        this.fDataGenerator.removeListener(this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.queryItemCount();
    }

    public void updateElement(int index) {
        final int topIdx = this.fViewer.getTable().getTopIndex();
        final int botIdx = topIdx + this.getVisibleItemCount(topIdx);
        this.queryValue(index);
        ++this.fCancelCallsPending;
        this.fDisplayExecutor.schedule(new Runnable(){

            public void run() {
                AsyncDataViewer.this.cancelStaleRequests(topIdx, botIdx);
            }
        }, 1L, TimeUnit.MILLISECONDS);
    }

    private int getVisibleItemCount(int top) {
        Table table = this.fViewer.getTable();
        int itemCount = table.getItemCount();
        return Math.min(table.getBounds().height / table.getItemHeight() + 2, itemCount - top);
    }

    @Override
    @ThreadSafe
    public void countChanged() {
        this.queryItemCount();
    }

    @Override
    @ThreadSafe
    public void valuesChanged(final Set<Integer> indexes) {
        final TableViewer tableViewer = this.fViewer;
        this.fDisplayExecutor.execute(new Runnable(){

            public void run() {
                if (!AsyncDataViewer.this.fViewer.getTable().isDisposed()) {
                    for (Integer index : indexes) {
                        tableViewer.clear(index.intValue());
                    }
                }
            }
        });
    }

    private void queryItemCount() {
        this.fIndexesToCancel.clear();
        this.fDataGenerator.getCount(new DataRequestMonitor<Integer>((Executor)this.fDisplayExecutor, null){

            protected void handleCompleted() {
                if (!AsyncDataViewer.this.fViewer.getTable().isDisposed()) {
                    AsyncDataViewer.this.fViewer.setItemCount(((Integer)this.getData()).intValue());
                    AsyncDataViewer.this.fViewer.getTable().clearAll();
                }
            }
        });
    }

    private void queryValue(int index) {
        ValueDataRequestMonitor rm = new ValueDataRequestMonitor(index);
        this.fItemDataRequestMonitors.add(rm);
        this.fDataGenerator.getValue(index, rm);
    }

    private void cancelStaleRequests(int topIdx, int botIdx) {
        --this.fCancelCallsPending;
        if (this.fDataGenerator == null || this.fViewer.getTable().isDisposed()) {
            return;
        }
        Iterator<ValueDataRequestMonitor> itr = this.fItemDataRequestMonitors.iterator();
        while (itr.hasNext()) {
            ValueDataRequestMonitor item = itr.next();
            if (item.fIndex >= topIdx && item.fIndex <= botIdx) continue;
            item.cancel();
            this.fIndexesToCancel.add(item.fIndex);
            itr.remove();
        }
        if (!this.fIndexesToCancel.isEmpty() && this.fCancelCallsPending == 0) {
            Set<Integer> canceledIdxs = this.fIndexesToCancel;
            this.fIndexesToCancel = new HashSet<Integer>();
            int[] canceledIdxsArray = new int[canceledIdxs.size()];
            int i = 0;
            for (Integer index : canceledIdxs) {
                canceledIdxsArray[i++] = index;
            }
            this.fViewer.getTable().clear(canceledIdxsArray);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        shell.setLayoutData((Object)data);
        Font font = new Font((Device)display, "Courier", 10, 0);
        TableViewer tableViewer = new TableViewer((Composite)shell, 0x10000800);
        tableViewer.getControl().setLayoutData((Object)data);
        final DataGeneratorWithExecutor generator = new DataGeneratorWithExecutor();
        AsyncDataViewer contentProvider = new AsyncDataViewer(tableViewer, generator);
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        tableViewer.setInput(new Object());
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        Query<Object> shutdownQuery = new Query<Object>(){

            protected void execute(DataRequestMonitor<Object> rm) {
                generator.shutdown((RequestMonitor)rm);
            }
        };
        ImmediateExecutor.getInstance().execute((Runnable)shutdownQuery);
        try {
            shutdownQuery.get();
        }
        catch (Exception exception) {}
        font.dispose();
        display.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueDataRequestMonitor
    extends DataRequestMonitor<String> {
        int fIndex;

        ValueDataRequestMonitor(int index) {
            super((Executor)AsyncDataViewer.this.fDisplayExecutor, null);
            this.fIndex = index;
        }

        protected void handleCompleted() {
            AsyncDataViewer.this.fItemDataRequestMonitors.remove((Object)this);
            if (this.isSuccess() && !AsyncDataViewer.this.fViewer.getTable().isDisposed()) {
                AsyncDataViewer.this.fViewer.replace(this.getData(), this.fIndex);
            }
        }
    }
}

