/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.service.DsfServices;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.examples.dsf.DsfExamplesPlugin;
import org.eclipse.cdt.examples.dsf.timers.AlarmService;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@ThreadSafeAndProhibitedFromDsfExecutor(value="fSession.getExecutor()")
public class TriggerCellModifier
implements ICellModifier {
    private final DsfSession fSession;
    @ThreadSafe
    private ServiceTracker fServiceTracker;

    public TriggerCellModifier(DsfSession session) {
        this.fSession = session;
    }

    public boolean canModify(Object element, String property) {
        return "org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE".equals(property) && this.getAlarmDMC(element) != null;
    }

    public Object getValue(Object element, String property) {
        if (!"org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE".equals(property)) {
            return "";
        }
        AlarmService.TriggerDMContext triggerCtx = this.getAlarmDMC(element);
        if (triggerCtx == null) {
            return "";
        }
        DsfSession session = DsfSession.getSession((String)triggerCtx.getSessionId());
        if (session == null) {
            return "";
        }
        GetValueQuery query = new GetValueQuery(triggerCtx);
        try {
            session.getExecutor().execute((Runnable)((Object)query));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            return "";
        }
        try {
            return ((Integer)query.get()).toString();
        }
        catch (InterruptedException interruptedException) {
            assert (false);
            return "";
        }
        catch (ExecutionException executionException) {
            return "";
        }
    }

    public void modify(Object element, String property, Object value) {
        if (!"org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID.COL_VALUE".equals(property)) {
            return;
        }
        AlarmService.TriggerDMContext dmc = this.getAlarmDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        Integer intValue = null;
        if (value instanceof String) {
            try {
                intValue = new Integer(((String)value).trim());
            }
            catch (NumberFormatException numberFormatException) {
                MessageDialog.openError((Shell)shell, (String)"Invalid Value", (String)"Please enter a positive integer");
                return;
            }
            if (intValue <= 0) {
                MessageDialog.openError((Shell)shell, (String)"Invalid Value", (String)"Please enter a positive integer");
                return;
            }
        }
        SetValueQuery query = new SetValueQuery(dmc, intValue);
        try {
            session.getExecutor().execute((Runnable)((Object)query));
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        try {
            query.get().toString();
        }
        catch (InterruptedException interruptedException) {
            assert (false);
        }
        catch (ExecutionException executionException) {}
    }

    @ThreadSafe
    public synchronized void dispose() {
        if (this.fServiceTracker != null) {
            this.fServiceTracker.close();
        }
    }

    private Shell getShell() {
        if (DsfExamplesPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            return DsfExamplesPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    private AlarmService.TriggerDMContext getAlarmDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (AlarmService.TriggerDMContext)((Object)((IAdaptable)element).getAdapter(AlarmService.TriggerDMContext.class));
        }
        return null;
    }

    @ThreadSafe
    private synchronized AlarmService getService(AlarmService.TriggerDMContext dmc) {
        String serviceId = DsfServices.createServiceFilter(AlarmService.class, (String)this.fSession.getId());
        if (this.fServiceTracker == null) {
            try {
                this.fServiceTracker = new ServiceTracker(DsfExamplesPlugin.getBundleContext(), DsfExamplesPlugin.getBundleContext().createFilter(serviceId), null);
                this.fServiceTracker.open();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                return null;
            }
        }
        return (AlarmService)((Object)this.fServiceTracker.getService());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetValueQuery
    extends Query<Integer> {
        final AlarmService.TriggerDMContext fDmc;

        private GetValueQuery(AlarmService.TriggerDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(DataRequestMonitor<Integer> rm) {
            DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            AlarmService service = TriggerCellModifier.this.getService(this.fDmc);
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", 10001, "Service not available", null));
                rm.done();
                return;
            }
            int value = service.getTriggerValue(this.fDmc);
            if (value == -1) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", 10002, "Invalid context", null));
                rm.done();
                return;
            }
            rm.setData((Object)value);
            rm.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetValueQuery
    extends Query<Object> {
        AlarmService.TriggerDMContext fDmc;
        int fValue;

        SetValueQuery(AlarmService.TriggerDMContext dmc, int value) {
            this.fDmc = dmc;
            this.fValue = value;
        }

        protected void execute(DataRequestMonitor<Object> rm) {
            DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            AlarmService service = TriggerCellModifier.this.getService(this.fDmc);
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.examples.dsf", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.setTriggerValue(this.fDmc, this.fValue);
            rm.setData(new Object());
            rm.done();
        }
    }
}

