/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigScope;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.preferences.TabFolderLayout;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryOptionsBlock;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiscoveryOptionsBlock
extends AbstractDiscoveryOptionsBlock {
    private static final String MISSING_BUILDER_MSG = "ScannerConfigOptionsDialog.label.missingBuilderInformation";
    private static final String DIALOG_TITLE = "ScannerConfigOptionsDialog.title";
    private static final String DIALOG_DESCRIPTION = "ScannerConfigOptionsDialog.description";
    private static final String SC_GROUP_LABEL = "ScannerConfigOptionsDialog.scGroup.label";
    private static final String SC_ENABLED_BUTTON = "ScannerConfigOptionsDialog.scGroup.enabled.button";
    private static final String SC_PROBLEM_REPORTING_ENABLED_BUTTON = "ScannerConfigOptionsDialog.scGroup.problemReporting.enabled.button";
    private static final String SC_SELECTED_PROFILE_COMBO = "ScannerConfigOptionsDialog.scGroup.selectedProfile.combo";
    private static final String SC_APPLY_PROGRESS_MESSAGE = "ScannerConfigOptionsDialog.apply.progressMessage";
    private Button scEnabledButton;
    private Button scProblemReportingEnabledButton;
    private Combo profileComboBox;
    private Composite profileComp;
    private boolean needsSCNature = false;
    private boolean fCreatePathContainer = false;

    public DiscoveryOptionsBlock() {
        super(MakeUIPlugin.getResourceString(DIALOG_TITLE));
        this.setDescription(MakeUIPlugin.getResourceString(DIALOG_DESCRIPTION));
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        if (container.getProject() == null) {
            this.fCreatePathContainer = true;
        }
    }

    public void createControl(Composite parent) {
        int tabColumns = 2;
        Font font = parent.getFont();
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        ((GridLayout)composite.getLayout()).verticalSpacing = 0;
        ((GridData)composite.getLayoutData()).horizontalAlignment = 768;
        composite.setFont(font);
        this.setControl((Control)composite);
        MakeUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), IMakeHelpContextIds.SCANNER_CONFIG_DISCOVERY_OPTIONS);
        Composite scComp = ControlFactory.createComposite((Composite)composite, (int)1);
        ((GridLayout)scComp.getLayout()).marginHeight = 0;
        ((GridLayout)scComp.getLayout()).marginTop = 5;
        scComp.setFont(font);
        if (this.createScannerConfigControls(scComp, tabColumns)) {
            this.profileComp = new Composite(composite, 0);
            this.profileComp.setFont(font);
            this.profileComp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.profileComp.setLayout((Layout)new TabFolderLayout());
            this.setCompositeParent(this.profileComp);
            this.handleDiscoveryProfileChanged();
            this.enableAllControls();
        }
        parent.layout(true);
    }

    private boolean createScannerConfigControls(Composite parent, int numColumns) {
        IProject project = this.getContainer().getProject();
        boolean showMissingBuilder = false;
        try {
            if (project != null && project.hasNature(MakeProjectNature.NATURE_ID) && !project.hasNature(ScannerConfigNature.NATURE_ID)) {
                this.needsSCNature = true;
            }
        }
        catch (CoreException coreException) {
            showMissingBuilder = true;
        }
        if (showMissingBuilder || !this.needsSCNature && !this.isInitialized()) {
            ControlFactory.createEmptySpace((Composite)parent);
            ControlFactory.createLabel((Composite)parent, (String)MakeUIPlugin.getResourceString(MISSING_BUILDER_MSG));
            return false;
        }
        Group scGroup = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(SC_GROUP_LABEL), (int)numColumns);
        scGroup.setFont(parent.getFont());
        ((GridData)scGroup.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)scGroup.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)scGroup.getLayoutData()).horizontalAlignment = 4;
        this.scEnabledButton = ControlFactory.createCheckBox((Composite)scGroup, (String)MakeUIPlugin.getResourceString(SC_ENABLED_BUTTON));
        this.scEnabledButton.setFont(parent.getFont());
        ((GridData)this.scEnabledButton.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.scEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.scEnabledButton.setSelection(this.needsSCNature ? false : this.getBuildInfo().isAutoDiscoveryEnabled());
        this.scEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.enableAllControls();
            }
        });
        this.scProblemReportingEnabledButton = ControlFactory.createCheckBox((Composite)scGroup, (String)MakeUIPlugin.getResourceString(SC_PROBLEM_REPORTING_ENABLED_BUTTON));
        this.scProblemReportingEnabledButton.setFont(parent.getFont());
        ((GridData)this.scProblemReportingEnabledButton.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.scProblemReportingEnabledButton.getLayoutData()).grabExcessHorizontalSpace = true;
        this.scProblemReportingEnabledButton.setSelection(this.getBuildInfo().isProblemReportingEnabled());
        Label label = ControlFactory.createLabel((Composite)scGroup, (String)MakeUIPlugin.getResourceString(SC_SELECTED_PROFILE_COMBO));
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.profileComboBox = new Combo((Composite)scGroup, 12);
        this.profileComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoveryOptionsBlock.this.getBuildInfo().setSelectedProfileId(DiscoveryOptionsBlock.this.getCurrentProfileId());
                DiscoveryOptionsBlock.this.handleDiscoveryProfileChanged();
            }
        });
        for (String profileId : this.getDiscoveryProfileIdList()) {
            String pageName = this.getDiscoveryProfileName(profileId);
            if (pageName == null) continue;
            this.profileComboBox.add(pageName);
            if (!profileId.equals(this.getBuildInfo().getSelectedProfileId())) continue;
            this.profileComboBox.setText(pageName);
        }
        this.profileComboBox.setEnabled(this.scEnabledButton.getSelection());
        return true;
    }

    private void enableAllControls() {
        boolean isSCDEnabled = this.scEnabledButton.getSelection();
        this.scProblemReportingEnabledButton.setEnabled(isSCDEnabled);
        this.profileComboBox.setEnabled(isSCDEnabled);
        this.profileComp.setVisible(isSCDEnabled);
    }

    public void setVisible(boolean visible) {
        if (!visible && !this.checkDialogForChanges()) {
            this.createBuildInfo();
            this.restoreFromBuildinfo(this.getBuildInfo());
            this.enableAllControls();
            this.handleDiscoveryProfileChanged();
            this.getCurrentPage().performDefaults();
        }
        super.setVisible(visible);
        this.enableAllControls();
    }

    protected String getCurrentProfileId() {
        String selectedProfileName = this.profileComboBox.getItem(this.profileComboBox.getSelectionIndex());
        String selectedProfileId = this.getDiscoveryProfileId(selectedProfileName);
        return selectedProfileId;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeUIPlugin.getResourceString(SC_APPLY_PROGRESS_MESSAGE), 3);
        IProject project = this.getContainer().getProject();
        this.createBuildInfo();
        if (this.getBuildInfo() != null) {
            this.populateBuildInfo(this.getBuildInfo());
            monitor.worked(1);
            if (this.scEnabledButton.getSelection()) {
                this.getCurrentPage().performApply();
            }
            monitor.worked(1);
            if (project != null) {
                this.configureProject(project, monitor);
            }
            this.getBuildInfo().save();
            if (this.isProfileDifferentThenPersisted()) {
                if (project != null) {
                    this.changeDiscoveryContainer(project);
                }
                this.updatePersistedProfile();
            }
        }
        monitor.done();
    }

    private void configureProject(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(MakeUIPlugin.getResourceString(SC_APPLY_PROGRESS_MESSAGE), 3);
        if (this.needsSCNature) {
            ScannerConfigNature.addScannerConfigNature((IProject)project);
            this.needsSCNature = false;
            this.fCreatePathContainer = true;
        }
        if (this.fCreatePathContainer) {
            this.createDiscoveredPathContainer(project, monitor);
            this.fCreatePathContainer = false;
        }
    }

    private void createDiscoveredPathContainer(IProject project, IProgressMonitor monitor) throws CModelException {
        IPathEntry[] entries;
        ArrayList<IPathEntry> newEntries;
        IContainerEntry container = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        ICProject cProject = CoreModel.getDefault().create(project);
        if (cProject != null && !(newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries = cProject.getRawPathEntries()))).contains(container)) {
            newEntries.add((IPathEntry)container);
            cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
        }
        MakeCorePlugin.getDefault().getDiscoveryManager().removeDiscoveredInfo(project);
    }

    private void changeDiscoveryContainer(IProject project) {
        String profileId = this.getBuildInfo().getSelectedProfileId();
        ScannerConfigScope profileScope = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId).getProfileScope();
        ArrayList<IProject> changedResources = new ArrayList<IProject>();
        changedResources.add(project);
        MakeCorePlugin.getDefault().getDiscoveryManager().changeDiscoveredContainer(project, profileScope, changedResources);
    }

    private void populateBuildInfo(IScannerConfigBuilderInfo2 buildInfo) {
        if (buildInfo != null) {
            buildInfo.setAutoDiscoveryEnabled(this.scEnabledButton.getSelection());
            String profileName = this.profileComboBox.getItem(this.profileComboBox.getSelectionIndex());
            buildInfo.setSelectedProfileId(this.getDiscoveryProfileId(profileName));
            buildInfo.setProblemReportingEnabled(this.scProblemReportingEnabledButton.getSelection());
        }
    }

    public void performDefaults() {
        if (!this.isInitialized() && !this.needsSCNature) {
            return;
        }
        this.createDefaultBuildInfo();
        this.restoreFromBuildinfo(this.getBuildInfo());
        this.enableAllControls();
        this.getCurrentPage().performDefaults();
        this.handleDiscoveryProfileChanged();
    }

    private void restoreFromBuildinfo(IScannerConfigBuilderInfo2 buildInfo) {
        if (buildInfo != null) {
            this.scEnabledButton.setSelection(buildInfo.isAutoDiscoveryEnabled());
            String profileId = buildInfo.getSelectedProfileId();
            this.profileComboBox.setText(this.getDiscoveryProfileName(profileId));
            this.scProblemReportingEnabledButton.setSelection(buildInfo.isProblemReportingEnabled());
        }
    }
}

