/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.core.scannerconfig.tests;

import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.testplugin.util.BaseTestCase;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public class CfgScannerConfigProfileManagerTests
extends BaseTestCase {
    IProject fProject;

    public static Test suite() {
        TestSuite suite = new TestSuite(CfgScannerConfigProfileManagerTests.class.getName());
        suite.addTestSuite(CfgScannerConfigProfileManagerTests.class);
        return suite;
    }

    protected void setUp() throws Exception {
        this.fProject = ManagedBuildTestHelper.createProject("CfgScannerConfigProfileManagerProj", "cdt.managedbuild.target.gnu.exe");
        ManagedBuildTestHelper.addManagedBuildNature(this.fProject);
    }

    protected void tearDown() throws Exception {
        ManagedBuildTestHelper.removeProject(this.fProject.getName());
    }

    public void testBasicCfgScannerConfigProfileChanges() throws CoreException {
        ICProjectDescription prjDesc = CoreModel.getDefault().getProjectDescription(this.fProject);
        ICConfigurationDescription[] cfgDescs = prjDesc.getConfigurations();
        CfgScannerConfigProfileManagerTests.assertTrue((cfgDescs.length > 0 ? 1 : 0) != 0);
        IConfiguration cfg0 = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)cfgDescs[0]);
        ICfgScannerConfigBuilderInfo2Set scbis = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg0);
        boolean resCfgTypeDiscovery = scbis.isPerRcTypeDiscovery();
        scbis.setPerRcTypeDiscovery(!resCfgTypeDiscovery);
        Map infoMap = scbis.getInfoMap();
        CfgInfoContext cic = (CfgInfoContext)infoMap.entrySet().iterator().next().getKey();
        IScannerConfigBuilderInfo2 scbi = (IScannerConfigBuilderInfo2)infoMap.entrySet().iterator().next().getValue();
        boolean autoDiscovery = scbi.isAutoDiscoveryEnabled();
        scbi.setAutoDiscoveryEnabled(!autoDiscovery);
        boolean problemReport = scbi.isProblemReportingEnabled();
        scbi.setProblemReportingEnabled(!problemReport);
        boolean buildOutputParser = scbi.isBuildOutputParserEnabled();
        scbi.setBuildOutputParserEnabled(!buildOutputParser);
        boolean buildOutputFileAction = scbi.isBuildOutputFileActionEnabled();
        scbi.setBuildOutputFileActionEnabled(!buildOutputFileAction);
        String buildOutputFilePath = scbi.getBuildOutputFilePath();
        scbi.setBuildOutputFilePath("dummyFile");
        scbis.applyInfo(cic, scbi);
        CoreModel.getDefault().setProjectDescription(this.fProject, prjDesc);
        this.fProject.close(null);
        this.fProject.open(null);
        prjDesc = CoreModel.getDefault().getProjectDescription(this.fProject);
        cfg0 = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)prjDesc.getConfigurations()[0]);
        scbis = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg0);
        CfgScannerConfigProfileManagerTests.assertTrue((boolean)(scbis.isPerRcTypeDiscovery() ^ resCfgTypeDiscovery));
        scbi = scbis.getInfo(cic);
        Assert.isTrue((boolean)(autoDiscovery ^ scbi.isAutoDiscoveryEnabled()));
        Assert.isTrue((boolean)(problemReport ^ scbi.isProblemReportingEnabled()));
        Assert.isTrue((boolean)(buildOutputParser ^ scbi.isBuildOutputParserEnabled()));
        Assert.isTrue((boolean)(buildOutputFileAction ^ scbi.isBuildOutputFileActionEnabled()));
        Assert.isTrue((boolean)"dummyFile".equals(scbi.getBuildOutputFilePath()));
        scbis.applyInfo(cic, null);
        CoreModel.getDefault().setProjectDescription(this.fProject, prjDesc);
        this.fProject.close(null);
        this.fProject.open(null);
        prjDesc = CoreModel.getDefault().getProjectDescription(this.fProject);
        cfg0 = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)prjDesc.getConfigurations()[0]);
        scbis = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo((IConfiguration)cfg0);
        scbi = scbis.getInfo(cic);
        Assert.isTrue((autoDiscovery == scbi.isAutoDiscoveryEnabled() ? 1 : 0) != 0);
        Assert.isTrue((problemReport == scbi.isProblemReportingEnabled() ? 1 : 0) != 0);
        Assert.isTrue((buildOutputParser == scbi.isBuildOutputParserEnabled() ? 1 : 0) != 0);
        Assert.isTrue((buildOutputFileAction == scbi.isBuildOutputFileActionEnabled() ? 1 : 0) != 0);
        Assert.isTrue((boolean)buildOutputFilePath.equals(buildOutputFilePath));
    }
}

