/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuildMessages;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class HeadlessBuilder
implements IApplication {
    private static final String PREF_BUILD_ALL_CONFIGS = "build.all.configs.enabled";
    public static final Integer ERROR = -1;
    public static final Integer OK = IApplication.EXIT_OK;
    private final Set<String> projectsToImport = new HashSet<String>();
    private final Set<String> projectsToBuild = new HashSet<String>();
    private final Set<String> projectsToClean = new HashSet<String>();
    private boolean buildAll = false;
    private boolean cleanAll = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        PrintingProgressMonitor monitor = new PrintingProgressMonitor();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        boolean isAutoBuilding = root.getWorkspace().isAutoBuilding();
        try {
            IWorkspaceDescription desc = root.getWorkspace().getDescription();
            desc.setAutoBuilding(false);
            root.getWorkspace().setDescription(desc);
            if (!root.isAccessible()) {
                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Workspace) + root.getLocationURI().toString() + HeadlessBuildMessages.HeadlessBuilder_is_not_accessible);
                Integer n = ERROR;
                return n;
            }
            if (!this.getArguments((String[])context.getArguments().get("application.args"))) {
                Integer n = ERROR;
                return n;
            }
            if (System.getProperty("org.eclipse.cdt.core.console") == null) {
                System.setProperty("org.eclipse.cdt.core.console", "org.eclipse.cdt.core.systemConsole");
            }
            for (String projURIStr : this.projectsToImport) {
                InputStream in = null;
                try {
                    IFileStore fstore;
                    String uri_string;
                    URI project_uri = null;
                    try {
                        project_uri = URI.create(projURIStr);
                    }
                    catch (Exception exception) {}
                    if (project_uri == null || project_uri.getScheme() == null) {
                        IPath p = new Path(projURIStr).addTrailingSeparator();
                        project_uri = URIUtil.toURI((IPath)p);
                    }
                    if (!(uri_string = project_uri.toASCIIString()).endsWith("/")) {
                        uri_string = String.valueOf(uri_string) + '/';
                        project_uri = new URI(uri_string);
                    }
                    if (!(fstore = EFS.getStore((URI)project_uri.resolve(".project"))).fetchInfo().exists()) {
                        System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_project) + project_uri.resolve(".project") + HeadlessBuildMessages.HeadlessBuilder_cant_be_found);
                        Integer n = ERROR;
                        return n;
                    }
                    in = fstore.openInputStream(0, (IProgressMonitor)monitor);
                    IProjectDescription desc2 = root.getWorkspace().loadProjectDescription(in);
                    IProject project = root.getProject(desc2.getName());
                    if (project.exists()) {
                        System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_project) + desc2.getName() + HeadlessBuildMessages.HeadlessBuilder_already_exists_in_workspace);
                        Integer n = ERROR;
                        return n;
                    }
                    if (!root.getWorkspace().validateProjectLocationURI(project, project_uri).equals(Status.OK_STATUS)) {
                        System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_URI) + project_uri + HeadlessBuildMessages.HeadlessBuilder_is_not_valid_in_workspace);
                        Integer n = ERROR;
                        return n;
                    }
                    desc2.setLocationURI(project_uri);
                    project.create(desc2, (IProgressMonitor)monitor);
                    project.open((IProgressMonitor)monitor);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
            boolean buildAllConfigs = prefs.getBoolean(PREF_BUILD_ALL_CONFIGS);
            try {
                IProject prj;
                prefs.setValue(PREF_BUILD_ALL_CONFIGS, true);
                if (this.cleanAll) {
                    System.out.println(HeadlessBuildMessages.HeadlessBuilder_cleaning_all_projects);
                    root.getWorkspace().build(15, (IProgressMonitor)monitor);
                } else {
                    for (String project : this.projectsToClean) {
                        prj = root.getProject(project);
                        if (!prj.exists()) {
                            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_clean_failed) + project + HeadlessBuildMessages.HeadlessBuilder_16);
                            continue;
                        }
                        prj.build(15, (IProgressMonitor)monitor);
                    }
                }
                if (this.buildAll) {
                    System.out.println(HeadlessBuildMessages.HeadlessBuilder_building_all);
                    root.getWorkspace().build(6, (IProgressMonitor)monitor);
                    return OK;
                }
                for (String project : this.projectsToBuild) {
                    prj = root.getProject(project);
                    if (!prj.exists()) {
                        System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_build_failed) + project + HeadlessBuildMessages.HeadlessBuilder_16);
                        continue;
                    }
                    prj.build(6, (IProgressMonitor)monitor);
                }
                return OK;
            }
            finally {
                prefs.setValue(PREF_BUILD_ALL_CONFIGS, buildAllConfigs);
                CCorePlugin.getDefault().savePluginPreferences();
            }
        }
        finally {
            IWorkspaceDescription desc = root.getWorkspace().getDescription();
            desc.setAutoBuilding(isAutoBuilding);
            root.getWorkspace().setDescription(desc);
        }
    }

    private boolean getArguments(String[] args) {
        try {
            if (args == null || args.length == 0) {
                throw new Exception(HeadlessBuildMessages.HeadlessBuilder_no_arguments);
            }
            int i = 0;
            while (i < args.length) {
                if ("-import".equals(args[i])) {
                    this.projectsToImport.add(args[++i]);
                } else if ("-build".equals(args[i])) {
                    this.projectsToBuild.add(args[++i]);
                } else if ("-cleanBuild".equals(args[i])) {
                    this.projectsToClean.add(args[++i]);
                } else {
                    System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_unknown_argument) + args[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_invalid_argument) + args != null ? Arrays.toString(args) : "");
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Error) + e.getMessage());
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_import);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_build);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_clean_build);
            return false;
        }
        if (this.projectsToClean.contains("all")) {
            this.cleanAll = true;
            this.buildAll = true;
            this.projectsToClean.remove("all");
        }
        if (this.projectsToBuild.contains("all")) {
            this.buildAll = true;
            this.projectsToBuild.remove("all");
        }
        this.projectsToBuild.addAll(this.projectsToClean);
        return true;
    }

    public void stop() {
    }

    private class PrintingProgressMonitor
    extends NullProgressMonitor {
        private PrintingProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() > 0) {
                System.out.println(name);
            }
        }
    }
}

