/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ObjectTypeBasedStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.extension.MatchObjectElement;

public class DbgTcmUtil {
    private static final PrintStream OUT = System.out;
    public static boolean DEBUG = false;

    private DbgTcmUtil() {
    }

    public static void print(String str) {
        OUT.print(str);
    }

    public static void println(String str) {
        OUT.println(str);
    }

    public static void fail(String msg) {
        DbgTcmUtil.println(msg);
        throw new DbgException(msg);
    }

    public static void fail() {
        DbgException e = new DbgException();
        e.printStackTrace(OUT);
        throw e;
    }

    public static void dumpStorage(PerTypeMapStorage storage) {
        DbgTcmUtil.println("starting storage dump..");
        int[] types = ObjectTypeBasedStorage.getSupportedObjectTypes();
        int i = 0;
        while (i < types.length) {
            int type = types[i];
            MatchObjectElement.TypeToStringAssociation assoc = MatchObjectElement.TypeToStringAssociation.getAssociation(type);
            if (assoc != null) {
                DbgTcmUtil.println(" dumping for type " + assoc.getString());
                Map map = storage.getMap(type, false);
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        IRealBuildObjectAssociation obj = (IRealBuildObjectAssociation)entry.getKey();
                        DbgTcmUtil.println("  dumping " + assoc.getString() + " " + obj.getUniqueRealName());
                        Set set = (Set)entry.getValue();
                        if (set != null) {
                            Iterator setIter = set.iterator();
                            while (setIter.hasNext()) {
                                DbgTcmUtil.println("   path \"" + setIter.next() + "\"");
                            }
                        }
                        DbgTcmUtil.println("  end dumping " + obj.getUniqueRealName());
                    }
                }
                DbgTcmUtil.println(" end type " + assoc.getString());
            }
            ++i;
        }
        DbgTcmUtil.println("end storage dump");
    }

    public static final class DbgException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private DbgException() {
        }

        private DbgException(String message, Throwable cause) {
            super(message, cause);
        }

        private DbgException(String message) {
            super(message);
        }

        private DbgException(Throwable cause) {
            super(cause);
        }
    }
}

