/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.mylyn.internal.ui;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.mylyn.internal.ui.CDTStructureBridge;
import org.eclipse.cdt.mylyn.internal.ui.CDTUIBridgePlugin;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;

public class InterestInducingProblemListener
implements IProblemChangedListener,
IPropertyChangeListener {
    public static final String PREDICTED_INTEREST_ERRORS = "org.eclipse.cdt.mylyn.ui.interest.prediction.errors";
    private CDTStructureBridge cdtStructureBridge = new CDTStructureBridge();

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        try {
            if (!ContextCorePlugin.getContextManager().isContextActive()) {
                return;
            }
            int i = 0;
            while (i < changedResources.length) {
                ICElement cdtElement;
                IResource resource = changedResources[i];
                if (resource instanceof IFile && (cdtElement = (ICElement)resource.getAdapter(ICElement.class)) != null) {
                    IInteractionElement element = ContextCorePlugin.getContextManager().getElement(CDTStructureBridge.getHandleForElement(cdtElement));
                    if (!this.cdtStructureBridge.containsProblem(element)) {
                        ContextCorePlugin.getContextManager().removeErrorPredictedInterest(element.getHandleIdentifier(), "c/c++", true);
                    } else {
                        ContextCorePlugin.getContextManager().addErrorPredictedInterest(element.getHandleIdentifier(), "c/c++", true);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.cdt.mylyn.ui", CDTUIBridgePlugin.getResourceString("MylynCDT.updateMarkerFailure"), (Throwable)e));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREDICTED_INTEREST_ERRORS.equals(event.getProperty())) {
            if (CDTUIBridgePlugin.getDefault().getPreferenceStore().getBoolean(PREDICTED_INTEREST_ERRORS)) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public void enable() {
        CUIPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void disable() {
        CUIPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }
}

