/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.CIndenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;

public final class IndentUtil {
    private static final String SLASHES = "//";

    private IndentUtil() {
    }

    public static IndentResult indentLines(IDocument document, ILineRange lines, ICProject project, IndentResult result) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        if (numberOfLines < 1) {
            return new IndentResult(null);
        }
        result = IndentUtil.reuseOrCreateToken(result, numberOfLines);
        CHeuristicScanner scanner = new CHeuristicScanner(document);
        CIndenter indenter = new CIndenter(document, scanner, project);
        boolean changed = false;
        int tabSize = CodeFormatterUtil.getTabWidth(project);
        boolean indentInsideLineComments = IndentUtil.indentInsideLineComments(project);
        int line = lines.getStartLine();
        int last = line + numberOfLines;
        int i = 0;
        while (line < last) {
            changed |= IndentUtil.indentLine(document, line, indenter, scanner, result.commentLinesAtColumnZero, i++, tabSize, indentInsideLineComments);
            ++line;
        }
        result.hasChanged = changed;
        return result;
    }

    public static void indentLines(IDocument document, LineRange lines, String indent) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        int line = lines.getStartLine();
        int last = line + numberOfLines;
        while (line < last) {
            int offset = document.getLineOffset(line);
            document.replace(offset, 0, indent);
            ++line;
        }
    }

    public static boolean indentInsideLineComments(ICProject project) {
        return "true".equals(IndentUtil.getCoreOption(project, "org.eclipse.cdt.core.formatter.indent_inside_line_comments"));
    }

    private static String getCoreOption(ICProject project, String key) {
        if (project == null) {
            return CCorePlugin.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    public static IndentResult shiftLines(IDocument document, ILineRange lines, ICProject project, IndentResult result) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        if (numberOfLines < 1) {
            return new IndentResult(null);
        }
        result = IndentUtil.reuseOrCreateToken(result, numberOfLines);
        result.hasChanged = false;
        CHeuristicScanner scanner = new CHeuristicScanner(document);
        CIndenter indenter = new CIndenter(document, scanner, project);
        boolean indentInsideLineComments = IndentUtil.indentInsideLineComments(project);
        String current = IndentUtil.getCurrentIndent(document, lines.getStartLine(), indentInsideLineComments);
        StringBuilder correct = new StringBuilder(IndentUtil.computeIndent(document, lines.getStartLine(), indenter, scanner));
        int tabSize = CodeFormatterUtil.getTabWidth(project);
        StringBuilder addition = new StringBuilder();
        int difference = IndentUtil.subtractIndent(correct, current, addition, tabSize);
        if (difference == 0) {
            return result;
        }
        if (result.leftmostLine == -1) {
            result.leftmostLine = IndentUtil.getLeftMostLine(document, lines, tabSize, indentInsideLineComments);
        }
        int maxReduction = IndentUtil.computeVisualLength(IndentUtil.getCurrentIndent(document, result.leftmostLine + lines.getStartLine(), indentInsideLineComments), tabSize);
        if (difference > 0) {
            int line = lines.getStartLine();
            int last = line + numberOfLines;
            int i = 0;
            while (line < last) {
                IndentUtil.addIndent(document, line, addition, result.commentLinesAtColumnZero, i++, indentInsideLineComments);
                ++line;
            }
        } else {
            int reduction = Math.min(-difference, maxReduction);
            int line = lines.getStartLine();
            int last = line + numberOfLines;
            int i = 0;
            while (line < last) {
                IndentUtil.cutIndent(document, line, reduction, tabSize, result.commentLinesAtColumnZero, i++, indentInsideLineComments);
                ++line;
            }
        }
        result.hasChanged = true;
        return result;
    }

    private static void addIndent(IDocument document, int line, CharSequence indent, boolean[] commentlines, int relative, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (indentInsideLineComments && !commentlines[relative]) {
            while (insert < endOffset - 2 && document.get(insert, 2).equals(SLASHES)) {
                insert += 2;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    public static int cutIndent(IDocument document, int line, int shiftWidth, int tabWidth) throws BadLocationException {
        return IndentUtil.cutIndent(document, line, shiftWidth, tabWidth, new boolean[1], 0, false);
    }

    private static int cutIndent(IDocument document, int line, int toDelete, int tabSize, boolean[] commentLines, int relative, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        if (indentInsideLineComments) {
            while (from < endOffset - 2 && document.get(from, 2).equals(SLASHES)) {
                from += 2;
            }
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= IndentUtil.computeVisualLength(ch, tabSize)) < 0) break;
            ++to;
        }
        if (endOffset > to + 1 && document.get(to, 2).equals(SLASHES)) {
            commentLines[relative] = true;
        }
        document.replace(from, to - from, "");
        return to - from;
    }

    private static int subtractIndent(CharSequence correct, CharSequence current, StringBuilder difference, int tabSize) {
        int c2;
        int c1 = IndentUtil.computeVisualLength(correct, tabSize);
        int diff = c1 - (c2 = IndentUtil.computeVisualLength(current, tabSize));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += IndentUtil.computeVisualLength(c, tabSize);
        }
        return diff;
    }

    private static int computeVisualLength(char ch, int tabSize) {
        if (ch == '\t') {
            return tabSize;
        }
        return 1;
    }

    public static int computeVisualLength(CharSequence seq, int tablen) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tablen != 0) {
                    size += tablen - size % tablen;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public static String getCurrentIndent(IDocument document, int line, boolean indentInsideLineComments) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        if (indentInsideLineComments) {
            while (to < endOffset - 2 && document.get(to, 2).equals(SLASHES)) {
                to += 2;
            }
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        return document.get(from, to - from);
    }

    private static int getLeftMostLine(IDocument document, ILineRange lines, int tabSize, boolean indentInsideLineComments) throws BadLocationException {
        int numberOfLines = lines.getNumberOfLines();
        int first = lines.getStartLine();
        int minLine = -1;
        int minIndent = Integer.MAX_VALUE;
        int line = 0;
        while (line < numberOfLines) {
            int length = IndentUtil.computeVisualLength(IndentUtil.getCurrentIndent(document, line + first, indentInsideLineComments), tabSize);
            if (length < minIndent && document.getLineLength(line + first) > 0) {
                minIndent = length;
                minLine = line;
            }
            ++line;
        }
        return minLine;
    }

    private static IndentResult reuseOrCreateToken(IndentResult token, int numberOfLines) {
        if (token == null) {
            token = new IndentResult(new boolean[numberOfLines]);
        } else if (token.commentLinesAtColumnZero == null) {
            token.commentLinesAtColumnZero = new boolean[numberOfLines];
        } else if (token.commentLinesAtColumnZero.length != numberOfLines) {
            boolean[] commentBooleans = new boolean[numberOfLines];
            System.arraycopy(token.commentLinesAtColumnZero, 0, commentBooleans, 0, Math.min(numberOfLines, token.commentLinesAtColumnZero.length));
            token.commentLinesAtColumnZero = commentBooleans;
        }
        return token;
    }

    private static boolean indentLine(IDocument document, int line, CIndenter indenter, CHeuristicScanner scanner, boolean[] commentLines, int lineIndex, int tabSize, boolean indentInsideLineComments) throws BadLocationException {
        ITypedRegion partition;
        int lineLength;
        int end;
        int offset;
        IRegion currentLine = document.getLineInformation(line);
        int wsStart = offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition2 = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
            String type = partition2.getType();
            if (type.equals("__c_multiline_comment")) {
                indent = IndentUtil.computeCommentIndent(document, line, scanner, startingPartition);
            } else if (startingPartition.getType().equals("__c_preprocessor")) {
                indent = IndentUtil.computePreprocessorIndent(document, line, startingPartition);
            } else if (!commentLines[lineIndex] && startingPartition.getOffset() == offset && startingPartition.getType().equals("__c_singleline_comment")) {
                return false;
            }
        }
        if (indent == null) {
            StringBuilder computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : new String();
        }
        if ((end = scanner.findNonWhitespaceForwardInAnyPartition(wsStart, offset + (lineLength = currentLine.getLength()))) == -1) {
            end = offset + lineLength;
        }
        int length = end - offset;
        String currentIndent = document.get(offset, length);
        if ((length > 0 || !indentInsideLineComments) && (partition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)end, (boolean)false)).getOffset() == end && "__c_singleline_comment".equals(partition.getType())) {
            commentLines[lineIndex] = true;
        }
        if (!indent.equals(currentIndent)) {
            document.replace(offset, length, indent);
            return true;
        }
        return false;
    }

    public static String computeIndent(IDocument document, int line, CIndenter indenter, CHeuristicScanner scanner) throws BadLocationException {
        IRegion currentLine = document.getLineInformation(line);
        int offset = currentLine.getOffset();
        String indent = null;
        if (offset < document.getLength()) {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)true);
            ITypedRegion startingPartition = TextUtilities.getPartition((IDocument)document, (String)"___c_partitioning", (int)offset, (boolean)false);
            String type = partition.getType();
            if (type.equals("__c_multiline_comment")) {
                indent = IndentUtil.computeCommentIndent(document, line, scanner, startingPartition);
            } else if (startingPartition.getType().equals("__c_preprocessor")) {
                indent = IndentUtil.computePreprocessorIndent(document, line, startingPartition);
            }
        }
        if (indent == null) {
            StringBuilder computed = indenter.computeIndentation(offset);
            indent = computed != null ? computed.toString() : new String();
        }
        return indent;
    }

    public static String computeCommentIndent(IDocument document, int line, CHeuristicScanner scanner, ITypedRegion partition) throws BadLocationException {
        int lineLength;
        int lineEnd;
        if (line == 0) {
            return null;
        }
        IRegion lineInfo = document.getLineInformation(line);
        int lineStart = lineInfo.getOffset();
        int nonWS = scanner.findNonWhitespaceForwardInAnyPartition(lineStart, lineEnd = lineStart + (lineLength = lineInfo.getLength()));
        if (nonWS == -1 || document.getChar(nonWS) != '*') {
            if (nonWS == -1) {
                return document.get(lineStart, lineLength);
            }
            return document.get(lineStart, nonWS - lineStart);
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        StringBuilder buf = new StringBuilder();
        int previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        if (previousLineNonWS == -1 || document.getChar(previousLineNonWS) != '*') {
            previousLine = document.getLineInformationOfOffset(partition.getOffset());
            previousLineStart = previousLine.getOffset();
            previousLineNonWS = scanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd = previousLineStart + (previousLineLength = previousLine.getLength()));
            if (previousLineNonWS == -1) {
                previousLineNonWS = previousLineEnd;
            }
            buf.append(' ');
        }
        String indentation = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        buf.insert(0, indentation);
        return buf.toString();
    }

    public static String computePreprocessorIndent(IDocument document, int line, ITypedRegion partition) throws BadLocationException {
        int ppFirstLine = document.getLineOfOffset(partition.getOffset());
        if (line == ppFirstLine) {
            return "";
        }
        CHeuristicScanner ppScanner = new CHeuristicScanner(document, "___c_partitioning", partition.getType());
        CIndenter ppIndenter = new CIndenter(document, ppScanner);
        if (line == ppFirstLine + 1) {
            return ppIndenter.createReusingIndent(new StringBuilder(), ppIndenter.getContinuationLineIndent(), 0).toString();
        }
        StringBuilder computed = ppIndenter.computeIndentation(document.getLineOffset(line), false);
        if (computed != null) {
            return computed.toString();
        }
        IRegion previousLine = document.getLineInformation(line - 1);
        int previousLineStart = previousLine.getOffset();
        int previousLineLength = previousLine.getLength();
        int previousLineEnd = previousLineStart + previousLineLength;
        int previousLineNonWS = ppScanner.findNonWhitespaceForwardInAnyPartition(previousLineStart, previousLineEnd);
        String previousIndent = document.get(previousLineStart, previousLineNonWS - previousLineStart);
        computed = new StringBuilder(previousIndent);
        return computed.toString();
    }

    public static String changePrefix(String prefix, int displayedWidth, int tabWidth, boolean useSpaces) {
        int column = IndentUtil.computeVisualLength(prefix, tabWidth);
        if (column > displayedWidth) {
            return prefix;
        }
        StringBuilder buffer = new StringBuilder(prefix);
        IndentUtil.appendIndent(buffer, displayedWidth, tabWidth, useSpaces, column);
        return buffer.toString();
    }

    private static StringBuilder appendIndent(StringBuilder buffer, int width, int tabWidth, boolean useSpaces, int startColumn) {
        assert (tabWidth > 0);
        int tabStop = startColumn - startColumn % tabWidth;
        int tabs = useSpaces ? 0 : (width - tabStop) / tabWidth;
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            startColumn = tabStop += tabWidth;
            ++i;
        }
        int spaces = width - startColumn;
        int i2 = 0;
        while (i2 < spaces) {
            buffer.append(' ');
            ++i2;
        }
        return buffer;
    }

    public static final class IndentResult {
        private boolean[] commentLinesAtColumnZero;
        private boolean hasChanged;
        private int leftmostLine = -1;

        private IndentResult(boolean[] commentLines) {
            this.commentLinesAtColumnZero = commentLines;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }
    }
}

