/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.cdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.cdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatterProfileManager
extends ProfileManager {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    public static final String KANDR_PROFILE = "org.eclipse.cdt.ui.default.kandr_profile";
    public static final String ALLMAN_PROFILE = "org.eclipse.cdt.ui.default.allman_profile";
    public static final String GNU_PROFILE = "org.eclipse.cdt.ui.default.gnu_profile";
    public static final String WHITESMITHS_PROFILE = "org.eclipse.cdt.ui.default.whitesmites_profile";
    public static final String DEFAULT_PROFILE = "org.eclipse.cdt.ui.default.kandr_profile";
    private static final ProfileManager.KeySet[] KEY_SETS = new ProfileManager.KeySet[]{new ProfileManager.KeySet("org.eclipse.cdt.core", new ArrayList<String>(DefaultCodeFormatterConstants.getDefaultSettings().keySet())), new ProfileManager.KeySet("org.eclipse.cdt.ui", EMPTY_LIST)};
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";

    public FormatterProfileManager(List<ProfileManager.Profile> profiles, IScopeContext context, PreferencesAccess preferencesAccess, IProfileVersioner profileVersioner) {
        super(FormatterProfileManager.addBuiltinProfiles(profiles, profileVersioner), context, preferencesAccess, profileVersioner, KEY_SETS, PROFILE_KEY, FORMATTER_SETTINGS_VERSION);
    }

    private static List<ProfileManager.Profile> addBuiltinProfiles(List<ProfileManager.Profile> profiles, IProfileVersioner profileVersioner) {
        ProfileManager.BuiltInProfile kandrProfile = new ProfileManager.BuiltInProfile("org.eclipse.cdt.ui.default.kandr_profile", FormatterMessages.ProfileManager_kandr_profile_name, FormatterProfileManager.getKandRSettings(), 2, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(kandrProfile);
        ProfileManager.BuiltInProfile allmanProfile = new ProfileManager.BuiltInProfile(ALLMAN_PROFILE, FormatterMessages.ProfileManager_allman_profile_name, FormatterProfileManager.getAllmanSettings(), 2, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(allmanProfile);
        ProfileManager.BuiltInProfile gnuProfile = new ProfileManager.BuiltInProfile(GNU_PROFILE, FormatterMessages.ProfileManager_gnu_profile_name, FormatterProfileManager.getGNUSettings(), 2, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(gnuProfile);
        ProfileManager.BuiltInProfile whitesmithsProfile = new ProfileManager.BuiltInProfile(WHITESMITHS_PROFILE, FormatterMessages.ProfileManager_whitesmiths_profile_name, FormatterProfileManager.getWhitesmithsSettings(), 2, profileVersioner.getCurrentVersion(), profileVersioner.getProfileKind());
        profiles.add(whitesmithsProfile);
        return profiles;
    }

    public static Map<String, String> getDefaultSettings() {
        return DefaultCodeFormatterConstants.getDefaultSettings();
    }

    public static Map<String, String> getKandRSettings() {
        return DefaultCodeFormatterConstants.getKandRSettings();
    }

    public static Map<String, String> getAllmanSettings() {
        return DefaultCodeFormatterConstants.getAllmanSettings();
    }

    public static Map<String, String> getGNUSettings() {
        return DefaultCodeFormatterConstants.getGNUSettings();
    }

    public static Map<String, String> getWhitesmithsSettings() {
        return DefaultCodeFormatterConstants.getWhitesmithsSettings();
    }

    @Override
    protected String getSelectedProfileId(IScopeContext instanceScope) {
        String profileId = instanceScope.getNode("org.eclipse.cdt.ui").get(PROFILE_KEY, null);
        if (profileId == null) {
            profileId = new DefaultScope().getNode("org.eclipse.cdt.ui").get(PROFILE_KEY, null);
        }
        return profileId;
    }

    @Override
    public ProfileManager.Profile getDefaultProfile() {
        ProfileManager.Profile p = super.getDefaultProfile();
        if (p != null) {
            return p;
        }
        return this.getProfile("org.eclipse.cdt.ui.default.kandr_profile");
    }
}

