/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodData;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoringWizard;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ImplementMethodInputPage
extends UserInputWizardPage {
    private ImplementMethodData data;
    private ImplementMethodRefactoringWizard wizard;
    private ContainerCheckedTreeViewer tree;

    public ImplementMethodInputPage(ImplementMethodData data, ImplementMethodRefactoringWizard implementMethodRefactoringWizard) {
        super(Messages.ImplementMethodInputPage_PageTitle);
        this.setData(data);
        this.wizard = implementMethodRefactoringWizard;
    }

    public boolean canFlipToNextPage() {
        if (this.data.needParameterInput()) {
            return super.canFlipToNextPage();
        }
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.ImplementMethodInputPage_PageTitle);
        this.setMessage(Messages.ImplementMethodInputPage_Header);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        this.createTree(comp);
        this.setControl((Control)comp);
        this.checkPage();
    }

    private void createTree(Composite comp) {
        this.tree = new ContainerCheckedTreeViewer(comp);
        this.tree.setContentProvider((IContentProvider)this.data);
        this.tree.setAutoExpandLevel(2);
        this.tree.setInput((Object)"");
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MethodToImplementConfig config = (MethodToImplementConfig)event.getElement();
                config.setChecked(event.getChecked());
                ImplementMethodInputPage.this.checkPage();
            }
        });
        for (MethodToImplementConfig config : this.data.getMethodsToImplement()) {
            this.tree.setChecked((Object)config, config.isChecked());
        }
    }

    public IWizardPage getNextPage() {
        if (this.data.needParameterInput()) {
            return this.wizard.getPageForConfig(this.data.getFirstConfigNeedingParameterNames());
        }
        return this.computeSuccessorPage();
    }

    public void setData(ImplementMethodData data) {
        this.data = data;
    }

    public ImplementMethodData getData() {
        return this.data;
    }

    private void checkPage() {
        if (this.data.getMethodsToImplement().size() > 0) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }
}

