/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.browser.ASTTypeInfo;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.cdt.internal.ui.search.TypeInfoSearchElement;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public abstract class PDOMSearchQuery
implements ISearchQuery {
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURANCES = 7;
    protected PDOMSearchResult result = new PDOMSearchResult(this);
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;

    protected PDOMSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.scope = scope;
        try {
            if (scope == null) {
                Object[] allProjects = CoreModel.getDefault().getCModel().getCProjects();
                int i = 0;
                while (i < allProjects.length) {
                    if (!allProjects[i].isOpen()) {
                        allProjects[i] = null;
                    }
                    ++i;
                }
                this.projects = (ICProject[])ArrayUtil.removeNulls(ICProject.class, (Object[])allProjects);
            } else {
                HashMap<String, ICProject> projectMap = new HashMap<String, ICProject>();
                int i = 0;
                while (i < scope.length) {
                    ICProject project = scope[i].getCProject();
                    if (project != null) {
                        projectMap.put(project.getElementName(), project);
                    }
                    ++i;
                }
                this.projects = projectMap.values().toArray(new ICProject[projectMap.size()]);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }

    public String getLabel() {
        String type = (this.flags & 4) != 0 ? CSearchMessages.PDOMSearch_query_refs_label : ((this.flags & 1) != 0 ? CSearchMessages.PDOMSearch_query_decls_label : CSearchMessages.PDOMSearch_query_defs_label);
        return type;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    protected boolean filterName(IIndexName name) {
        return false;
    }

    private void collectNames(IIndex index, IIndexName[] names) throws CoreException {
        IIndexName[] iIndexNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexName name = iIndexNameArray[n2];
            if (!this.filterName(name)) {
                IASTFileLocation loc = name.getFileLocation();
                IIndexBinding binding = index.findBinding((IName)name);
                this.result.addMatch(new PDOMSearchMatch(new TypeInfoSearchElement(index, name, binding), loc.getNodeOffset(), loc.getNodeLength()));
            }
            ++n2;
        }
    }

    protected void createMatches(IIndex index, IBinding binding) throws CoreException {
        if (binding != null) {
            IIndexName[] names = index.findNames(binding, this.flags);
            this.collectNames(index, names);
        }
    }

    protected void createLocalMatches(IASTTranslationUnit ast, IBinding binding) {
        if (binding != null) {
            HashSet<IASTName> names = new HashSet<IASTName>();
            names.addAll(Arrays.asList(ast.getDeclarationsInAST(binding)));
            names.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
            names.addAll(Arrays.asList(ast.getReferences(binding)));
            for (IASTName name : names) {
                ITypeReference ref;
                ASTTypeInfo typeInfo;
                if (!((this.flags & 1) != 0 && name.isDeclaration() || (this.flags & 2) != 0 && name.isDefinition()) && ((this.flags & 4) == 0 || !name.isReference()) || (typeInfo = ASTTypeInfo.create((IASTName)name)) == null || (ref = typeInfo.getResolvedReference()) == null) continue;
                this.result.addMatch(new PDOMSearchMatch(new TypeInfoSearchElement(typeInfo), ref.getOffset(), ref.getLength()));
            }
        }
    }

    public final IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        IStatus iStatus;
        PDOMSearchResult result = (PDOMSearchResult)this.getSearchResult();
        result.removeAll();
        result.setIndexerBusy(!CCorePlugin.getIndexManager().isIndexerIdle());
        IIndex index = CCorePlugin.getIndexManager().getIndex(this.projects, 0);
        try {
            index.acquireReadLock();
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        try {
            iStatus = this.runWithIndex(index, monitor);
        }
        catch (Throwable throwable) {
            try {
                index.releaseReadLock();
                throw throwable;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        index.releaseReadLock();
        return iStatus;
    }

    protected abstract IStatus runWithIndex(IIndex var1, IProgressMonitor var2);

    public ICProject[] getProjects() {
        return this.projects;
    }

    public String getScopeDescription() {
        StringBuilder buf = new StringBuilder();
        switch (this.scope.length) {
            case 0: {
                break;
            }
            case 1: {
                buf.append(this.scope[0].getElementName());
                break;
            }
            case 2: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                break;
            }
            default: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                buf.append(", ...");
            }
        }
        return buf.toString();
    }
}

