/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.BackingStoreException;

class EclipsePreferencesAdapter
implements IPreferenceStore {
    private ListenerList fListeners = new ListenerList(1);
    private IEclipsePreferences.IPreferenceChangeListener fListener = new PreferenceChangeListener();
    private final IScopeContext fContext;
    private final String fQualifier;

    public EclipsePreferencesAdapter(IScopeContext context, String qualifier) {
        this.fContext = context;
        this.fQualifier = qualifier;
    }

    private IEclipsePreferences getNode() {
        return this.fContext.getNode(this.fQualifier);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.fListeners.size() == 0) {
            this.getNode().addPreferenceChangeListener(this.fListener);
        }
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.size() == 0) {
            this.getNode().removePreferenceChangeListener(this.fListener);
        }
    }

    public boolean contains(String name) {
        return this.getNode().get(name, null) != null;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    public boolean getBoolean(String name) {
        return this.getNode().getBoolean(name, false);
    }

    public boolean getDefaultBoolean(String name) {
        return false;
    }

    public double getDefaultDouble(String name) {
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        return 0;
    }

    public long getDefaultLong(String name) {
        return 0L;
    }

    public String getDefaultString(String name) {
        return "";
    }

    public double getDouble(String name) {
        return this.getNode().getDouble(name, 0.0);
    }

    public float getFloat(String name) {
        return this.getNode().getFloat(name, 0.0f);
    }

    public int getInt(String name) {
        return this.getNode().getInt(name, 0);
    }

    public long getLong(String name) {
        return this.getNode().getLong(name, 0L);
    }

    public String getString(String name) {
        return this.getNode().get(name, "");
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        try {
            return this.getNode().keys().length > 0;
        }
        catch (BackingStoreException backingStoreException) {
            return true;
        }
    }

    public void putValue(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, double value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, float value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, int value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, long value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, String defaultObject) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setToDefault(String name) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, double value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, float value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, int value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, long value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, boolean value) {
        throw new UnsupportedOperationException();
    }

    private class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceChangeListener() {
        }

        public void preferenceChange(final IEclipsePreferences.PreferenceChangeEvent event) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                    }
                });
            } else {
                EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
            }
        }
    }
}

