/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchUnresolvedIncludesQuery;
import org.eclipse.cdt.internal.ui.util.StatusLineHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

public class FindUnresolvedIncludesProjectAction
implements IObjectActionDelegate {
    private ISelection fSelection;
    private IWorkbenchSite fSite;

    public void run(IAction action) {
        ArrayList<ICProject> projects = new ArrayList<ICProject>();
        IStructuredSelection cElements = SelectionConverter.convertSelectionToCElements(this.fSelection);
        for (Object elem : cElements) {
            if (!(elem instanceof ICProject)) continue;
            projects.add((ICProject)elem);
        }
        if (projects.isEmpty()) {
            StatusLineHandler.showStatusLineMessage(this.fSite, CSearchMessages.CSearchOperation_operationUnavailable_message);
            return;
        }
        PDOMSearchUnresolvedIncludesQuery searchJob = new PDOMSearchUnresolvedIncludesQuery((ICElement[])projects.toArray(new ICProject[projects.size()]));
        StatusLineHandler.clearStatusLine(this.fSite);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)searchJob);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }
}

