/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.corext.template.c.ExclusivePositionUpdater;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.editor.IndentUtil;
import org.eclipse.cdt.internal.ui.text.FastCPartitionScanner;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CFormatter {
    private static final String COMMENT_START = "/*-";
    private static final String COMMENT_END = "*/";
    private final String fLineDelimiter;
    private final int fInitialIndentLevel;
    private boolean fUseCodeFormatter;
    private final ICProject fProject;

    public CFormatter(String lineDelimiter, int initialIndentLevel, boolean useCodeFormatter, ICProject project) {
        this.fLineDelimiter = lineDelimiter;
        this.fUseCodeFormatter = useCodeFormatter;
        this.fInitialIndentLevel = initialIndentLevel;
        this.fProject = project;
    }

    public void format(TemplateBuffer buffer, TemplateContext context) throws BadLocationException {
        try {
            VariableTracker tracker = new VariableTracker(buffer);
            IDocument document = tracker.getDocument();
            this.internalFormat(document, context, buffer);
            this.convertLineDelimiters(document);
            if (this.isReplacedAreaEmpty(context)) {
                this.trimStart(document);
            }
            tracker.updateBuffer();
        }
        catch (MalformedTreeException malformedTreeException) {
            throw new BadLocationException();
        }
    }

    private void internalFormat(IDocument document, TemplateContext context, TemplateBuffer buffer) throws BadLocationException {
        if (this.fUseCodeFormatter) {
            try {
                this.format(document);
                return;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (MalformedTreeException malformedTreeException) {}
        }
        this.indent(document, buffer);
    }

    private void convertLineDelimiters(IDocument document) throws BadLocationException {
        int lines = document.getNumberOfLines();
        int line = 0;
        while (line < lines) {
            IRegion region = document.getLineInformation(line);
            String lineDelimiter = document.getLineDelimiter(line);
            if (lineDelimiter != null) {
                document.replace(region.getOffset() + region.getLength(), lineDelimiter.length(), this.fLineDelimiter);
            }
            ++line;
        }
    }

    private void trimStart(IDocument document) throws BadLocationException {
        this.trimAtOffset(0, document);
    }

    private String trimAtOffset(int offset, IDocument document) throws BadLocationException {
        int i = offset;
        while (i < document.getLength() && Character.isWhitespace(document.getChar(i))) {
            ++i;
        }
        String trim = document.get(offset, i - offset);
        document.replace(offset, i - offset, "");
        return trim;
    }

    private boolean isReplacedAreaEmpty(TemplateContext context) {
        if (context instanceof DocumentTemplateContext) {
            DocumentTemplateContext dtc = (DocumentTemplateContext)context;
            if (dtc.getCompletionLength() == 0) {
                return true;
            }
            try {
                if (dtc.getDocument().get(dtc.getStart(), dtc.getEnd() - dtc.getStart()).trim().length() == 0) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    private void format(IDocument doc) throws BadLocationException {
        Map options = this.fProject != null ? this.fProject.getOptions(true) : CCorePlugin.getOptions();
        TextEdit edit = CodeFormatterUtil.format(0, doc.get(), this.fInitialIndentLevel, this.fLineDelimiter, options);
        if (edit == null) {
            throw new BadLocationException();
        }
        edit.apply(doc, 2);
    }

    private void indent(IDocument document, TemplateBuffer buffer) throws BadLocationException, MalformedTreeException {
        this.prefixSelectionLines(document, buffer);
        this.adjustIndentation(document);
    }

    private void adjustIndentation(IDocument document) throws BadLocationException {
        int lines = document.getNumberOfLines();
        if (lines == 0) {
            return;
        }
        String option = this.fProject == null ? CCorePlugin.getOption((String)"org.eclipse.cdt.core.formatter.tabulation.char") : this.fProject.getOption("org.eclipse.cdt.core.formatter.tabulation.char", true);
        boolean useSpaces = "space".equals(option);
        int indentWidth = CodeFormatterUtil.getIndentWidth(this.fProject);
        int tabWidth = CodeFormatterUtil.getTabWidth(this.fProject);
        int line = 0;
        while (line < lines) {
            IRegion lineRegion = document.getLineInformation(line);
            String indent = IndentUtil.getCurrentIndent(document, line, false);
            int tabs = 0;
            int i = 0;
            while (i < indent.length()) {
                if (indent.charAt(i) != '\t') break;
                ++tabs;
                ++i;
            }
            int totalIndentWidth = (this.fInitialIndentLevel + tabs) * indentWidth + IndentUtil.computeVisualLength(indent.substring(tabs), tabWidth);
            String newIndent = IndentUtil.changePrefix("", totalIndentWidth, tabWidth, useSpaces);
            document.replace(lineRegion.getOffset(), indent.length(), newIndent);
            ++line;
        }
    }

    private void prefixSelectionLines(IDocument document, TemplateBuffer buffer) {
        TemplateVariable[] variables = buffer.getVariables();
        int i = 0;
        block2: while (i < variables.length) {
            if (variables[i].getName().equals("line_selection")) {
                if (variables[i].getLength() <= 0) break;
                int tabWidth = CodeFormatterUtil.getTabWidth(this.fProject);
                int delta = 0;
                int[] offsets = variables[i].getOffsets();
                int j = 0;
                while (j < offsets.length) {
                    block6: {
                        int offset = offsets[j] + delta;
                        try {
                            int startLine = document.getLineOfOffset(offset);
                            int startOffset = document.getLineOffset(startLine);
                            int endLine = document.getLineOfOffset(offset + variables[i].getLength() - 1);
                            String prefix = document.get(startOffset, offset - startOffset);
                            String shift = this.trimAtOffset(offset, document);
                            delta -= shift.length();
                            if (startLine >= endLine) break block6;
                            int shiftWidth = IndentUtil.computeVisualLength(shift, tabWidth);
                            int line = startLine + 1;
                            while (line <= endLine) {
                                String currentIndent = IndentUtil.getCurrentIndent(document, line, false);
                                int indentWidth = IndentUtil.computeVisualLength(currentIndent, tabWidth);
                                int newIndentWidth = Math.max(0, indentWidth - shiftWidth);
                                String newIndent = IndentUtil.changePrefix(prefix, prefix.length() + newIndentWidth, 1, true);
                                int lineOffset = document.getLineOffset(line);
                                document.replace(lineOffset, currentIndent.length(), newIndent);
                                delta -= currentIndent.length();
                                delta += newIndent.length();
                                ++line;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            break block2;
                        }
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class VariableTracker {
        private static final String CATEGORY = "__template_variables";
        private Document fDocument;
        private final TemplateBuffer fBuffer;
        private List<TypedPosition> fPositions;

        public VariableTracker(TemplateBuffer buffer) throws MalformedTreeException, BadLocationException {
            Assert.isLegal((buffer != null ? 1 : 0) != 0);
            this.fBuffer = buffer;
            this.fDocument = new Document(this.fBuffer.getString());
            VariableTracker.installCStuff(this.fDocument);
            this.fDocument.addPositionCategory(CATEGORY);
            this.fDocument.addPositionUpdater((IPositionUpdater)new ExclusivePositionUpdater(CATEGORY));
            this.fPositions = this.createRangeMarkers(this.fBuffer.getVariables(), (IDocument)this.fDocument);
        }

        private static void installCStuff(Document document) {
            String[] types = new String[]{"__c_multiline_comment", "__c_singleline_comment", "__c_string", "__c_character", "__c_preprocessor", "__dftl_partition_content_type"};
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new FastCPartitionScanner(), types);
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner("___c_partitioning", (IDocumentPartitioner)partitioner);
        }

        public IDocument getDocument() {
            this.checkState();
            return this.fDocument;
        }

        private void checkState() {
            if (this.fDocument == null) {
                throw new IllegalStateException();
            }
        }

        public TemplateBuffer updateBuffer() throws MalformedTreeException, BadLocationException {
            this.checkState();
            TemplateVariable[] variables = this.fBuffer.getVariables();
            try {
                this.removeRangeMarkers(this.fPositions, (IDocument)this.fDocument, variables);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
            this.fBuffer.setContent(this.fDocument.get(), variables);
            this.fDocument = null;
            return this.fBuffer;
        }

        private List<TypedPosition> createRangeMarkers(TemplateVariable[] variables, IDocument document) throws MalformedTreeException, BadLocationException {
            HashMap<ReplaceEdit, String> markerToOriginal = new HashMap<ReplaceEdit, String>();
            MultiTextEdit root = new MultiTextEdit(0, document.getLength());
            ArrayList<Object> edits = new ArrayList<Object>();
            boolean hasModifications = false;
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                int[] nArray = variable.getOffsets();
                String value = variable.getDefaultValue();
                if (this.isWhitespaceVariable(value)) {
                    String placeholder = CFormatter.COMMENT_START + value + CFormatter.COMMENT_END;
                    int j = 0;
                    while (j != nArray.length) {
                        ReplaceEdit replace = new ReplaceEdit(nArray[j], value.length(), placeholder);
                        root.addChild((TextEdit)replace);
                        hasModifications = true;
                        markerToOriginal.put(replace, value);
                        edits.add(replace);
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j != nArray.length) {
                        RangeMarker marker = new RangeMarker(nArray[j], value.length());
                        root.addChild((TextEdit)marker);
                        edits.add(marker);
                        ++j;
                    }
                }
                ++i;
            }
            if (hasModifications) {
                root.apply(document, 2);
            }
            ArrayList<TypedPosition> positions = new ArrayList<TypedPosition>();
            for (TextEdit textEdit : edits) {
                try {
                    TypedPosition pos = new TypedPosition(textEdit.getOffset(), textEdit.getLength(), (String)markerToOriginal.get(textEdit));
                    document.addPosition(CATEGORY, (Position)pos);
                    positions.add(pos);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    Assert.isTrue((boolean)false);
                }
            }
            return positions;
        }

        private boolean isWhitespaceVariable(String value) {
            int length = value.length();
            return length == 0 || value.trim().length() == 0;
        }

        private void removeRangeMarkers(List<TypedPosition> positions, IDocument document, TemplateVariable[] variables) throws MalformedTreeException, BadLocationException, BadPositionCategoryException {
            for (TypedPosition position : positions) {
                document.removePosition(CATEGORY, (Position)position);
                String original = position.getType();
                if (original != null) {
                    document.replace(position.getOffset(), position.getLength(), original);
                    position.setLength(original.length());
                }
                document.addPosition((Position)position);
            }
            Iterator<TypedPosition> it = positions.iterator();
            int i = 0;
            while (i != variables.length) {
                TemplateVariable variable = variables[i];
                int[] offsets = new int[variable.getOffsets().length];
                int j = 0;
                while (j != offsets.length) {
                    offsets[j] = it.next().getOffset();
                    ++j;
                }
                variable.setOffsets(offsets);
                ++i;
            }
        }
    }
}

