/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text.doctools.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICompletionProposalComputer;
import org.eclipse.cdt.ui.text.doctools.generic.GenericDocTag;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTagCompletionProposalComputer
implements ICompletionProposalComputer {
    protected GenericDocTag[] tags;
    protected char[] tagMarkers;

    public GenericTagCompletionProposalComputer(GenericDocTag[] tags, char[] tagMarkers) {
        this.tags = tags;
        this.tagMarkers = tagMarkers;
    }

    protected boolean isTagMarker(char c) {
        char[] cArray = this.tagMarkers;
        int n = this.tagMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            char candidate = cArray[n2];
            if (c == candidate) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IDocument doc = context.getDocument();
        int ivcOffset = context.getInvocationOffset();
        try {
            ITypedRegion tr = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)ivcOffset, (boolean)false);
            int firstNonWS = ivcOffset;
            while (firstNonWS - 1 > tr.getOffset() && !Character.isWhitespace(doc.get(firstNonWS - 1, 1).charAt(0))) {
                --firstNonWS;
            }
            String prefix = doc.get(firstNonWS, ivcOffset - firstNonWS);
            if (prefix.length() > 0 && this.isTagMarker(prefix.charAt(0))) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                char tagMarker = prefix.charAt(0);
                GenericDocTag[] genericDocTagArray = this.tags;
                int n = this.tags.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericDocTag tag2 = genericDocTagArray[n2];
                    String tag = tag2.getTagName();
                    if (tag.toLowerCase().startsWith(prefix.substring(1).toLowerCase())) {
                        CCompletionProposal proposal = new CCompletionProposal(String.valueOf(tagMarker) + tag, ivcOffset - prefix.length(), prefix.length(), null, String.valueOf(tagMarker) + tag, 1, context.getViewer());
                        String description = tag2.getTagDescription();
                        if (description != null && description.length() > 0) {
                            proposal.setAdditionalProposalInfo(description);
                        }
                        proposals.add(proposal);
                    }
                    ++n2;
                }
                return proposals;
            }
        }
        catch (BadLocationException badLocationException) {}
        return Collections.emptyList();
    }

    @Override
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void sessionEnded() {
    }

    @Override
    public void sessionStarted() {
    }
}

