/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.upc.ast;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.upc.ast.IUPCASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTCompositeTypeSpecifier;

public class UPCASTCompositeTypeSpecifier
extends CASTCompositeTypeSpecifier
implements IUPCASTCompositeTypeSpecifier {
    private int referenceType;
    private int sharedQualifier;
    private IASTExpression blockSizeExpression;

    public UPCASTCompositeTypeSpecifier() {
    }

    public UPCASTCompositeTypeSpecifier(int key, IASTName name) {
        super(key, name);
    }

    public UPCASTCompositeTypeSpecifier(int key, IASTName name, IASTExpression blockSizeExpression) {
        super(key, name);
        this.setBlockSizeExpression(blockSizeExpression);
    }

    public IASTExpression getBlockSizeExpression() {
        return this.blockSizeExpression;
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public int getSharedQualifier() {
        return this.sharedQualifier;
    }

    public void setBlockSizeExpression(IASTExpression expr) {
        this.blockSizeExpression = expr;
        if (expr != null) {
            expr.setParent((IASTNode)this);
            expr.setPropertyInParent(BLOCK_SIZE_EXPRESSION);
        }
    }

    public void setReferenceType(int referenceType) {
        this.referenceType = referenceType;
    }

    public void setSharedQualifier(int shared) {
        this.sharedQualifier = shared;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.visit((IASTDeclSpecifier)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.getName() != null && !this.getName().accept(action)) {
            return false;
        }
        if (this.blockSizeExpression != null && !this.blockSizeExpression.accept(action)) {
            return false;
        }
        IASTDeclaration[] decls = this.getMembers();
        int i = 0;
        while (i < decls.length) {
            if (!decls[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitDeclSpecifiers) {
            switch (action.leave((IASTDeclSpecifier)this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

