/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.cdtvariables.CdtVariable;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;

public class EclipseVariablesVariableSupplier
implements ICdtVariableSupplier {
    private static final char COLON = ':';
    private static EclipseVariablesVariableSupplier fInstance;

    private EclipseVariablesVariableSupplier() {
    }

    public static EclipseVariablesVariableSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new EclipseVariablesVariableSupplier();
        }
        return fInstance;
    }

    public ICdtVariable getVariable(String macroName, IVariableContextInfo info) {
        return this.getVariable(macroName);
    }

    public ICdtVariable getVariable(String macroName) {
        IStringVariableManager mngr;
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        String varName = null;
        String param = null;
        IValueVariable var = null;
        int index = macroName.indexOf(58);
        if (index == -1) {
            varName = macroName;
        } else if (index > 0) {
            varName = macroName.substring(0, index);
            param = macroName.substring(index + 1);
        }
        if (varName != null && (var = (mngr = VariablesPlugin.getDefault().getStringVariableManager()).getValueVariable(varName)) == null) {
            var = mngr.getDynamicVariable(varName);
        }
        if (var != null) {
            return new EclipseVarMacro((IStringVariable)var, param);
        }
        return null;
    }

    public ICdtVariable[] getVariables(IVariableContextInfo info) {
        return this.getVariables();
    }

    public ICdtVariable[] getVariables() {
        IValueVariable[] valVars;
        IStringVariableManager mngr = VariablesPlugin.getDefault().getStringVariableManager();
        IDynamicVariable[] vars = mngr.getDynamicVariables();
        HashMap<String, Object> map = new HashMap<String, Object>();
        IDynamicVariable[] iDynamicVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IDynamicVariable var = iDynamicVariableArray[n2];
            map.put(var.getName(), var);
            ++n2;
        }
        IValueVariable[] iValueVariableArray = valVars = mngr.getValueVariables();
        int n3 = valVars.length;
        n = 0;
        while (n < n3) {
            IValueVariable valVar = iValueVariableArray[n];
            map.put(valVar.getName(), valVar);
            ++n;
        }
        Collection collection = map.values();
        ICdtVariable[] macros = new EclipseVarMacro[collection.size()];
        Iterator iter = collection.iterator();
        int i = 0;
        while (i < macros.length) {
            macros[i] = new EclipseVarMacro((IStringVariable)iter.next());
            ++i;
        }
        return macros;
    }

    public class EclipseVarMacro
    extends CdtVariable {
        private IStringVariable fVariable;
        private String fArgument;
        private boolean fInitialized;

        private EclipseVarMacro(IStringVariable var) {
            this(var, (String)null);
        }

        private EclipseVarMacro(IStringVariable var, String argument) {
            this.fVariable = var;
            this.fType = 1;
            this.fName = var.getName();
            if (argument != null) {
                this.fName = String.valueOf(this.fName) + ':' + argument;
            }
            this.fArgument = argument;
        }

        public String getStringValue() throws CdtVariableException {
            if (!this.fInitialized) {
                this.loadValue(this.fVariable);
                this.fInitialized = true;
            }
            return this.fStringValue;
        }

        private void loadValue(IStringVariable var) {
            if (var instanceof IDynamicVariable) {
                IDynamicVariable dynamicVar = (IDynamicVariable)var;
                if (this.fArgument == null || dynamicVar.supportsArgument()) {
                    try {
                        this.fStringValue = dynamicVar.getValue(this.fArgument);
                    }
                    catch (CoreException coreException) {
                        this.fStringValue = null;
                    }
                } else {
                    this.fStringValue = null;
                }
            } else if (var instanceof IValueVariable) {
                this.fStringValue = this.fArgument == null ? ((IValueVariable)var).getValue() : null;
            }
        }

        public IStringVariable getVariable() {
            return this.fVariable;
        }
    }
}

