/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CScope
implements ICScope,
IASTInternalScope {
    public static final int NAMESPACE_TYPE_TAG = 0;
    public static final int NAMESPACE_TYPE_OTHER = 1;
    public static final int NAMESPACE_TYPE_BOTH = 2;
    private static final IndexFilter[] INDEX_FILTERS = new IndexFilter[]{new IndexFilter(){

        public boolean acceptBinding(IBinding binding) throws CoreException {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptBinding(binding) && (binding instanceof ICompositeType || binding instanceof IEnumeration);
        }

        public boolean acceptLinkage(ILinkage linkage) {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptLinkage(linkage);
        }
    }, new IndexFilter(){

        public boolean acceptBinding(IBinding binding) throws CoreException {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptBinding(binding) && !(binding instanceof ICompositeType) && !(binding instanceof IEnumeration);
        }

        public boolean acceptLinkage(ILinkage linkage) {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptLinkage(linkage);
        }
    }, IndexFilter.C_DECLARED_OR_IMPLICIT};
    private IASTNode physicalNode = null;
    private boolean isFullyCached = false;
    private CharArrayObjectMap[] mapsToNameOrBinding = new CharArrayObjectMap[]{CharArrayObjectMap.EMPTY_MAP, CharArrayObjectMap.EMPTY_MAP};
    private ObjectMap reuseBindings = null;

    public CScope(IASTNode physical) {
        this.physicalNode = physical;
    }

    public IScope getParent() {
        return CVisitor.getContainingScope(this.physicalNode);
    }

    public IBinding[] find(String name) throws DOMException {
        return CVisitor.findBindings(this, name, false);
    }

    public IBinding getBinding(int namespaceType, char[] name) {
        Object o = this.mapsToNameOrBinding[namespaceType].get(name);
        if (o instanceof IBinding) {
            return (IBinding)o;
        }
        if (o instanceof IASTName) {
            return ((IASTName)o).resolveBinding();
        }
        return null;
    }

    public void removeBinding(IBinding binding) {
        Object o;
        int type = binding instanceof ICompositeType || binding instanceof IEnumeration ? 0 : 1;
        CharArrayObjectMap bindingsMap = this.mapsToNameOrBinding[type];
        if (bindingsMap != CharArrayObjectMap.EMPTY_MAP && (o = bindingsMap.remove(binding.getNameCharArray(), 0, binding.getNameCharArray().length)) != null && this.reuseBindings != null) {
            this.reuseBindings.remove(o);
        }
        this.isFullyCached = false;
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) {
        char[] n;
        Object current;
        int type = this.getNamespaceType(name);
        CharArrayObjectMap map = this.mapsToNameOrBinding[type];
        if (map == CharArrayObjectMap.EMPTY_MAP) {
            map = this.mapsToNameOrBinding[type] = new CharArrayObjectMap(1);
        }
        if ((current = map.get(n = name.toCharArray())) instanceof IASTName) {
            CASTName currentName = (CASTName)current;
            if (currentName.getOffset() <= ((CASTName)name).getOffset()) {
                return;
            }
            if (name.getBinding() == null) {
                IBinding reuseBinding = currentName.getBinding();
                if (reuseBinding == null && this.reuseBindings != null) {
                    reuseBinding = (IBinding)this.reuseBindings.get(currentName);
                }
                if (reuseBinding != null) {
                    if (this.reuseBindings == null) {
                        this.reuseBindings = new ObjectMap(1);
                    }
                    this.reuseBindings.put(name, reuseBinding);
                    this.reuseBindings.remove(currentName);
                }
            }
        }
        map.put(n, name);
    }

    private int getNamespaceType(IASTName name) {
        ASTNodeProperty prop = name.getPropertyInParent();
        if (prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTEnumerationSpecifier.ENUMERATION_NAME || prop == CVisitor.STRING_LOOKUP_TAGS_PROPERTY) {
            return 0;
        }
        return 1;
    }

    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) throws DOMException {
        return this.getBindings(name, resolve, prefix, IIndexFileSet.EMPTY);
    }

    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        IASTTranslationUnit tu;
        IIndex index;
        char[] c = name.toCharArray();
        if (c.length == 0) {
            return null;
        }
        int type = this.getNamespaceType(name);
        Object o = this.mapsToNameOrBinding[type].get(name.toCharArray());
        if (o instanceof IBinding) {
            return (IBinding)o;
        }
        if (o instanceof IASTName) {
            IASTName n = (IASTName)o;
            if (!this.isTypeDefinition(name) || CVisitor.declaredBefore(n, name)) {
                IBinding b = n.getBinding();
                if (b != null) {
                    return b;
                }
                if (this.reuseBindings != null && (b = (IBinding)this.reuseBindings.get(n)) != null) {
                    return b;
                }
                if (resolve && n != name) {
                    return n.resolveBinding();
                }
            }
        }
        IBinding result = null;
        if (this.physicalNode instanceof IASTTranslationUnit && (index = (tu = (IASTTranslationUnit)this.physicalNode).getIndex()) != null) {
            try {
                IBinding[] bindings = index.findBindings(name.toCharArray(), INDEX_FILTERS[type], (IProgressMonitor)new NullProgressMonitor());
                if (fileSet != null) {
                    bindings = fileSet.filterFileLocalBindings(bindings);
                }
                result = this.processIndexResults(name, bindings);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        }
        return result;
    }

    private boolean isTypeDefinition(IASTName name) {
        if (name.getPropertyInParent() == IASTNamedTypeSpecifier.NAME) {
            return true;
        }
        IASTNode parent = name.getParent();
        while (parent != null) {
            if (parent instanceof IASTUnaryExpression ? ((IASTUnaryExpression)parent).getOperator() == 14 : parent instanceof IASTTypeIdExpression && ((IASTTypeIdExpression)parent).getOperator() == 3) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        IASTTranslationUnit tu;
        IIndex index;
        char[] c = name.toCharArray();
        Object[] obj = null;
        CharArrayObjectMap[] charArrayObjectMapArray = this.mapsToNameOrBinding;
        int n = this.mapsToNameOrBinding.length;
        int n2 = 0;
        while (n2 < n) {
            CharArrayObjectMap map = charArrayObjectMapArray[n2];
            if (prefixLookup) {
                Object[] keys;
                Object[] objectArray = keys = map.keyArray();
                int n3 = keys.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object key2 = objectArray[n4];
                    char[] key = (char[])key2;
                    if (CharArrayUtils.equals(key, 0, c.length, c, true)) {
                        obj = ArrayUtil.append(obj, map.get(key));
                    }
                    ++n4;
                }
            } else {
                obj = ArrayUtil.append(obj, map.get(c));
            }
            ++n2;
        }
        if (this.physicalNode instanceof IASTTranslationUnit && (index = (tu = (IASTTranslationUnit)this.physicalNode).getIndex()) != null) {
            try {
                Object[] bindings;
                Object[] objectArray = bindings = prefixLookup ? index.findBindingsForPrefix(name.toCharArray(), true, INDEX_FILTERS[2], null) : index.findBindings(name.toCharArray(), INDEX_FILTERS[2], null);
                if (fileSet != null) {
                    bindings = fileSet.filterFileLocalBindings((IBinding[])bindings);
                }
                obj = ArrayUtil.addAll(Object.class, obj, bindings);
            }
            catch (CoreException ce) {
                CCorePlugin.log(ce);
            }
        }
        obj = ArrayUtil.trim(Object.class, obj);
        Object[] result = null;
        Object[] objectArray = obj;
        int n5 = obj.length;
        n = 0;
        while (n < n5) {
            Object element = objectArray[n];
            if (element instanceof IBinding) {
                result = (IBinding[])ArrayUtil.append(IBinding.class, result, element);
            } else if (element instanceof IASTName) {
                IASTName n6 = (IASTName)element;
                IBinding b = n6.getBinding();
                if (b == null) {
                    if (this.reuseBindings != null) {
                        b = (IBinding)this.reuseBindings.get(n6);
                    }
                    if (resolve && b == null && n6 != name) {
                        b = n6.resolveBinding();
                    }
                }
                if (b != null) {
                    result = (IBinding[])ArrayUtil.append(IBinding.class, result, b);
                }
            }
            ++n;
        }
        return (IBinding[])ArrayUtil.trim(IBinding.class, result);
    }

    private IBinding processIndexResults(IASTName name, IBinding[] bindings) {
        if (bindings.length != 1) {
            return null;
        }
        return bindings[0];
    }

    public void setFullyCached(boolean b) {
        this.isFullyCached = b;
    }

    public boolean isFullyCached() {
        return this.isFullyCached;
    }

    public IName getScopeName() {
        if (this.physicalNode instanceof IASTCompositeTypeSpecifier) {
            return ((IASTCompositeTypeSpecifier)this.physicalNode).getName();
        }
        return null;
    }

    public void flushCache() {
        Object obj;
        CharArrayObjectMap map = this.mapsToNameOrBinding[0];
        CharArrayObjectMap builtins = null;
        int i = 0;
        while (i < map.size()) {
            obj = map.getAt(i);
            if (obj instanceof IASTName) {
                ((IASTName)obj).setBinding(null);
            } else if (obj instanceof IBinding) {
                if (builtins == null) {
                    builtins = new CharArrayObjectMap(2);
                }
                builtins.put(((IBinding)obj).getNameCharArray(), obj);
            }
            ++i;
        }
        this.mapsToNameOrBinding[0] = builtins == null ? CharArrayObjectMap.EMPTY_MAP : builtins;
        map = this.mapsToNameOrBinding[1];
        builtins = null;
        i = 0;
        while (i < map.size()) {
            obj = map.getAt(i);
            if (obj instanceof IASTName) {
                ((IASTName)obj).setBinding(null);
            } else if (obj instanceof IBinding) {
                if (builtins == null) {
                    builtins = new CharArrayObjectMap(2);
                }
                builtins.put(((IBinding)obj).getNameCharArray(), obj);
            }
            ++i;
        }
        this.mapsToNameOrBinding[1] = builtins == null ? CharArrayObjectMap.EMPTY_MAP : builtins;
        this.reuseBindings = null;
        this.isFullyCached = false;
    }

    public void addBinding(IBinding binding) {
        CharArrayObjectMap map;
        int type = 1;
        if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
            type = 0;
        }
        if ((map = this.mapsToNameOrBinding[type]) == CharArrayObjectMap.EMPTY_MAP) {
            map = this.mapsToNameOrBinding[type] = new CharArrayObjectMap(2);
        }
        map.put(binding.getNameCharArray(), binding);
    }

    protected static class CollectNamesAction
    extends CASTVisitor {
        private char[] name;
        private IASTName[] result = null;

        CollectNamesAction(char[] n) {
            this.name = n;
            this.shouldVisitNames = true;
        }

        public int visit(IASTName n) {
            ASTNodeProperty prop = n.getPropertyInParent();
            if ((prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTDeclarator.DECLARATOR_NAME) && CharArrayUtils.equals(n.toCharArray(), this.name)) {
                this.result = (IASTName[])ArrayUtil.append(IASTName.class, this.result, n);
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTDeclarationStatement) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNames() {
            return (IASTName[])ArrayUtil.trim(IASTName.class, this.result);
        }
    }
}

