/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IPathEntryContainerExtension;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.PathEntryContainerChanged;
import org.eclipse.cdt.core.model.PathEntryContainerInitializer;
import org.eclipse.cdt.core.resources.IPathEntryStore;
import org.eclipse.cdt.core.resources.IPathEntryStoreListener;
import org.eclipse.cdt.core.resources.PathEntryStoreChangedEvent;
import org.eclipse.cdt.core.settings.model.util.PathEntryResolveInfo;
import org.eclipse.cdt.core.settings.model.util.PathEntryResolveInfoElement;
import org.eclipse.cdt.core.settings.model.util.ThreadLocalMap;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.PathEntryContainerUpdatesOperation;
import org.eclipse.cdt.internal.core.model.PathEntryStoreChangedOperation;
import org.eclipse.cdt.internal.core.model.PathEntryStoreProxy;
import org.eclipse.cdt.internal.core.model.PathEntryUtil;
import org.eclipse.cdt.internal.core.model.SetPathEntriesOperation;
import org.eclipse.cdt.internal.core.model.SetPathEntryContainerOperation;
import org.eclipse.cdt.internal.core.settings.model.AbstractCExtensionProxy;
import org.eclipse.cdt.internal.core.settings.model.ConfigBasedPathEntryStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathEntryManager
implements IPathEntryStoreListener,
IElementChangedListener {
    public static final String PATHENTRY_STORE_ID = "PathEntryStore";
    public static final String PATHENTRY_STORE_UNIQ_ID = "org.eclipse.cdt.core.PathEntryStore";
    static String CONTAINER_INITIALIZER_EXTPOINT_ID = "PathEntryContainerInitializer";
    static final String[] NO_PREREQUISITES = new String[0];
    private static HashMap<ICProject, Map<IPath, IPathEntryContainer>> Containers = new HashMap(5);
    static final IPathEntry[] NO_PATHENTRIES = new IPathEntry[0];
    static final IIncludeEntry[] NO_INCLUDE_ENTRIES = new IIncludeEntry[0];
    static final IIncludeFileEntry[] NO_INCLUDE_FILE_ENTRIES = new IIncludeFileEntry[0];
    static final IMacroEntry[] NO_MACRO_ENTRIES = new IMacroEntry[0];
    static final IMacroFileEntry[] NO_MACRO_FILE_ENTRIES = new IMacroFileEntry[0];
    static final IPathEntryContainer[] NO_PATHENTRYCONTAINERS = new IPathEntryContainer[0];
    protected Map<ICProject, ArrayList<IPathEntry>> resolvedMap = new Hashtable<ICProject, ArrayList<IPathEntry>>();
    private Map<ICProject, PathEntryResolveInfo> resolvedInfoMap = new Hashtable<ICProject, PathEntryResolveInfo>();
    private ThreadLocalMap resolveInfoValidState = new ThreadLocalMap();
    private Map<IProject, IPathEntryStore> storeMap = new HashMap<IProject, IPathEntryStore>();
    private static PathEntryManager pathEntryManager;
    protected ConcurrentLinkedQueue<PathEntryProblem> markerProblems = new ConcurrentLinkedQueue();
    Job markerTask = new GenerateMarkersJob("PathEntry Marker Job");

    private PathEntryManager() {
    }

    public static synchronized PathEntryManager getDefault() {
        if (pathEntryManager == null) {
            pathEntryManager = new PathEntryManager();
            CoreModel.getDefault().addElementChangedListener(pathEntryManager);
        }
        return pathEntryManager;
    }

    public IIncludeFileEntry[] getIncludeFileEntries(IPath resPath) throws CModelException {
        ICElement celement = CoreModel.getDefault().create(resPath);
        if (celement instanceof ITranslationUnit) {
            return this.getIncludeFileEntries((ITranslationUnit)celement);
        }
        if (celement != null) {
            ArrayList<IPathEntry> entryList = new ArrayList<IPathEntry>();
            ICProject cproject = celement.getCProject();
            ArrayList<IPathEntry> resolvedListEntries = this.getResolvedPathEntries(cproject, false);
            IPathEntry[] pathEntries = this.getCachedResolvedPathEntries(resolvedListEntries, cproject);
            int i = 0;
            while (i < pathEntries.length) {
                IPathEntry entry = pathEntries[i];
                if ((entry.getEntryKind() & 0x100) != 0) {
                    entryList.add(entry);
                }
                ++i;
            }
            IIncludeFileEntry[] incFiles = entryList.toArray(new IIncludeFileEntry[entryList.size()]);
            return incFiles;
        }
        return NO_INCLUDE_FILE_ENTRIES;
    }

    public IIncludeFileEntry[] getIncludeFileEntries(ITranslationUnit cunit) throws CModelException {
        List<IPathEntry> list = this.getPathEntries(cunit, 256);
        IIncludeFileEntry[] incFiles = list.toArray(new IIncludeFileEntry[list.size()]);
        return incFiles;
    }

    public IIncludeEntry[] getIncludeEntries(IPath resPath) throws CModelException {
        ICElement celement = CoreModel.getDefault().create(resPath);
        if (celement instanceof ITranslationUnit) {
            return this.getIncludeEntries((ITranslationUnit)celement);
        }
        if (celement != null) {
            ArrayList<IPathEntry> entryList = new ArrayList<IPathEntry>();
            ICProject cproject = celement.getCProject();
            ArrayList<IPathEntry> resolvedListEntries = this.getResolvedPathEntries(cproject, false);
            IPathEntry[] pathEntries = this.getCachedResolvedPathEntries(resolvedListEntries, cproject);
            int i = 0;
            while (i < pathEntries.length) {
                IPathEntry entry = pathEntries[i];
                if ((entry.getEntryKind() & 0x10) != 0) {
                    entryList.add(entry);
                }
                ++i;
            }
            IIncludeEntry[] includes = entryList.toArray(new IIncludeEntry[entryList.size()]);
            return includes;
        }
        return NO_INCLUDE_ENTRIES;
    }

    public IIncludeEntry[] getIncludeEntries(ITranslationUnit cunit) throws CModelException {
        List<IPathEntry> list = this.getPathEntries(cunit, 16);
        IIncludeEntry[] includes = list.toArray(new IIncludeEntry[list.size()]);
        return includes;
    }

    public IMacroEntry[] getMacroEntries(IPath resPath) throws CModelException {
        ICElement celement = CoreModel.getDefault().create(resPath);
        if (celement instanceof ITranslationUnit) {
            return this.getMacroEntries((ITranslationUnit)celement);
        }
        if (celement != null) {
            ArrayList<IPathEntry> entryList = new ArrayList<IPathEntry>();
            ICProject cproject = celement.getCProject();
            ArrayList<IPathEntry> resolvedListEntries = this.getResolvedPathEntries(cproject, false);
            IPathEntry[] pathEntries = this.getCachedResolvedPathEntries(resolvedListEntries, cproject);
            int i = 0;
            while (i < pathEntries.length) {
                IPathEntry entry = pathEntries[i];
                if ((entry.getEntryKind() & 0x40) != 0) {
                    entryList.add(entry);
                }
                ++i;
            }
            IMacroEntry[] macros = entryList.toArray(new IMacroEntry[entryList.size()]);
            return macros;
        }
        return NO_MACRO_ENTRIES;
    }

    private IMacroEntry[] getMacroEntries(ITranslationUnit cunit) throws CModelException {
        ArrayList<IPathEntry> macroList = new ArrayList<IPathEntry>();
        ICProject cproject = cunit.getCProject();
        IPath resPath = cunit.getPath();
        ArrayList<IPathEntry> resolvedListEntries = this.getResolvedPathEntries(cproject, false);
        int i = 0;
        while (i < resolvedListEntries.size()) {
            IPathEntry entry = resolvedListEntries.get(i);
            if (entry.getEntryKind() == 64) {
                macroList.add(entry);
            }
            ++i;
        }
        IPathEntryContainer[] containers = this.getPathEntryContainers(cproject);
        int i2 = 0;
        while (i2 < containers.length) {
            if (containers[i2] instanceof IPathEntryContainerExtension) {
                IPathEntryContainerExtension extension = (IPathEntryContainerExtension)containers[i2];
                IPathEntry[] incs = extension.getPathEntries(resPath, 64);
                macroList.addAll((Collection)Arrays.asList(incs));
            }
            ++i2;
        }
        IMacroEntry[] macros = macroList.toArray(new IMacroEntry[macroList.size()]);
        macroList.clear();
        int count = resPath.segmentCount();
        HashMap<String, IMacroEntry> symbolMap = new HashMap<String, IMacroEntry>();
        int i3 = 0;
        while (i3 < count) {
            IPath newPath = resPath.removeLastSegments(i3);
            IMacroEntry[] iMacroEntryArray = macros;
            int n = macros.length;
            int n2 = 0;
            while (n2 < n) {
                String key;
                IMacroEntry macro = iMacroEntryArray[n2];
                IPath otherPath = macro.getPath();
                if (newPath.equals((Object)otherPath) && !symbolMap.containsKey(key = macro.getMacroName())) {
                    symbolMap.put(key, macro);
                }
                ++n2;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < resolvedListEntries.size()) {
            ICProject refCProject;
            IResource res;
            IPathEntry entry = resolvedListEntries.get(i3);
            if (entry != null && entry.getEntryKind() == 4 && (res = cproject.getCModel().getWorkspace().getRoot().findMember(entry.getPath())) != null && res.getType() == 4 && (refCProject = CoreModel.getDefault().create((IProject)res)) != null) {
                IPathEntry[] projEntries;
                IPathEntry[] iPathEntryArray = projEntries = refCProject.getResolvedPathEntries();
                int n = projEntries.length;
                int n3 = 0;
                while (n3 < n) {
                    IMacroEntry macro;
                    String key;
                    IPathEntry projEntry = iPathEntryArray[n3];
                    if (projEntry.isExported() && projEntry.getEntryKind() == 64 && !symbolMap.containsKey(key = (macro = (IMacroEntry)entry).getMacroName())) {
                        symbolMap.put(key, macro);
                    }
                    ++n3;
                }
            }
            ++i3;
        }
        return symbolMap.values().toArray(NO_MACRO_ENTRIES);
    }

    public IMacroFileEntry[] getMacroFileEntries(IPath resPath) throws CModelException {
        ICElement celement = CoreModel.getDefault().create(resPath);
        if (celement instanceof ITranslationUnit) {
            return this.getMacroFileEntries((ITranslationUnit)celement);
        }
        return NO_MACRO_FILE_ENTRIES;
    }

    public IMacroFileEntry[] getMacroFileEntries(ITranslationUnit cunit) throws CModelException {
        List<IPathEntry> list = this.getPathEntries(cunit, 512);
        IMacroFileEntry[] macFiles = list.toArray(new IMacroFileEntry[list.size()]);
        return macFiles;
    }

    private List<IPathEntry> getPathEntries(ITranslationUnit cunit, int type) throws CModelException {
        ArrayList<IPathEntry> entryList = new ArrayList<IPathEntry>();
        ICProject cproject = cunit.getCProject();
        IPath resPath = cunit.getPath();
        ArrayList<IPathEntry> resolvedListEntries = this.getResolvedPathEntries(cproject, false);
        int i = 0;
        while (i < resolvedListEntries.size()) {
            IPathEntry entry = resolvedListEntries.get(i);
            if ((entry.getEntryKind() & type) != 0) {
                entryList.add(entry);
            }
            ++i;
        }
        IPathEntryContainer[] containers = this.getPathEntryContainers(cproject);
        int i2 = 0;
        while (i2 < containers.length) {
            if (containers[i2] instanceof IPathEntryContainerExtension) {
                IPathEntryContainerExtension extension = (IPathEntryContainerExtension)containers[i2];
                IPathEntry[] incs = extension.getPathEntries(resPath, type);
                entryList.addAll((Collection)Arrays.asList(incs));
            }
            ++i2;
        }
        IPathEntry[] entries = entryList.toArray(new IPathEntry[entryList.size()]);
        entryList.clear();
        int count = resPath.segmentCount();
        int i3 = 0;
        while (i3 < count) {
            IPath newPath = resPath.removeLastSegments(i3);
            IPathEntry[] iPathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry entrie = iPathEntryArray[n2];
                IPath otherPath = entrie.getPath();
                if (newPath.equals((Object)otherPath)) {
                    entryList.add(entrie);
                }
                ++n2;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < resolvedListEntries.size()) {
            ICProject refCProject;
            IResource res;
            IPathEntry entry = resolvedListEntries.get(i3);
            if (entry != null && entry.getEntryKind() == 4 && (res = cproject.getCModel().getWorkspace().getRoot().findMember(entry.getPath())) != null && res.getType() == 4 && (refCProject = CoreModel.getDefault().create((IProject)res)) != null) {
                IPathEntry[] projEntries;
                IPathEntry[] iPathEntryArray = projEntries = refCProject.getResolvedPathEntries();
                int n = projEntries.length;
                int n3 = 0;
                while (n3 < n) {
                    IPathEntry projEntry = iPathEntryArray[n3];
                    if (projEntry.isExported() && (projEntry.getEntryKind() & type) != 0) {
                        entryList.add(projEntry);
                    }
                    ++n3;
                }
            }
            ++i3;
        }
        return entryList;
    }

    protected IPathEntry[] getCachedResolvedPathEntries(ICProject cproject) {
        ArrayList<IPathEntry> resolvedListEntries = this.resolvedMap.get(cproject);
        if (resolvedListEntries != null) {
            try {
                return this.getCachedResolvedPathEntries(resolvedListEntries, cproject);
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    public PathEntryResolveInfo getResolveInfo(ICProject cproject, boolean useCache) throws CModelException {
        Object[] resolved;
        PathEntryResolveInfo info = this.resolvedInfoMap.get(cproject);
        if (info == null && useCache) {
            this.getResolvedPathEntries(cproject);
            info = this.resolvedInfoMap.get(cproject);
        }
        if (!(info != null && useCache && this.getResolveInfoValidState(cproject) || (resolved = this.getResolvedPathEntries(cproject, false, false)) == null)) {
            info = (PathEntryResolveInfo)resolved[1];
        }
        return info;
    }

    private void setResolveInfoValidState(ICProject cproject, boolean valid) {
        Boolean v = valid ? null : Boolean.FALSE;
        this.resolveInfoValidState.set(cproject, v);
    }

    private boolean getResolveInfoValidState(ICProject cproject) {
        return this.resolveInfoValidState.get(cproject) == null;
    }

    protected IPathEntry[] removeCachedResolvedPathEntries(ICProject cproject) {
        ArrayList<IPathEntry> resolvedListEntries = this.resolvedMap.remove(cproject);
        this.resolvedInfoMap.remove(cproject);
        if (resolvedListEntries != null) {
            try {
                return this.getCachedResolvedPathEntries(resolvedListEntries, cproject);
            }
            catch (CModelException cModelException) {}
        }
        return null;
    }

    private IPathEntry[] getCachedResolvedPathEntries(ArrayList<IPathEntry> resolvedListEntries, ICProject cproject) throws CModelException {
        IPathEntry[] entries = resolvedListEntries.toArray(NO_PATHENTRIES);
        boolean hasContainerExtension = false;
        IPathEntry[] iPathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IContainerEntry centry;
            IPathEntryContainer container;
            IPathEntry entrie = iPathEntryArray[n2];
            if (entrie.getEntryKind() == 32 && (container = this.getPathEntryContainer(centry = (IContainerEntry)entrie, cproject)) instanceof IPathEntryContainerExtension) {
                hasContainerExtension = true;
                break;
            }
            ++n2;
        }
        if (hasContainerExtension) {
            IPath projectPath = cproject.getPath();
            ArrayList<IPathEntry> listEntries = new ArrayList<IPathEntry>(entries.length);
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 32) {
                    IPathEntry[] containerEntries;
                    IContainerEntry centry = (IContainerEntry)entries[i];
                    IPathEntryContainer container = this.getPathEntryContainer(centry, cproject);
                    if (container != null && (containerEntries = container.getPathEntries()) != null) {
                        IPathEntry[] iPathEntryArray2 = containerEntries;
                        int n3 = containerEntries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPathEntry containerEntrie = iPathEntryArray2[n4];
                            IPathEntry newEntry = PathEntryUtil.cloneEntryAndExpand(projectPath, containerEntrie);
                            listEntries.add(newEntry);
                            ++n4;
                        }
                    }
                } else {
                    listEntries.add(entries[i]);
                }
                ++i;
            }
            entries = listEntries.toArray(NO_PATHENTRIES);
        }
        return entries;
    }

    public IPathEntry[] getResolvedPathEntries(ICProject cproject) throws CModelException {
        boolean treeLock = cproject.getProject().getWorkspace().isTreeLocked();
        ArrayList<IPathEntry> resolvedListEntries = this.getResolvedPathEntries(cproject, !treeLock);
        return this.getCachedResolvedPathEntries(resolvedListEntries, cproject);
    }

    private ArrayList<IPathEntry> getResolvedPathEntries(ICProject cproject, boolean generateMarkers) throws CModelException {
        Object[] result = this.getResolvedPathEntries(cproject, generateMarkers, true);
        if (result != null) {
            return (ArrayList)result[0];
        }
        return null;
    }

    private Object[] getResolvedPathEntries(ICProject cproject, boolean generateMarkers, boolean useCache) throws CModelException {
        ArrayList<IPathEntry> resolvedEntries = null;
        PathEntryResolveInfo rInfo = null;
        if (useCache) {
            resolvedEntries = this.resolvedMap.get(cproject);
            rInfo = this.resolvedInfoMap.get(cproject);
        }
        if (resolvedEntries == null) {
            List<IPathEntry> dups;
            ArrayList<PathEntryResolveInfoElement> resolveInfoList = new ArrayList<PathEntryResolveInfoElement>();
            IPath projectPath = cproject.getPath();
            IPathEntry[] rawEntries = this.getRawPathEntries(cproject);
            resolvedEntries = new ArrayList();
            IPathEntry[] iPathEntryArray = rawEntries;
            int n = rawEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry entry = iPathEntryArray[n2];
                if (entry.getEntryKind() == 32) {
                    IContainerEntry centry = (IContainerEntry)entry;
                    IPathEntryContainer container = this.getPathEntryContainer(centry, cproject);
                    if (container != null) {
                        if (!(container instanceof IPathEntryContainerExtension)) {
                            IPathEntry[] containerEntries = container.getPathEntries();
                            ArrayList<IPathEntry> resolvedList = new ArrayList<IPathEntry>();
                            if (containerEntries != null) {
                                IPathEntry[] iPathEntryArray2 = containerEntries;
                                int n3 = containerEntries.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IPathEntry containerEntrie = iPathEntryArray2[n4];
                                    IPathEntry newEntry = PathEntryUtil.cloneEntryAndExpand(projectPath, containerEntrie);
                                    resolvedEntries.add(newEntry);
                                    resolvedList.add(newEntry);
                                    ++n4;
                                }
                            }
                            resolveInfoList.add(new PathEntryResolveInfoElement((IPathEntry)centry, resolvedList));
                        } else {
                            IPathEntry resolved = PathEntryUtil.cloneEntryAndExpand(projectPath, entry);
                            resolvedEntries.add(resolved);
                            resolveInfoList.add(new PathEntryResolveInfoElement(entry, resolved));
                        }
                    }
                } else {
                    IPathEntry clone = PathEntryUtil.cloneEntryAndExpand(projectPath, entry);
                    IPathEntry e = PathEntryUtil.getExpandedPathEntry(clone, cproject);
                    if (e != null) {
                        resolvedEntries.add(e);
                    }
                    resolveInfoList.add(new PathEntryResolveInfoElement(entry, e));
                }
                ++n2;
            }
            resolvedEntries.trimToSize();
            if (generateMarkers) {
                IPathEntry[] finalEntries = resolvedEntries.toArray(NO_PATHENTRIES);
                ArrayList<ICModelStatus> problemList = new ArrayList<ICModelStatus>();
                ICModelStatus status = this.validatePathEntry(cproject, finalEntries);
                if (!status.isOK()) {
                    problemList.add(status);
                }
                IPathEntry[] iPathEntryArray3 = finalEntries;
                int n5 = finalEntries.length;
                int clone = 0;
                while (clone < n5) {
                    IPathEntry finalEntrie = iPathEntryArray3[clone];
                    status = PathEntryUtil.validatePathEntry(cproject, finalEntrie, true, false);
                    if (!status.isOK()) {
                        problemList.add(status);
                    }
                    ++clone;
                }
                ICModelStatus[] problems = new ICModelStatus[problemList.size()];
                problemList.toArray(problems);
                IProject project = cproject.getProject();
                if (PathEntryUtil.hasPathEntryProblemMarkersChange(project, problems)) {
                    this.addProblemMarkers(project, problems);
                }
            }
            if ((dups = PathEntryUtil.checkForDuplication(resolvedEntries, 8)).size() > 0) {
                resolvedEntries.removeAll(dups);
            }
            if ((dups = PathEntryUtil.checkForDuplication(resolvedEntries, 128)).size() > 0) {
                resolvedEntries.removeAll(dups);
            }
            rInfo = new PathEntryResolveInfo(resolveInfoList);
            if (useCache) {
                this.resolvedMap.put(cproject, resolvedEntries);
                this.resolvedInfoMap.put(cproject, rInfo);
            }
        }
        return new Object[]{resolvedEntries, rInfo};
    }

    public void setRawPathEntries(ICProject cproject, IPathEntry[] newEntries, IProgressMonitor monitor) throws CModelException {
        try {
            IPathEntry[] oldResolvedEntries = this.getCachedResolvedPathEntries(cproject);
            SetPathEntriesOperation op = new SetPathEntriesOperation(cproject, oldResolvedEntries, newEntries);
            op.runOperation(monitor);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public IPathEntry[] getRawPathEntries(ICProject cproject) throws CModelException {
        IPathEntry[] newEntries;
        IPathEntry[] pathEntries;
        IProject project = cproject.getProject();
        if (!CoreModel.hasCNature(project) && !CoreModel.hasCCNature(project)) {
            throw new CModelException(new CModelStatus(969));
        }
        try {
            IPathEntryStore store = this.getPathEntryStore(project, true);
            pathEntries = store.getRawPathEntries();
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        boolean foundSource = false;
        boolean foundOutput = false;
        IPathEntry[] iPathEntryArray = pathEntries;
        int n = pathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntry rawEntry = iPathEntryArray[n2];
            if (rawEntry.getEntryKind() == 8) {
                foundSource = true;
            }
            if (rawEntry.getEntryKind() == 128) {
                foundOutput = true;
            }
            ++n2;
        }
        if (!foundSource) {
            newEntries = new IPathEntry[pathEntries.length + 1];
            System.arraycopy(pathEntries, 0, newEntries, 0, pathEntries.length);
            newEntries[pathEntries.length] = CoreModel.newSourceEntry(cproject.getPath());
            pathEntries = newEntries;
        }
        if (!foundOutput) {
            newEntries = new IPathEntry[pathEntries.length + 1];
            System.arraycopy(pathEntries, 0, newEntries, 0, pathEntries.length);
            newEntries[pathEntries.length] = CoreModel.newOutputEntry(cproject.getPath());
            pathEntries = newEntries;
        }
        return pathEntries;
    }

    public void setPathEntryContainer(ICProject[] affectedProjects, IPathEntryContainer newContainer, IProgressMonitor monitor) throws CModelException {
        SetPathEntryContainerOperation op = new SetPathEntryContainerOperation(affectedProjects, newContainer);
        op.runOperation(monitor);
    }

    public void clearPathEntryContainer(ICProject[] affectedProjects, IPath containerPath, IProgressMonitor monitor) throws CModelException {
        SetPathEntryContainerOperation op = new SetPathEntryContainerOperation(affectedProjects, containerPath);
        op.runOperation(monitor);
    }

    public synchronized IPathEntryContainer[] getPathEntryContainers(ICProject cproject) {
        IPathEntryContainer[] pcs = NO_PATHENTRYCONTAINERS;
        Map<IPath, IPathEntryContainer> projectContainers = Containers.get(cproject);
        if (projectContainers != null) {
            Collection<IPathEntryContainer> collection = projectContainers.values();
            pcs = collection.toArray(NO_PATHENTRYCONTAINERS);
        }
        return pcs;
    }

    public IPathEntryContainer getPathEntryContainer(IContainerEntry entry, ICProject cproject) throws CModelException {
        return this.getPathEntryContainer(entry.getPath(), cproject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPathEntryContainer getPathEntryContainer(final IPath containerPath, final ICProject project) throws CModelException {
        IPathEntryContainer container = this.containerGet(project, containerPath, true);
        if (container instanceof PathEntryContainerLock) {
            PathEntryContainerLock lock;
            boolean runInitializer = false;
            PathEntryContainerLock pathEntryContainerLock = lock = (PathEntryContainerLock)container;
            synchronized (pathEntryContainerLock) {
                if (!lock.isContainerInitialize()) {
                    runInitializer = true;
                    lock.setContainerInitialize(runInitializer);
                } else if (!Thread.holdsLock(lock)) {
                    while (this.containerGet(project, containerPath, true) instanceof PathEntryContainerLock) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (runInitializer) {
                final PathEntryContainerInitializer initializer = this.getPathEntryContainerInitializer(containerPath.segment(0));
                final boolean[] ok = new boolean[1];
                if (initializer != null) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Status status = new Status(4, "org.eclipse.cdt.core", 4, "Exception occurred in container initializer: " + initializer, exception);
                            CCorePlugin.log((IStatus)status);
                        }

                        public void run() throws Exception {
                            initializer.initialize(containerPath, project);
                            ok[0] = true;
                        }
                    });
                }
                if (!ok[0]) {
                    this.containerPut(project, containerPath, null);
                }
            }
            container = this.containerGet(project, containerPath, false);
        }
        return container;
    }

    public PathEntryContainerInitializer getPathEntryContainerInitializer(String containerID) {
        CCorePlugin core = CCorePlugin.getDefault();
        if (core == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String initializerID = configElement.getAttribute("id");
                    if (initializerID != null && initializerID.equals(containerID)) {
                        try {
                            Object execExt = configElement.createExecutableExtension("class");
                            if (execExt instanceof PathEntryContainerInitializer) {
                                return (PathEntryContainerInitializer)execExt;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    synchronized IPathEntryContainer containerGet(ICProject cproject, IPath containerPath, boolean bCreateLock) {
        Map<IPath, IPathEntryContainer> projectContainers = Containers.get(cproject);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(cproject, projectContainers);
        }
        IPathEntryContainer container = projectContainers.get(containerPath);
        if (bCreateLock && container == null) {
            container = new PathEntryContainerLock();
            projectContainers.put(containerPath, container);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void containerPut(ICProject cproject, IPath containerPath, IPathEntryContainer container) {
        IPathEntryContainer oldContainer;
        Map<IPath, IPathEntryContainer> projectContainers = Containers.get(cproject);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IPathEntryContainer>();
            Containers.put(cproject, projectContainers);
        }
        if ((oldContainer = container == null ? projectContainers.remove(containerPath) : projectContainers.put(containerPath, container)) instanceof PathEntryContainerLock) {
            IPathEntryContainer iPathEntryContainer = oldContainer;
            synchronized (iPathEntryContainer) {
                oldContainer.notifyAll();
            }
        }
    }

    synchronized void containerRemove(ICProject cproject) {
        Containers.remove(cproject);
    }

    public void pathEntryContainerUpdates(IPathEntryContainerExtension container, PathEntryContainerChanged[] events, IProgressMonitor monitor) {
        PathEntryContainerUpdatesOperation op = new PathEntryContainerUpdatesOperation(container, events);
        try {
            op.runOperation(monitor);
        }
        catch (CModelException cModelException) {}
    }

    public String[] projectPrerequisites(IPathEntry[] entries) throws CModelException {
        if (entries != null) {
            ArrayList<String> prerequisites = new ArrayList<String>();
            IPathEntry[] iPathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IPathEntry entrie = iPathEntryArray[n2];
                if (entrie.getEntryKind() == 4) {
                    IProjectEntry entry = (IProjectEntry)entrie;
                    prerequisites.add(entry.getPath().lastSegment());
                }
                ++n2;
            }
            int size = prerequisites.size();
            if (size != 0) {
                String[] result = new String[size];
                prerequisites.toArray(result);
                return result;
            }
        }
        return NO_PREREQUISITES;
    }

    public void saveRawPathEntries(ICProject cproject, IPathEntry[] entries) throws CModelException {
        if (entries == null) {
            entries = NO_PATHENTRIES;
        }
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(entries.length);
        IPath projectPath = cproject.getPath();
        IPathEntry[] iPathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPathEntry entry;
            IPathEntry entrie = iPathEntryArray[n2];
            int kind = entrie.getEntryKind();
            IPath resourcePath = entrie.getPath();
            if (resourcePath == null) {
                resourcePath = Path.EMPTY;
            }
            if (kind != 32 && resourcePath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(resourcePath)) {
                if (resourcePath.segment(0).equals(projectPath.segment(0))) {
                    resourcePath = resourcePath.removeFirstSegments(1);
                    resourcePath = resourcePath.makeRelative();
                } else {
                    resourcePath = resourcePath.makeAbsolute();
                }
            }
            switch (kind) {
                case 16: {
                    IIncludeEntry include = (IIncludeEntry)entrie;
                    IPath baseRef = include.getBaseReference();
                    if (baseRef == null || baseRef.isEmpty()) {
                        entry = CoreModel.newIncludeEntry(resourcePath, include.getBasePath(), include.getIncludePath(), include.isSystemInclude(), include.getExclusionPatterns(), include.isExported());
                        break;
                    }
                    entry = CoreModel.newIncludeRefEntry(resourcePath, baseRef, include.getIncludePath());
                    break;
                }
                case 256: {
                    IIncludeFileEntry includeFile = (IIncludeFileEntry)entrie;
                    entry = CoreModel.newIncludeFileEntry(resourcePath, includeFile.getBasePath(), includeFile.getBaseReference(), includeFile.getIncludeFilePath(), includeFile.getExclusionPatterns(), includeFile.isExported());
                    break;
                }
                case 1: {
                    IPath baseRef;
                    ILibraryEntry library = (ILibraryEntry)entrie;
                    IPath sourcePath = library.getSourceAttachmentPath();
                    if (sourcePath != null && projectPath != null && projectPath.isPrefixOf(sourcePath) && sourcePath.segment(0).equals(projectPath.segment(0))) {
                        sourcePath = sourcePath.removeFirstSegments(1);
                        sourcePath = sourcePath.makeRelative();
                    }
                    if ((baseRef = library.getBaseReference()) == null || baseRef.isEmpty()) {
                        entry = CoreModel.newLibraryEntry(resourcePath, library.getBasePath(), library.getLibraryPath(), sourcePath, library.getSourceAttachmentRootPath(), library.getSourceAttachmentPrefixMapping(), library.isExported());
                        break;
                    }
                    entry = CoreModel.newLibraryRefEntry(resourcePath, baseRef, library.getLibraryPath());
                    break;
                }
                case 64: {
                    IPathEntry macro = (IMacroEntry)entrie;
                    IPath baseRef = macro.getBaseReference();
                    if (baseRef == null || baseRef.isEmpty()) {
                        entry = CoreModel.newMacroEntry(resourcePath, macro.getMacroName(), macro.getMacroValue(), macro.getExclusionPatterns(), macro.isExported());
                        break;
                    }
                    entry = CoreModel.newMacroRefEntry(resourcePath, baseRef, macro.getMacroName());
                    break;
                }
                case 512: {
                    IPathEntry macro = (IMacroFileEntry)entrie;
                    entry = CoreModel.newMacroFileEntry(resourcePath, macro.getBasePath(), macro.getBaseReference(), macro.getMacroFilePath(), macro.getExclusionPatterns(), macro.isExported());
                    break;
                }
                case 128: {
                    IOutputEntry out = (IOutputEntry)entrie;
                    entry = CoreModel.newOutputEntry(resourcePath, out.getExclusionPatterns());
                    break;
                }
                case 4: {
                    IProjectEntry projEntry = (IProjectEntry)entrie;
                    entry = CoreModel.newProjectEntry(projEntry.getPath(), projEntry.isExported());
                    break;
                }
                case 8: {
                    ISourceEntry source = (ISourceEntry)entrie;
                    entry = CoreModel.newSourceEntry(resourcePath, source.getExclusionPatterns());
                    break;
                }
                case 32: {
                    entry = CoreModel.newContainerEntry(entrie.getPath(), entrie.isExported());
                    break;
                }
                default: {
                    entry = entrie;
                }
            }
            list.add(entry);
            ++n2;
        }
        try {
            IPathEntry[] newRawEntries = new IPathEntry[list.size()];
            list.toArray(newRawEntries);
            IProject project = cproject.getProject();
            IPathEntryStore store = this.getPathEntryStore(project, true);
            this.setResolveInfoValidState(cproject, false);
            store.setRawPathEntries(newRawEntries);
            this.setResolveInfoValidState(cproject, true);
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public void addProblemMarkers(IProject project, ICModelStatus[] problems) {
        PathEntryProblem problem = new PathEntryProblem(project, problems);
        this.markerProblems.add(problem);
        this.markerTask.schedule();
    }

    private boolean needDelta(ICProject cproject) {
        try {
            PathEntryStoreProxy store = (PathEntryStoreProxy)this.getPathEntryStore(cproject.getProject(), false);
            return store == null || !(store.getStore() instanceof ConfigBasedPathEntryStore);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public ICElementDelta[] generatePathEntryDeltas(ICProject cproject, IPathEntry[] oldEntries, IPathEntry[] newEntries) {
        ICElementDelta delta;
        ICElementDelta delta2;
        int n;
        int n2;
        IPathEntry[] iPathEntryArray;
        boolean found;
        if (!this.needDelta(cproject)) {
            return new ICElementDelta[0];
        }
        ArrayList<ICElementDelta> list = new ArrayList<ICElementDelta>();
        if (oldEntries == null) {
            return new ICElementDelta[0];
        }
        if (newEntries == null) {
            newEntries = NO_PATHENTRIES;
        }
        IPathEntry[] iPathEntryArray2 = oldEntries;
        int n3 = oldEntries.length;
        int n4 = 0;
        while (n4 < n3) {
            IPathEntry oldEntrie = iPathEntryArray2[n4];
            found = false;
            iPathEntryArray = newEntries;
            n2 = newEntries.length;
            n = 0;
            while (n < n2) {
                IPathEntry newEntrie = iPathEntryArray[n];
                if (oldEntrie.equals(newEntrie)) {
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found && (delta2 = this.makePathEntryDelta(cproject, oldEntrie, true)) != null) {
                list.add(delta2);
            }
            ++n4;
        }
        iPathEntryArray2 = newEntries;
        n3 = newEntries.length;
        n4 = 0;
        while (n4 < n3) {
            IPathEntry newEntrie = iPathEntryArray2[n4];
            found = false;
            iPathEntryArray = oldEntries;
            n2 = oldEntries.length;
            n = 0;
            while (n < n2) {
                IPathEntry oldEntrie = iPathEntryArray[n];
                if (newEntrie.equals(oldEntrie)) {
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found && (delta2 = this.makePathEntryDelta(cproject, newEntrie, false)) != null) {
                list.add(delta2);
            }
            ++n4;
        }
        if (list.size() == 0 && oldEntries.length == newEntries.length) {
            int i = 0;
            while (i < newEntries.length) {
                ICElementDelta delta3;
                if (!newEntries[i].equals(oldEntries[i]) && (delta3 = this.makePathEntryDelta(cproject, null, false)) != null) {
                    list.add(delta3);
                }
                ++i;
            }
        }
        if (list.size() == 0 && oldEntries.length != newEntries.length && (delta = this.makePathEntryDelta(cproject, null, true)) != null) {
            list.add(delta);
        }
        ICElementDelta[] deltas = new ICElementDelta[list.size()];
        list.toArray(deltas);
        return deltas;
    }

    protected ICElementDelta makePathEntryDelta(ICProject cproject, IPathEntry entry, boolean removed) {
        ICElement celement = null;
        int flag = 262144;
        if (entry == null) {
            celement = cproject;
            flag = 262144;
        } else {
            int kind = entry.getEntryKind();
            switch (kind) {
                case 8: {
                    ISourceEntry source = (ISourceEntry)entry;
                    IPath path = source.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = removed ? 512 : 256;
                    break;
                }
                case 1: {
                    celement = cproject;
                    flag = removed ? 8192 : 4096;
                    break;
                }
                case 4: {
                    celement = cproject;
                    flag = 16384;
                    break;
                }
                case 16: {
                    IIncludeEntry include = (IIncludeEntry)entry;
                    IPath path = include.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = 2048;
                    break;
                }
                case 256: {
                    IIncludeFileEntry includeFile = (IIncludeFileEntry)entry;
                    IPath path = includeFile.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = 2048;
                    break;
                }
                case 64: {
                    IMacroEntry macro = (IMacroEntry)entry;
                    IPath path = macro.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = 1024;
                    break;
                }
                case 512: {
                    IMacroFileEntry macro = (IMacroFileEntry)entry;
                    IPath path = macro.getPath();
                    celement = CoreModel.getDefault().create(path);
                    flag = 1024;
                    break;
                }
            }
        }
        if (celement == null) {
            celement = cproject;
        }
        CElementDelta delta = new CElementDelta(cproject.getCModel());
        delta.changed(celement, flag);
        return delta;
    }

    static String[] getRegisteredContainerIDs() {
        CCorePlugin core = CCorePlugin.getDefault();
        if (core == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", CONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String idAttribute = configElement.getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathEntryStore(IProject project, IPathEntryStore newStore) {
        IPathEntryStore oldStore = null;
        Map<IProject, IPathEntryStore> map = this.storeMap;
        synchronized (map) {
            oldStore = this.storeMap.remove(project);
            if (newStore != null) {
                this.storeMap.put(project, newStore);
            }
        }
        if (oldStore != null) {
            oldStore.removePathEntryStoreListener(this);
            oldStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPathEntryStore getPathEntryStore(IProject project, boolean create) throws CoreException {
        Map<IProject, IPathEntryStore> map = this.storeMap;
        synchronized (map) {
            IPathEntryStore store = this.storeMap.get(project);
            if (store == null) {
                if (create) {
                    store = this.createPathEntryStore(project);
                    this.storeMap.put(project, store);
                    store.addPathEntryStoreListener(this);
                }
            } else if (store instanceof AbstractCExtensionProxy) {
                ((AbstractCExtensionProxy)((Object)store)).updateProject(project);
            }
            return store;
        }
    }

    public IPathEntryStore createPathEntryStore(IProject project) throws CoreException {
        return new PathEntryStoreProxy(project);
    }

    @Override
    public void pathEntryStoreChanged(PathEntryStoreChangedEvent event) {
        IProject project = event.getProject();
        if (project == null) {
            return;
        }
        CModelManager manager = CModelManager.getDefault();
        ICProject cproject = manager.create(project);
        if (event.hasClosed()) {
            this.setPathEntryStore(project, null);
            this.containerRemove(cproject);
        }
        if (project.isAccessible()) {
            try {
                PathEntryStoreChangedOperation op = new PathEntryStoreChangedOperation(cproject);
                op.runOperation(null);
            }
            catch (CModelException e) {
                CCorePlugin.log((Throwable)((Object)e));
            }
        } else {
            this.resolvedMap.remove(cproject);
            this.resolvedInfoMap.remove(cproject);
            this.containerRemove(cproject);
        }
    }

    @Override
    public void elementChanged(ElementChangedEvent event) {
        block10: {
            try {
                ICProject[] cProjects;
                if (!this.processDelta(event.getDelta())) break block10;
                ICProject[] iCProjectArray = cProjects = this.resolvedMap.keySet().toArray(new ICProject[0]);
                int n = cProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    ICProject project2 = iCProjectArray[n2];
                    IPathEntry[] entries = this.getCachedResolvedPathEntries(project2);
                    if (entries != null) {
                        IProject project = project2.getProject();
                        try {
                            IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.pathentry_problem", false, 0);
                            if (markers != null && markers.length > 0) {
                                ArrayList<ICModelStatus> problemList = new ArrayList<ICModelStatus>();
                                IPathEntry[] iPathEntryArray = entries;
                                int n3 = entries.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IPathEntry entrie = iPathEntryArray[n4];
                                    ICModelStatus status = PathEntryUtil.validatePathEntry(project2, entrie, true, false);
                                    if (!status.isOK()) {
                                        problemList.add(status);
                                    }
                                    ++n4;
                                }
                                ICModelStatus[] problems = new ICModelStatus[problemList.size()];
                                problemList.toArray(problems);
                                if (PathEntryUtil.hasPathEntryProblemMarkersChange(project, problems)) {
                                    this.addProblemMarkers(project, problems);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    protected boolean processDelta(ICElementDelta delta) throws CModelException {
        int kind = delta.getKind();
        ICElement element = delta.getElement();
        int type = element.getElementType();
        if (type == 11) {
            ICProject cproject = (ICProject)element;
            if (kind == 2 || kind == 1) {
                if (kind == 2) {
                    IProject project = cproject.getProject();
                    IPathEntryStore store = null;
                    try {
                        try {
                            store = this.getPathEntryStore(project, false);
                            if (store != null) {
                                store.close();
                            }
                        }
                        catch (CoreException e) {
                            throw new CModelException(e);
                        }
                    }
                    finally {
                        if (store == null) {
                            this.resolvedMap.remove(cproject);
                            this.resolvedInfoMap.remove(cproject);
                            this.containerRemove(cproject);
                        }
                    }
                }
                return true;
            }
        }
        if (element instanceof IWorkingCopy) {
            return false;
        }
        if (kind == 1 || kind == 2) {
            if (element instanceof ISourceRoot) {
                ISourceRoot sourceRoot = (ISourceRoot)element;
                if (kind == 2) {
                    this.updatePathEntryFromDeleteSource(sourceRoot);
                }
            }
            return true;
        }
        if (type == 10 || type == 12 || type == 11) {
            ICElementDelta[] affectedChildren;
            ICElementDelta[] iCElementDeltaArray = affectedChildren = delta.getAffectedChildren();
            int n = affectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                ICElementDelta element2 = iCElementDeltaArray[n2];
                if (this.processDelta(element2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    void updatePathEntryFromDeleteSource(ISourceRoot sourceRoot) throws CModelException {
        final ICProject cproject = sourceRoot.getCProject();
        IPathEntry[] rawEntries = this.getRawPathEntries(cproject);
        boolean change = false;
        ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(rawEntries.length);
        int i = 0;
        while (i < rawEntries.length) {
            if (rawEntries[i].getEntryKind() == 8) {
                if (sourceRoot.getPath().equals((Object)rawEntries[i].getPath())) {
                    change = true;
                } else {
                    list.add(rawEntries[i]);
                }
            } else {
                list.add(rawEntries[i]);
            }
            ++i;
        }
        if (change) {
            IPathEntry[] newEntries = new IPathEntry[list.size()];
            list.toArray(newEntries);
            final IPathEntry[] finalEntries = newEntries;
            Job updatePathEntry = new Job("PathEntry Update source roots"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CCorePlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor mon) throws CoreException {
                                PathEntryManager.this.setRawPathEntries(cproject, finalEntries, mon);
                            }
                        }, null);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            IProject project = cproject.getProject();
            IWorkspaceRoot rule = project.getWorkspace().getRoot();
            updatePathEntry.setRule((ISchedulingRule)rule);
            updatePathEntry.schedule();
        }
    }

    public ICModelStatus validatePathEntry(ICProject cProject, IPathEntry[] entries) {
        return PathEntryUtil.validatePathEntry(cProject, entries);
    }

    public ICModelStatus validatePathEntry(ICProject cProject, IPathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        return PathEntryUtil.validatePathEntry(cProject, entry, checkSourceAttachment, recurseInContainers);
    }

    private class GenerateMarkersJob
    extends WorkspaceJob {
        public GenerateMarkersJob(String name) {
            super(name);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            while (PathEntryManager.this.markerProblems.peek() != null && !monitor.isCanceled()) {
                PathEntryProblem problem = PathEntryManager.this.markerProblems.poll();
                IProject project = problem.project;
                ICModelStatus[] problems = problem.problems;
                PathEntryUtil.flushPathEntryProblemMarkers(project);
                int i = 0;
                while (i < problems.length) {
                    PathEntryUtil.createPathEntryProblemMarker(project, problems[i]);
                    ++i;
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class PathEntryContainerLock
    implements IPathEntryContainer {
        boolean runInitializer;

        private PathEntryContainerLock() {
        }

        public boolean isContainerInitialize() {
            return this.runInitializer;
        }

        public void setContainerInitialize(boolean init) {
            this.runInitializer = init;
        }

        public IPathEntry[] getPathEntries() {
            return NO_PATHENTRIES;
        }

        public String getDescription() {
            return new String("Lock container");
        }

        public IPath getPath() {
            return Path.EMPTY;
        }
    }

    private class PathEntryProblem {
        IProject project;
        ICModelStatus[] problems;

        public PathEntryProblem(IProject project, ICModelStatus[] problems) {
            this.project = project;
            this.problems = problems;
        }
    }
}

