/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICBuildSetting;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.CExtensionInfo;
import org.eclipse.cdt.internal.core.COwner;
import org.eclipse.cdt.internal.core.COwnerConfiguration;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.internal.core.settings.model.CConfigExtensionReference;
import org.eclipse.cdt.internal.core.settings.model.CConfigurationDescriptionCache;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsHolder;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CStorage;
import org.eclipse.cdt.internal.core.settings.model.CfgExportSettingContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ExtensionContainerFactory;
import org.eclipse.cdt.internal.core.settings.model.IInternalCCfgInfo;
import org.eclipse.cdt.internal.core.settings.model.InternalXmlStorageElement;
import org.eclipse.cdt.utils.envvar.StorableEnvironment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CConfigurationSpecSettings
implements ICSettingsStorage {
    static final String BUILD_SYSTEM_ID = "buildSystemId";
    private static final String PROJECT_EXTENSION_ATTR_POINT = "point";
    private static final String PROJECT_EXTENSION_ATTR_ID = "id";
    private static final String PROJECT_EXTENSION_ATTRIBUTE = "attribute";
    private static final String PROJECT_EXTENSION_ATTRIBUTE_KEY = "key";
    private static final String PROJECT_EXTENSION_ATTRIBUTE_VALUE = "value";
    private static final String PROJECT_EXTENSION = "extension";
    private static final String PROJECT_DATA = "data";
    private static final String PROJECT_DATA_ITEM = "item";
    private static final String PROJECT_DATA_ID = "id";
    private static final String PROJECT_EXTENSIONS = "extensions";
    private static final String OWNER_ID = "owner";
    private static final String OLD_OWNER_ID = "id";
    static final String ID = "id";
    static final String NAME = "name";
    private ICConfigurationDescription fCfg;
    private ICStorageElement fRootStorageElement;
    private ICStorageElement fSettingsStorageElement;
    private CStorage fStorage;
    private String fBuildSystemId;
    private String fName;
    private String fId;
    private StorableCdtVariables fMacros;
    private StorableEnvironment fEnvironment;
    private Map<String, String> fRefMapCache;
    private CExternalSettingsHolder fExtSettingsProvider = new CExternalSettingsHolder();
    private boolean fIsModified;
    private HashMap fSessionPropertiesMap;
    private HashMap fExtMap;
    private HashMap fExtInfoMap = new HashMap();
    private String fOwnerId;
    private COwner fOwner;

    public CConfigurationSpecSettings(ICConfigurationDescription des, ICStorageElement storage) throws CoreException {
        this.fCfg = des;
        this.fRootStorageElement = storage;
        ICStorageElement settings = this.getSettingsStorageElement();
        this.fBuildSystemId = settings.getAttribute(BUILD_SYSTEM_ID);
        this.fName = settings.getAttribute(NAME);
        this.fId = settings.getAttribute("id");
        this.setCOwner(settings.getAttribute(OWNER_ID));
        ICStorageElement[] children = settings.getChildren();
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String name = child.getName();
            if ("macros".equals(name)) {
                this.fMacros = new StorableCdtVariables(child, this.fCfg.isReadOnly());
            } else if ("externalSettings".equals(name)) {
                this.fExtSettingsProvider = new CExternalSettingsHolder(child);
            } else if ("environment".equals(name)) {
                this.fEnvironment = new StorableEnvironment(child, this.fCfg.isReadOnly());
            } else if (PROJECT_EXTENSIONS.equals(name)) {
                this.loadExtensionInfo(child, false);
            }
            ++i;
        }
    }

    public CConfigurationSpecSettings(ICConfigurationDescription des, ICStorageElement storage, ICStorageElement oldInfo) throws CoreException {
        this.fCfg = des;
        this.fRootStorageElement = storage;
        this.loadOldStileDescription(oldInfo);
    }

    private void loadOldStileDescription(ICStorageElement storage) throws CoreException {
        this.setCOwner(storage.getAttribute("id"));
        this.loadExtensionInfo(storage, true);
    }

    public CConfigurationSpecSettings(ICConfigurationDescription des, CConfigurationSpecSettings base) {
        this(des, base, null);
    }

    public CConfigurationSpecSettings(ICConfigurationDescription des, CConfigurationSpecSettings base, ICStorageElement rootEl) {
        this.fCfg = des;
        this.fRootStorageElement = rootEl;
        this.fBuildSystemId = base.fBuildSystemId;
        this.fName = base.fName;
        this.fId = base.fId;
        if (base.fMacros != null) {
            this.fMacros = new StorableCdtVariables(base.fMacros, des.isReadOnly());
        }
        if (base.fExtSettingsProvider != null) {
            this.fExtSettingsProvider = new CExternalSettingsHolder(base.fExtSettingsProvider);
        }
        if (base.fSessionPropertiesMap != null) {
            this.fSessionPropertiesMap = (HashMap)base.fSessionPropertiesMap.clone();
        }
        if (base.fEnvironment != null) {
            this.fEnvironment = new StorableEnvironment(base.fEnvironment, des.isReadOnly());
        }
        this.fOwnerId = base.fOwnerId;
        this.fOwner = base.fOwner;
        this.copyExtensionInfo(base);
    }

    public void setCOwner(String ownerId) throws CoreException {
        if (ownerId == null) {
            ownerId = "";
        }
        if (ownerId.equals(this.fOwnerId)) {
            return;
        }
        this.fOwnerId = ownerId;
        COwnerConfiguration cfg = CProjectDescriptionManager.getInstance().getDescriptorManager().getOwnerConfiguration(this.fOwnerId);
        this.fOwner = new COwner(cfg);
    }

    private ICStorageElement getSettingsStorageElement() throws CoreException {
        if (this.fSettingsStorageElement == null) {
            this.fSettingsStorageElement = this.getStorage("org.eclipse.cdt.core.settings", true);
        }
        return this.fSettingsStorageElement;
    }

    @Override
    public ICStorageElement getStorage(String id, boolean create) throws CoreException {
        return this.getStorageBase().getStorage(id, create);
    }

    @Override
    public void removeStorage(String id) throws CoreException {
        this.getStorageBase().removeStorage(id);
    }

    public boolean containsStorage(String id) throws CoreException {
        return this.getStorageBase().containsStorage(id);
    }

    ICStorageElement getRootStorageElement() throws CoreException {
        if (this.fRootStorageElement == null) {
            this.fRootStorageElement = this.fCfg.isPreferenceConfiguration() ? CProjectDescriptionManager.getInstance().getBuildSystemConfigPreferenceStorage(this.fBuildSystemId) : CProjectDescriptionManager.getInstance().createStorage(this.fCfg.getProjectDescription(), this.fCfg.getId());
        }
        return this.fRootStorageElement;
    }

    void removeConfiguration() throws CoreException {
        CProjectDescriptionManager.getInstance().removeStorage(this.fCfg.getProjectDescription(), this.fCfg.getId());
    }

    private CStorage getStorageBase() throws CoreException {
        if (this.fStorage == null) {
            this.fStorage = new CStorage((InternalXmlStorageElement)this.getRootStorageElement());
        }
        return this.fStorage;
    }

    void doneInitialization() {
        if (this.isReadOnly()) {
            if (this.fRootStorageElement != null) {
                ((InternalXmlStorageElement)this.fRootStorageElement).setReadOnly(true, false);
            }
            if (this.fSettingsStorageElement != null) {
                ((InternalXmlStorageElement)this.fSettingsStorageElement).setReadOnly(true, false);
            }
            if (this.fStorage != null) {
                this.fStorage.setReadOnly(true, false);
            }
        }
    }

    public String getBuildSystemId() {
        return this.fBuildSystemId;
    }

    public ICConfigurationDescription getConfigurarion() {
        return this.fCfg;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        if (this.isReadOnly()) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (!CDataUtil.objectsEqual(this.fName, name)) {
            this.fName = name;
            this.fIsModified = true;
        }
    }

    public String getId() {
        return this.fId;
    }

    public void setId(String id) {
        if (this.isReadOnly()) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (!CDataUtil.objectsEqual(this.fId, id)) {
            this.fId = id;
            this.fIsModified = true;
        }
    }

    void setBuildSystemId(String id) {
        if (this.isReadOnly()) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        if (!CDataUtil.objectsEqual(this.fBuildSystemId, id)) {
            this.fBuildSystemId = id;
            this.fIsModified = true;
        }
    }

    void serializeId() throws CoreException {
        this.fId = this.fCfg.getId();
        ICStorageElement settings = this.getSettingsStorageElement();
        settings.setAttribute("id", this.fId);
    }

    void serialize() throws CoreException {
        this.fId = this.fCfg.getId();
        this.fName = this.fCfg.getName();
        ICStorageElement settings = this.getSettingsStorageElement();
        settings.clear();
        settings.setAttribute("id", this.fId);
        settings.setAttribute(NAME, this.fName);
        settings.setAttribute(BUILD_SYSTEM_ID, this.fBuildSystemId);
        if (this.fMacros != null && !this.fMacros.isEmpty()) {
            ICStorageElement macrosEl = settings.createChild("macros");
            this.fMacros.serialize(macrosEl);
        }
        if (this.fExtSettingsProvider != null) {
            ICStorageElement child = settings.createChild("externalSettings");
            this.fExtSettingsProvider.serialize(child);
        }
        ICStorageElement extEl = settings.createChild(PROJECT_EXTENSIONS);
        this.encodeProjectExtensions(extEl);
    }

    public boolean isReadOnly() {
        return this.fCfg.isReadOnly();
    }

    public StorableCdtVariables getMacros() {
        if (this.fMacros == null) {
            this.fMacros = new StorableCdtVariables(this.isReadOnly());
        }
        return this.fMacros;
    }

    public StorableEnvironment getEnvironment() {
        return this.fEnvironment;
    }

    public void setEnvironment(StorableEnvironment environment) {
        this.fEnvironment = environment;
    }

    public Map<String, String> getReferenceInfo() {
        if (!this.fCfg.isReadOnly()) {
            return CfgExportSettingContainerFactory.getReferenceMap(this.fCfg);
        }
        if (this.fRefMapCache == null) {
            this.fRefMapCache = CfgExportSettingContainerFactory.getReferenceMap(this.fCfg);
        }
        return new HashMap<String, String>(this.fRefMapCache);
    }

    public void setReferenceInfo(Map<String, String> ref) {
        this.fRefMapCache = null;
        CfgExportSettingContainerFactory.setReferenceMap(this.fCfg, ref);
    }

    public ICExternalSetting[] getExternalSettings() {
        return this.fExtSettingsProvider.getExternalSettings();
    }

    public ICExternalSetting createExternalSetting(String[] languageIDs, String[] contentTypeIDs, String[] extensions, ICSettingEntry[] entries) {
        return this.fExtSettingsProvider.createExternalSetting(languageIDs, contentTypeIDs, extensions, entries);
    }

    public void removeExternalSetting(ICExternalSetting setting) {
        this.fExtSettingsProvider.removeExternalSetting((CExternalSetting)setting);
    }

    public void removeExternalSettings() {
        this.fExtSettingsProvider.removeExternalSettings();
    }

    public boolean isModified() {
        if (this.fIsModified) {
            return true;
        }
        if (this.fMacros != null && this.fMacros.isDirty()) {
            return true;
        }
        if (this.fEnvironment != null && this.fEnvironment.isDirty()) {
            return true;
        }
        return this.fExtSettingsProvider.isModified();
    }

    void setModified(boolean modified) {
        if (this.isReadOnly()) {
            throw ExceptionFactory.createIsReadOnlyException();
        }
        this.fIsModified = modified;
        if (!modified) {
            if (this.fMacros != null) {
                this.fMacros.setDirty(false);
            }
            if (this.fEnvironment != null) {
                this.fEnvironment.setDirty(false);
            }
        }
    }

    void setModified() {
        this.setModified(true);
    }

    private Map getSessionPropertiesMap(boolean create) {
        if (this.fSessionPropertiesMap == null && create) {
            this.fSessionPropertiesMap = new HashMap();
        }
        return this.fSessionPropertiesMap;
    }

    public Object getSettionProperty(QualifiedName name) {
        Map map = this.getSessionPropertiesMap(false);
        return map != null ? map.get(name) : null;
    }

    public void setSettionProperty(QualifiedName name, Object value) {
        Map map = this.getSessionPropertiesMap(true);
        if (value != null) {
            map.put(name, value);
        } else {
            map.remove(name);
        }
        this.fIsModified = true;
    }

    private HashMap getExtMap() {
        if (this.fExtMap == null) {
            this.fExtMap = new HashMap();
        }
        return this.fExtMap;
    }

    public Map getExtensionMapCopy() {
        return (HashMap)this.getExtMap().clone();
    }

    private ICConfigExtensionReference[] doGet(String extensionPointID) {
        return (CConfigExtensionReference[])this.getExtMap().get(extensionPointID);
    }

    public ICConfigExtensionReference[] get(String extensionPointID) {
        this.checkReconsile(extensionPointID, true);
        ICConfigExtensionReference[] refs = this.doGet(extensionPointID);
        if (refs == null) {
            return new ICConfigExtensionReference[0];
        }
        return (ICConfigExtensionReference[])refs.clone();
    }

    private void checkReconsile(String extensionPointID, boolean toExt) {
        ICBuildSetting bs;
        if (toExt) {
            Set[] delta = this.getReferenceDelta(extensionPointID);
            if (delta != null) {
                if (delta[0] != null) {
                    for (ICConfigExtensionReference ref : delta[0]) {
                        try {
                            this.doRemove(ref);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                }
                if (delta[1] != null) {
                    for (String id : delta[1]) {
                        try {
                            this.doCreate(extensionPointID, id);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                }
            }
        } else if ("org.eclipse.cdt.core.BinaryParser".equals(extensionPointID)) {
            ICTargetPlatformSetting tp = this.fCfg.getTargetPlatformSetting();
            if (tp != null) {
                tp.setBinaryParserIds(this.getIds(this.doGet(extensionPointID)));
            }
        } else if ("org.eclipse.cdt.core.ErrorParser".equals(extensionPointID) && (bs = this.fCfg.getBuildSetting()) != null) {
            bs.setErrorParserIDs(this.getIds(this.doGet(extensionPointID)));
        }
    }

    private String[] getIds(ICConfigExtensionReference[] refs) {
        if (refs == null || refs.length == 0) {
            return new String[0];
        }
        String[] ids = new String[refs.length];
        int i = 0;
        while (i < refs.length) {
            ids[i] = refs[i].getID();
            ++i;
        }
        return ids;
    }

    void reconcileExtensionSettings(boolean toExts) {
        this.checkReconsile("org.eclipse.cdt.core.BinaryParser", toExts);
        this.checkReconsile("org.eclipse.cdt.core.ErrorParser", toExts);
    }

    private CConfigExtensionReference createRef(String extensionPoint, String extension) {
        CConfigExtensionReference[] extensions = (CConfigExtensionReference[])this.getExtMap().get(extensionPoint);
        if (extensions == null) {
            extensions = new CConfigExtensionReference[1];
            this.getExtMap().put(extensionPoint, extensions);
        } else {
            CConfigExtensionReference[] newExtensions = new CConfigExtensionReference[extensions.length + 1];
            System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
            extensions = newExtensions;
            this.getExtMap().put(extensionPoint, extensions);
        }
        extensions[extensions.length - 1] = new CConfigExtensionReference(this, extensionPoint, extension);
        return extensions[extensions.length - 1];
    }

    private ICConfigExtensionReference doCreate(String extensionPoint, String extension) throws CoreException {
        CConfigExtensionReference extRef = this.createRef(extensionPoint, extension);
        return extRef;
    }

    public ICConfigExtensionReference create(String extensionPoint, String extension) throws CoreException {
        this.checkReconsile(extensionPoint, true);
        ICConfigExtensionReference[] refs = this.doGet(extensionPoint);
        ICConfigExtensionReference extRef = null;
        if (refs != null && refs.length != 0) {
            int i = 0;
            while (i < refs.length) {
                if (refs[i].getID().equals(extension)) {
                    extRef = refs[i];
                    break;
                }
                ++i;
            }
        }
        if (extRef == null) {
            extRef = this.createRef(extensionPoint, extension);
            this.checkReconsile(extensionPoint, false);
            this.fIsModified = true;
        }
        return extRef;
    }

    public void doRemove(ICConfigExtensionReference ext) throws CoreException {
        CConfigExtensionReference[] extensions = (CConfigExtensionReference[])this.getExtMap().get(ext.getExtensionPoint());
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i] == ext) {
                System.arraycopy(extensions, i + 1, extensions, i, extensions.length - 1 - i);
                if (extensions.length > 1) {
                    CConfigExtensionReference[] newExtensions = new CConfigExtensionReference[extensions.length - 1];
                    System.arraycopy(extensions, 0, newExtensions, 0, newExtensions.length);
                    this.getExtMap().put(ext.getExtensionPoint(), newExtensions);
                } else {
                    this.getExtMap().remove(ext.getExtensionPoint());
                }
            }
            ++i;
        }
    }

    public void remove(ICConfigExtensionReference ext) throws CoreException {
        this.doRemove(ext);
        this.fIsModified = true;
    }

    private boolean doRemove(String extensionPoint) throws CoreException {
        CConfigExtensionReference[] extensions = (CConfigExtensionReference[])this.getExtMap().get(extensionPoint);
        if (extensions != null) {
            this.getExtMap().remove(extensionPoint);
            return true;
        }
        return false;
    }

    public void remove(String extensionPoint) throws CoreException {
        boolean changed = this.doRemove(extensionPoint);
        this.checkReconsile(extensionPoint, false);
        if (changed) {
            this.fIsModified = true;
        }
    }

    CExtensionInfo getInfo(CConfigExtensionReference cProjectExtension) {
        CExtensionInfo info = (CExtensionInfo)this.fExtInfoMap.get(cProjectExtension);
        if (info == null) {
            info = new CExtensionInfo();
            this.fExtInfoMap.put(cProjectExtension, info);
        }
        return info;
    }

    private void loadExtensionInfo(ICStorageElement node, boolean oldData) {
        ICStorageElement[] list = node.getChildren();
        int i = 0;
        while (i < list.length) {
            ICStorageElement childNode = list[i];
            if (childNode.getName().equals(PROJECT_EXTENSION)) {
                try {
                    this.decodeProjectExtension(childNode);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            } else if (oldData && childNode.getName().equals(PROJECT_DATA)) {
                try {
                    this.decodeProjectData(childNode);
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                }
            }
            ++i;
        }
    }

    private void decodeProjectExtension(ICStorageElement element) throws CoreException {
        String point = element.getAttribute(PROJECT_EXTENSION_ATTR_POINT);
        String id = element.getAttribute("id");
        CConfigExtensionReference ext = this.createRef(point, id);
        ICStorageElement[] extAttrib = element.getChildren();
        int j = 0;
        while (j < extAttrib.length) {
            if (extAttrib[j].getName().equals(PROJECT_EXTENSION_ATTRIBUTE)) {
                this.getInfo(ext).setAttribute(extAttrib[j].getAttribute(PROJECT_EXTENSION_ATTRIBUTE_KEY), extAttrib[j].getAttribute(PROJECT_EXTENSION_ATTRIBUTE_VALUE));
            }
            ++j;
        }
    }

    private void encodeProjectExtensions(ICStorageElement configRootElement) {
        for (CConfigExtensionReference[] extension : this.getExtMap().values()) {
            int i = 0;
            while (i < extension.length) {
                ICStorageElement element = configRootElement.createChild(PROJECT_EXTENSION);
                element.setAttribute(PROJECT_EXTENSION_ATTR_POINT, extension[i].getExtensionPoint());
                element.setAttribute("id", extension[i].getID());
                CExtensionInfo info = (CExtensionInfo)this.fExtInfoMap.get(extension[i]);
                if (info != null) {
                    for (Map.Entry entry : info.getAttributes().entrySet()) {
                        ICStorageElement extAttributes = element.createChild(PROJECT_EXTENSION_ATTRIBUTE);
                        extAttributes.setAttribute(PROJECT_EXTENSION_ATTRIBUTE_KEY, (String)entry.getKey());
                        extAttributes.setAttribute(PROJECT_EXTENSION_ATTRIBUTE_VALUE, (String)entry.getValue());
                    }
                }
                ++i;
            }
        }
    }

    private void decodeProjectData(ICStorageElement data) throws CoreException {
        ICStorageElement[] nodes = data.getChildren();
        int i = 0;
        while (i < nodes.length) {
            ICStorageElement element;
            String dataId;
            if (PROJECT_DATA_ITEM.equals(nodes[i].getName()) && (dataId = (element = nodes[i]).getAttribute("id")) != null) {
                element.removeAttribute("id");
                try {
                    this.importStorage(dataId, element);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    public void importStorage(String id, ICStorageElement el) throws CoreException {
        CStorage storage = this.getStorageBase();
        storage.importStorage(id, el);
    }

    private void copyExtensionInfo(CConfigurationSpecSettings other) {
        other.reconcileExtensionSettings(true);
        if (other.fExtMap != null && other.fExtMap.size() != 0) {
            this.fExtMap = (HashMap)other.fExtMap.clone();
            for (Map.Entry entry : this.fExtMap.entrySet()) {
                CConfigExtensionReference[] refs = (CConfigExtensionReference[])entry.getValue();
                refs = (CConfigExtensionReference[])refs.clone();
                int i = 0;
                while (i < refs.length) {
                    refs[i] = new CConfigExtensionReference(this, refs[i]);
                    ++i;
                }
                entry.setValue(refs);
            }
        }
        if (other.fExtInfoMap != null && other.fExtInfoMap.size() != 0) {
            this.fExtInfoMap = (HashMap)other.fExtInfoMap.clone();
            for (Map.Entry entry : this.fExtInfoMap.entrySet()) {
                CExtensionInfo info = (CExtensionInfo)entry.getValue();
                info = new CExtensionInfo(info);
                entry.setValue(info);
            }
        }
    }

    public COwner getCOwner() {
        return this.fOwner;
    }

    public String getCOwnerId() {
        return this.fOwnerId;
    }

    private static boolean usesCache(ICConfigurationDescription cfg) {
        CConfigurationData data = ((IInternalCCfgInfo)((Object)cfg)).getConfigurationData(false);
        if (data instanceof CConfigurationDescriptionCache) {
            return ((CConfigurationDescriptionCache)data).isReadOnly();
        }
        return false;
    }

    private Set[] getReferenceDelta(String extPointId) {
        if (!CConfigurationSpecSettings.usesCache(this.fCfg)) {
            ICBuildSetting bs;
            if ("org.eclipse.cdt.core.BinaryParser".equals(extPointId)) {
                ICTargetPlatformSetting tp = this.fCfg.getTargetPlatformSetting();
                if (tp != null) {
                    String[] ids = tp.getBinaryParserIds();
                    ICConfigExtensionReference[] refs = this.doGet(extPointId);
                    return this.getReferenceDelta(refs, ids);
                }
            } else if ("org.eclipse.cdt.core.ErrorParser".equals(extPointId) && (bs = this.fCfg.getBuildSetting()) != null) {
                String[] ids = bs.getErrorParserIDs();
                ICConfigExtensionReference[] refs = this.doGet(extPointId);
                return this.getReferenceDelta(refs, ids);
            }
        }
        return null;
    }

    private Set[] getReferenceDelta(ICConfigExtensionReference[] refs, String[] extIds) {
        if (refs == null || refs.length == 0) {
            if (extIds == null || extIds.length == 0) {
                return null;
            }
            Set[] setArray = new Set[2];
            setArray[1] = new HashSet(Arrays.asList(extIds));
            return setArray;
        }
        if (extIds == null || extIds.length == 0) {
            Map map = this.createRefMap(refs);
            Set[] setArray = new Set[2];
            setArray[0] = new HashSet(map.values());
            return setArray;
        }
        HashSet idSet = new HashSet(Arrays.asList(extIds));
        HashSet idSetCopy = new HashSet(idSet);
        Map refsMap = this.createRefMap(refs);
        idSet.removeAll(refsMap.keySet());
        refsMap.keySet().removeAll(idSetCopy);
        HashSet extSet = new HashSet(refsMap.values());
        return new Set[]{extSet, idSet};
    }

    private Map createRefMap(ICConfigExtensionReference[] refs) {
        HashMap<String, ICConfigExtensionReference> refsMap = new HashMap<String, ICConfigExtensionReference>(refs.length);
        int i = 0;
        while (i < refs.length) {
            refsMap.put(refs[i].getID(), refs[i]);
            ++i;
        }
        return refsMap;
    }

    boolean extRefSettingsEqual(CConfigurationSpecSettings other) {
        if (this.fExtMap == null || this.fExtMap.size() == 0) {
            return other.fExtMap == null || other.fExtMap.size() == 0;
        }
        if (other.fExtMap == null || other.fExtMap.size() == 0) {
            return false;
        }
        if (this.fExtMap.size() != other.fExtMap.size()) {
            return false;
        }
        for (Map.Entry entry : this.fExtMap.entrySet()) {
            ICConfigExtensionReference[] thisRefs = (ICConfigExtensionReference[])entry.getValue();
            ICConfigExtensionReference[] otherRefs = (ICConfigExtensionReference[])other.fExtMap.get(entry.getKey());
            if (otherRefs == null) {
                return thisRefs.length == 0;
            }
            if (thisRefs.length != otherRefs.length) {
                return false;
            }
            Map map = this.createRefMap(thisRefs);
            map.entrySet().removeAll(this.createRefMap(otherRefs).entrySet());
            if (map.size() == 0) continue;
            return false;
        }
        return true;
    }

    public String[] getExternalSettingsProviderIds() {
        return ExtensionContainerFactory.getReferencedProviderIds(this.fCfg);
    }

    public void setExternalSettingsProviderIds(String[] ids) {
        ExtensionContainerFactory.setReferencedProviderIds(this.fCfg, ids);
    }

    public void updateExternalSettingsProviders(String[] ids) {
        ExtensionContainerFactory.updateReferencedProviderIds(this.fCfg, ids);
    }
}

